# coding: utf-8

"""
    Bacalhau API

    This page is the reference of the Bacalhau REST API. Project docs are available at https://docs.bacalhau.org/. Find more information about Bacalhau at https://github.com/bacalhau-project/bacalhau.  # noqa: E501

    OpenAPI spec version: ${VERSION}
    Contact: team@bacalhau.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TimeoutConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'execution_timeout': 'int',
        'queue_timeout': 'int',
        'total_timeout': 'int'
    }

    attribute_map = {
        'execution_timeout': 'ExecutionTimeout',
        'queue_timeout': 'QueueTimeout',
        'total_timeout': 'TotalTimeout'
    }

    def __init__(self, execution_timeout=None, queue_timeout=None, total_timeout=None):  # noqa: E501
        """TimeoutConfig - a model defined in Swagger"""  # noqa: E501
        self._execution_timeout = None
        self._queue_timeout = None
        self._total_timeout = None
        self.discriminator = None
        if execution_timeout is not None:
            self.execution_timeout = execution_timeout
        if queue_timeout is not None:
            self.queue_timeout = queue_timeout
        if total_timeout is not None:
            self.total_timeout = total_timeout

    @property
    def execution_timeout(self):
        """Gets the execution_timeout of this TimeoutConfig.  # noqa: E501

        ExecutionTimeout is the maximum amount of time a task is allowed to run in seconds. Zero means no timeout, such as for a daemon task.  # noqa: E501

        :return: The execution_timeout of this TimeoutConfig.  # noqa: E501
        :rtype: int
        """
        return self._execution_timeout

    @execution_timeout.setter
    def execution_timeout(self, execution_timeout):
        """Sets the execution_timeout of this TimeoutConfig.

        ExecutionTimeout is the maximum amount of time a task is allowed to run in seconds. Zero means no timeout, such as for a daemon task.  # noqa: E501

        :param execution_timeout: The execution_timeout of this TimeoutConfig.  # noqa: E501
        :type: int
        """

        self._execution_timeout = execution_timeout

    @property
    def queue_timeout(self):
        """Gets the queue_timeout of this TimeoutConfig.  # noqa: E501

        QueueTimeout is the maximum amount of time a task is allowed to wait in the orchestrator queue in seconds before being scheduled. Zero means no timeout.  # noqa: E501

        :return: The queue_timeout of this TimeoutConfig.  # noqa: E501
        :rtype: int
        """
        return self._queue_timeout

    @queue_timeout.setter
    def queue_timeout(self, queue_timeout):
        """Sets the queue_timeout of this TimeoutConfig.

        QueueTimeout is the maximum amount of time a task is allowed to wait in the orchestrator queue in seconds before being scheduled. Zero means no timeout.  # noqa: E501

        :param queue_timeout: The queue_timeout of this TimeoutConfig.  # noqa: E501
        :type: int
        """

        self._queue_timeout = queue_timeout

    @property
    def total_timeout(self):
        """Gets the total_timeout of this TimeoutConfig.  # noqa: E501

        TotalTimeout is the maximum amount of time a task is allowed to complete in seconds. This includes the time spent in the queue, the time spent executing and the time spent retrying. Zero means no timeout.  # noqa: E501

        :return: The total_timeout of this TimeoutConfig.  # noqa: E501
        :rtype: int
        """
        return self._total_timeout

    @total_timeout.setter
    def total_timeout(self, total_timeout):
        """Sets the total_timeout of this TimeoutConfig.

        TotalTimeout is the maximum amount of time a task is allowed to complete in seconds. This includes the time spent in the queue, the time spent executing and the time spent retrying. Zero means no timeout.  # noqa: E501

        :param total_timeout: The total_timeout of this TimeoutConfig.  # noqa: E501
        :type: int
        """

        self._total_timeout = total_timeout

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TimeoutConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TimeoutConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
