from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkRenderingContext2D

class vtkAxis(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    class Location(int): ...
    AUTO:int
    BOTTOM:'Location'
    CUSTOM:int
    FIXED:int
    FIXED_NOTATION:int
    LEFT:'Location'
    PARALLEL:'Location'
    PRINTF_NOTATION:int
    RIGHT:'Location'
    SCIENTIFIC_NOTATION:int
    STANDARD_NOTATION:int
    TICK_SIMPLE:int
    TICK_WILKINSON_EXTENDED:int
    TOP:'Location'
    axis_visible:'getset_descriptor'
    behavior:'getset_descriptor'
    grid_pen:'getset_descriptor'
    grid_visible:'getset_descriptor'
    label_format:'getset_descriptor'
    label_offset:'getset_descriptor'
    label_properties:'getset_descriptor'
    labels_visible:'getset_descriptor'
    log_scale:'getset_descriptor'
    log_scale_active:'getset_descriptor'
    margins:'getset_descriptor'
    maximum:'getset_descriptor'
    maximum_limit:'getset_descriptor'
    minimum:'getset_descriptor'
    minimum_limit:'getset_descriptor'
    notation:'getset_descriptor'
    number_of_ticks:'getset_descriptor'
    pen:'getset_descriptor'
    point1:'getset_descriptor'
    point2:'getset_descriptor'
    position:'getset_descriptor'
    position1:'getset_descriptor'
    position2:'getset_descriptor'
    precision:'getset_descriptor'
    range:'getset_descriptor'
    range_label_format:'getset_descriptor'
    range_labels_visible:'getset_descriptor'
    scaling_factor:'getset_descriptor'
    shift:'getset_descriptor'
    tick_label_algorithm:'getset_descriptor'
    tick_labels:'getset_descriptor'
    tick_length:'getset_descriptor'
    tick_positions:'getset_descriptor'
    tick_scene_positions:'getset_descriptor'
    ticks_visible:'getset_descriptor'
    title:'getset_descriptor'
    title_properties:'getset_descriptor'
    title_visible:'getset_descriptor'
    unscaled_maximum:'getset_descriptor'
    unscaled_maximum_limit:'getset_descriptor'
    unscaled_minimum:'getset_descriptor'
    unscaled_minimum_limit:'getset_descriptor'
    unscaled_range:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AutoScale(self) -> None: ...
    def GenerateSimpleLabel(self, val:float) -> str: ...
    def GetAxisVisible(self) -> bool: ...
    def GetBehavior(self) -> int: ...
    def GetBoundingRect(self, painter:'vtkContext2D') -> 'vtkRectf': ...
    def GetGridPen(self) -> 'vtkPen': ...
    def GetGridVisible(self) -> bool: ...
    def GetLabelFormat(self) -> str: ...
    def GetLabelOffset(self) -> float: ...
    def GetLabelProperties(self) -> 'vtkTextProperty': ...
    def GetLabelsVisible(self) -> bool: ...
    def GetLogScale(self) -> bool: ...
    def GetLogScaleActive(self) -> bool: ...
    def GetMargins(self) -> Tuple[int, int]: ...
    def GetMaximum(self) -> float: ...
    def GetMaximumLimit(self) -> float: ...
    def GetMinimum(self) -> float: ...
    def GetMinimumLimit(self) -> float: ...
    def GetNotation(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTicks(self) -> int: ...
    def GetPen(self) -> 'vtkPen': ...
    def GetPoint1(self) -> Tuple[float, float]: ...
    def GetPoint2(self) -> Tuple[float, float]: ...
    def GetPosition(self) -> int: ...
    def GetPosition1(self) -> 'vtkVector2f': ...
    def GetPosition2(self) -> 'vtkVector2f': ...
    def GetPrecision(self) -> int: ...
    def GetRange(self, range:MutableSequence[float]) -> None: ...
    def GetRangeLabelFormat(self) -> str: ...
    def GetRangeLabelsVisible(self) -> bool: ...
    def GetScalingFactor(self) -> float: ...
    def GetShift(self) -> float: ...
    def GetTickLabelAlgorithm(self) -> int: ...
    def GetTickLabels(self) -> 'vtkStringArray': ...
    def GetTickLength(self) -> float: ...
    def GetTickPositions(self) -> 'vtkDoubleArray': ...
    def GetTickScenePositions(self) -> 'vtkFloatArray': ...
    def GetTicksVisible(self) -> bool: ...
    def GetTitle(self) -> str: ...
    def GetTitleProperties(self) -> 'vtkTextProperty': ...
    def GetTitleVisible(self) -> bool: ...
    def GetUnscaledMaximum(self) -> float: ...
    def GetUnscaledMaximumLimit(self) -> float: ...
    def GetUnscaledMinimum(self) -> float: ...
    def GetUnscaledMinimumLimit(self) -> float: ...
    def GetUnscaledRange(self, range:MutableSequence[float]) -> None: ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LogScaleOff(self) -> None: ...
    def LogScaleOn(self) -> None: ...
    def NewInstance(self) -> 'vtkAxis': ...
    @staticmethod
    def NiceMinMax(min:float, max:float, pixelRange:float, tickPixelSpacing:float) -> float: ...
    @staticmethod
    def NiceNumber(number:float, roundUp:bool) -> float: ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def RecalculateTickSpacing(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAxis': ...
    def SetAxisVisible(self, _arg:bool) -> None: ...
    def SetBehavior(self, _arg:int) -> None: ...
    def SetCustomTickPositions(self, positions:'vtkDoubleArray', labels:'vtkStringArray'=...) -> bool: ...
    def SetGridPen(self, _arg:'vtkPen') -> None: ...
    def SetGridVisible(self, _arg:bool) -> None: ...
    def SetLabelFormat(self, fmt:str) -> None: ...
    def SetLabelOffset(self, _arg:float) -> None: ...
    def SetLabelsVisible(self, _arg:bool) -> None: ...
    def SetLogScale(self, logScale:bool) -> None: ...
    @overload
    def SetMargins(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetMargins(self, _arg:Sequence[int]) -> None: ...
    def SetMaximum(self, maximum:float) -> None: ...
    def SetMaximumLimit(self, highest:float) -> None: ...
    def SetMinimum(self, minimum:float) -> None: ...
    def SetMinimumLimit(self, lowest:float) -> None: ...
    def SetNotation(self, notation:int) -> None: ...
    def SetNumberOfTicks(self, numberOfTicks:int) -> None: ...
    def SetPen(self, _arg:'vtkPen') -> None: ...
    @overload
    def SetPoint1(self, pos:'vtkVector2f') -> None: ...
    @overload
    def SetPoint1(self, x:float, y:float) -> None: ...
    @overload
    def SetPoint2(self, pos:'vtkVector2f') -> None: ...
    @overload
    def SetPoint2(self, x:float, y:float) -> None: ...
    def SetPosition(self, position:int) -> None: ...
    def SetPrecision(self, precision:int) -> None: ...
    @overload
    def SetRange(self, minimum:float, maximum:float) -> None: ...
    @overload
    def SetRange(self, range:MutableSequence[float]) -> None: ...
    def SetRangeLabelFormat(self, _arg:str) -> None: ...
    def SetRangeLabelsVisible(self, _arg:bool) -> None: ...
    def SetScalingFactor(self, _arg:float) -> None: ...
    def SetShift(self, _arg:float) -> None: ...
    def SetTickLabelAlgorithm(self, _arg:int) -> None: ...
    def SetTickLength(self, _arg:float) -> None: ...
    def SetTicksVisible(self, _arg:bool) -> None: ...
    def SetTitle(self, title:str) -> None: ...
    def SetTitleVisible(self, _arg:bool) -> None: ...
    def SetUnscaledMaximum(self, maximum:float) -> None: ...
    def SetUnscaledMaximumLimit(self, highest:float) -> None: ...
    def SetUnscaledMinimum(self, minimum:float) -> None: ...
    def SetUnscaledMinimumLimit(self, lowest:float) -> None: ...
    @overload
    def SetUnscaledRange(self, minimum:float, maximum:float) -> None: ...
    @overload
    def SetUnscaledRange(self, range:MutableSequence[float]) -> None: ...
    def Update(self) -> None: ...

class vtkAxisExtended(vtkmodules.vtkCommonCore.vtkObject):
    desired_font_size:'getset_descriptor'
    font_size:'getset_descriptor'
    is_axis_vertical:'getset_descriptor'
    label_format:'getset_descriptor'
    orientation:'getset_descriptor'
    precision:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def Coverage(dmin:float, dmax:float, lmin:float, lmax:float) -> float: ...
    @staticmethod
    def CoverageMax(dmin:float, dmax:float, span:float) -> float: ...
    @staticmethod
    def Density(k:int, m:float, dmin:float, dmax:float, lmin:float, lmax:float) -> float: ...
    @staticmethod
    def DensityMax(k:int, m:float) -> float: ...
    @staticmethod
    def FormatLegibilityScore(n:float, format:int) -> float: ...
    @staticmethod
    def FormatStringLength(format:int, n:float, precision:int) -> int: ...
    def GenerateExtendedTickLabels(self, dmin:float, dmax:float, m:float, scaling:float) -> 'vtkVector3d': ...
    def GetDesiredFontSize(self) -> int: ...
    def GetFontSize(self) -> int: ...
    def GetIsAxisVertical(self) -> bool: ...
    def GetLabelFormat(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetPrecision(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAxisExtended': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAxisExtended': ...
    def SetDesiredFontSize(self, _arg:int) -> None: ...
    def SetFontSize(self, _arg:int) -> None: ...
    def SetIsAxisVertical(self, _arg:bool) -> None: ...
    def SetLabelFormat(self, _arg:int) -> None: ...
    def SetOrientation(self, _arg:int) -> None: ...
    def SetPrecision(self, _arg:int) -> None: ...
    @staticmethod
    def Simplicity(qIndex:int, qLength:int, j:int, lmin:float, lmax:float, lstep:float) -> float: ...
    @staticmethod
    def SimplicityMax(qIndex:int, qLength:int, j:int) -> float: ...

class vtkChartLegend(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    BOTTOM:int
    CENTER:int
    CUSTOM:int
    LEFT:int
    RIGHT:int
    TOP:int
    brush:'getset_descriptor'
    cache_bounds:'getset_descriptor'
    chart:'getset_descriptor'
    drag_enabled:'getset_descriptor'
    horizontal_alignment:'getset_descriptor'
    inline:'getset_descriptor'
    label_properties:'getset_descriptor'
    label_size:'getset_descriptor'
    padding:'getset_descriptor'
    pen:'getset_descriptor'
    point:'getset_descriptor'
    point_is_normalized:'getset_descriptor'
    point_vector:'getset_descriptor'
    symbol_width:'getset_descriptor'
    vertical_alignment:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CacheBoundsOff(self) -> None: ...
    def CacheBoundsOn(self) -> None: ...
    def GetBoundingRect(self, painter:'vtkContext2D') -> 'vtkRectf': ...
    def GetBrush(self) -> 'vtkBrush': ...
    def GetCacheBounds(self) -> bool: ...
    def GetChart(self) -> 'vtkChart': ...
    def GetDragEnabled(self) -> bool: ...
    def GetHorizontalAlignment(self) -> int: ...
    def GetInline(self) -> bool: ...
    def GetLabelProperties(self) -> 'vtkTextProperty': ...
    def GetLabelSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPadding(self) -> int: ...
    def GetPen(self) -> 'vtkPen': ...
    def GetPoint(self) -> Tuple[float, float]: ...
    def GetPointIsNormalized(self) -> bool: ...
    def GetPointVector(self) -> 'vtkVector2f': ...
    def GetSymbolWidth(self) -> int: ...
    def GetVerticalAlignment(self) -> int: ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseButtonReleaseEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def NewInstance(self) -> 'vtkChartLegend': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PointIsNormalizedOff(self) -> None: ...
    def PointIsNormalizedOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkChartLegend': ...
    def SetCacheBounds(self, _arg:bool) -> None: ...
    def SetChart(self, chart:'vtkChart') -> None: ...
    def SetDragEnabled(self, _arg:bool) -> None: ...
    def SetHorizontalAlignment(self, _arg:int) -> None: ...
    def SetInline(self, _arg:bool) -> None: ...
    def SetLabelSize(self, size:int) -> None: ...
    def SetPadding(self, _arg:int) -> None: ...
    @overload
    def SetPoint(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetPoint(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetPoint(self, point:'vtkVector2f') -> None: ...
    def SetPointIsNormalized(self, _arg:bool) -> None: ...
    def SetSymbolWidth(self, _arg:int) -> None: ...
    def SetVerticalAlignment(self, _arg:int) -> None: ...
    def Update(self) -> None: ...

class vtkCategoryLegend(vtkChartLegend):
    HORIZONTAL:int
    VERTICAL:int
    outlier_label:'getset_descriptor'
    scalars_to_colors:'getset_descriptor'
    title:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBoundingRect(self, painter:'vtkContext2D') -> 'vtkRectf': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutlierLabel(self) -> str: ...
    def GetScalarsToColors(self) -> 'vtkScalarsToColors': ...
    def GetTitle(self) -> str: ...
    def GetValues(self) -> 'vtkVariantArray': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCategoryLegend': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCategoryLegend': ...
    def SetOutlierLabel(self, _arg:str) -> None: ...
    def SetScalarsToColors(self, stc:'vtkScalarsToColors') -> None: ...
    def SetTitle(self, title:str) -> None: ...
    def SetValues(self, __a:'vtkVariantArray') -> None: ...

class vtkChart(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    class EventIds(int): ...
    ACTION_TYPES_COUNT:int
    AREA:int
    AXES_TO_RECT:int
    BAG:int
    BAR:int
    CLICK_AND_DRAG:int
    FILL_RECT:int
    FILL_SCENE:int
    FUNCTIONALBAG:int
    LINE:int
    NOTIFY:int
    PAN:int
    POINTS:int
    SELECT:int
    SELECTION_COLUMNS:int
    SELECTION_PLOTS:int
    SELECTION_ROWS:int
    SELECT_POLYGON:int
    SELECT_RECTANGLE:int
    STACKED:int
    UpdateRange:'EventIds'
    ZOOM:int
    ZOOM_AXIS:int
    action_to_button:'getset_descriptor'
    annotation_link:'getset_descriptor'
    auto_size:'getset_descriptor'
    background_brush:'getset_descriptor'
    borders:'getset_descriptor'
    bottom_border:'getset_descriptor'
    click_action_to_button:'getset_descriptor'
    geometry:'getset_descriptor'
    layout_strategy:'getset_descriptor'
    left_border:'getset_descriptor'
    legend:'getset_descriptor'
    number_of_axes:'getset_descriptor'
    number_of_plots:'getset_descriptor'
    point1:'getset_descriptor'
    point2:'getset_descriptor'
    render_empty:'getset_descriptor'
    right_border:'getset_descriptor'
    selection_method:'getset_descriptor'
    selection_mode:'getset_descriptor'
    show_legend:'getset_descriptor'
    size:'getset_descriptor'
    title:'getset_descriptor'
    title_properties:'getset_descriptor'
    top_border:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def AddPlot(self, type:int) -> 'vtkPlot': ...
    @overload
    def AddPlot(self, plot:'vtkPlot') -> int: ...
    def ClearPlots(self) -> None: ...
    def GetActionToButton(self, action:int) -> int: ...
    def GetAnnotationLink(self) -> 'vtkAnnotationLink': ...
    def GetAutoSize(self) -> bool: ...
    def GetAxis(self, axisIndex:int) -> 'vtkAxis': ...
    def GetBackgroundBrush(self) -> 'vtkBrush': ...
    def GetClickActionToButton(self, action:int) -> int: ...
    def GetGeometry(self) -> Tuple[int, int]: ...
    def GetLayoutStrategy(self) -> int: ...
    def GetLegend(self) -> 'vtkChartLegend': ...
    def GetNumberOfAxes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPlots(self) -> int: ...
    def GetPlot(self, index:int) -> 'vtkPlot': ...
    def GetPoint1(self) -> Tuple[int, int]: ...
    def GetPoint2(self) -> Tuple[int, int]: ...
    def GetRenderEmpty(self) -> bool: ...
    def GetSelectionMethod(self) -> int: ...
    def GetSelectionMode(self) -> int: ...
    def GetSelectionModeMaxValue(self) -> int: ...
    def GetSelectionModeMinValue(self) -> int: ...
    def GetShowLegend(self) -> bool: ...
    def GetSize(self) -> 'vtkRectf': ...
    def GetTitle(self) -> str: ...
    def GetTitleProperties(self) -> 'vtkTextProperty': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkChart': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def RecalculateBounds(self) -> None: ...
    def RemoveAllPlots(self) -> None: ...
    @overload
    def RemovePlot(self, index:int) -> bool: ...
    @overload
    def RemovePlot(self, plot:'vtkPlot') -> bool: ...
    def RemovePlotInstance(self, plot:'vtkPlot') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkChart': ...
    def SetActionToButton(self, action:int, button:int) -> None: ...
    def SetAnnotationLink(self, link:'vtkAnnotationLink') -> None: ...
    def SetAutoSize(self, isAutoSized:bool) -> None: ...
    def SetAxis(self, axisIndex:int, __b:'vtkAxis') -> None: ...
    def SetBackgroundBrush(self, brush:'vtkBrush') -> None: ...
    def SetBorders(self, left:int, bottom:int, right:int, top:int) -> None: ...
    def SetBottomBorder(self, border:int) -> None: ...
    def SetClickActionToButton(self, action:int, button:int) -> None: ...
    @overload
    def SetGeometry(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetGeometry(self, _arg:Sequence[int]) -> None: ...
    def SetLayoutStrategy(self, _arg:int) -> None: ...
    def SetLeftBorder(self, border:int) -> None: ...
    @overload
    def SetPoint1(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetPoint1(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetPoint2(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetPoint2(self, _arg:Sequence[int]) -> None: ...
    def SetRenderEmpty(self, _arg:bool) -> None: ...
    def SetRightBorder(self, border:int) -> None: ...
    def SetSelectionMethod(self, method:int) -> None: ...
    def SetSelectionMode(self, _arg:int) -> None: ...
    def SetShowLegend(self, visible:bool) -> None: ...
    def SetSize(self, rect:'vtkRectf') -> None: ...
    def SetTitle(self, title:str) -> None: ...
    def SetTopBorder(self, border:int) -> None: ...

class vtkChartBox(vtkChart):
    column_visibility_all:'getset_descriptor'
    geometry:'getset_descriptor'
    layout_strategy:'getset_descriptor'
    number_of_plots:'getset_descriptor'
    number_of_visible_columns:'getset_descriptor'
    plot:'getset_descriptor'
    selected_column:'getset_descriptor'
    size:'getset_descriptor'
    tooltip:'getset_descriptor'
    visible_columns:'getset_descriptor'
    y_axis:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetColumnId(self, name:str) -> int: ...
    @overload
    def GetColumnVisibility(self, name:str) -> bool: ...
    @overload
    def GetColumnVisibility(self, column:int) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPlots(self) -> int: ...
    def GetNumberOfVisibleColumns(self) -> int: ...
    def GetPlot(self, index:int) -> 'vtkPlot': ...
    def GetSelectedColumn(self) -> int: ...
    def GetTooltip(self) -> 'vtkTooltipItem': ...
    def GetVisibleColumns(self) -> 'vtkStringArray': ...
    def GetXPosition(self, index:int) -> float: ...
    def GetYAxis(self) -> 'vtkAxis': ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseButtonReleaseEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def NewInstance(self) -> 'vtkChartBox': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkChartBox': ...
    @overload
    def SetColumnVisibility(self, name:str, visible:bool) -> None: ...
    @overload
    def SetColumnVisibility(self, column:int, visible:bool) -> None: ...
    def SetColumnVisibilityAll(self, visible:bool) -> None: ...
    def SetGeometry(self, arg1:int, arg2:int) -> None: ...
    def SetLayoutStrategy(self, strategy:int) -> None: ...
    def SetPlot(self, plot:'vtkPlotBox') -> None: ...
    def SetSelectedColumn(self, _arg:int) -> None: ...
    def SetSize(self, rect:'vtkRectf') -> None: ...
    def SetTooltip(self, tooltip:'vtkTooltipItem') -> None: ...
    def SetTooltipInfo(self, __a:'vtkContextMouseEvent', __b:'vtkVector2d', __c:int, __d:'vtkPlot', segmentIndex:int=-1) -> None: ...
    def Update(self) -> None: ...

class vtkChartBoxData(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkChartBoxData') -> None: ...

class vtkChartXY(vtkChart):
    adjust_lower_bound_for_log_plot:'getset_descriptor'
    auto_axes:'getset_descriptor'
    bar_width_fraction:'getset_descriptor'
    drag_point_along_x:'getset_descriptor'
    drag_point_along_y:'getset_descriptor'
    draw_axes_at_origin:'getset_descriptor'
    force_axes_to_bounds:'getset_descriptor'
    hidden_axis_border:'getset_descriptor'
    ignore_nan_in_bounds:'getset_descriptor'
    legend:'getset_descriptor'
    number_of_axes:'getset_descriptor'
    number_of_plots:'getset_descriptor'
    selection_method:'getset_descriptor'
    show_legend:'getset_descriptor'
    tooltip:'getset_descriptor'
    zoom_with_mouse_wheel:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def AddPlot(self, type:int) -> 'vtkPlot': ...
    @overload
    def AddPlot(self, type:int, blockIndex:int) -> 'vtkPlot': ...
    @overload
    def AddPlot(self, plot:'vtkPlot') -> int: ...
    @overload
    def AddPlot(self, plot:'vtkPlot', blockIndex:int) -> int: ...
    @staticmethod
    def AddSelection(selection:'vtkIdTypeArray', oldSelection:'vtkIdTypeArray') -> None: ...
    def AdjustLowerBoundForLogPlotOff(self) -> None: ...
    def AdjustLowerBoundForLogPlotOn(self) -> None: ...
    def AutoAxesOff(self) -> None: ...
    def AutoAxesOn(self) -> None: ...
    @staticmethod
    def BuildSelection(link:'vtkAnnotationLink', selectionMode:int, plotSelection:'vtkIdTypeArray', oldSelection:'vtkIdTypeArray', plot:'vtkPlot') -> None: ...
    def ClearPlots(self) -> None: ...
    def DragPointAlongXOff(self) -> None: ...
    def DragPointAlongXOn(self) -> None: ...
    def DragPointAlongYOff(self) -> None: ...
    def DragPointAlongYOn(self) -> None: ...
    def DrawAxesAtOriginOff(self) -> None: ...
    def DrawAxesAtOriginOn(self) -> None: ...
    def ForceAxesToBoundsOff(self) -> None: ...
    def ForceAxesToBoundsOn(self) -> None: ...
    def GetAdjustLowerBoundForLogPlot(self) -> bool: ...
    def GetAutoAxes(self) -> bool: ...
    def GetAxis(self, axisIndex:int) -> 'vtkAxis': ...
    def GetAxisZoom(self, index:int) -> bool: ...
    def GetBarWidthFraction(self) -> float: ...
    def GetDragPointAlongX(self) -> bool: ...
    def GetDragPointAlongY(self) -> bool: ...
    def GetDrawAxesAtOrigin(self) -> bool: ...
    def GetForceAxesToBounds(self) -> bool: ...
    def GetHiddenAxisBorder(self) -> int: ...
    def GetIgnoreNanInBounds(self) -> bool: ...
    def GetLegend(self) -> 'vtkChartLegend': ...
    @staticmethod
    def GetMouseSelectionMode(mouse:'vtkContextMouseEvent', selectionMode:int) -> int: ...
    def GetNumberOfAxes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPlots(self) -> int: ...
    def GetPlot(self, index:int) -> 'vtkPlot': ...
    def GetPlotCorner(self, plot:'vtkPlot') -> int: ...
    def GetPlotIndex(self, __a:'vtkPlot') -> int: ...
    def GetTooltip(self) -> 'vtkTooltipItem': ...
    def GetZoomWithMouseWheel(self) -> bool: ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IgnoreNanInBoundsOff(self) -> None: ...
    def IgnoreNanInBoundsOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def KeyPressEvent(self, key:'vtkContextKeyEvent') -> bool: ...
    def LowerPlot(self, plot:'vtkPlot') -> int: ...
    @staticmethod
    def MakeSelection(link:'vtkAnnotationLink', selectionIds:'vtkIdTypeArray', plot:'vtkPlot') -> None: ...
    @staticmethod
    def MinusSelection(selection:'vtkIdTypeArray', oldSelection:'vtkIdTypeArray') -> None: ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseButtonReleaseEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseEnterEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseLeaveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseWheelEvent(self, mouse:'vtkContextMouseEvent', delta:int) -> bool: ...
    def NewInstance(self) -> 'vtkChartXY': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def RaisePlot(self, plot:'vtkPlot') -> int: ...
    def RecalculateBounds(self) -> None: ...
    def RemovePlot(self, index:int) -> bool: ...
    def RemovePlotSelections(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkChartXY': ...
    def SetAdjustLowerBoundForLogPlot(self, _arg:bool) -> None: ...
    def SetAutoAxes(self, _arg:bool) -> None: ...
    def SetAxis(self, axisIndex:int, __b:'vtkAxis') -> None: ...
    def SetAxisZoom(self, index:int, v:bool) -> None: ...
    def SetBarWidthFraction(self, _arg:float) -> None: ...
    def SetDragPointAlongX(self, _arg:bool) -> None: ...
    def SetDragPointAlongY(self, _arg:bool) -> None: ...
    def SetDrawAxesAtOrigin(self, _arg:bool) -> None: ...
    def SetForceAxesToBounds(self, _arg:bool) -> None: ...
    def SetHiddenAxisBorder(self, _arg:int) -> None: ...
    def SetIgnoreNanInBounds(self, _arg:bool) -> None: ...
    def SetPlotCorner(self, plot:'vtkPlot', corner:int) -> None: ...
    def SetSelectionMethod(self, method:int) -> None: ...
    def SetShowLegend(self, visible:bool) -> None: ...
    def SetTooltip(self, tooltip:'vtkTooltipItem') -> None: ...
    def SetTooltipInfo(self, __a:'vtkContextMouseEvent', __b:'vtkVector2d', __c:int, __d:'vtkPlot', segmentIndex:int=-1) -> None: ...
    def SetZoomWithMouseWheel(self, _arg:bool) -> None: ...
    def StackPlotAbove(self, plot:'vtkPlot', under:'vtkPlot') -> int: ...
    def StackPlotUnder(self, plot:'vtkPlot', above:'vtkPlot') -> int: ...
    @staticmethod
    def ToggleSelection(selection:'vtkIdTypeArray', oldSelection:'vtkIdTypeArray') -> None: ...
    def Update(self) -> None: ...
    def ZoomWithMouseWheelOff(self) -> None: ...
    def ZoomWithMouseWheelOn(self) -> None: ...

class vtkChartHistogram2D(vtkChartXY):
    transfer_function:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlot(self, index:int) -> 'vtkPlot': ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkChartHistogram2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkChartHistogram2D': ...
    def SetInputData(self, data:'vtkImageData', z:int=0) -> None: ...
    def SetTransferFunction(self, function:'vtkScalarsToColors') -> None: ...
    def Update(self) -> None: ...

class vtkChartMatrix(vtkmodules.vtkRenderingContext2D.vtkAbstractContextItem):
    class StretchType(int):
        CUSTOM:'StretchType'
        SCENE:'StretchType'
    border_bottom:'getset_descriptor'
    border_left:'getset_descriptor'
    border_right:'getset_descriptor'
    border_top:'getset_descriptor'
    borders:'getset_descriptor'
    fill_strategy:'getset_descriptor'
    gutter:'getset_descriptor'
    gutter_x:'getset_descriptor'
    gutter_y:'getset_descriptor'
    number_of_charts:'getset_descriptor'
    padding:'getset_descriptor'
    rect:'getset_descriptor'
    size:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Allocate(self) -> None: ...
    def ClearSpecificResizes(self) -> None: ...
    def ComputeCurrentElementSceneRect(self, index:'vtkVector2i', offset:'vtkVector2f', increment:'vtkVector2f') -> 'vtkRectf': ...
    def GetBorders(self, borders:MutableSequence[int]) -> None: ...
    def GetChart(self, position:'vtkVector2i') -> 'vtkChart': ...
    def GetChartIndex(self, position:'vtkVector2f') -> 'vtkVector2i': ...
    def GetChartMatrix(self, position:'vtkVector2i') -> 'vtkChartMatrix': ...
    def GetChartSpan(self, position:'vtkVector2i') -> 'vtkVector2i': ...
    def GetFillStrategy(self) -> 'StretchType': ...
    def GetFlatIndex(self, index:'vtkVector2i') -> int: ...
    def GetGutter(self) -> 'vtkVector2f': ...
    def GetNumberOfCharts(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRect(self) -> 'vtkRecti': ...
    def GetSize(self) -> 'vtkVector2i': ...
    def GoToNextElement(self, index:'vtkVector2i', offset:'vtkVector2f') -> None: ...
    def InitLayoutTraversal(self, index:'vtkVector2i', offset:'vtkVector2f', increment:'vtkVector2f') -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsDoneWithTraversal(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LabelOuter(self, leftBottomIdx:'vtkVector2i', rightTopIdx:'vtkVector2i') -> None: ...
    @overload
    def Link(self, index1:'vtkVector2i', index2:'vtkVector2i', axis:int=1) -> None: ...
    @overload
    def Link(self, flatIndex1:int, flatIndex2:int, axis:int=1) -> None: ...
    @overload
    def LinkAll(self, index:'vtkVector2i', axis:int=1) -> None: ...
    @overload
    def LinkAll(self, flatIndex:int, axis:int=1) -> None: ...
    def NewInstance(self) -> 'vtkChartMatrix': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def ResetLinkedLayout(self) -> None: ...
    def ResetLinks(self, axis:int=1) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkChartMatrix': ...
    def SetBorderBottom(self, value:int) -> None: ...
    def SetBorderLeft(self, value:int) -> None: ...
    def SetBorderRight(self, value:int) -> None: ...
    def SetBorderTop(self, value:int) -> None: ...
    def SetBorders(self, left:int, bottom:int, right:int, top:int) -> None: ...
    def SetChart(self, position:'vtkVector2i', chart:'vtkChart') -> bool: ...
    def SetChartMatrix(self, position:'vtkVector2i', chartMatrix:'vtkChartMatrix') -> bool: ...
    def SetChartSpan(self, position:'vtkVector2i', span:'vtkVector2i') -> bool: ...
    def SetFillStrategy(self, _arg:'StretchType') -> None: ...
    def SetGutter(self, gutter:'vtkVector2f') -> None: ...
    def SetGutterX(self, value:float) -> None: ...
    def SetGutterY(self, value:float) -> None: ...
    def SetPadding(self, padding:float) -> None: ...
    def SetRect(self, rect:'vtkRecti') -> None: ...
    def SetSize(self, size:'vtkVector2i') -> None: ...
    def SetSpecificResize(self, index:'vtkVector2i', resize:'vtkVector2f') -> None: ...
    @overload
    def Unlink(self, index1:'vtkVector2i', index2:'vtkVector2i', axis:int=1) -> None: ...
    @overload
    def Unlink(self, flatIndex1:int, flatIndex2:int, axis:int=1) -> None: ...
    @overload
    def UnlinkAll(self, index:'vtkVector2i', axis:int=1) -> None: ...
    @overload
    def UnlinkAll(self, flatIndex:int, axis:int=1) -> None: ...
    def Update(self) -> None: ...

class vtkChartParallelCoordinates(vtkChart):
    column_visibility_all:'getset_descriptor'
    legend:'getset_descriptor'
    number_of_axes:'getset_descriptor'
    number_of_plots:'getset_descriptor'
    plot:'getset_descriptor'
    show_legend:'getset_descriptor'
    visible_columns:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAxis(self, axisIndex:int) -> 'vtkAxis': ...
    def GetColumnVisibility(self, name:str) -> bool: ...
    def GetLegend(self) -> 'vtkChartLegend': ...
    def GetNumberOfAxes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPlots(self) -> int: ...
    def GetPlot(self, index:int) -> 'vtkPlot': ...
    def GetVisibleColumns(self) -> 'vtkStringArray': ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseButtonReleaseEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseEnterEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseLeaveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseWheelEvent(self, mouse:'vtkContextMouseEvent', delta:int) -> bool: ...
    def NewInstance(self) -> 'vtkChartParallelCoordinates': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PaintRect(self, painter:'vtkContext2D', axis:int, min:float, max:float) -> bool: ...
    def RecalculateBounds(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkChartParallelCoordinates': ...
    def SetColumnVisibility(self, name:str, visible:bool) -> None: ...
    def SetColumnVisibilityAll(self, visible:bool) -> None: ...
    def SetPlot(self, plot:'vtkPlotParallelCoordinates') -> None: ...
    def SetShowLegend(self, visible:bool) -> None: ...
    def SetVisibleColumns(self, visColumns:'vtkStringArray') -> None: ...
    def Update(self) -> None: ...
    def UpdateCurrentAxisSelection(self, axisId:int) -> None: ...

class vtkChartPie(vtkChart):
    legend:'getset_descriptor'
    number_of_plots:'getset_descriptor'
    plot:'getset_descriptor'
    scene:'getset_descriptor'
    show_legend:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def AddPlot(self, type:int) -> 'vtkPlot': ...
    @overload
    def AddPlot(self, plot:'vtkPlot') -> int: ...
    def GetLegend(self) -> 'vtkChartLegend': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPlots(self) -> int: ...
    def GetPlot(self, index:int) -> 'vtkPlot': ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseButtonReleaseEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseEnterEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseLeaveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseWheelEvent(self, mouse:'vtkContextMouseEvent', delta:int) -> bool: ...
    def NewInstance(self) -> 'vtkChartPie': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkChartPie': ...
    def SetPlot(self, plot:'vtkPlotPie') -> None: ...
    def SetScene(self, scene:'vtkContextScene') -> None: ...
    def SetShowLegend(self, visible:bool) -> None: ...
    def Update(self) -> None: ...

class vtkChartPlotData(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkChartPlotData') -> None: ...

class vtkChartXYZ(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    angle:'getset_descriptor'
    annotation_link:'getset_descriptor'
    around_x:'getset_descriptor'
    auto_rotate:'getset_descriptor'
    axes_text_property:'getset_descriptor'
    axis_color:'getset_descriptor'
    clipping_planes_enabled:'getset_descriptor'
    decorate_axes:'getset_descriptor'
    ensure_outer_edge_axis_labelling:'getset_descriptor'
    fit_to_scene:'getset_descriptor'
    geometry:'getset_descriptor'
    margins:'getset_descriptor'
    scale_box_with_plot:'getset_descriptor'
    x_axis_label:'getset_descriptor'
    y_axis_label:'getset_descriptor'
    z_axis_label:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddPlot(self, plot:'vtkPlot3D') -> int: ...
    def ClearPlots(self) -> None: ...
    def GetAxesTextProperty(self) -> 'vtkTextProperty': ...
    def GetAxis(self, axis:int) -> 'vtkAxis': ...
    def GetAxisColor(self) -> 'vtkColor4ub': ...
    def GetClippingPlanesEnabled(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaleBoxWithPlot(self) -> bool: ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def KeyPressEvent(self, key:'vtkContextKeyEvent') -> bool: ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseWheelEvent(self, mouse:'vtkContextMouseEvent', delta:int) -> bool: ...
    def NewInstance(self) -> 'vtkChartXYZ': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def RecalculateBounds(self) -> None: ...
    def RecalculateTransform(self) -> None: ...
    def RemovePlot(self, plot:'vtkPlot3D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkChartXYZ': ...
    def SetAngle(self, _arg:float) -> None: ...
    def SetAnnotationLink(self, link:'vtkAnnotationLink') -> None: ...
    def SetAroundX(self, isX:bool) -> None: ...
    def SetAutoRotate(self, _arg:bool) -> None: ...
    def SetAxis(self, axisIndex:int, axis:'vtkAxis') -> None: ...
    def SetAxisColor(self, color:'vtkColor4ub') -> None: ...
    def SetClippingPlanesEnabled(self, __a:bool) -> None: ...
    def SetDecorateAxes(self, b:bool) -> None: ...
    def SetEnsureOuterEdgeAxisLabelling(self, _arg:bool) -> None: ...
    def SetFitToScene(self, b:bool) -> None: ...
    def SetGeometry(self, bounds:'vtkRectf') -> None: ...
    def SetMargins(self, margins:'vtkVector4i') -> None: ...
    def SetScaleBoxWithPlot(self, _arg:bool) -> None: ...
    def SetXAxisLabel(self, _arg:str) -> None: ...
    def SetYAxisLabel(self, _arg:str) -> None: ...
    def SetZAxisLabel(self, _arg:str) -> None: ...
    def Update(self) -> None: ...

class vtkColorLegend(vtkChartLegend):
    HORIZONTAL:int
    VERTICAL:int
    draw_border:'getset_descriptor'
    orientation:'getset_descriptor'
    point:'getset_descriptor'
    position:'getset_descriptor'
    texture_size:'getset_descriptor'
    title:'getset_descriptor'
    transfer_function:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DrawBorderOff(self) -> None: ...
    def DrawBorderOn(self) -> None: ...
    def GetBoundingRect(self, painter:'vtkContext2D') -> 'vtkRectf': ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetDrawBorder(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetPosition(self) -> 'vtkRectf': ...
    def GetTitle(self) -> str: ...
    def GetTransferFunction(self) -> 'vtkScalarsToColors': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def NewInstance(self) -> 'vtkColorLegend': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkColorLegend': ...
    def SetDrawBorder(self, _arg:bool) -> None: ...
    def SetOrientation(self, orientation:int) -> None: ...
    def SetPoint(self, x:float, y:float) -> None: ...
    def SetPosition(self, pos:'vtkRectf') -> None: ...
    def SetTextureSize(self, w:float, h:float) -> None: ...
    def SetTitle(self, title:str) -> None: ...
    def SetTransferFunction(self, transfer:'vtkScalarsToColors') -> None: ...
    def Update(self) -> None: ...

class vtkPlot(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    brush:'getset_descriptor'
    color:'getset_descriptor'
    color_f:'getset_descriptor'
    data:'getset_descriptor'
    indexed_labels:'getset_descriptor'
    input:'getset_descriptor'
    input_connection:'getset_descriptor'
    input_data:'getset_descriptor'
    label:'getset_descriptor'
    labels:'getset_descriptor'
    legend_visibility:'getset_descriptor'
    pen:'getset_descriptor'
    selectable:'getset_descriptor'
    selection:'getset_descriptor'
    selection_brush:'getset_descriptor'
    selection_pen:'getset_descriptor'
    shift_scale:'getset_descriptor'
    tooltip_label_format:'getset_descriptor'
    tooltip_notation:'getset_descriptor'
    tooltip_precision:'getset_descriptor'
    use_index_for_x_series:'getset_descriptor'
    width:'getset_descriptor'
    x_axis:'getset_descriptor'
    x_axis_input_array_to_process:'getset_descriptor'
    y_axis:'getset_descriptor'
    y_axis_input_array_to_process:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    @staticmethod
    def ClampPos(pos:MutableSequence[float], bounds:MutableSequence[float]) -> bool: ...
    @overload
    def ClampPos(self, pos:MutableSequence[float]) -> bool: ...
    @staticmethod
    def FilterSelectedPoints(points:'vtkDataArray', selectedPoints:'vtkDataArray', selectedIds:'vtkIdTypeArray') -> None: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetBrush(self) -> 'vtkBrush': ...
    @overload
    def GetColor(self, rgb:MutableSequence[int]) -> None: ...
    @overload
    def GetColor(self, rgb:MutableSequence[float]) -> None: ...
    def GetColorF(self, rgb:MutableSequence[float]) -> None: ...
    def GetColorRGBA(self, rgba:MutableSequence[int]) -> None: ...
    def GetData(self) -> 'vtkContextMapper2D': ...
    def GetIndexedLabels(self) -> 'vtkStringArray': ...
    def GetInput(self) -> 'vtkTable': ...
    def GetInputConnection(self) -> 'vtkAlgorithmOutput': ...
    @overload
    def GetLabel(self) -> str: ...
    @overload
    def GetLabel(self, index:int) -> str: ...
    def GetLabels(self) -> 'vtkStringArray': ...
    def GetLegendVisibility(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLabels(self) -> int: ...
    def GetPen(self) -> 'vtkPen': ...
    def GetProperty(self, property:str) -> 'vtkVariant': ...
    def GetSelectable(self) -> bool: ...
    def GetSelection(self) -> 'vtkIdTypeArray': ...
    def GetSelectionBrush(self) -> 'vtkBrush': ...
    def GetSelectionPen(self) -> 'vtkPen': ...
    def GetShiftScale(self) -> 'vtkRectd': ...
    def GetTooltipLabel(self, plotPos:'vtkVector2d', seriesIndex:int, segmentIndex:int) -> str: ...
    def GetTooltipLabelFormat(self) -> str: ...
    def GetTooltipNotation(self) -> int: ...
    def GetTooltipPrecision(self) -> int: ...
    def GetUnscaledInputBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetUseIndexForXSeries(self) -> bool: ...
    def GetWidth(self) -> float: ...
    def GetXAxis(self) -> 'vtkAxis': ...
    def GetXAxisInputArrayToProcess(self) -> str: ...
    def GetYAxis(self) -> 'vtkAxis': ...
    def GetYAxisInputArrayToProcess(self) -> str: ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LegendVisibilityOff(self) -> None: ...
    def LegendVisibilityOn(self) -> None: ...
    def NewInstance(self) -> 'vtkPlot': ...
    def PaintLegend(self, painter:'vtkContext2D', rect:'vtkRectf', legendIndex:int) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlot': ...
    def SelectPoints(self, min:'vtkVector2f', max:'vtkVector2f') -> bool: ...
    def SelectPointsInPolygon(self, polygon:'vtkContextPolygon') -> bool: ...
    def SelectableOff(self) -> None: ...
    def SelectableOn(self) -> None: ...
    def SetBrush(self, brush:'vtkBrush') -> None: ...
    @overload
    def SetColor(self, r:int, g:int, b:int, a:int) -> None: ...
    @overload
    def SetColor(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetColorF(self, r:float, g:float, b:float, a:float) -> None: ...
    @overload
    def SetColorF(self, r:float, g:float, b:float) -> None: ...
    def SetIndexedLabels(self, labels:'vtkStringArray') -> None: ...
    def SetInputArray(self, index:int, name:str) -> None: ...
    def SetInputConnection(self, input:'vtkAlgorithmOutput') -> None: ...
    @overload
    def SetInputData(self, table:'vtkTable') -> None: ...
    @overload
    def SetInputData(self, table:'vtkTable', xColumn:str, yColumn:str) -> None: ...
    @overload
    def SetInputData(self, table:'vtkTable', xColumn:int, yColumn:int) -> None: ...
    def SetLabel(self, label:str) -> None: ...
    def SetLabels(self, labels:'vtkStringArray') -> None: ...
    def SetLegendVisibility(self, _arg:bool) -> None: ...
    def SetPen(self, pen:'vtkPen') -> None: ...
    def SetProperty(self, property:str, var:'vtkVariant') -> None: ...
    def SetSelectable(self, _arg:bool) -> None: ...
    def SetSelection(self, id:'vtkIdTypeArray') -> None: ...
    def SetSelectionBrush(self, brush:'vtkBrush') -> None: ...
    def SetSelectionPen(self, pen:'vtkPen') -> None: ...
    def SetShiftScale(self, shiftScale:'vtkRectd') -> None: ...
    def SetTooltipLabelFormat(self, label:str) -> None: ...
    def SetTooltipNotation(self, notation:int) -> None: ...
    def SetTooltipPrecision(self, precision:int) -> None: ...
    def SetUseIndexForXSeries(self, _arg:bool) -> None: ...
    def SetWidth(self, width:float) -> None: ...
    def SetXAxis(self, axis:'vtkAxis') -> None: ...
    def SetXAxisInputArrayToProcess(self, name:str) -> None: ...
    def SetYAxis(self, axis:'vtkAxis') -> None: ...
    def SetYAxisInputArrayToProcess(self, name:str) -> None: ...
    def Update(self) -> None: ...
    def UpdateCache(self) -> bool: ...

class vtkControlPointsItem(vtkPlot):
    CurrentPointChangedEvent:int
    CurrentPointEditEvent:int
    add_point_item:'getset_descriptor'
    current_point:'getset_descriptor'
    draw_points:'getset_descriptor'
    end_points_movable:'getset_descriptor'
    end_points_removable:'getset_descriptor'
    end_points_x_movable:'getset_descriptor'
    end_points_y_movable:'getset_descriptor'
    label_format:'getset_descriptor'
    number_of_points:'getset_descriptor'
    number_of_selected_points:'getset_descriptor'
    screen_point_radius:'getset_descriptor'
    selected_point_brush:'getset_descriptor'
    selected_point_pen:'getset_descriptor'
    show_labels:'getset_descriptor'
    stroke_mode:'getset_descriptor'
    switch_points_mode:'getset_descriptor'
    use_add_point_item:'getset_descriptor'
    user_bounds:'getset_descriptor'
    valid_bounds:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddPoint(self, newPos:MutableSequence[float]) -> int: ...
    def DeselectAllPoints(self) -> None: ...
    @overload
    def DeselectPoint(self, pointId:int) -> None: ...
    @overload
    def DeselectPoint(self, currentPoint:MutableSequence[float]) -> None: ...
    def DrawPointsOff(self) -> None: ...
    def DrawPointsOn(self) -> None: ...
    def FindPoint(self, pos:MutableSequence[float]) -> int: ...
    def GetAddPointItem(self) -> 'vtkPlot': ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetControlPoint(self, index:int, point:MutableSequence[float]) -> None: ...
    def GetControlPointId(self, pos:MutableSequence[float]) -> int: ...
    def GetControlPointsIds(self, ids:'vtkIdTypeArray', excludeFirstAndLast:bool=False) -> None: ...
    def GetCurrentPoint(self) -> int: ...
    def GetDrawPoints(self) -> bool: ...
    def GetEndPointsMovable(self) -> bool: ...
    def GetEndPointsRemovable(self) -> bool: ...
    def GetEndPointsXMovable(self) -> bool: ...
    def GetEndPointsYMovable(self) -> bool: ...
    def GetLabelFormat(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetNumberOfSelectedPoints(self) -> int: ...
    def GetScreenPointRadius(self) -> float: ...
    def GetSelectedPointBrush(self) -> 'vtkBrush': ...
    def GetSelectedPointPen(self) -> 'vtkPen': ...
    def GetShowLabels(self) -> bool: ...
    def GetStrokeMode(self) -> bool: ...
    def GetSwitchPointsMode(self) -> bool: ...
    def GetUseAddPointItem(self) -> bool: ...
    def GetUserBounds(self) -> Tuple[float, float, float, float]: ...
    def GetValidBounds(self) -> Tuple[float, float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    def IsOverPoint(self, pos:MutableSequence[float], pointId:int) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def KeyPressEvent(self, key:'vtkContextKeyEvent') -> bool: ...
    def KeyReleaseEvent(self, key:'vtkContextKeyEvent') -> bool: ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseButtonReleaseEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseDoubleClickEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    @overload
    def MovePoints(self, translation:'vtkVector2f', pointIds:'vtkIdTypeArray') -> None: ...
    @overload
    def MovePoints(self, translation:'vtkVector2f', dontMoveFirstAndLast:bool=False) -> None: ...
    def NewInstance(self) -> 'vtkControlPointsItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def RemoveCurrentPoint(self) -> None: ...
    @overload
    def RemovePoint(self, pos:MutableSequence[float]) -> int: ...
    @overload
    def RemovePoint(self, pointId:int) -> int: ...
    def ResetBounds(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkControlPointsItem': ...
    def SelectAllPoints(self) -> None: ...
    @overload
    def SelectPoint(self, pointId:int) -> None: ...
    @overload
    def SelectPoint(self, currentPoint:MutableSequence[float]) -> None: ...
    def SelectPoints(self, min:'vtkVector2f', max:'vtkVector2f') -> bool: ...
    def SetControlPoint(self, index:int, point:MutableSequence[float]) -> None: ...
    def SetCurrentPoint(self, index:int) -> None: ...
    def SetDrawPoints(self, _arg:bool) -> None: ...
    def SetEndPointsRemovable(self, _arg:bool) -> None: ...
    def SetEndPointsXMovable(self, _arg:bool) -> None: ...
    def SetEndPointsYMovable(self, _arg:bool) -> None: ...
    def SetLabelFormat(self, _arg:str) -> None: ...
    def SetScreenPointRadius(self, _arg:float) -> None: ...
    def SetShowLabels(self, _arg:bool) -> None: ...
    def SetStrokeMode(self, _arg:bool) -> None: ...
    def SetSwitchPointsMode(self, _arg:bool) -> None: ...
    def SetUseAddPointItem(self, _arg:bool) -> None: ...
    @overload
    def SetUserBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetUserBounds(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetValidBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetValidBounds(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SpreadPoints(self, factor:float, pointIds:'vtkIdTypeArray') -> None: ...
    @overload
    def SpreadPoints(self, factor:float, dontSpreadFirstAndLast:bool=False) -> None: ...
    @overload
    def ToggleSelectPoint(self, pointId:int) -> None: ...
    @overload
    def ToggleSelectPoint(self, currentPoint:MutableSequence[float]) -> None: ...
    def UseAddPointItemOff(self) -> None: ...
    def UseAddPointItemOn(self) -> None: ...

class vtkColorTransferControlPointsItem(vtkControlPointsItem):
    color_fill:'getset_descriptor'
    color_transfer_function:'getset_descriptor'
    number_of_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddPoint(self, newPos:MutableSequence[float]) -> int: ...
    def GetColorFill(self) -> bool: ...
    def GetColorTransferFunction(self) -> 'vtkColorTransferFunction': ...
    def GetControlPoint(self, index:int, point:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkColorTransferControlPointsItem': ...
    @overload
    def RemovePoint(self, pos:MutableSequence[float]) -> int: ...
    @overload
    def RemovePoint(self, pointId:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkColorTransferControlPointsItem': ...
    def SetColorFill(self, _arg:bool) -> None: ...
    def SetColorTransferFunction(self, function:'vtkColorTransferFunction') -> None: ...
    def SetControlPoint(self, index:int, point:MutableSequence[float]) -> None: ...

class vtkScalarsToColorsItem(vtkPlot):
    histogram_table:'getset_descriptor'
    mask_above_curve:'getset_descriptor'
    poly_line_pen:'getset_descriptor'
    user_bounds:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetHistogramTable(self) -> 'vtkTable': ...
    def GetMaskAboveCurve(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolyLinePen(self) -> 'vtkPen': ...
    def GetTooltipLabel(self, plotPos:'vtkVector2d', seriesIndex:int, segmentIndex:int) -> str: ...
    def GetUserBounds(self) -> Tuple[float, float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkScalarsToColorsItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkScalarsToColorsItem': ...
    def SetHistogramTable(self, histogramTable:'vtkTable') -> None: ...
    def SetMaskAboveCurve(self, _arg:bool) -> None: ...
    @overload
    def SetUserBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetUserBounds(self, _arg:Sequence[float]) -> None: ...

class vtkColorTransferFunctionItem(vtkScalarsToColorsItem):
    color_transfer_function:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetColorTransferFunction(self) -> 'vtkColorTransferFunction': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkColorTransferFunctionItem': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkColorTransferFunctionItem': ...
    def SetColorTransferFunction(self, t:'vtkColorTransferFunction') -> None: ...

class vtkCompositeControlPointsItem(vtkColorTransferControlPointsItem):
    class PointsFunctionType(int): ...
    ColorAndOpacityPointsFunction:'PointsFunctionType'
    ColorPointsFunction:'PointsFunctionType'
    OpacityPointsFunction:'PointsFunctionType'
    color_transfer_function:'getset_descriptor'
    number_of_points:'getset_descriptor'
    opacity_function:'getset_descriptor'
    points_function:'getset_descriptor'
    use_opacity_point_handles:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddPoint(self, newPos:MutableSequence[float]) -> int: ...
    def GetControlPoint(self, index:int, point:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetOpacityFunction(self) -> 'vtkPiecewiseFunction': ...
    def GetPointsFunction(self) -> int: ...
    def GetUseOpacityPointHandles(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseDoubleClickEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def NewInstance(self) -> 'vtkCompositeControlPointsItem': ...
    @overload
    def RemovePoint(self, pos:MutableSequence[float]) -> int: ...
    @overload
    def RemovePoint(self, pointId:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeControlPointsItem': ...
    def SetColorTransferFunction(self, function:'vtkColorTransferFunction') -> None: ...
    def SetControlPoint(self, index:int, point:MutableSequence[float]) -> None: ...
    def SetOpacityFunction(self, opacity:'vtkPiecewiseFunction') -> None: ...
    def SetPointsFunction(self, _arg:int) -> None: ...
    def SetUseOpacityPointHandles(self, _arg:bool) -> None: ...

class vtkCompositeTransferFunctionItem(vtkColorTransferFunctionItem):
    opacity_function:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacityFunction(self) -> 'vtkPiecewiseFunction': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeTransferFunctionItem': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeTransferFunctionItem': ...
    def SetOpacityFunction(self, opacity:'vtkPiecewiseFunction') -> None: ...

class vtkContextArea(vtkmodules.vtkRenderingContext2D.vtkAbstractContextItem):
    class DrawAreaResizeBehaviorType(int): ...
    DARB_Expand:'DrawAreaResizeBehaviorType'
    DARB_FixedAspect:'DrawAreaResizeBehaviorType'
    DARB_FixedMargins:'DrawAreaResizeBehaviorType'
    DARB_FixedRect:'DrawAreaResizeBehaviorType'
    draw_area_bounds:'getset_descriptor'
    draw_area_item:'getset_descriptor'
    draw_area_resize_behavior:'getset_descriptor'
    fill_viewport:'getset_descriptor'
    fixed_aspect:'getset_descriptor'
    fixed_margins:'getset_descriptor'
    fixed_rect:'getset_descriptor'
    geometry:'getset_descriptor'
    show_grid:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def FillViewportOff(self) -> None: ...
    def FillViewportOn(self) -> None: ...
    def GetAxis(self, location:vtkAxis.Location) -> 'vtkAxis': ...
    def GetDrawAreaBounds(self) -> 'vtkRectd': ...
    def GetDrawAreaItem(self) -> 'vtkAbstractContextItem': ...
    def GetDrawAreaResizeBehavior(self) -> 'DrawAreaResizeBehaviorType': ...
    def GetFillViewport(self) -> bool: ...
    def GetFixedAspect(self) -> float: ...
    def GetFixedMargins(self) -> 'vtkTuple_IiLi4EE': ...
    @overload
    def GetFixedMarginsArray(self, margins:MutableSequence[int]) -> None: ...
    @overload
    def GetFixedMarginsArray(self) -> Pointer: ...
    def GetFixedRect(self) -> 'vtkRecti': ...
    def GetGeometry(self) -> 'vtkRecti': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShowGrid(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContextArea': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContextArea': ...
    def SetDrawAreaBounds(self, _arg:'vtkRectd') -> None: ...
    def SetDrawAreaResizeBehavior(self, _arg:'DrawAreaResizeBehaviorType') -> None: ...
    def SetFillViewport(self, _arg:bool) -> None: ...
    def SetFixedAspect(self, aspect:float) -> None: ...
    @overload
    def SetFixedMargins(self, margins:'vtkTuple_IiLi4EE') -> None: ...
    @overload
    def SetFixedMargins(self, margins:MutableSequence[int]) -> None: ...
    @overload
    def SetFixedMargins(self, left:int, right:int, bottom:int, top:int) -> None: ...
    @overload
    def SetFixedRect(self, rect:'vtkRecti') -> None: ...
    @overload
    def SetFixedRect(self, x:int, y:int, width:int, height:int) -> None: ...
    def SetGeometry(self, _arg:'vtkRecti') -> None: ...
    def SetShowGrid(self, show:bool) -> None: ...
    def ShowGridOff(self) -> None: ...
    def ShowGridOn(self) -> None: ...

class vtkContextPolygon(object):
    number_of_points:'getset_descriptor'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, polygon:'vtkContextPolygon') -> None: ...
    @overload
    def AddPoint(self, point:'vtkVector2f') -> None: ...
    @overload
    def AddPoint(self, x:float, y:float) -> None: ...
    def Clear(self) -> None: ...
    def Contains(self, point:'vtkVector2f') -> bool: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetPoint(self, index:int) -> 'vtkVector2f': ...
    def Transformed(self, transform:'vtkTransform2D') -> 'vtkContextPolygon': ...

class vtkInteractiveArea(vtkContextArea):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseWheelEvent(self, mouse:'vtkContextMouseEvent', delta:int) -> bool: ...
    def NewInstance(self) -> 'vtkInteractiveArea': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInteractiveArea': ...

class vtkLookupTableItem(vtkScalarsToColorsItem):
    lookup_table:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetLookupTable(self) -> 'vtkLookupTable': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLookupTableItem': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLookupTableItem': ...
    def SetLookupTable(self, t:'vtkLookupTable') -> None: ...

class vtkPiecewiseControlPointsItem(vtkControlPointsItem):
    piecewise_function:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddPoint(self, newPos:MutableSequence[float]) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPiecewiseFunction(self) -> 'vtkPiecewiseFunction': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPiecewiseControlPointsItem': ...
    def RemovePoint(self, pos:MutableSequence[float]) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPiecewiseControlPointsItem': ...
    def SetPiecewiseFunction(self, function:'vtkPiecewiseFunction') -> None: ...

class vtkPiecewiseFunctionItem(vtkScalarsToColorsItem):
    piecewise_function:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPiecewiseFunction(self) -> 'vtkPiecewiseFunction': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPiecewiseFunctionItem': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPiecewiseFunctionItem': ...
    def SetPiecewiseFunction(self, t:'vtkPiecewiseFunction') -> None: ...

class vtkPiecewisePointHandleItem(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    current_point_index:'getset_descriptor'
    parent:'getset_descriptor'
    piecewise_function:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def CallRedraw(sender:'vtkObject', event:int, receiver:Pointer, params:Pointer) -> None: ...
    def GetCurrentPointIndex(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPiecewiseFunction(self) -> 'vtkWeakPointer_I20vtkPiecewiseFunctionE': ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    def IsOverHandle(self, pos:MutableSequence[float]) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseButtonReleaseEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def NewInstance(self) -> 'vtkPiecewisePointHandleItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPiecewisePointHandleItem': ...
    def SetCurrentPointIndex(self, _arg:int) -> None: ...
    def SetParent(self, parent:'vtkAbstractContextItem') -> None: ...
    def SetPiecewiseFunction(self, piecewiseFunc:'vtkPiecewiseFunction') -> None: ...

class vtkPlot3D(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    chart:'getset_descriptor'
    colors:'getset_descriptor'
    input_data:'getset_descriptor'
    pen:'getset_descriptor'
    selection:'getset_descriptor'
    selection_pen:'getset_descriptor'
    vtk_points:'getset_descriptor'
    x_axis_label:'getset_descriptor'
    y_axis_label:'getset_descriptor'
    z_axis_label:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetChart(self) -> 'vtkChartXYZ': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPen(self) -> 'vtkPen': ...
    def GetSelection(self) -> 'vtkIdTypeArray': ...
    def GetSelectionPen(self) -> 'vtkPen': ...
    def GetVTKPoints(self) -> 'vtkPoints': ...
    def GetXAxisLabel(self) -> str: ...
    def GetYAxisLabel(self) -> str: ...
    def GetZAxisLabel(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlot3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlot3D': ...
    def SetChart(self, chart:'vtkChartXYZ') -> None: ...
    def SetColors(self, colorArr:'vtkDataArray') -> None: ...
    @overload
    def SetInputData(self, input:'vtkTable') -> None: ...
    @overload
    def SetInputData(self, input:'vtkTable', xName:str, yName:str, zName:str) -> None: ...
    @overload
    def SetInputData(self, input:'vtkTable', xName:str, yName:str, zName:str, colorName:str) -> None: ...
    @overload
    def SetInputData(self, input:'vtkTable', xColumn:int, yColumn:int, zColumn:int) -> None: ...
    def SetPen(self, pen:'vtkPen') -> None: ...
    def SetSelection(self, id:'vtkIdTypeArray') -> None: ...
    def SetSelectionPen(self, pen:'vtkPen') -> None: ...

class vtkPlotArea(vtkPlot):
    color:'getset_descriptor'
    color_f:'getset_descriptor'
    valid_point_mask_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTooltipLabel(self, plotPos:'vtkVector2d', seriesIndex:int, segmentIndex:int) -> str: ...
    def GetValidPointMaskName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotArea': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PaintLegend(self, painter:'vtkContext2D', rect:'vtkRectf', legendIndex:int) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotArea': ...
    @overload
    def SetColor(self, r:int, g:int, b:int, a:int) -> None: ...
    @overload
    def SetColor(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetColorF(self, r:float, g:float, b:float, a:float) -> None: ...
    @overload
    def SetColorF(self, r:float, g:float, b:float) -> None: ...
    def SetInputArray(self, index:int, name:str) -> None: ...
    def SetValidPointMaskName(self, _arg:str) -> None: ...
    def UpdateCache(self) -> bool: ...

class vtkPlotPoints(vtkPlot):
    CIRCLE:int
    CROSS:int
    DIAMOND:int
    NONE:int
    PLUS:int
    SQUARE:int
    color_array_name:'getset_descriptor'
    lookup_table:'getset_descriptor'
    marker_size:'getset_descriptor'
    marker_style:'getset_descriptor'
    scalar_visibility:'getset_descriptor'
    valid_point_mask_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultLookupTable(self) -> None: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetColorArrayName(self) -> str: ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetMarkerSize(self) -> float: ...
    def GetMarkerStyle(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarVisibility(self) -> int: ...
    def GetUnscaledInputBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetValidPointMaskName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotPoints': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PaintLegend(self, painter:'vtkContext2D', rect:'vtkRectf', legendIndex:int) -> bool: ...
    def ReleaseGraphicsCache(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotPoints': ...
    def ScalarVisibilityOff(self) -> None: ...
    def ScalarVisibilityOn(self) -> None: ...
    @overload
    def SelectColorArray(self, arrayNum:int) -> None: ...
    @overload
    def SelectColorArray(self, arrayName:str) -> None: ...
    def SelectPoints(self, min:'vtkVector2f', max:'vtkVector2f') -> bool: ...
    def SelectPointsInPolygon(self, polygon:'vtkContextPolygon') -> bool: ...
    def SetLookupTable(self, lut:'vtkScalarsToColors') -> None: ...
    def SetMarkerSize(self, _arg:float) -> None: ...
    def SetMarkerStyle(self, _arg:int) -> None: ...
    def SetScalarVisibility(self, _arg:int) -> None: ...
    def SetValidPointMaskName(self, _arg:str) -> None: ...
    def UpdateCache(self) -> bool: ...

class vtkPlotBag(vtkPlotPoints):
    bag_visible:'getset_descriptor'
    input_data:'getset_descriptor'
    labels:'getset_descriptor'
    line_pen:'getset_descriptor'
    point_pen:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBagVisible(self) -> bool: ...
    def GetLabels(self) -> 'vtkStringArray': ...
    def GetLinePen(self) -> 'vtkPen': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointPen(self) -> 'vtkPen': ...
    def GetTooltipLabel(self, plotPos:'vtkVector2d', seriesIndex:int, segmentIndex:int) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotBag': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PaintLegend(self, painter:'vtkContext2D', rect:'vtkRectf', legendIndex:int) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotBag': ...
    def SetBagVisible(self, _arg:bool) -> None: ...
    @overload
    def SetInputData(self, table:'vtkTable') -> None: ...
    @overload
    def SetInputData(self, table:'vtkTable', yColumn:str, densityColumn:str) -> None: ...
    @overload
    def SetInputData(self, table:'vtkTable', xColumn:str, yColumn:str, densityColumn:str) -> None: ...
    @overload
    def SetInputData(self, table:'vtkTable', xColumn:int, yColumn:int, densityColumn:int) -> None: ...
    def SetLinePen(self, pen:'vtkPen') -> None: ...
    def SetPointPen(self, pen:'vtkPen') -> None: ...
    def UpdateCache(self) -> bool: ...

class vtkPlotBar(vtkPlot):
    HORIZONTAL:int
    VERTICAL:int
    bars_count:'getset_descriptor'
    color:'getset_descriptor'
    color_array_name:'getset_descriptor'
    color_f:'getset_descriptor'
    color_series:'getset_descriptor'
    enable_opacity_mapping:'getset_descriptor'
    group_name:'getset_descriptor'
    labels:'getset_descriptor'
    lookup_table:'getset_descriptor'
    offset:'getset_descriptor'
    orientation:'getset_descriptor'
    scalar_visibility:'getset_descriptor'
    width:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultLookupTable(self) -> None: ...
    def EnableOpacityMappingOff(self) -> None: ...
    def EnableOpacityMappingOn(self) -> None: ...
    def GetBarsCount(self) -> int: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float], unscaled:bool) -> None: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetColor(self, rgb:MutableSequence[float]) -> None: ...
    def GetColorArrayName(self) -> str: ...
    def GetColorF(self, rgb:MutableSequence[float]) -> None: ...
    def GetColorSeries(self) -> 'vtkColorSeries': ...
    def GetDataBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetEnableOpacityMapping(self) -> bool: ...
    def GetGroupName(self) -> str: ...
    def GetLabels(self) -> 'vtkStringArray': ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> float: ...
    def GetOrientation(self) -> int: ...
    def GetScalarVisibility(self) -> bool: ...
    def GetTooltipLabel(self, plotPos:'vtkVector2d', seriesIndex:int, segmentIndex:int) -> str: ...
    def GetUnscaledInputBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetWidth(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotBar': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PaintLegend(self, painter:'vtkContext2D', rect:'vtkRectf', legendIndex:int) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotBar': ...
    def ScalarVisibilityOff(self) -> None: ...
    def ScalarVisibilityOn(self) -> None: ...
    @overload
    def SelectColorArray(self, arrayNum:int) -> None: ...
    @overload
    def SelectColorArray(self, arrayName:str) -> None: ...
    def SelectPoints(self, min:'vtkVector2f', max:'vtkVector2f') -> bool: ...
    @overload
    def SetColor(self, r:int, g:int, b:int, a:int) -> None: ...
    @overload
    def SetColor(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetColorF(self, r:float, g:float, b:float, a:float) -> None: ...
    @overload
    def SetColorF(self, r:float, g:float, b:float) -> None: ...
    def SetColorSeries(self, colorSeries:'vtkColorSeries') -> None: ...
    def SetEnableOpacityMapping(self, _arg:bool) -> None: ...
    def SetGroupName(self, name:str) -> None: ...
    def SetInputArray(self, index:int, name:str) -> None: ...
    def SetLookupTable(self, lut:'vtkScalarsToColors') -> None: ...
    def SetOffset(self, _arg:float) -> None: ...
    def SetOrientation(self, orientation:int) -> None: ...
    def SetScalarVisibility(self, _arg:bool) -> None: ...
    def SetWidth(self, _arg:float) -> None: ...
    def UpdateCache(self) -> bool: ...

class vtkPlotRangeHandlesItem(vtkPlot):
    class Orientation(int): ...
    class Handle(int): ...
    HORIZONTAL:'Orientation'
    LEFT_HANDLE:'Handle'
    NO_HANDLE:'Handle'
    RIGHT_HANDLE:'Handle'
    VERTICAL:'Orientation'
    extent:'getset_descriptor'
    extent_to_axis_range:'getset_descriptor'
    handle_orientation:'getset_descriptor'
    handle_width:'getset_descriptor'
    highlight_brush:'getset_descriptor'
    lock_tooltip_to_mouse:'getset_descriptor'
    synchronize_range_handles:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeHandlesDrawRange(self) -> None: ...
    def ExtentToAxisRangeOff(self) -> None: ...
    def ExtentToAxisRangeOn(self) -> None: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetExtent(self) -> Tuple[float, float, float, float]: ...
    def GetExtentToAxisRange(self) -> int: ...
    def GetHandleOrientation(self) -> int: ...
    def GetHandleOrientationMaxValue(self) -> int: ...
    def GetHandleOrientationMinValue(self) -> int: ...
    def GetHandleWidth(self) -> float: ...
    def GetHandlesRange(self, range:MutableSequence[float]) -> None: ...
    def GetHighlightBrush(self) -> 'vtkBrush': ...
    def GetLockTooltipToMouse(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSynchronizeRangeHandles(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LockTooltipToMouseOff(self) -> None: ...
    def LockTooltipToMouseOn(self) -> None: ...
    def NewInstance(self) -> 'vtkPlotRangeHandlesItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotRangeHandlesItem': ...
    @overload
    def SetExtent(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetExtent(self, _arg:Sequence[float]) -> None: ...
    def SetExtentToAxisRange(self, _arg:int) -> None: ...
    def SetHandleOrientation(self, _arg:int) -> None: ...
    def SetHandleOrientationToHorizontal(self) -> None: ...
    def SetHandleOrientationToVertical(self) -> None: ...
    def SetHandleWidth(self, _arg:float) -> None: ...
    def SetLockTooltipToMouse(self, _arg:int) -> None: ...
    def SetSynchronizeRangeHandles(self, _arg:int) -> None: ...
    def SynchronizeRangeHandlesOff(self) -> None: ...
    def SynchronizeRangeHandlesOn(self) -> None: ...

class vtkPlotBarRangeHandlesItem(vtkPlotRangeHandlesItem):
    plot_bar:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlotBar(self) -> 'vtkPlotBar': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotBarRangeHandlesItem': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotBarRangeHandlesItem': ...
    def SetPlotBar(self, _arg:'vtkPlotBar') -> None: ...

class vtkPlotBox(vtkPlot):
    box_width:'getset_descriptor'
    input_data:'getset_descriptor'
    labels:'getset_descriptor'
    lookup_table:'getset_descriptor'
    title_properties:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultLookupTable(self) -> None: ...
    def GetBoxWidth(self) -> float: ...
    def GetLabels(self) -> 'vtkStringArray': ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTitleProperties(self) -> 'vtkTextProperty': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotBox': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PaintLegend(self, painter:'vtkContext2D', rect:'vtkRectf', legendIndex:int) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotBox': ...
    def SetBoxWidth(self, _arg:float) -> None: ...
    def SetColumnColor(self, colName:str, rgb:MutableSequence[float]) -> None: ...
    @overload
    def SetInputData(self, table:'vtkTable') -> None: ...
    @overload
    def SetInputData(self, table:'vtkTable', __b:str, __c:str) -> None: ...
    def SetLookupTable(self, lut:'vtkScalarsToColors') -> None: ...
    def UpdateCache(self) -> bool: ...

class vtkPlotFunctionalBag(vtkPlot):
    lookup_table:'getset_descriptor'
    visible:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultLookupTable(self) -> None: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUnscaledInputBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetVisible(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    def IsBag(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotFunctionalBag': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PaintLegend(self, painter:'vtkContext2D', rect:'vtkRectf', legendIndex:int) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotFunctionalBag': ...
    def SelectPoints(self, min:'vtkVector2f', max:'vtkVector2f') -> bool: ...
    def SelectPointsInPolygon(self, polygon:'vtkContextPolygon') -> bool: ...
    def SetLookupTable(self, lut:'vtkScalarsToColors') -> None: ...
    def UpdateCache(self) -> bool: ...

class vtkPlotGrid(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    x_axis:'getset_descriptor'
    y_axis:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotGrid': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotGrid': ...
    def SetXAxis(self, axis:'vtkAxis') -> None: ...
    def SetYAxis(self, axis:'vtkAxis') -> None: ...

class vtkPlotHistogram2D(vtkPlot):
    array_name:'getset_descriptor'
    input_data:'getset_descriptor'
    input_image_data:'getset_descriptor'
    position:'getset_descriptor'
    transfer_function:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetArrayName(self) -> str: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetInputImageData(self) -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPosition(self) -> 'vtkRectf': ...
    def GetTooltipLabel(self, plotPos:'vtkVector2d', seriesIndex:int, segmentIndex:int) -> str: ...
    def GetTransferFunction(self) -> 'vtkScalarsToColors': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotHistogram2D': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotHistogram2D': ...
    def SetArrayName(self, _arg:str) -> None: ...
    @overload
    def SetInputData(self, data:'vtkImageData', z:int=0) -> None: ...
    @overload
    def SetInputData(self, __a:'vtkTable') -> None: ...
    @overload
    def SetInputData(self, __a:'vtkTable', __b:str, __c:str) -> None: ...
    def SetPosition(self, pos:'vtkRectf') -> None: ...
    def SetTransferFunction(self, transfer:'vtkScalarsToColors') -> None: ...
    def Update(self) -> None: ...
    def UpdateCache(self) -> bool: ...

class vtkPlotLine(vtkPlotPoints):
    poly_line:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolyLine(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotLine': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PaintLegend(self, painter:'vtkContext2D', rect:'vtkRectf', legendIndex:int) -> bool: ...
    def PolyLineOff(self) -> None: ...
    def PolyLineOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotLine': ...
    def SetPolyLine(self, _arg:bool) -> None: ...

class vtkPlotPoints3D(vtkPlot3D):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotPoints3D': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotPoints3D': ...

class vtkPlotLine3D(vtkPlotPoints3D):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotLine3D': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotLine3D': ...

class vtkPlotParallelCoordinates(vtkPlot):
    color_array_name:'getset_descriptor'
    color_mode:'getset_descriptor'
    input_data:'getset_descriptor'
    lookup_table:'getset_descriptor'
    scalar_visibility:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultLookupTable(self) -> None: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetColorArrayName(self) -> str: ...
    def GetColorMode(self) -> int: ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarVisibility(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotParallelCoordinates': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PaintLegend(self, painter:'vtkContext2D', rect:'vtkRectf', legendIndex:int) -> bool: ...
    def ResetSelectionRange(self) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotParallelCoordinates': ...
    def ScalarVisibilityOff(self) -> None: ...
    def ScalarVisibilityOn(self) -> None: ...
    @overload
    def SelectColorArray(self, arrayNum:int) -> None: ...
    @overload
    def SelectColorArray(self, arrayName:str) -> None: ...
    def SetColorMode(self, _arg:int) -> None: ...
    def SetColorModeToDefault(self) -> None: ...
    def SetColorModeToDirectScalars(self) -> None: ...
    def SetColorModeToMapScalars(self) -> None: ...
    @overload
    def SetInputData(self, table:'vtkTable') -> None: ...
    @overload
    def SetInputData(self, table:'vtkTable', __b:str, __c:str) -> None: ...
    def SetLookupTable(self, lut:'vtkScalarsToColors') -> None: ...
    def SetScalarVisibility(self, _arg:int) -> None: ...
    @overload
    def SetSelectionRange(self, axis:int, low:float, high:float) -> bool: ...
    @overload
    def SetSelectionRange(self, axis:int, axisSelection:MutableSequence[float]) -> bool: ...
    def UpdateCache(self) -> bool: ...

class vtkPlotPie(vtkPlot):
    color_series:'getset_descriptor'
    dimensions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetColorSeries(self) -> 'vtkColorSeries': ...
    def GetDimensions(self) -> Tuple[int, int, int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotPie': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PaintLegend(self, painter:'vtkContext2D', rect:'vtkRectf', legendIndex:int) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotPie': ...
    def SetColorSeries(self, colorSeries:'vtkColorSeries') -> None: ...
    @overload
    def SetDimensions(self, arg1:int, arg2:int, arg3:int, arg4:int) -> None: ...
    @overload
    def SetDimensions(self, arg:Sequence[int]) -> None: ...
    def UpdateCache(self) -> bool: ...

class vtkPlotStacked(vtkPlot):
    color:'getset_descriptor'
    color_f:'getset_descriptor'
    color_series:'getset_descriptor'
    labels:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetColor(self, rgb:MutableSequence[float]) -> None: ...
    def GetColorF(self, rgb:MutableSequence[float]) -> None: ...
    def GetColorSeries(self) -> 'vtkColorSeries': ...
    def GetLabels(self) -> 'vtkStringArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUnscaledInputBounds(self, bounds:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotStacked': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PaintLegend(self, painter:'vtkContext2D', rect:'vtkRectf', legendIndex:int) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotStacked': ...
    def SelectPoints(self, min:'vtkVector2f', max:'vtkVector2f') -> bool: ...
    @overload
    def SetColor(self, r:int, g:int, b:int, a:int) -> None: ...
    @overload
    def SetColor(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetColorF(self, r:float, g:float, b:float, a:float) -> None: ...
    @overload
    def SetColorF(self, r:float, g:float, b:float) -> None: ...
    def SetColorSeries(self, colorSeries:'vtkColorSeries') -> None: ...
    def SetInputArray(self, index:int, name:str) -> None: ...
    def UpdateCache(self) -> bool: ...

class vtkPlotSurface(vtkPlot3D):
    input_data:'getset_descriptor'
    x_range:'getset_descriptor'
    y_range:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlotSurface': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlotSurface': ...
    @overload
    def SetInputData(self, input:'vtkTable') -> None: ...
    @overload
    def SetInputData(self, input:'vtkTable', xName:str, yName:str, zName:str) -> None: ...
    @overload
    def SetInputData(self, input:'vtkTable', xName:str, yName:str, zName:str, colorName:str) -> None: ...
    @overload
    def SetInputData(self, input:'vtkTable', xColumn:int, yColumn:int, zColumn:int) -> None: ...
    def SetXRange(self, min:float, max:float) -> None: ...
    def SetYRange(self, min:float, max:float) -> None: ...

class vtkRangeHandlesItem(vtkPlotRangeHandlesItem):
    color_transfer_function:'getset_descriptor'
    handle_orientation:'getset_descriptor'
    synchronize_range_handles:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeHandlesDrawRange(self) -> None: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetColorTransferFunction(self) -> 'vtkColorTransferFunction': ...
    def GetHandlesRange(self, range:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRangeHandlesItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRangeHandlesItem': ...
    def SetColorTransferFunction(self, ctf:'vtkColorTransferFunction') -> None: ...
    def SetHandleOrientation(self, orientation:int) -> None: ...
    def SetSynchronizeRangeHandles(self, synchronize:int) -> None: ...
    def SynchronizeRangeHandlesOn(self) -> None: ...

class vtkScatterPlotMatrix(vtkChartMatrix):
    ACTIVEPLOT:int
    HISTOGRAM:int
    NOPLOT:int
    SCATTERPLOT:int
    active_plot:'getset_descriptor'
    annotation_link:'getset_descriptor'
    axis_label_notation:'getset_descriptor'
    axis_label_precision:'getset_descriptor'
    column_visibility_all:'getset_descriptor'
    indexed_labels:'getset_descriptor'
    input:'getset_descriptor'
    main_chart:'getset_descriptor'
    number_of_animation_path_elements:'getset_descriptor'
    number_of_bins:'getset_descriptor'
    number_of_frames:'getset_descriptor'
    plot_marker_style:'getset_descriptor'
    scatter_plot_selected_active_color:'getset_descriptor'
    scatter_plot_selected_row_column_color:'getset_descriptor'
    scene:'getset_descriptor'
    selection_mode:'getset_descriptor'
    size:'getset_descriptor'
    title:'getset_descriptor'
    title_properties:'getset_descriptor'
    tooltip:'getset_descriptor'
    tooltip_notation:'getset_descriptor'
    tooltip_precision:'getset_descriptor'
    visible_columns:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddAnimationPath(self, move:'vtkVector2i') -> bool: ...
    def AdvanceAnimation(self) -> None: ...
    def BeginAnimationPath(self, interactor:'vtkRenderWindowInteractor') -> bool: ...
    def ClearAnimationPath(self) -> None: ...
    def GetActivePlot(self) -> 'vtkVector2i': ...
    def GetAnimationPathElement(self, i:int) -> 'vtkVector2i': ...
    def GetAnnotationLink(self) -> 'vtkAnnotationLink': ...
    def GetAxisColor(self, plotType:int) -> 'vtkColor4ub': ...
    def GetAxisLabelNotation(self, plotType:int) -> int: ...
    def GetAxisLabelPrecision(self, plotType:int) -> int: ...
    def GetAxisLabelProperties(self, plotType:int) -> 'vtkTextProperty': ...
    def GetAxisLabelVisibility(self, plotType:int) -> bool: ...
    def GetBackgroundColor(self, plotType:int) -> 'vtkColor4ub': ...
    def GetColumnName(self, column:int) -> str: ...
    def GetColumnVisibility(self, name:str) -> bool: ...
    def GetGridColor(self, plotType:int) -> 'vtkColor4ub': ...
    def GetGridVisibility(self, plotType:int) -> bool: ...
    def GetIndexedLabels(self) -> 'vtkStringArray': ...
    def GetMainChart(self) -> 'vtkChart': ...
    def GetNumberOfAnimationPathElements(self) -> int: ...
    def GetNumberOfBins(self) -> int: ...
    def GetNumberOfFrames(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetPlotType(self, pos:'vtkVector2i') -> int: ...
    @overload
    def GetPlotType(self, row:int, column:int) -> int: ...
    def GetRowName(self, row:int) -> str: ...
    def GetScatterPlotSelectedActiveColor(self) -> 'vtkColor4ub': ...
    def GetScatterPlotSelectedRowColumnColor(self) -> 'vtkColor4ub': ...
    def GetSelectionMode(self) -> int: ...
    def GetTitle(self) -> str: ...
    def GetTitleProperties(self) -> 'vtkTextProperty': ...
    def GetTooltip(self) -> 'vtkTooltipItem': ...
    def GetTooltipNotation(self, plotType:int) -> int: ...
    def GetTooltipPrecision(self, plotType:int) -> int: ...
    def GetVisibleColumns(self) -> 'vtkStringArray': ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def InsertVisibleColumn(self, name:str, index:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseButtonReleaseEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def NewInstance(self) -> 'vtkScatterPlotMatrix': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkScatterPlotMatrix': ...
    def SetActivePlot(self, position:'vtkVector2i') -> bool: ...
    def SetAxisColor(self, plotType:int, color:'vtkColor4ub') -> None: ...
    def SetAxisLabelNotation(self, plotType:int, notation:int) -> None: ...
    def SetAxisLabelPrecision(self, plotType:int, precision:int) -> None: ...
    def SetAxisLabelProperties(self, plotType:int, prop:'vtkTextProperty') -> None: ...
    def SetAxisLabelVisibility(self, plotType:int, visible:bool) -> None: ...
    def SetBackgroundColor(self, plotType:int, color:'vtkColor4ub') -> None: ...
    def SetColumnVisibility(self, name:str, visible:bool) -> None: ...
    def SetColumnVisibilityAll(self, visible:bool) -> None: ...
    def SetGridColor(self, plotType:int, color:'vtkColor4ub') -> None: ...
    def SetGridVisibility(self, plotType:int, visible:bool) -> None: ...
    def SetIndexedLabels(self, labels:'vtkStringArray') -> None: ...
    def SetInput(self, table:'vtkTable') -> None: ...
    def SetNumberOfBins(self, numberOfBins:int) -> None: ...
    def SetNumberOfFrames(self, frames:int) -> None: ...
    def SetPlotColor(self, plotType:int, color:'vtkColor4ub') -> None: ...
    def SetPlotMarkerSize(self, plotType:int, size:float) -> None: ...
    def SetPlotMarkerStyle(self, plotType:int, style:int) -> None: ...
    def SetScatterPlotSelectedActiveColor(self, color:'vtkColor4ub') -> None: ...
    def SetScatterPlotSelectedRowColumnColor(self, color:'vtkColor4ub') -> None: ...
    def SetScene(self, scene:'vtkContextScene') -> None: ...
    def SetSelectionMode(self, __a:int) -> None: ...
    def SetSize(self, size:'vtkVector2i') -> None: ...
    def SetTitle(self, title:str) -> None: ...
    def SetTitleProperties(self, prop:'vtkTextProperty') -> None: ...
    def SetTooltip(self, tooltip:'vtkTooltipItem') -> None: ...
    def SetTooltipNotation(self, plotType:int, notation:int) -> None: ...
    def SetTooltipPrecision(self, plotType:int, precision:int) -> None: ...
    def SetVisibleColumns(self, visColumns:'vtkStringArray') -> None: ...
    def Update(self) -> None: ...
    def UpdateChartSettings(self, plotType:int) -> None: ...
    def UpdateSettings(self) -> None: ...

