from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel

VTK_DENSITY_ESTIMATE_FIXED_RADIUS:int
VTK_DENSITY_ESTIMATE_RELATIVE_RADIUS:int
VTK_DENSITY_FORM_NPTS:int
VTK_DENSITY_FORM_VOLUME_NORM:int
VTK_EXTRACT_ALL_CLUSTERS:int
VTK_EXTRACT_ALL_REGIONS:int
VTK_EXTRACT_CLOSEST_POINT_CLUSTER:int
VTK_EXTRACT_CLOSEST_POINT_REGION:int
VTK_EXTRACT_LARGEST_CLUSTER:int
VTK_EXTRACT_LARGEST_REGION:int
VTK_EXTRACT_POINT_SEEDED_CLUSTERS:int
VTK_EXTRACT_POINT_SEEDED_REGIONS:int
VTK_EXTRACT_SPECIFIED_CLUSTERS:int
VTK_EXTRACT_SPECIFIED_REGIONS:int
VTK_MAX_LEVEL:int

class vtkBoundedPointSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    bounds:'getset_descriptor'
    number_of_points:'getset_descriptor'
    number_of_points_max_value:'getset_descriptor'
    number_of_points_min_value:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    produce_cell_output:'getset_descriptor'
    produce_random_scalars:'getset_descriptor'
    scalar_range:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetNumberOfPointsMaxValue(self) -> int: ...
    def GetNumberOfPointsMinValue(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetProduceCellOutput(self) -> bool: ...
    def GetProduceRandomScalars(self) -> bool: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBoundedPointSource': ...
    def ProduceCellOutputOff(self) -> None: ...
    def ProduceCellOutputOn(self) -> None: ...
    def ProduceRandomScalarsOff(self) -> None: ...
    def ProduceRandomScalarsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBoundedPointSource': ...
    @overload
    def SetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetBounds(self, _arg:Sequence[float]) -> None: ...
    def SetNumberOfPoints(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetProduceCellOutput(self, _arg:bool) -> None: ...
    def SetProduceRandomScalars(self, _arg:bool) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...

class vtkConnectedPointsFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    aligned_normals:'getset_descriptor'
    closest_point:'getset_descriptor'
    extraction_mode:'getset_descriptor'
    locator:'getset_descriptor'
    normal_angle:'getset_descriptor'
    number_of_extracted_regions:'getset_descriptor'
    radius:'getset_descriptor'
    scalar_connectivity:'getset_descriptor'
    scalar_range:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddSeed(self, id:int) -> None: ...
    def AddSpecifiedRegion(self, id:int) -> None: ...
    def AlignedNormalsOff(self) -> None: ...
    def AlignedNormalsOn(self) -> None: ...
    def DeleteSeed(self, id:int) -> None: ...
    def DeleteSpecifiedRegion(self, id:int) -> None: ...
    def GetAlignedNormals(self) -> int: ...
    def GetClosestPoint(self) -> Tuple[float, float, float]: ...
    def GetExtractionMode(self) -> int: ...
    def GetExtractionModeAsString(self) -> str: ...
    def GetExtractionModeMaxValue(self) -> int: ...
    def GetExtractionModeMinValue(self) -> int: ...
    def GetLocator(self) -> 'vtkAbstractPointLocator': ...
    def GetNormalAngle(self) -> float: ...
    def GetNormalAngleMaxValue(self) -> float: ...
    def GetNormalAngleMinValue(self) -> float: ...
    def GetNumberOfExtractedRegions(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetScalarConnectivity(self) -> int: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def InitializeSeedList(self) -> None: ...
    def InitializeSpecifiedRegionList(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConnectedPointsFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConnectedPointsFilter': ...
    def ScalarConnectivityOff(self) -> None: ...
    def ScalarConnectivityOn(self) -> None: ...
    def SetAlignedNormals(self, _arg:int) -> None: ...
    @overload
    def SetClosestPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetClosestPoint(self, _arg:Sequence[float]) -> None: ...
    def SetExtractionMode(self, _arg:int) -> None: ...
    def SetExtractionModeToAllRegions(self) -> None: ...
    def SetExtractionModeToClosestPointRegion(self) -> None: ...
    def SetExtractionModeToLargestRegion(self) -> None: ...
    def SetExtractionModeToPointSeededRegions(self) -> None: ...
    def SetExtractionModeToSpecifiedRegions(self) -> None: ...
    def SetLocator(self, locator:'vtkAbstractPointLocator') -> None: ...
    def SetNormalAngle(self, _arg:float) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetScalarConnectivity(self, _arg:int) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...

class vtkConvertToPointCloud(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class CellGeneration(int): ...
    NO_CELLS:'CellGeneration'
    POLYVERTEX_CELL:'CellGeneration'
    VERTEX_CELLS:'CellGeneration'
    cell_generation_mode:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellGenerationMode(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConvertToPointCloud': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConvertToPointCloud': ...
    def SetCellGenerationMode(self, _arg:int) -> None: ...

class vtkDensifyPointCloudFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class NeighborhoodType(int): ...
    N_CLOSEST:'NeighborhoodType'
    RADIUS:'NeighborhoodType'
    interpolate_attribute_data:'getset_descriptor'
    maximum_number_of_iterations:'getset_descriptor'
    maximum_number_of_points:'getset_descriptor'
    neighborhood_type:'getset_descriptor'
    number_of_closest_points:'getset_descriptor'
    number_of_closest_points_max_value:'getset_descriptor'
    number_of_closest_points_min_value:'getset_descriptor'
    radius:'getset_descriptor'
    target_distance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetInterpolateAttributeData(self) -> bool: ...
    def GetMaximumNumberOfIterations(self) -> int: ...
    def GetMaximumNumberOfIterationsMaxValue(self) -> int: ...
    def GetMaximumNumberOfIterationsMinValue(self) -> int: ...
    def GetMaximumNumberOfPoints(self) -> int: ...
    def GetMaximumNumberOfPointsMaxValue(self) -> int: ...
    def GetMaximumNumberOfPointsMinValue(self) -> int: ...
    def GetNeighborhoodType(self) -> int: ...
    def GetNumberOfClosestPoints(self) -> int: ...
    def GetNumberOfClosestPointsMaxValue(self) -> int: ...
    def GetNumberOfClosestPointsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetTargetDistance(self) -> float: ...
    def GetTargetDistanceMaxValue(self) -> float: ...
    def GetTargetDistanceMinValue(self) -> float: ...
    def InterpolateAttributeDataOff(self) -> None: ...
    def InterpolateAttributeDataOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDensifyPointCloudFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDensifyPointCloudFilter': ...
    def SetInterpolateAttributeData(self, _arg:bool) -> None: ...
    def SetMaximumNumberOfIterations(self, _arg:int) -> None: ...
    def SetMaximumNumberOfPoints(self, _arg:int) -> None: ...
    def SetNeighborhoodType(self, _arg:int) -> None: ...
    def SetNeighborhoodTypeToNClosest(self) -> None: ...
    def SetNeighborhoodTypeToRadius(self) -> None: ...
    def SetNumberOfClosestPoints(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetTargetDistance(self, _arg:float) -> None: ...

class vtkInterpolationKernel(vtkmodules.vtkCommonCore.vtkObject):
    requires_initialization:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeBasis(self, x:MutableSequence[float], pIds:'vtkIdList', ptId:int=0) -> int: ...
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', weights:'vtkDoubleArray') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRequiresInitialization(self) -> bool: ...
    def Initialize(self, loc:'vtkAbstractPointLocator', ds:'vtkDataSet', pd:'vtkPointData') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInterpolationKernel': ...
    def RequiresInitializationOff(self) -> None: ...
    def RequiresInitializationOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInterpolationKernel': ...
    def SetRequiresInitialization(self, _arg:bool) -> None: ...

class vtkGeneralizedKernel(vtkInterpolationKernel):
    class KernelStyle(int): ...
    N_CLOSEST:'KernelStyle'
    RADIUS:'KernelStyle'
    kernel_footprint:'getset_descriptor'
    normalize_weights:'getset_descriptor'
    number_of_points:'getset_descriptor'
    number_of_points_max_value:'getset_descriptor'
    number_of_points_min_value:'getset_descriptor'
    radius:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeBasis(self, x:MutableSequence[float], pIds:'vtkIdList', ptId:int=0) -> int: ...
    @overload
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', prob:'vtkDoubleArray', weights:'vtkDoubleArray') -> int: ...
    @overload
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', weights:'vtkDoubleArray') -> int: ...
    def GetKernelFootprint(self) -> int: ...
    def GetNormalizeWeights(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetNumberOfPointsMaxValue(self) -> int: ...
    def GetNumberOfPointsMinValue(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGeneralizedKernel': ...
    def NormalizeWeightsOff(self) -> None: ...
    def NormalizeWeightsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGeneralizedKernel': ...
    def SetKernelFootprint(self, _arg:int) -> None: ...
    def SetKernelFootprintToNClosest(self) -> None: ...
    def SetKernelFootprintToRadius(self) -> None: ...
    def SetNormalizeWeights(self, _arg:bool) -> None: ...
    def SetNumberOfPoints(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...

class vtkEllipsoidalGaussianKernel(vtkGeneralizedKernel):
    eccentricity:'getset_descriptor'
    normals_array_name:'getset_descriptor'
    scalars_array_name:'getset_descriptor'
    scale_factor:'getset_descriptor'
    sharpness:'getset_descriptor'
    use_normals:'getset_descriptor'
    use_scalars:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', prob:'vtkDoubleArray', weights:'vtkDoubleArray') -> int: ...
    @overload
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', weights:'vtkDoubleArray') -> int: ...
    def GetEccentricity(self) -> float: ...
    def GetEccentricityMaxValue(self) -> float: ...
    def GetEccentricityMinValue(self) -> float: ...
    def GetNormalsArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarsArrayName(self) -> str: ...
    def GetScaleFactor(self) -> float: ...
    def GetScaleFactorMaxValue(self) -> float: ...
    def GetScaleFactorMinValue(self) -> float: ...
    def GetSharpness(self) -> float: ...
    def GetSharpnessMaxValue(self) -> float: ...
    def GetSharpnessMinValue(self) -> float: ...
    def GetUseNormals(self) -> bool: ...
    def GetUseScalars(self) -> bool: ...
    def Initialize(self, loc:'vtkAbstractPointLocator', ds:'vtkDataSet', pd:'vtkPointData') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEllipsoidalGaussianKernel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEllipsoidalGaussianKernel': ...
    def SetEccentricity(self, _arg:float) -> None: ...
    def SetNormalsArrayName(self, _arg:str) -> None: ...
    def SetScalarsArrayName(self, _arg:str) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetSharpness(self, _arg:float) -> None: ...
    def SetUseNormals(self, _arg:bool) -> None: ...
    def SetUseScalars(self, _arg:bool) -> None: ...
    def UseNormalsOff(self) -> None: ...
    def UseNormalsOn(self) -> None: ...
    def UseScalarsOff(self) -> None: ...
    def UseScalarsOn(self) -> None: ...

class vtkEuclideanClusterExtraction(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    closest_point:'getset_descriptor'
    color_clusters:'getset_descriptor'
    extraction_mode:'getset_descriptor'
    locator:'getset_descriptor'
    number_of_extracted_clusters:'getset_descriptor'
    radius:'getset_descriptor'
    scalar_connectivity:'getset_descriptor'
    scalar_range:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddSeed(self, id:int) -> None: ...
    def AddSpecifiedCluster(self, id:int) -> None: ...
    def ColorClustersOff(self) -> None: ...
    def ColorClustersOn(self) -> None: ...
    def DeleteSeed(self, id:int) -> None: ...
    def DeleteSpecifiedCluster(self, id:int) -> None: ...
    def GetClosestPoint(self) -> Tuple[float, float, float]: ...
    def GetColorClusters(self) -> bool: ...
    def GetExtractionMode(self) -> int: ...
    def GetExtractionModeAsString(self) -> str: ...
    def GetExtractionModeMaxValue(self) -> int: ...
    def GetExtractionModeMinValue(self) -> int: ...
    def GetLocator(self) -> 'vtkAbstractPointLocator': ...
    def GetNumberOfExtractedClusters(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetScalarConnectivity(self) -> bool: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def InitializeSeedList(self) -> None: ...
    def InitializeSpecifiedClusterList(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEuclideanClusterExtraction': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEuclideanClusterExtraction': ...
    def ScalarConnectivityOff(self) -> None: ...
    def ScalarConnectivityOn(self) -> None: ...
    @overload
    def SetClosestPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetClosestPoint(self, _arg:Sequence[float]) -> None: ...
    def SetColorClusters(self, _arg:bool) -> None: ...
    def SetExtractionMode(self, _arg:int) -> None: ...
    def SetExtractionModeToAllClusters(self) -> None: ...
    def SetExtractionModeToClosestPointCluster(self) -> None: ...
    def SetExtractionModeToLargestCluster(self) -> None: ...
    def SetExtractionModeToPointSeededClusters(self) -> None: ...
    def SetExtractionModeToSpecifiedClusters(self) -> None: ...
    def SetLocator(self, locator:'vtkAbstractPointLocator') -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetScalarConnectivity(self, _arg:bool) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...

class vtkPointCloudFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    generate_outliers:'getset_descriptor'
    generate_vertices:'getset_descriptor'
    number_of_points_removed:'getset_descriptor'
    point_map:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GenerateOutliersOff(self) -> None: ...
    def GenerateOutliersOn(self) -> None: ...
    def GenerateVerticesOff(self) -> None: ...
    def GenerateVerticesOn(self) -> None: ...
    def GetGenerateOutliers(self) -> bool: ...
    def GetGenerateVertices(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPointsRemoved(self) -> int: ...
    def GetPointMap(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointCloudFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointCloudFilter': ...
    def SetGenerateOutliers(self, _arg:bool) -> None: ...
    def SetGenerateVertices(self, _arg:bool) -> None: ...

class vtkExtractEnclosedPoints(vtkPointCloudFilter):
    check_surface:'getset_descriptor'
    surface:'getset_descriptor'
    surface_connection:'getset_descriptor'
    surface_data:'getset_descriptor'
    tolerance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CheckSurfaceOff(self) -> None: ...
    def CheckSurfaceOn(self) -> None: ...
    def GetCheckSurface(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetSurface(self) -> 'vtkPolyData': ...
    @overload
    def GetSurface(self, sourceInfo:'vtkInformationVector') -> 'vtkPolyData': ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractEnclosedPoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractEnclosedPoints': ...
    def SetCheckSurface(self, _arg:int) -> None: ...
    def SetSurfaceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSurfaceData(self, pd:'vtkPolyData') -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkExtractHierarchicalBins(vtkPointCloudFilter):
    bin:'getset_descriptor'
    binning_filter:'getset_descriptor'
    level:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBin(self) -> int: ...
    def GetBinningFilter(self) -> 'vtkHierarchicalBinningFilter': ...
    def GetLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractHierarchicalBins': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractHierarchicalBins': ...
    def SetBin(self, _arg:int) -> None: ...
    def SetBinningFilter(self, __a:'vtkHierarchicalBinningFilter') -> None: ...
    def SetLevel(self, _arg:int) -> None: ...

class vtkExtractPointCloudPiece(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    modulo_ordering:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetModuloOrdering(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def ModuloOrderingOff(self) -> None: ...
    def ModuloOrderingOn(self) -> None: ...
    def NewInstance(self) -> 'vtkExtractPointCloudPiece': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractPointCloudPiece': ...
    def SetModuloOrdering(self, _arg:bool) -> None: ...

class vtkExtractPoints(vtkPointCloudFilter):
    extract_inside:'getset_descriptor'
    implicit_function:'getset_descriptor'
    m_time:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ExtractInsideOff(self) -> None: ...
    def ExtractInsideOn(self) -> None: ...
    def GetExtractInside(self) -> bool: ...
    def GetImplicitFunction(self) -> 'vtkImplicitFunction': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractPoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractPoints': ...
    def SetExtractInside(self, _arg:bool) -> None: ...
    def SetImplicitFunction(self, __a:'vtkImplicitFunction') -> None: ...

class vtkExtractSurface(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    compute_gradients:'getset_descriptor'
    compute_normals:'getset_descriptor'
    hole_filling:'getset_descriptor'
    radius:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetHoleFilling(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def HoleFillingOff(self) -> None: ...
    def HoleFillingOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractSurface': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractSurface': ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetHoleFilling(self, _arg:bool) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...

class vtkFitImplicitFunction(vtkPointCloudFilter):
    implicit_function:'getset_descriptor'
    m_time:'getset_descriptor'
    threshold:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetImplicitFunction(self) -> 'vtkImplicitFunction': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetThreshold(self) -> float: ...
    def GetThresholdMaxValue(self) -> float: ...
    def GetThresholdMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFitImplicitFunction': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFitImplicitFunction': ...
    def SetImplicitFunction(self, __a:'vtkImplicitFunction') -> None: ...
    def SetThreshold(self, _arg:float) -> None: ...

class vtkGaussianKernel(vtkGeneralizedKernel):
    sharpness:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', prob:'vtkDoubleArray', weights:'vtkDoubleArray') -> int: ...
    @overload
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', weights:'vtkDoubleArray') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSharpness(self) -> float: ...
    def GetSharpnessMaxValue(self) -> float: ...
    def GetSharpnessMinValue(self) -> float: ...
    def Initialize(self, loc:'vtkAbstractPointLocator', ds:'vtkDataSet', pd:'vtkPointData') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGaussianKernel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGaussianKernel': ...
    def SetSharpness(self, _arg:float) -> None: ...

class vtkHierarchicalBinningFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    automatic:'getset_descriptor'
    bounds:'getset_descriptor'
    divisions:'getset_descriptor'
    number_of_global_bins:'getset_descriptor'
    number_of_levels:'getset_descriptor'
    number_of_levels_max_value:'getset_descriptor'
    number_of_levels_min_value:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AutomaticOff(self) -> None: ...
    def AutomaticOn(self) -> None: ...
    def GetAutomatic(self) -> bool: ...
    def GetBinBounds(self, globalBin:int, bounds:MutableSequence[float]) -> None: ...
    def GetBinOffset(self, globalBin:int, npts:int) -> int: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetDivisions(self) -> Tuple[int, int, int]: ...
    def GetLevelOffset(self, level:int, npts:int) -> int: ...
    def GetLocalBinBounds(self, level:int, localBin:int, bounds:MutableSequence[float]) -> None: ...
    def GetLocalBinOffset(self, level:int, localBin:int, npts:int) -> int: ...
    def GetNumberOfBins(self, level:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfGlobalBins(self) -> int: ...
    def GetNumberOfLevels(self) -> int: ...
    def GetNumberOfLevelsMaxValue(self) -> int: ...
    def GetNumberOfLevelsMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHierarchicalBinningFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHierarchicalBinningFilter': ...
    def SetAutomatic(self, _arg:bool) -> None: ...
    @overload
    def SetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetBounds(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetDivisions(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetDivisions(self, _arg:Sequence[int]) -> None: ...
    def SetNumberOfLevels(self, _arg:int) -> None: ...

class vtkLinearKernel(vtkGeneralizedKernel):
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', prob:'vtkDoubleArray', weights:'vtkDoubleArray') -> int: ...
    @overload
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', weights:'vtkDoubleArray') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLinearKernel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLinearKernel': ...

class vtkMaskPointsFilter(vtkPointCloudFilter):
    empty_value:'getset_descriptor'
    mask:'getset_descriptor'
    mask_connection:'getset_descriptor'
    mask_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetEmptyValue(self) -> int: ...
    def GetMask(self) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMaskPointsFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMaskPointsFilter': ...
    def SetEmptyValue(self, _arg:int) -> None: ...
    def SetMaskConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetMaskData(self, source:'vtkDataObject') -> None: ...

class vtkPCACurvatureEstimation(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    locator:'getset_descriptor'
    sample_size:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetLocator(self) -> 'vtkAbstractPointLocator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSampleSize(self) -> int: ...
    def GetSampleSizeMaxValue(self) -> int: ...
    def GetSampleSizeMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPCACurvatureEstimation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPCACurvatureEstimation': ...
    def SetLocator(self, locator:'vtkAbstractPointLocator') -> None: ...
    def SetSampleSize(self, _arg:int) -> None: ...

class vtkPCANormalEstimation(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class Style(int): ...
    AS_COMPUTED:'Style'
    GRAPH_TRAVERSAL:'Style'
    KNN:int
    POINT:'Style'
    RADIUS:int
    flip_normals:'getset_descriptor'
    locator:'getset_descriptor'
    normal_orientation:'getset_descriptor'
    orientation_point:'getset_descriptor'
    radius:'getset_descriptor'
    sample_size:'getset_descriptor'
    search_mode:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def FlipNormalsOff(self) -> None: ...
    def FlipNormalsOn(self) -> None: ...
    def GetFlipNormals(self) -> bool: ...
    def GetLocator(self) -> 'vtkAbstractPointLocator': ...
    def GetNormalOrientation(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientationPoint(self) -> Tuple[float, float, float]: ...
    def GetRadius(self) -> float: ...
    def GetSampleSize(self) -> int: ...
    def GetSampleSizeMaxValue(self) -> int: ...
    def GetSampleSizeMinValue(self) -> int: ...
    def GetSearchMode(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPCANormalEstimation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPCANormalEstimation': ...
    def SetFlipNormals(self, _arg:bool) -> None: ...
    def SetLocator(self, locator:'vtkAbstractPointLocator') -> None: ...
    def SetNormalOrientation(self, _arg:int) -> None: ...
    def SetNormalOrientationToAsComputed(self) -> None: ...
    def SetNormalOrientationToGraphTraversal(self) -> None: ...
    def SetNormalOrientationToPoint(self) -> None: ...
    @overload
    def SetOrientationPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrientationPoint(self, _arg:Sequence[float]) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetSampleSize(self, _arg:int) -> None: ...
    def SetSearchMode(self, _arg:int) -> None: ...
    def SetSearchModeToKNN(self) -> None: ...
    def SetSearchModeToRadius(self) -> None: ...

class vtkPointDensityFilter(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    class FunctionClass(int): ...
    NON_ZERO:'FunctionClass'
    ZERO:'FunctionClass'
    adjust_distance:'getset_descriptor'
    compute_gradient:'getset_descriptor'
    density_estimate:'getset_descriptor'
    density_form:'getset_descriptor'
    locator:'getset_descriptor'
    model_bounds:'getset_descriptor'
    radius:'getset_descriptor'
    relative_radius:'getset_descriptor'
    sample_dimensions:'getset_descriptor'
    scalar_weighting:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeGradientOff(self) -> None: ...
    def ComputeGradientOn(self) -> None: ...
    def GetAdjustDistance(self) -> float: ...
    def GetAdjustDistanceMaxValue(self) -> float: ...
    def GetAdjustDistanceMinValue(self) -> float: ...
    def GetComputeGradient(self) -> bool: ...
    def GetDensityEstimate(self) -> int: ...
    def GetDensityEstimateAsString(self) -> str: ...
    def GetDensityEstimateMaxValue(self) -> int: ...
    def GetDensityEstimateMinValue(self) -> int: ...
    def GetDensityForm(self) -> int: ...
    def GetDensityFormAsString(self) -> str: ...
    def GetDensityFormMaxValue(self) -> int: ...
    def GetDensityFormMinValue(self) -> int: ...
    def GetLocator(self) -> 'vtkAbstractPointLocator': ...
    def GetModelBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetRelativeRadius(self) -> float: ...
    def GetRelativeRadiusMaxValue(self) -> float: ...
    def GetRelativeRadiusMinValue(self) -> float: ...
    def GetSampleDimensions(self) -> Tuple[int, int, int]: ...
    def GetScalarWeighting(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointDensityFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointDensityFilter': ...
    def ScalarWeightingOff(self) -> None: ...
    def ScalarWeightingOn(self) -> None: ...
    def SetAdjustDistance(self, _arg:float) -> None: ...
    def SetComputeGradient(self, _arg:bool) -> None: ...
    def SetDensityEstimate(self, _arg:int) -> None: ...
    def SetDensityEstimateToFixedRadius(self) -> None: ...
    def SetDensityEstimateToRelativeRadius(self) -> None: ...
    def SetDensityForm(self, _arg:int) -> None: ...
    def SetDensityFormToNumberOfPoints(self) -> None: ...
    def SetDensityFormToVolumeNormalized(self) -> None: ...
    def SetLocator(self, locator:'vtkAbstractPointLocator') -> None: ...
    @overload
    def SetModelBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetModelBounds(self, _arg:Sequence[float]) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetRelativeRadius(self, _arg:float) -> None: ...
    @overload
    def SetSampleDimensions(self, i:int, j:int, k:int) -> None: ...
    @overload
    def SetSampleDimensions(self, dim:MutableSequence[int]) -> None: ...
    def SetScalarWeighting(self, _arg:bool) -> None: ...

class vtkPointInterpolator(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class Strategy(int): ...
    CLOSEST_POINT:'Strategy'
    MASK_POINTS:'Strategy'
    NULL_VALUE:'Strategy'
    kernel:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    null_points_strategy:'getset_descriptor'
    null_value:'getset_descriptor'
    pass_cell_arrays:'getset_descriptor'
    pass_field_arrays:'getset_descriptor'
    pass_point_arrays:'getset_descriptor'
    promote_output_arrays:'getset_descriptor'
    source:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    valid_points_mask_array_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddExcludedArray(self, excludedArray:str) -> None: ...
    def ClearExcludedArrays(self) -> None: ...
    def GetExcludedArray(self, i:int) -> str: ...
    def GetKernel(self) -> 'vtkInterpolationKernel': ...
    def GetLocator(self) -> 'vtkAbstractPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNullPointsStrategy(self) -> int: ...
    def GetNullValue(self) -> float: ...
    def GetNumberOfExcludedArrays(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassCellArrays(self) -> bool: ...
    def GetPassFieldArrays(self) -> bool: ...
    def GetPassPointArrays(self) -> bool: ...
    def GetPromoteOutputArrays(self) -> bool: ...
    def GetSource(self) -> 'vtkDataObject': ...
    def GetValidPointsMaskArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointInterpolator': ...
    def PassCellArraysOff(self) -> None: ...
    def PassCellArraysOn(self) -> None: ...
    def PassFieldArraysOff(self) -> None: ...
    def PassFieldArraysOn(self) -> None: ...
    def PassPointArraysOff(self) -> None: ...
    def PassPointArraysOn(self) -> None: ...
    def PromoteOutputArraysOff(self) -> None: ...
    def PromoteOutputArraysOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointInterpolator': ...
    def SetKernel(self, kernel:'vtkInterpolationKernel') -> None: ...
    def SetLocator(self, locator:'vtkAbstractPointLocator') -> None: ...
    def SetNullPointsStrategy(self, _arg:int) -> None: ...
    def SetNullPointsStrategyToClosestPoint(self) -> None: ...
    def SetNullPointsStrategyToMaskPoints(self) -> None: ...
    def SetNullPointsStrategyToNullValue(self) -> None: ...
    def SetNullValue(self, _arg:float) -> None: ...
    def SetPassCellArrays(self, _arg:bool) -> None: ...
    def SetPassFieldArrays(self, _arg:bool) -> None: ...
    def SetPassPointArrays(self, _arg:bool) -> None: ...
    def SetPromoteOutputArrays(self, _arg:bool) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkDataObject') -> None: ...
    def SetValidPointsMaskArrayName(self, _arg:str) -> None: ...

class vtkPointInterpolator2D(vtkPointInterpolator):
    interpolate_z:'getset_descriptor'
    z_array_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetInterpolateZ(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetZArrayName(self) -> str: ...
    def InterpolateZOff(self) -> None: ...
    def InterpolateZOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointInterpolator2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointInterpolator2D': ...
    def SetInterpolateZ(self, _arg:bool) -> None: ...
    def SetZArrayName(self, _arg:str) -> None: ...

class vtkPointOccupancyFilter(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    empty_value:'getset_descriptor'
    model_bounds:'getset_descriptor'
    occupied_value:'getset_descriptor'
    sample_dimensions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetEmptyValue(self) -> int: ...
    def GetModelBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOccupiedValue(self) -> int: ...
    def GetSampleDimensions(self) -> Tuple[int, int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointOccupancyFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointOccupancyFilter': ...
    def SetEmptyValue(self, _arg:int) -> None: ...
    @overload
    def SetModelBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetModelBounds(self, _arg:Sequence[float]) -> None: ...
    def SetOccupiedValue(self, _arg:int) -> None: ...
    @overload
    def SetSampleDimensions(self, i:int, j:int, k:int) -> None: ...
    @overload
    def SetSampleDimensions(self, dim:MutableSequence[int]) -> None: ...

class vtkPointSmoothingFilter(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    DEFAULT_SMOOTHING:int
    FRAME_FIELD_SMOOTHING:int
    GEOMETRIC_SMOOTHING:int
    PLANE_MOTION:int
    SCALAR_SMOOTHING:int
    TENSOR_SMOOTHING:int
    UNCONSTRAINED_MOTION:int
    UNIFORM_SMOOTHING:int
    attraction_factor:'getset_descriptor'
    boundary_angle:'getset_descriptor'
    compute_packing_radius:'getset_descriptor'
    convergence:'getset_descriptor'
    enable_constraints:'getset_descriptor'
    fixed_angle:'getset_descriptor'
    frame_field_array:'getset_descriptor'
    generate_constraint_normals:'getset_descriptor'
    generate_constraint_scalars:'getset_descriptor'
    locator:'getset_descriptor'
    maximum_step_size:'getset_descriptor'
    motion_constraint:'getset_descriptor'
    neighborhood_size:'getset_descriptor'
    number_of_iterations:'getset_descriptor'
    number_of_iterations_max_value:'getset_descriptor'
    number_of_iterations_min_value:'getset_descriptor'
    number_of_sub_iterations:'getset_descriptor'
    number_of_sub_iterations_max_value:'getset_descriptor'
    number_of_sub_iterations_min_value:'getset_descriptor'
    packing_factor:'getset_descriptor'
    packing_radius:'getset_descriptor'
    plane:'getset_descriptor'
    smoothing_mode:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputePackingRadiusOff(self) -> None: ...
    def ComputePackingRadiusOn(self) -> None: ...
    def EnableConstraintsOff(self) -> None: ...
    def EnableConstraintsOn(self) -> None: ...
    def GenerateConstraintNormalsOff(self) -> None: ...
    def GenerateConstraintNormalsOn(self) -> None: ...
    def GenerateConstraintScalarsOff(self) -> None: ...
    def GenerateConstraintScalarsOn(self) -> None: ...
    def GetAttractionFactor(self) -> float: ...
    def GetAttractionFactorMaxValue(self) -> float: ...
    def GetAttractionFactorMinValue(self) -> float: ...
    def GetBoundaryAngle(self) -> float: ...
    def GetBoundaryAngleMaxValue(self) -> float: ...
    def GetBoundaryAngleMinValue(self) -> float: ...
    def GetComputePackingRadius(self) -> bool: ...
    def GetConvergence(self) -> float: ...
    def GetConvergenceMaxValue(self) -> float: ...
    def GetConvergenceMinValue(self) -> float: ...
    def GetEnableConstraints(self) -> bool: ...
    def GetFixedAngle(self) -> float: ...
    def GetFixedAngleMaxValue(self) -> float: ...
    def GetFixedAngleMinValue(self) -> float: ...
    def GetFrameFieldArray(self) -> 'vtkDataArray': ...
    def GetGenerateConstraintNormals(self) -> bool: ...
    def GetGenerateConstraintScalars(self) -> bool: ...
    def GetLocator(self) -> 'vtkAbstractPointLocator': ...
    def GetMaximumStepSize(self) -> float: ...
    def GetMaximumStepSizeMaxValue(self) -> float: ...
    def GetMaximumStepSizeMinValue(self) -> float: ...
    def GetMotionConstraint(self) -> int: ...
    def GetNeighborhoodSize(self) -> int: ...
    def GetNeighborhoodSizeMaxValue(self) -> int: ...
    def GetNeighborhoodSizeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIterations(self) -> int: ...
    def GetNumberOfIterationsMaxValue(self) -> int: ...
    def GetNumberOfIterationsMinValue(self) -> int: ...
    def GetNumberOfSubIterations(self) -> int: ...
    def GetNumberOfSubIterationsMaxValue(self) -> int: ...
    def GetNumberOfSubIterationsMinValue(self) -> int: ...
    def GetPackingFactor(self) -> float: ...
    def GetPackingFactorMaxValue(self) -> float: ...
    def GetPackingFactorMinValue(self) -> float: ...
    def GetPackingRadius(self) -> float: ...
    def GetPackingRadiusMaxValue(self) -> float: ...
    def GetPackingRadiusMinValue(self) -> float: ...
    def GetPlane(self) -> 'vtkPlane': ...
    def GetSmoothingMode(self) -> int: ...
    def GetSmoothingModeMaxValue(self) -> int: ...
    def GetSmoothingModeMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointSmoothingFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointSmoothingFilter': ...
    def SetAttractionFactor(self, _arg:float) -> None: ...
    def SetBoundaryAngle(self, _arg:float) -> None: ...
    def SetComputePackingRadius(self, _arg:bool) -> None: ...
    def SetConvergence(self, _arg:float) -> None: ...
    def SetEnableConstraints(self, _arg:bool) -> None: ...
    def SetFixedAngle(self, _arg:float) -> None: ...
    def SetFrameFieldArray(self, __a:'vtkDataArray') -> None: ...
    def SetGenerateConstraintNormals(self, _arg:bool) -> None: ...
    def SetGenerateConstraintScalars(self, _arg:bool) -> None: ...
    def SetLocator(self, locator:'vtkAbstractPointLocator') -> None: ...
    def SetMaximumStepSize(self, _arg:float) -> None: ...
    def SetMotionConstraint(self, _arg:int) -> None: ...
    def SetMotionConstraintToPlane(self) -> None: ...
    def SetMotionConstraintToUnconstrained(self) -> None: ...
    def SetNeighborhoodSize(self, _arg:int) -> None: ...
    def SetNumberOfIterations(self, _arg:int) -> None: ...
    def SetNumberOfSubIterations(self, _arg:int) -> None: ...
    def SetPackingFactor(self, _arg:float) -> None: ...
    def SetPackingRadius(self, _arg:float) -> None: ...
    def SetPlane(self, __a:'vtkPlane') -> None: ...
    def SetSmoothingMode(self, _arg:int) -> None: ...
    def SetSmoothingModeToDefault(self) -> None: ...
    def SetSmoothingModeToFrameField(self) -> None: ...
    def SetSmoothingModeToGeometric(self) -> None: ...
    def SetSmoothingModeToScalars(self) -> None: ...
    def SetSmoothingModeToTensors(self) -> None: ...
    def SetSmoothingModeToUniform(self) -> None: ...

class vtkPoissonDiskSampler(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    locator:'getset_descriptor'
    radius:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetLocator(self) -> 'vtkAbstractPointLocator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPoissonDiskSampler': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPoissonDiskSampler': ...
    def SetLocator(self, locator:'vtkAbstractPointLocator') -> None: ...
    def SetRadius(self, _arg:float) -> None: ...

class vtkProbabilisticVoronoiKernel(vtkGeneralizedKernel):
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', prob:'vtkDoubleArray', weights:'vtkDoubleArray') -> int: ...
    @overload
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', weights:'vtkDoubleArray') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProbabilisticVoronoiKernel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProbabilisticVoronoiKernel': ...

class vtkProjectPointsToPlane(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    class PlaneProjectionType(int): ...
    BEST_COORDINATE_PLANE:'PlaneProjectionType'
    BEST_FIT_PLANE:'PlaneProjectionType'
    SPECIFIED_PLANE:'PlaneProjectionType'
    X_PLANE:'PlaneProjectionType'
    Y_PLANE:'PlaneProjectionType'
    Z_PLANE:'PlaneProjectionType'
    normal:'getset_descriptor'
    origin:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    projection_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNormal(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetProjectionType(self) -> int: ...
    def GetProjectionTypeMaxValue(self) -> int: ...
    def GetProjectionTypeMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProjectPointsToPlane': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProjectPointsToPlane': ...
    @overload
    def SetNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNormal(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:Sequence[float]) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetProjectionType(self, _arg:int) -> None: ...
    def SetProjectionTypeToBestCoordinatePlane(self) -> None: ...
    def SetProjectionTypeToBestFitPlane(self) -> None: ...
    def SetProjectionTypeToSpecifiedPlane(self) -> None: ...
    def SetProjectionTypeToXPlane(self) -> None: ...
    def SetProjectionTypeToYPlane(self) -> None: ...
    def SetProjectionTypeToZPlane(self) -> None: ...

class vtkRadiusOutlierRemoval(vtkPointCloudFilter):
    locator:'getset_descriptor'
    number_of_neighbors:'getset_descriptor'
    number_of_neighbors_max_value:'getset_descriptor'
    number_of_neighbors_min_value:'getset_descriptor'
    radius:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetLocator(self) -> 'vtkAbstractPointLocator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfNeighbors(self) -> int: ...
    def GetNumberOfNeighborsMaxValue(self) -> int: ...
    def GetNumberOfNeighborsMinValue(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRadiusOutlierRemoval': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRadiusOutlierRemoval': ...
    def SetLocator(self, locator:'vtkAbstractPointLocator') -> None: ...
    def SetNumberOfNeighbors(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...

class vtkSPHKernel(vtkInterpolationKernel):
    cutoff_array:'getset_descriptor'
    cutoff_factor:'getset_descriptor'
    density_array:'getset_descriptor'
    dimension:'getset_descriptor'
    mass_array:'getset_descriptor'
    norm_factor:'getset_descriptor'
    spatial_step:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeBasis(self, x:MutableSequence[float], pIds:'vtkIdList', ptId:int=0) -> int: ...
    def ComputeDerivWeight(self, d:float) -> float: ...
    def ComputeDerivWeights(self, x:MutableSequence[float], pIds:'vtkIdList', weights:'vtkDoubleArray', gradWeights:'vtkDoubleArray') -> int: ...
    def ComputeFunctionWeight(self, d:float) -> float: ...
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', weights:'vtkDoubleArray') -> int: ...
    def GetCutoffArray(self) -> 'vtkDataArray': ...
    def GetCutoffFactor(self) -> float: ...
    def GetDensityArray(self) -> 'vtkDataArray': ...
    def GetDimension(self) -> int: ...
    def GetDimensionMaxValue(self) -> int: ...
    def GetDimensionMinValue(self) -> int: ...
    def GetMassArray(self) -> 'vtkDataArray': ...
    def GetNormFactor(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSpatialStep(self) -> float: ...
    def GetSpatialStepMaxValue(self) -> float: ...
    def GetSpatialStepMinValue(self) -> float: ...
    def Initialize(self, loc:'vtkAbstractPointLocator', ds:'vtkDataSet', pd:'vtkPointData') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSPHKernel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSPHKernel': ...
    def SetCutoffArray(self, __a:'vtkDataArray') -> None: ...
    def SetDensityArray(self, __a:'vtkDataArray') -> None: ...
    def SetDimension(self, _arg:int) -> None: ...
    def SetMassArray(self, __a:'vtkDataArray') -> None: ...
    def SetSpatialStep(self, _arg:float) -> None: ...

class vtkSPHCubicKernel(vtkSPHKernel):
    def __init__(self, **properties:Any) -> None: ...
    def ComputeDerivWeight(self, d:float) -> float: ...
    def ComputeFunctionWeight(self, d:float) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, loc:'vtkAbstractPointLocator', ds:'vtkDataSet', pd:'vtkPointData') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSPHCubicKernel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSPHCubicKernel': ...

class vtkSPHInterpolator(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class NullStrategy(int): ...
    MASK_POINTS:'NullStrategy'
    NULL_VALUE:'NullStrategy'
    compute_shepard_sum:'getset_descriptor'
    cutoff_array_name:'getset_descriptor'
    density_array_name:'getset_descriptor'
    kernel:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    mass_array_name:'getset_descriptor'
    null_points_strategy:'getset_descriptor'
    null_value:'getset_descriptor'
    pass_cell_arrays:'getset_descriptor'
    pass_field_arrays:'getset_descriptor'
    pass_point_arrays:'getset_descriptor'
    promote_output_arrays:'getset_descriptor'
    shepard_normalization:'getset_descriptor'
    shepard_sum_array_name:'getset_descriptor'
    source:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    valid_points_mask_array_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddDerivativeArray(self, derivArray:str) -> None: ...
    def AddExcludedArray(self, excludedArray:str) -> None: ...
    def ClearDerivativeArrays(self) -> None: ...
    def ClearExcludedArrays(self) -> None: ...
    def ComputeShepardSumOff(self) -> None: ...
    def ComputeShepardSumOn(self) -> None: ...
    def GetComputeShepardSum(self) -> int: ...
    def GetCutoffArrayName(self) -> str: ...
    def GetDensityArrayName(self) -> str: ...
    def GetDerivativeArray(self, i:int) -> str: ...
    def GetExcludedArray(self, i:int) -> str: ...
    def GetKernel(self) -> 'vtkSPHKernel': ...
    def GetLocator(self) -> 'vtkAbstractPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetMassArrayName(self) -> str: ...
    def GetNullPointsStrategy(self) -> int: ...
    def GetNullValue(self) -> float: ...
    def GetNumberOfDerivativeArrays(self) -> int: ...
    def GetNumberOfExcludedArrays(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassCellArrays(self) -> int: ...
    def GetPassFieldArrays(self) -> int: ...
    def GetPassPointArrays(self) -> int: ...
    def GetPromoteOutputArrays(self) -> int: ...
    def GetShepardNormalization(self) -> int: ...
    def GetShepardSumArrayName(self) -> str: ...
    def GetSource(self) -> 'vtkDataObject': ...
    def GetValidPointsMaskArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSPHInterpolator': ...
    def PassCellArraysOff(self) -> None: ...
    def PassCellArraysOn(self) -> None: ...
    def PassFieldArraysOff(self) -> None: ...
    def PassFieldArraysOn(self) -> None: ...
    def PassPointArraysOff(self) -> None: ...
    def PassPointArraysOn(self) -> None: ...
    def PromoteOutputArraysOff(self) -> None: ...
    def PromoteOutputArraysOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSPHInterpolator': ...
    def SetComputeShepardSum(self, _arg:int) -> None: ...
    def SetCutoffArrayName(self, _arg:str) -> None: ...
    def SetDensityArrayName(self, _arg:str) -> None: ...
    def SetKernel(self, kernel:'vtkSPHKernel') -> None: ...
    def SetLocator(self, locator:'vtkAbstractPointLocator') -> None: ...
    def SetMassArrayName(self, _arg:str) -> None: ...
    def SetNullPointsStrategy(self, _arg:int) -> None: ...
    def SetNullPointsStrategyToMaskPoints(self) -> None: ...
    def SetNullPointsStrategyToNullValue(self) -> None: ...
    def SetNullValue(self, _arg:float) -> None: ...
    def SetPassCellArrays(self, _arg:int) -> None: ...
    def SetPassFieldArrays(self, _arg:int) -> None: ...
    def SetPassPointArrays(self, _arg:int) -> None: ...
    def SetPromoteOutputArrays(self, _arg:int) -> None: ...
    def SetShepardNormalization(self, _arg:int) -> None: ...
    def SetShepardSumArrayName(self, _arg:str) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkDataObject') -> None: ...
    def SetValidPointsMaskArrayName(self, _arg:str) -> None: ...
    def ShepardNormalizationOff(self) -> None: ...
    def ShepardNormalizationOn(self) -> None: ...

class vtkSPHQuarticKernel(vtkSPHKernel):
    def __init__(self, **properties:Any) -> None: ...
    def ComputeDerivWeight(self, d:float) -> float: ...
    def ComputeFunctionWeight(self, d:float) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, loc:'vtkAbstractPointLocator', ds:'vtkDataSet', pd:'vtkPointData') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSPHQuarticKernel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSPHQuarticKernel': ...

class vtkSPHQuinticKernel(vtkSPHKernel):
    def __init__(self, **properties:Any) -> None: ...
    def ComputeDerivWeight(self, d:float) -> float: ...
    def ComputeFunctionWeight(self, d:float) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, loc:'vtkAbstractPointLocator', ds:'vtkDataSet', pd:'vtkPointData') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSPHQuinticKernel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSPHQuinticKernel': ...

class vtkShepardKernel(vtkGeneralizedKernel):
    power_parameter:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', prob:'vtkDoubleArray', weights:'vtkDoubleArray') -> int: ...
    @overload
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', weights:'vtkDoubleArray') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPowerParameter(self) -> float: ...
    def GetPowerParameterMaxValue(self) -> float: ...
    def GetPowerParameterMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkShepardKernel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkShepardKernel': ...
    def SetPowerParameter(self, _arg:float) -> None: ...

class vtkSignedDistance(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    bounds:'getset_descriptor'
    dimensions:'getset_descriptor'
    locator:'getset_descriptor'
    radius:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Append(self, input:'vtkPolyData') -> None: ...
    def EndAppend(self) -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetDimensions(self) -> Tuple[int, int, int]: ...
    def GetLocator(self) -> 'vtkAbstractPointLocator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSignedDistance': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSignedDistance': ...
    @overload
    def SetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetBounds(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetDimensions(self, i:int, j:int, k:int) -> None: ...
    @overload
    def SetDimensions(self, dim:Sequence[int]) -> None: ...
    def SetLocator(self, locator:'vtkAbstractPointLocator') -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def StartAppend(self) -> None: ...

class vtkStatisticalOutlierRemoval(vtkPointCloudFilter):
    computed_mean:'getset_descriptor'
    computed_standard_deviation:'getset_descriptor'
    locator:'getset_descriptor'
    sample_size:'getset_descriptor'
    standard_deviation_factor:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetComputedMean(self) -> float: ...
    def GetComputedMeanMaxValue(self) -> float: ...
    def GetComputedMeanMinValue(self) -> float: ...
    def GetComputedStandardDeviation(self) -> float: ...
    def GetComputedStandardDeviationMaxValue(self) -> float: ...
    def GetComputedStandardDeviationMinValue(self) -> float: ...
    def GetLocator(self) -> 'vtkAbstractPointLocator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSampleSize(self) -> int: ...
    def GetSampleSizeMaxValue(self) -> int: ...
    def GetSampleSizeMinValue(self) -> int: ...
    def GetStandardDeviationFactor(self) -> float: ...
    def GetStandardDeviationFactorMaxValue(self) -> float: ...
    def GetStandardDeviationFactorMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStatisticalOutlierRemoval': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStatisticalOutlierRemoval': ...
    def SetComputedMean(self, _arg:float) -> None: ...
    def SetComputedStandardDeviation(self, _arg:float) -> None: ...
    def SetLocator(self, locator:'vtkAbstractPointLocator') -> None: ...
    def SetSampleSize(self, _arg:int) -> None: ...
    def SetStandardDeviationFactor(self, _arg:float) -> None: ...

class vtkUnsignedDistance(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    adjust_bounds:'getset_descriptor'
    adjust_distance:'getset_descriptor'
    bounds:'getset_descriptor'
    cap_value:'getset_descriptor'
    capping:'getset_descriptor'
    dimensions:'getset_descriptor'
    locator:'getset_descriptor'
    output_scalar_type:'getset_descriptor'
    radius:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AdjustBoundsOff(self) -> None: ...
    def AdjustBoundsOn(self) -> None: ...
    def Append(self, input:'vtkPolyData') -> None: ...
    def CappingOff(self) -> None: ...
    def CappingOn(self) -> None: ...
    def EndAppend(self) -> None: ...
    def GetAdjustBounds(self) -> int: ...
    def GetAdjustDistance(self) -> float: ...
    def GetAdjustDistanceMaxValue(self) -> float: ...
    def GetAdjustDistanceMinValue(self) -> float: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetCapValue(self) -> float: ...
    def GetCapping(self) -> int: ...
    def GetDimensions(self) -> Tuple[int, int, int]: ...
    def GetLocator(self) -> 'vtkAbstractPointLocator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputScalarType(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnsignedDistance': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnsignedDistance': ...
    def SetAdjustBounds(self, _arg:int) -> None: ...
    def SetAdjustDistance(self, _arg:float) -> None: ...
    @overload
    def SetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetBounds(self, _arg:Sequence[float]) -> None: ...
    def SetCapValue(self, _arg:float) -> None: ...
    def SetCapping(self, _arg:int) -> None: ...
    @overload
    def SetDimensions(self, i:int, j:int, k:int) -> None: ...
    @overload
    def SetDimensions(self, dim:Sequence[int]) -> None: ...
    def SetLocator(self, locator:'vtkAbstractPointLocator') -> None: ...
    def SetOutputScalarType(self, _arg:int) -> None: ...
    def SetOutputScalarTypeToDouble(self) -> None: ...
    def SetOutputScalarTypeToFloat(self) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def StartAppend(self) -> None: ...

class vtkVoronoiKernel(vtkInterpolationKernel):
    def __init__(self, **properties:Any) -> None: ...
    def ComputeBasis(self, x:MutableSequence[float], pIds:'vtkIdList', ptId:int=0) -> int: ...
    def ComputeWeights(self, x:MutableSequence[float], pIds:'vtkIdList', weights:'vtkDoubleArray') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVoronoiKernel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVoronoiKernel': ...

class vtkVoxelGrid(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class Style(int): ...
    AUTOMATIC:'Style'
    MANUAL:'Style'
    SPECIFY_LEAF_SIZE:'Style'
    configuration_style:'getset_descriptor'
    divisions:'getset_descriptor'
    kernel:'getset_descriptor'
    leaf_size:'getset_descriptor'
    number_of_points_per_bin:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetConfigurationStyle(self) -> int: ...
    def GetDivisions(self) -> Tuple[int, int, int]: ...
    def GetKernel(self) -> 'vtkInterpolationKernel': ...
    def GetLeafSize(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPointsPerBin(self) -> int: ...
    def GetNumberOfPointsPerBinMaxValue(self) -> int: ...
    def GetNumberOfPointsPerBinMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVoxelGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVoxelGrid': ...
    def SetConfigurationStyle(self, _arg:int) -> None: ...
    def SetConfigurationStyleToAutomatic(self) -> None: ...
    def SetConfigurationStyleToLeafSize(self) -> None: ...
    def SetConfigurationStyleToManual(self) -> None: ...
    @overload
    def SetDivisions(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetDivisions(self, _arg:Sequence[int]) -> None: ...
    def SetKernel(self, kernel:'vtkInterpolationKernel') -> None: ...
    @overload
    def SetLeafSize(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetLeafSize(self, _arg:Sequence[float]) -> None: ...
    def SetNumberOfPointsPerBin(self, _arg:int) -> None: ...

class vtkWendlandQuinticKernel(vtkSPHKernel):
    def __init__(self, **properties:Any) -> None: ...
    def ComputeDerivWeight(self, d:float) -> float: ...
    def ComputeFunctionWeight(self, d:float) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, loc:'vtkAbstractPointLocator', ds:'vtkDataSet', pd:'vtkPointData') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWendlandQuinticKernel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWendlandQuinticKernel': ...

