# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.6.1](https://github.com/microsoft/kiota-python/compare/microsoft-kiota-abstractions-v1.6.0...microsoft-kiota-abstractions-v1.6.1) (2024-11-09)


### Bug Fixes

* fixes typing issues discovered from github api generation ([92cf4c5](https://github.com/microsoft/kiota-python/commit/92cf4c5a33e67406f8f38d255c1ed990d95a7892))
* fixes typing issues discovered from github api generation ([6e68068](https://github.com/microsoft/kiota-python/commit/6e6806880b1fa0a43d63a97b937461d688e62ea0))
* type information for collection of primitives ([b3afe83](https://github.com/microsoft/kiota-python/commit/b3afe83e8ee979a246ed15d24490f6ac8df546bb))

## [1.6.0](https://github.com/microsoft/kiota-python/compare/microsoft-kiota-abstractions-v1.5.0...microsoft-kiota-abstractions-v1.6.0) (2024-10-28)


### Features

* add support for MultipartBody filename parameter ([50aa7e3](https://github.com/microsoft/kiota-python/commit/50aa7e3149e9c2b13360463e129a9db20e9987ab))

## [1.5.0](https://github.com/microsoft/kiota-python/compare/microsoft-kiota-abstractions-v1.4.6...microsoft-kiota-abstractions-v1.5.0) (2024-10-22)


### Miscellaneous Chores

* **microsoft-kiota-abstractions:** Synchronize microsoft-kiota versions

## [1.4.6](https://github.com/microsoft/kiota-python/compare/microsoft-kiota-abstractions-v1.4.5...microsoft-kiota-abstractions-v1.4.6) (2024-10-18)


### Bug Fixes

* fixes typing errors from integration tests for optional parameters ([87e036d](https://github.com/microsoft/kiota-python/commit/87e036d3dc56b2dfff9dd93134ea1aba66918b18))
* fixes typing errors from integration tests for optional parameters ([caea6f9](https://github.com/microsoft/kiota-python/commit/caea6f9e43d60434d7088f0c6499a6ddb9d7dc14))

## [1.4.5](https://github.com/microsoft/kiota-python/compare/microsoft-kiota-abstractions-v1.4.4...microsoft-kiota-abstractions-v1.4.5) (2024-10-16)


### Miscellaneous Chores

* **microsoft-kiota-abstractions:** Synchronize microsoft-kiota versions

## [1.4.4](https://github.com/microsoft/kiota-python/compare/microsoft-kiota-abstractions-v1.4.3...microsoft-kiota-abstractions-v1.4.4) (2024-10-16)


### Miscellaneous Chores

* **microsoft-kiota-abstractions:** Synchronize microsoft-kiota versions

## [1.4.3](https://github.com/microsoft/kiota-python/compare/microsoft-kiota-abstractions-v1.4.2...microsoft-kiota-abstractions-v1.4.3) (2024-10-16)


### Bug Fixes

* fixed missing install command before release ([4b02a38](https://github.com/microsoft/kiota-python/commit/4b02a38abfa30897431a92815a6eb1f7b5824803))
* fixed missing install command before release ([1928ba1](https://github.com/microsoft/kiota-python/commit/1928ba157a05036b4fb1c7868cf0d54b0949f58d))
* fixed type variable in enum writer method to align to reader methods ([d5ce1ec](https://github.com/microsoft/kiota-python/commit/d5ce1ec226b804dd949a2f3b52d1b0cb042fc062))
* include licence file in distribution package. ([645af28](https://github.com/microsoft/kiota-python/commit/645af285a6f97848b190c51199fda9f541e9027a))

## [1.4.2](https://github.com/microsoft/kiota-python/compare/v1.4.1...v1.4.2) (2024-10-15)


### Bug Fixes

* fixed missing install command before release ([4b02a38](https://github.com/microsoft/kiota-python/commit/4b02a38abfa30897431a92815a6eb1f7b5824803))
* fixed missing install command before release ([1928ba1](https://github.com/microsoft/kiota-python/commit/1928ba157a05036b4fb1c7868cf0d54b0949f58d))

## [1.4.1](https://github.com/microsoft/kiota-python/compare/v1.4.0...v1.4.1) (2024-10-15)


### Bug Fixes

* fixed type variable in enum writer method to align to reader methods ([d5ce1ec](https://github.com/microsoft/kiota-python/commit/d5ce1ec226b804dd949a2f3b52d1b0cb042fc062))
* include licence file in distribution package. ([645af28](https://github.com/microsoft/kiota-python/commit/645af285a6f97848b190c51199fda9f541e9027a))

## [1.4.0](https://github.com/microsoft/kiota-python/compare/v1.3.4...v1.4.0) (2024-10-14)


### Features

* setup release please. ([5411d15](https://github.com/microsoft/kiota-python/commit/5411d156ef08a623c6a463c09f1215a2b83ce3f0))
* setup release please. ([6842de0](https://github.com/microsoft/kiota-python/commit/6842de04a25552852b514c402b864c871ff2d6c6))


### Bug Fixes

* bumps required open telemetry version ([2b8cee1](https://github.com/microsoft/kiota-python/commit/2b8cee10db7ca87545d18b37d8d60af4474e0dd4))
* bumps required open telemetry version ([7f5bc94](https://github.com/microsoft/kiota-python/commit/7f5bc940ec748ca17c4118e75e81e1efff52642f))

## [1.3.3] - 2024-05-21

### Added

### Changed

- Adds support for guid and date parameters in the url. [#245](https://github.com/microsoft/kiota-abstractions-python/issues/245)

## [1.3.2] - 2024-03-25

### Added

### Changed

- Moved DeprecationWarning to __post_init__ of BaseRequestConfiguration. [microsoft/kiota#250](https://github.com/microsoft/kiota-abstractions-python/pull/250)

## [1.3.1] - 2024-03-05

### Added

### Changed

- Fixed a bug with serialization of parsable multipart body due to unsubscriptable argument type.

## [1.3.0] - 2024-02-28

### Added

- Added multipart body class to support multipart serialization. [microsoft/kiota#3030](https://github.com/microsoft/kiota/issues/3030)

### Changed

## [1.2.0] - 2024-01-31

### Added

- Added methods in request information to reduce the amount of code being generated. [microsoft/kiota#3695](https://github.com/microsoft/kiota/issues/3695)

### Changed

- Fixed an issue where path and query parameters of enum type would not be expanded properly. [microsoft/kiota#3783](https://github.com/microsoft/kiota/issues/3783)

## [1.1.0] - 2024-01-25

### Added

- Added an abstract class to mark composed type wrappers and facilitate serialization.

### Changed

## [1.0.0] - 2023-10-31

### Added

### Changed

- GA release

## [0.9.1] - 2023-10-25

### Added

### Changed

- Initialize headers in BaseRequestConfiguration to a HeadersCollection instance

## [0.9.0] - 2023-10-10

### Added

- Added a content type parameter to the set stream content method in request information.

### Changed

- Added dedicated HeadersCollection class to manage request headers.

## [0.8.7] - 2023-10-05

### Added

- Added a try_add method for request headers

### Changed

## [0.8.6] - 2023-09-19

### Added

### Changed

- Updated BaseRequestBuilder to set the raw url value if provided.

## [0.8.5] - 2023-09-15

### Added

### Changed

- Fix error where updating an attribute of a nested backed model marks all other attributes as changed.

## [0.8.4] - 2023-09-14

### Added

### Changed

- Fix error when instantiating BackedModel using positional and keyword arguments

## [0.8.3] - 2023-09-13

### Added

### Changed

- Fix error representation when APIError class has no error attribute.

## [0.8.2] - 2023-09-13

### Added

### Changed

- Switched from uritemplate to std-uritemplate for URI templating.
- Handles exception thrown when APIError class has no error attribute.

## [0.8.1] - 2023-09-01

### Added

- Added opentelemetry to project dependencies.

### Changed

## [0.8.0] - 2023-08-24

### Added

- Added opentelemetry to support observability.
- Added an additional parameter to authentication methods to carry contextual information.

### Changed

## [0.7.1] - 2023-08-09

### Added

### Changed

- Set the default value for the `is_initialization_completed` parameter in the `InMemoryBackingStore` class to be `False` and use the
`__post_init__` method of backed model to set it to `True`.
- Changed the string representation of the `APIError` class to be more descriptive.

## [0.7.0] - 2023-07-27

### Added

- Added an abstract translator method that should convert a `RequestInformation` object into the native client HTTP request object.
- Enable backing store for Python.

### Changed

## [0.6.0] - 2023-06-27

### Added

- API key authentication provider.

### Changed

## [0.5.5] - 2023-06-26

### Added

### Changed

- Changed BaseRequestBuilder class to be instantiable.
- Renamed RequestConfiguration class to BaseRequestConfiguration.

## [0.5.4] - 2023-06-22

### Added

- Added a base request builder and a request configuration class to reduce the amount of code being generated.

### Changed

## [0.5.2] - 2023-06-05

### Added

### Changed

- Changed Parsable and APIError to dataclasses.
- Added support for merging of object values for intersection types

## [0.5.1] - 2023-04-29

### Added

- Adds the response headers to the APIError class.

### Changed

## [0.5.0] - 2023-02-07

### Added

- Added support for multi-valued request headers.

### Changed

## [0.4.0] - 2023-02-06

### Added

### Changed

- Added a response status code property to the API exception class.

## [0.2.3] - 2023-01-17

### Added

### Changed

- Changes the ResponseHandler parameter in RequestAdapter to be a RequestOption
