"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetPrimaryBalanceCurrency(str, Enum):
    r"""The balance's ISO 4217 currency code."""

    EUR = "EUR"
    GBP = "GBP"
    CHF = "CHF"
    DKK = "DKK"
    NOK = "NOK"
    PLN = "PLN"
    SEK = "SEK"
    USD = "USD"
    CZK = "CZK"
    HUF = "HUF"
    AUD = "AUD"
    CAD = "CAD"


class GetPrimaryBalanceTransferThresholdTypedDict(TypedDict):
    r"""The minimum amount configured for scheduled automatic settlements. As soon as the amount on the balance exceeds this threshold, the complete balance will be paid out to the transfer destination according to the configured frequency."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetPrimaryBalanceTransferThreshold(BaseModel):
    r"""The minimum amount configured for scheduled automatic settlements. As soon as the amount on the balance exceeds this threshold, the complete balance will be paid out to the transfer destination according to the configured frequency."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetPrimaryBalanceTransferDestinationTypedDict(TypedDict):
    r"""The destination where the available amount will be automatically transferred to according to the configured transfer frequency."""

    type: NotRequired[str]
    r"""The default destination of automatic scheduled transfers. Currently only `bank-account` is supported.

    * `bank-account` — Transfer the balance amount to an external bank account

    Possible values: `bank-account`
    """
    bank_account: NotRequired[str]
    r"""The configured bank account number of the beneficiary the balance amount is to be transferred to."""
    beneficiary_name: NotRequired[str]
    r"""The full name of the beneficiary the balance amount is to be transferred to."""


class GetPrimaryBalanceTransferDestination(BaseModel):
    r"""The destination where the available amount will be automatically transferred to according to the configured transfer frequency."""

    type: Optional[str] = None
    r"""The default destination of automatic scheduled transfers. Currently only `bank-account` is supported.

    * `bank-account` — Transfer the balance amount to an external bank account

    Possible values: `bank-account`
    """

    bank_account: Annotated[Optional[str], pydantic.Field(alias="bankAccount")] = None
    r"""The configured bank account number of the beneficiary the balance amount is to be transferred to."""

    beneficiary_name: Annotated[
        Optional[str], pydantic.Field(alias="beneficiaryName")
    ] = None
    r"""The full name of the beneficiary the balance amount is to be transferred to."""


class GetPrimaryBalanceAvailableAmountTypedDict(TypedDict):
    r"""The amount directly available on the balance, e.g. `{\"currency\":\"EUR\", \"value\":\"100.00\"}`."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetPrimaryBalanceAvailableAmount(BaseModel):
    r"""The amount directly available on the balance, e.g. `{\"currency\":\"EUR\", \"value\":\"100.00\"}`."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetPrimaryBalancePendingAmountTypedDict(TypedDict):
    r"""The total amount that is queued to be transferred to your balance. For example, a credit card payment can take a few days to clear."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetPrimaryBalancePendingAmount(BaseModel):
    r"""The total amount that is queued to be transferred to your balance. For example, a credit card payment can take a few days to clear."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetPrimaryBalanceSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetPrimaryBalanceSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetPrimaryBalanceDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetPrimaryBalanceDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetPrimaryBalanceLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetPrimaryBalanceSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[GetPrimaryBalanceDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetPrimaryBalanceLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetPrimaryBalanceSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[GetPrimaryBalanceDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetPrimaryBalanceResponseBodyTypedDict(TypedDict):
    r"""The primary balance object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a balance object. Will always contain the string `balance` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this balance."""
    mode: NotRequired[str]
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    currency: NotRequired[GetPrimaryBalanceCurrency]
    r"""The balance's ISO 4217 currency code."""
    description: NotRequired[str]
    r"""The description or name of the balance. Can be used to denote the purpose of the balance."""
    status: NotRequired[str]
    r"""The status of the balance.

    Possible values: `active` `inactive`
    """
    transfer_frequency: NotRequired[str]
    r"""The frequency with which the available amount on the balance will be settled to the configured transfer destination.

    Settlements created during weekends or on bank holidays will take place on the next business day.

    Possible values: `daily` `every-monday` `every-tuesday` `every-wednesday` `every-thursday` `every-friday` `monthly` `never`
    """
    transfer_threshold: NotRequired[GetPrimaryBalanceTransferThresholdTypedDict]
    r"""The minimum amount configured for scheduled automatic settlements. As soon as the amount on the balance exceeds this threshold, the complete balance will be paid out to the transfer destination according to the configured frequency."""
    transfer_reference: NotRequired[Nullable[str]]
    r"""The transfer reference set to be included in all the transfers for this balance."""
    transfer_destination: NotRequired[
        Nullable[GetPrimaryBalanceTransferDestinationTypedDict]
    ]
    r"""The destination where the available amount will be automatically transferred to according to the configured transfer frequency."""
    available_amount: NotRequired[GetPrimaryBalanceAvailableAmountTypedDict]
    r"""The amount directly available on the balance, e.g. `{\"currency\":\"EUR\", \"value\":\"100.00\"}`."""
    pending_amount: NotRequired[GetPrimaryBalancePendingAmountTypedDict]
    r"""The total amount that is queued to be transferred to your balance. For example, a credit card payment can take a few days to clear."""
    links: NotRequired[GetPrimaryBalanceLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetPrimaryBalanceResponseBody(BaseModel):
    r"""The primary balance object."""

    resource: Optional[str] = "balance"
    r"""Indicates the response contains a balance object. Will always contain the string `balance` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this balance."""

    mode: Optional[str] = None
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    currency: Optional[GetPrimaryBalanceCurrency] = None
    r"""The balance's ISO 4217 currency code."""

    description: Optional[str] = None
    r"""The description or name of the balance. Can be used to denote the purpose of the balance."""

    status: Optional[str] = None
    r"""The status of the balance.

    Possible values: `active` `inactive`
    """

    transfer_frequency: Annotated[
        Optional[str], pydantic.Field(alias="transferFrequency")
    ] = None
    r"""The frequency with which the available amount on the balance will be settled to the configured transfer destination.

    Settlements created during weekends or on bank holidays will take place on the next business day.

    Possible values: `daily` `every-monday` `every-tuesday` `every-wednesday` `every-thursday` `every-friday` `monthly` `never`
    """

    transfer_threshold: Annotated[
        Optional[GetPrimaryBalanceTransferThreshold],
        pydantic.Field(alias="transferThreshold"),
    ] = None
    r"""The minimum amount configured for scheduled automatic settlements. As soon as the amount on the balance exceeds this threshold, the complete balance will be paid out to the transfer destination according to the configured frequency."""

    transfer_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="transferReference")
    ] = UNSET
    r"""The transfer reference set to be included in all the transfers for this balance."""

    transfer_destination: Annotated[
        OptionalNullable[GetPrimaryBalanceTransferDestination],
        pydantic.Field(alias="transferDestination"),
    ] = UNSET
    r"""The destination where the available amount will be automatically transferred to according to the configured transfer frequency."""

    available_amount: Annotated[
        Optional[GetPrimaryBalanceAvailableAmount],
        pydantic.Field(alias="availableAmount"),
    ] = None
    r"""The amount directly available on the balance, e.g. `{\"currency\":\"EUR\", \"value\":\"100.00\"}`."""

    pending_amount: Annotated[
        Optional[GetPrimaryBalancePendingAmount], pydantic.Field(alias="pendingAmount")
    ] = None
    r"""The total amount that is queued to be transferred to your balance. For example, a credit card payment can take a few days to clear."""

    links: Annotated[
        Optional[GetPrimaryBalanceLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "createdAt",
            "currency",
            "description",
            "status",
            "transferFrequency",
            "transferThreshold",
            "transferReference",
            "transferDestination",
            "availableAmount",
            "pendingAmount",
            "_links",
        ]
        nullable_fields = ["transferReference", "transferDestination"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
