# SQLMesh Visual Studio Code Extension

**Transform your data engineering workflow with intelligent SQL development and powerful lineage visualization.**

## Overview

The SQLMesh VSCode extension brings the power of SQLMesh directly into your editor with intelligent code assistance, interactive lineage visualization, and seamless integration with Tobiko Cloud.

## 🚀 Quick Start

1. **Install the extension** from the [Visual Studio Marketplace](https://marketplace.visualstudio.com/items?itemName=tobikodata.sqlmesh)
2. **Set up your Python environment** with SQLMesh
3. **Configure your Python interpreter** in VSCode
4. **Start building data pipelines!**

For a more detailed guide, see the [VSCode Extension Guide](https://sqlmesh.readthedocs.io/en/stable/guides/vscode/).

## ✨ Features

### 🔗 Interactive Lineage Visualization
- **Real-time lineage graphs** showing data flow between models
- **Interactive exploration** with clickable nodes
- **Model dependency tracking** across your entire project

### 🧠 Intelligent Code Assistance
- **Smart auto-completion** for model names and SQLMesh keywords
- **Hover tooltips** with model descriptions and metadata
- **Go-to-definition** navigation for model references
- **Real-time error detection** with inline diagnostics

### 🎨 Code Formatting & Quality
- **Automatic formatting** for SQLMesh models
- **Integrated linter** with built-in and custom rules
- **Format on save** support
- **Project-wide formatting** commands

### ☁️ Tobiko Cloud Integration
- **Seamless authentication** within VSCode
- **Cloud project management**
- **Secure credential handling**

## 📖 Usage

Here's an overview of the extension's features:

### Viewing Model Lineage
1. Open any SQLMesh model file
2. Navigate to the "Lineage" tab in the panel
3. Explore your data pipeline visually

### Using Auto-completion
- Start typing model names or SQLMesh keywords
- Press `Ctrl+Space` to trigger suggestions
- Navigate with arrow keys and press `Enter` to accept

### Formatting Code
- **Single file**: Right-click → "Format Document"
- **Entire project**: Command Palette → "Format SQLMesh project"
- **Auto-format**: Enable "Format on Save" in VSCode settings

### Managing Tobiko Cloud Authentication
- **Sign in**: Command Palette → "Sign in to Tobiko Cloud"
- **Sign out**: Command Palette → "Sign out of Tobiko Cloud"
- **View status**: Check the bottom-left status bar

## 🐛 Troubleshooting

If you encounter issues, please refer to the [VSCode Extension Guide](https://sqlmesh.readthedocs.io/en/stable/guides/vscode/) for troubleshooting steps.

## 📚 Documentation

- [Full SQLMesh Documentation](https://sqlmesh.readthedocs.io/)
- [VSCode Extension Guide](https://sqlmesh.readthedocs.io/en/stable/guides/vscode/)
- [Tobiko Cloud Documentation](https://docs.tobiko.cloud/)

## 🤝 Contributing

We welcome contributions! Please:

1. [Report bugs](https://github.com/tobikodata/sqlmesh/issues) you encounter
2. [Request features](https://github.com/tobikodata/sqlmesh/issues) you'd like to see
3. Share feedback on your experience

## 📄 License

This extension is licensed under the Apache License 2.0. See [LICENSE](LICENSE) for details.

## 🔗 Links

- [SQLMesh GitHub Repository](https://github.com/tobikodata/sqlmesh)
- [Tobiko Data Website](https://tobikodata.com)
- [Extension Marketplace Page](https://marketplace.visualstudio.com/items?itemName=tobikodata.sqlmesh)

---

**Happy data engineering!** 🚀