"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrivateAssetBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const certificatemanager = require("@aws-cdk/aws-certificatemanager");
const cloudfront = require("@aws-cdk/aws-cloudfront");
const origins = require("@aws-cdk/aws-cloudfront-origins");
const iam = require("@aws-cdk/aws-iam");
const route53 = require("@aws-cdk/aws-route53");
const route53Targets = require("@aws-cdk/aws-route53-targets");
const s3 = require("@aws-cdk/aws-s3");
const core = require("@aws-cdk/core");
const nodejs_edge_function_1 = require("./nodejs-edge-function");
/**
 * @stability stable
 */
class PrivateAssetBucket extends core.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        let assetBucket;
        if (props.assetBucketNameImport) {
            assetBucket = s3.Bucket.fromBucketName(this, 'Resource', props.assetBucketNameImport);
        }
        else {
            assetBucket = new s3.Bucket(this, 'Resource', {
                bucketName: props.assetBucketName,
            });
        }
        this.assetBucketName = assetBucket.bucketName;
        const imageAccessFunction = new nodejs_edge_function_1.NodejsEdgeFunction(this, 'edge');
        imageAccessFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: [
                'logs:CreateLogGroup',
                'logs:CreateLogStream',
                'logs:PutLogEvents',
            ],
            resources: ['arn:aws:logs:*:*:*'],
        }));
        const assetBucketDomainName = (_b = props.customDomain) === null || _b === void 0 ? void 0 : _b.domainName;
        const assetBucketCert = props.customDomain ? new certificatemanager.DnsValidatedCertificate(this, 'assetBucketCert', {
            domainName: assetBucketDomainName !== null && assetBucketDomainName !== void 0 ? assetBucketDomainName : '',
            hostedZone: props.customDomain.zone,
            region: 'us-east-1',
        }) : undefined;
        const imageCloudfront = new cloudfront.Distribution(this, 'imageCloudfront', {
            certificate: assetBucketCert,
            domainNames: assetBucketDomainName ? [assetBucketDomainName] : undefined,
            defaultBehavior: {
                originRequestPolicy: new cloudfront.OriginRequestPolicy(this, 'originRequestPolicy', {
                    cookieBehavior: cloudfront.OriginRequestCookieBehavior.all(),
                }),
                origin: new origins.S3Origin(assetBucket, {
                    customHeaders: {
                        // Need to ingest the userpool infor through headers as enviornment variables aren't supported for Lambda@Edge
                        'x-env-userpoolid': props.userPoolId,
                        'x-env-clientid': props.userPoolClientId,
                    },
                }),
                edgeLambdas: [
                    {
                        functionVersion: imageAccessFunction.currentVersion,
                        eventType: cloudfront.LambdaEdgeEventType.ORIGIN_REQUEST,
                    },
                ],
            },
        });
        this.assetBucketCloudfrontUrl = imageCloudfront.distributionDomainName;
        const assetBucketRecord = props.customDomain ? new route53.ARecord(this, 'assetBucketRecord', {
            recordName: props.customDomain.domainName.split('.')[0],
            target: route53.RecordTarget.fromAlias(new route53Targets.CloudFrontTarget(imageCloudfront)),
            zone: props.customDomain.zone,
        }) : undefined;
        this.assetBucketRecordDomainName = assetBucketRecord === null || assetBucketRecord === void 0 ? void 0 : assetBucketRecord.domainName;
    }
}
exports.PrivateAssetBucket = PrivateAssetBucket;
_a = JSII_RTTI_SYMBOL_1;
PrivateAssetBucket[_a] = { fqn: "cdk-private-asset-bucket.PrivateAssetBucket", version: "1.143.1" };
//# sourceMappingURL=data:application/json;base64,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