# -*- coding: utf-8 -*-

"""
Special Functions

There are a number of functions found in mathematical physics and found in standard handbooks.

One thing to note is that the technical literature often contains several conflicting definitions. So beware and check for conformance with the Mathics documentation.

A number of special functions can be evaluated for arbitrary complex values of their arguments. However defining relations may apply only for some special choices of arguments. Here, the full function corresponds to an extension or "analytic continuation" of the defining relation.

For example, integral representations of functions are only valid when the integral exists, but the functions can usually be defined by analytic continuation.

"""

# This tells documentation how to sort this module
# Here we are also hiding "specialfns" since this erroneously appears at the top level.
sort_order = "mathics.builtin.special-functions"
