# DO NOT MODIFY -- This file is generated by type_spec
# flake8: noqa: F821
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
# ruff: noqa: PLR0904
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
import uncountable.types.api.equipment.associate_equipment_input as associate_equipment_input_t
import uncountable.types.api.recipes.associate_recipe_as_input as associate_recipe_as_input_t
from uncountable.types import async_batch_t
from uncountable.types import base_t
import uncountable.types.api.recipes.clear_recipe_outputs as clear_recipe_outputs_t
import uncountable.types.api.recipes.create_recipe as create_recipe_t
import uncountable.types.api.recipes.edit_recipe_inputs as edit_recipe_inputs_t
from uncountable.types import entity_t
from uncountable.types import field_values_t
from uncountable.types import generic_upload_t
import uncountable.types.api.entity.grant_entity_permissions as grant_entity_permissions_t
from uncountable.types import identifier_t
import uncountable.types.api.uploader.invoke_uploader as invoke_uploader_t
from uncountable.types import recipe_identifiers_t
from uncountable.types import recipe_metadata_t
from uncountable.types import recipe_workflow_steps_t
import uncountable.types.api.entity.set_entity_field_values as set_entity_field_values_t
import uncountable.types.api.recipes.set_recipe_metadata as set_recipe_metadata_t
import uuid
from abc import ABC, abstractmethod
from pkgs.serialization_util.serialization_helpers import serialize_for_api


class AsyncBatchProcessorBase(ABC):
    @abstractmethod
    def _enqueue(self, req: async_batch_t.AsyncBatchRequest) -> None:
        ...

    @abstractmethod
    def send(self) -> base_t.ObjectId:
        ...

    def associate_equipment_input(
        self,
        *,
        equipment_key: identifier_t.IdentifierKey,
        material_family_ids: list[base_t.ObjectId],
        depends_on: typing.Optional[list[str]] = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Create or return the input association for equipment

        :param equipment_key: Identifier of the equipment to associate
        :param material_family_ids: The list of material families to add the input to. This must be non-empty
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = associate_equipment_input_t.Arguments(
            equipment_key=equipment_key,
            material_family_ids=material_family_ids,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.ASSOCIATE_EQUIPMENT_INPUT,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def associate_recipe_as_input(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        input_key: typing.Optional[identifier_t.IdentifierKey] = None,
        show_in_listings: typing.Optional[bool] = None,
        depends_on: typing.Optional[list[str]] = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Create or return the input association for a recipe

        :param recipe_key: Identifier for the recipe
        :param input_key: Identifier for an input to use for the association.  Optionally supplied.  If not supplied, one is created
        :param show_in_listings: After associating the input should it be present in listings
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = associate_recipe_as_input_t.Arguments(
            recipe_key=recipe_key,
            input_key=input_key,
            show_in_listings=show_in_listings,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.ASSOCIATE_RECIPE_AS_INPUT,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def clear_recipe_outputs(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        depends_on: typing.Optional[list[str]] = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Clears all output values & output metadata for a given recipe

        :param recipe_key: The identifier of the recipe
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = clear_recipe_outputs_t.Arguments(
            recipe_key=recipe_key,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.CLEAR_RECIPE_OUTPUTS,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def create_recipe(
        self,
        *,
        material_family_id: base_t.ObjectId,
        workflow_id: base_t.ObjectId,
        name: typing.Optional[str] = None,
        project_id: typing.Optional[base_t.ObjectId] = None,
        workflow_variant_id: typing.Optional[typing.Optional[base_t.ObjectId]] = None,
        recipe_metadata: typing.Optional[list[recipe_metadata_t.MetadataValue]] = None,
        identifiers: typing.Optional[recipe_identifiers_t.RecipeIdentifiers] = None,
        definition_key: typing.Optional[identifier_t.IdentifierKey] = None,
        depends_on: typing.Optional[list[str]] = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Returns the id of the recipe being created.

        :param name: The name for the recipe
        :param material_family_id: The material family for the recipe
        :param project_id: The identifier of the project to create the recipe in
        :param workflow_id: The identifier of the workflow to create the recipe with
        :param workflow_variant_id: The identifier of the workflow variant to create the recipe with
        :param recipe_metadata: Metadata values to populate the recipe with
        :param identifiers: A recipe won't be created if it matches the identifier.  An identifier must be unique in the schema
        :param definition_key: The entity definition identifier, default is used if not supplied
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = create_recipe_t.Arguments(
            name=name,
            material_family_id=material_family_id,
            project_id=project_id,
            workflow_id=workflow_id,
            workflow_variant_id=workflow_variant_id,
            recipe_metadata=recipe_metadata,
            identifiers=identifiers,
            definition_key=definition_key,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.CREATE_RECIPE,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def edit_recipe_inputs(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        recipe_workflow_step_identifier: recipe_workflow_steps_t.RecipeWorkflowStepIdentifier,
        edits: list[edit_recipe_inputs_t.RecipeInputEdit],
        depends_on: typing.Optional[list[str]] = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Clear, update, or add inputs on a recipe

        :param recipe_key: Identifier for the recipe
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = edit_recipe_inputs_t.Arguments(
            recipe_key=recipe_key,
            recipe_workflow_step_identifier=recipe_workflow_step_identifier,
            edits=edits,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.EDIT_RECIPE_INPUTS,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def grant_entity_permissions(
        self,
        *,
        entity_type: entity_t.LimitedEntityType,
        entity_key: identifier_t.IdentifierKey,
        permission_types: list[entity_t.GrantableEntityPermissionType],
        user_keys: typing.Optional[list[identifier_t.IdentifierKey]] = None,
        user_group_keys: typing.Optional[list[identifier_t.IdentifierKey]] = None,
        all_users: typing.Optional[bool] = None,
        depends_on: typing.Optional[list[str]] = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Grant entity permissions to a list of users or user groups or to all users.

        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = grant_entity_permissions_t.Arguments(
            entity_type=entity_type,
            entity_key=entity_key,
            permission_types=permission_types,
            user_keys=user_keys,
            user_group_keys=user_group_keys,
            all_users=all_users,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.GRANT_ENTITY_PERMISSIONS,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def invoke_uploader(
        self,
        *,
        uploader_key: identifier_t.IdentifierKey,
        destination: generic_upload_t.UploadDestination,
        file_id: typing.Optional[base_t.ObjectId] = None,
        file_ids: typing.Optional[list[base_t.ObjectId]] = None,
        depends_on: typing.Optional[list[str]] = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Runs a file through an uploader.

        :param file_id: DEPRECATED: use file_ids
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = invoke_uploader_t.Arguments(
            file_id=file_id,
            file_ids=file_ids,
            uploader_key=uploader_key,
            destination=destination,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.INVOKE_UPLOADER,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def set_entity_field_values(
        self,
        *,
        entity_identifier: entity_t.EntityIdentifier,
        field_values: list[field_values_t.FieldArgumentValue],
        depends_on: typing.Optional[list[str]] = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Sets field values for an entity

        :param entity_identifier: Entity to update
        :param field_values: Field values to set
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = set_entity_field_values_t.Arguments(
            entity_identifier=entity_identifier,
            field_values=field_values,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.SET_ENTITY_FIELD_VALUES,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def set_recipe_metadata(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        recipe_metadata: list[recipe_metadata_t.MetadataValue],
        depends_on: typing.Optional[list[str]] = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Set metadata values on a recipe

        :param recipe_key: Identifier for the recipe
        :param recipe_metadata: Metadata values to populate the recipe with
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = set_recipe_metadata_t.Arguments(
            recipe_key=recipe_key,
            recipe_metadata=recipe_metadata,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.SET_RECIPE_METADATA,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )
