# Generated by Django 4.2.1 on 2023-11-13 02:38

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='CloudStorage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('module', models.CharField(max_length=400)),
                ('status', models.CharField(default='Turn Off', max_length=150)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
            ],
        ),
        migrations.CreateModel(
            name='Domains',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(default='Pending', max_length=150)),
                ('name', models.CharField(max_length=150)),
                ('tld', models.CharField(max_length=150)),
                ('price', models.DecimalField(blank=True, decimal_places=2, error_messages={'name': {'max_lenght': 'The price must be between 0 and 9999.99'}}, help_text='Maximun 9999.99', max_digits=6, null=True, verbose_name='Price USD')),
                ('request', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='domainowner', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ResquetsCloud',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('module', models.CharField(max_length=400)),
                ('status', models.CharField(default='Turn Off', max_length=150)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('domain', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='recloud', to='cloud.domains')),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='requestcloud', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ZoneDNS',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('module', models.CharField(max_length=400)),
                ('status', models.CharField(default='Turn Off', max_length=150)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('domain', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='domain', to='cloud.domains')),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='zone', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='VirtualCloud',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('module', models.CharField(max_length=400)),
                ('status', models.CharField(default='Turn Off', max_length=150)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('domain', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='vdomain', to='cloud.domains')),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='virtualcloud', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='UsageCloud',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('usage', models.IntegerField(default=1)),
                ('monthy_cost', models.DecimalField(blank=True, decimal_places=2, max_digits=6, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('cloudstorage', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='storage_usage', to='cloud.cloudstorage')),
                ('requestcloud', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='request_usage', to='cloud.resquetscloud')),
                ('virtualcloud', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='virtual_usage', to='cloud.virtualcloud')),
                ('zonadns', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='dns_usage', to='cloud.zonedns')),
            ],
        ),
        migrations.AddField(
            model_name='cloudstorage',
            name='domain',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='storage', to='cloud.domains'),
        ),
        migrations.AddField(
            model_name='cloudstorage',
            name='owner',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='cloudstorage', to=settings.AUTH_USER_MODEL),
        ),
    ]
