import functools
import time

def ttl_cache(ttl_seconds=30):
    """
    Time-to-live cache decorator.
    
    TODO: Update the same in ttl_cache of SageMakerStudioDataEngineeringSessions / implement a common util pkg for all SMUS DE pkgs to use.
    """
    def decorator(func):
        cache = {}
        @functools.wraps(func)
        def wrapper(*args, **kwargs):
            try:
                key = (args, tuple(sorted(kwargs.items())))
            except TypeError:
                # Handle unhashable types by converting to string
                key = (str(args), str(sorted(kwargs.items())))
            now = time.time()
            
            # Remove expired entries
            expired_keys = [k for k, v in cache.items() if now - v['time'] >= ttl_seconds]
            for k in expired_keys:
                del cache[k]
            
            # Check for valid cache result
            if key in cache:
                result = cache[key]['value']
            else:
                result = func(*args, **kwargs)
                cache[key] = {'value': result, 'time': now}
            return result
        
        def clear_cache():
            cache.clear()

        wrapper.clear_cache = clear_cache
        return wrapper
    return decorator