import { AutoScalingGroup, CfnAutoScalingGroup } from '@aws-cdk/aws-autoscaling';
import { DashboardProps } from '@aws-cdk/aws-cloudwatch';
import { CfnReplicationGroup } from '@aws-cdk/aws-elasticache';
import { BaseLoadBalancer, CfnLoadBalancer } from '@aws-cdk/aws-elasticloadbalancingv2';
import { CfnDBCluster } from '@aws-cdk/aws-rds';
import { Construct } from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface HalloumiDashboard extends DashboardProps {
    /**
     * List of LoadBalancers.
     *
     * If set, must only contain a list of LoadBalancer or Dictionary "{ 'name': string, 'full_name': string }"
     *
     * @default - None
     * @stability stable
     */
    readonly loadBalancer?: (BaseLoadBalancer | CfnLoadBalancer | {
        [key: string]: string;
        name: string;
        full_name: string;
    })[];
    /**
     * List of AutoScaling.
     *
     * If set, must only contain a list of AutoScaling or Dictionary "{ 'name': string, 'max_capacity': number }"
     *
     * @default - None
     * @stability stable
     */
    readonly autoScaling?: (AutoScalingGroup | CfnAutoScalingGroup | {
        [key: string]: string | number | number[];
        name: string;
        max_capacity: number;
    })[];
    /**
     * List of RDS.
     *
     * If set, must only contain a list of RDS
     *
     * @default - None
     * @stability stable
     */
    readonly rds?: (CfnDBCluster)[];
    /**
     * List of Elasticache.
     *
     * If set, must only contain a list of Elasticache or Dictionary "{ 'name': string, 'nodes': number }" with nodes being optional
     *
     * @default - None
     * @stability stable
     */
    readonly elasticache?: (CfnReplicationGroup | {
        [key: string]: string | number;
        name: string;
    })[];
}
/**
 * An AWS CloudWatch Dashboard.
 *
 * @stability stable
 * @example
 *
 * // create a dashboard for AutoScaling
 * new Dashboard(this, 'dashboard', {
 *    autoScalingName: 'my-auto-scaling',
 *    autoScalingMaxCapacity: 10
 * });
 */
export declare class Dashboard extends Construct {
    /**
     * Creates a Dashboard based on the Halloumi best practices.
     *
     * @param scope the scope into which to import this dashboard.
     * @param id the logical ID of the returned dashboard construct.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: HalloumiDashboard);
}
