"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../../lib");
const kms = require("aws-cdk-lib/aws-kms");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-sns-sqs with customer managed KMS key';
stack.node.setContext("@aws-cdk/aws-sns-subscriptions:restrictSqsDescryption", true);
// Definitions
// Create a customer managed KMS CMK to encrypt the SNS Topic
const snsEncryptionKeyProps = {
    enableKeyRotation: true,
    removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY
};
const snsEncryptionKey = new kms.Key(stack, 'ImportedSNSEncryptionKey', snsEncryptionKeyProps);
// Create customer managed KMS CMK to encrypt the SQS Queue
const sqsEncryptionKeyProps = {
    enableKeyRotation: true,
    removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY
};
const sqsEncryptionKey = new kms.Key(stack, 'ImportedSQSEncryptionKey', sqsEncryptionKeyProps);
// Create the SNS to SQS construct
const props = {
    topicProps: {
        masterKey: snsEncryptionKey
    },
    queueProps: {
        encryptionMasterKey: sqsEncryptionKey
    },
    encryptQueueWithCmk: false,
    encryptTopicWithCmk: false
};
new lib_1.SnsToSqs(stack, 'test-sns-sqs', props);
new integ_tests_alpha_1.IntegTest(stack, 'Integ', { testCases: [
        stack
    ] });
//# sourceMappingURL=data:application/json;base64,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