"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckKeyProperty = exports.CheckQueueKeyType = exports.CheckTopicKeyType = exports.keyType = void 0;
const assertions_1 = require("aws-cdk-lib/assertions");
/*
 * Checking the specific type of key associated  with a resource is non-trivial. We've
 * extracted the functionality here to keep the code  that checks the test result cleaner
 */
var keyType;
(function (keyType) {
    keyType[keyType["cmk"] = 0] = "cmk";
    keyType[keyType["sse"] = 1] = "sse";
    keyType[keyType["none"] = 2] = "none";
})(keyType = exports.keyType || (exports.keyType = {}));
function CheckTopicKeyType(template, type) {
    // First ensure there's an encryption key
    if (type === keyType.none) {
        template.hasResourceProperties("AWS::SNS::Topic", assertions_1.Match.not({
            KmsMasterKeyId: assertions_1.Match.anyValue()
        }));
    }
    else {
        template.hasResourceProperties("AWS::SNS::Topic", {
            KmsMasterKeyId: assertions_1.Match.anyValue()
        });
        // Now confirm is is the correct  type
        if (type === keyType.cmk) {
            template.hasResourceProperties("AWS::SNS::Topic", assertions_1.Match.not({
                KmsMasterKeyId: {
                    "Fn::Join": ["", assertions_1.Match.arrayWith([":alias/aws/sns"])]
                }
            }));
        }
        else if (type === keyType.sse) {
            template.hasResourceProperties("AWS::SNS::Topic", {
                KmsMasterKeyId: {
                    "Fn::Join": ["", assertions_1.Match.arrayWith([":alias/aws/sns"])]
                }
            });
        }
        else {
            throw new Error('Invalid Key Type');
        }
    }
}
exports.CheckTopicKeyType = CheckTopicKeyType;
function CheckQueueKeyType(template, type) {
    if (type === keyType.none) {
        template.hasResourceProperties("AWS::SQS::Queue", assertions_1.Match.not({
            KmsMasterKeyId: assertions_1.Match.anyValue()
        }));
    }
    else {
        template.hasResourceProperties("AWS::SQS::Queue", {
            KmsMasterKeyId: assertions_1.Match.anyValue()
        });
        // Now confirm is is the correct  type
        if (type === keyType.cmk) {
            template.hasResourceProperties("AWS::SQS::Queue", assertions_1.Match.not({
                KmsMasterKeyId: {
                    "Fn::Join": ["", assertions_1.Match.arrayWith([":alias/aws/sqs"])]
                }
            }));
        }
        else if (type === keyType.sse) {
            template.hasResourceProperties("AWS::SQS::Queue", {
                KmsMasterKeyId: {
                    "Fn::Join": ["", assertions_1.Match.arrayWith([":alias/aws/sqs"])]
                }
            });
        }
        else {
            throw new Error('Invalid Key Type');
        }
    }
}
exports.CheckQueueKeyType = CheckQueueKeyType;
function CheckKeyProperty(encryptionKey, type) {
    // Ensure the value  is set
    if (type === keyType.none) {
        expect(encryptionKey).toBeUndefined();
    }
    else {
        expect(encryptionKey).toBeDefined();
        // Now confirm it is the correct type\
        if (type === keyType.cmk) {
            expect(encryptionKey?.keyArn).not.toContain('alias/aws/sns');
        }
        else if (type === keyType.sse) {
            expect(encryptionKey?.keyArn).toContain('alias/aws/sns');
        }
        else {
            throw new Error('Invalid Key Type');
        }
    }
}
exports.CheckKeyProperty = CheckKeyProperty;
//# sourceMappingURL=data:application/json;base64,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