/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import { Template } from 'aws-cdk-lib/assertions';
import * as kms from 'aws-cdk-lib/aws-kms';
export declare enum keyType {
    cmk = 0,
    sse = 1,
    none = 2
}
export declare function CheckTopicKeyType(template: Template, type: keyType): void;
export declare function CheckQueueKeyType(template: Template, type: keyType): void;
export declare function CheckKeyProperty(encryptionKey: kms.Key | undefined, type: keyType): void;
