"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53RecordTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use another Route 53 record as an alias record target.
 *
 * @stability stable
 */
class Route53RecordTarget {
    /**
     * @stability stable
     */
    constructor(record) {
        this.record = record;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record, zone) {
        if (!zone) { // zone introduced as optional to avoid a breaking change
            throw new Error('Cannot bind to record without a zone');
        }
        return {
            dnsName: this.record.domainName,
            hostedZoneId: zone.hostedZoneId,
        };
    }
}
exports.Route53RecordTarget = Route53RecordTarget;
_a = JSII_RTTI_SYMBOL_1;
Route53RecordTarget[_a] = { fqn: "@aws-cdk/aws-route53-targets.Route53RecordTarget", version: "1.114.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm91dGU1My1yZWNvcmQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJyb3V0ZTUzLXJlY29yZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBR0EsTUFBYSxtQkFBbUI7Ozs7SUFDOUIsWUFBNkIsTUFBMEI7UUFBMUIsV0FBTSxHQUFOLE1BQU0sQ0FBb0I7SUFDdkQsQ0FBQzs7Ozs7O0lBRU0sSUFBSSxDQUFDLE9BQTJCLEVBQUUsSUFBMEI7UUFDakUsSUFBSSxDQUFDLElBQUksRUFBRSxFQUFFLHlEQUF5RDtZQUNwRSxNQUFNLElBQUksS0FBSyxDQUFDLHNDQUFzQyxDQUFDLENBQUM7U0FDekQ7UUFDRCxPQUFPO1lBQ0wsT0FBTyxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsVUFBVTtZQUMvQixZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7U0FDaEMsQ0FBQztJQUNKLENBQUM7O0FBWkgsa0RBYUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3V0ZTUzIGZyb20gJ0Bhd3MtY2RrL2F3cy1yb3V0ZTUzJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFJvdXRlNTNSZWNvcmRUYXJnZXQgaW1wbGVtZW50cyByb3V0ZTUzLklBbGlhc1JlY29yZFRhcmdldCB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcmVjb3JkOiByb3V0ZTUzLklSZWNvcmRTZXQpIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKF9yZWNvcmQ6IHJvdXRlNTMuSVJlY29yZFNldCwgem9uZT86IHJvdXRlNTMuSUhvc3RlZFpvbmUpOiByb3V0ZTUzLkFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnIHtcbiAgICBpZiAoIXpvbmUpIHsgLy8gem9uZSBpbnRyb2R1Y2VkIGFzIG9wdGlvbmFsIHRvIGF2b2lkIGEgYnJlYWtpbmcgY2hhbmdlXG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0Nhbm5vdCBiaW5kIHRvIHJlY29yZCB3aXRob3V0IGEgem9uZScpO1xuICAgIH1cbiAgICByZXR1cm4ge1xuICAgICAgZG5zTmFtZTogdGhpcy5yZWNvcmQuZG9tYWluTmFtZSxcbiAgICAgIGhvc3RlZFpvbmVJZDogem9uZS5ob3N0ZWRab25lSWQsXG4gICAgfTtcbiAgfVxufVxuIl19