# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AdminsArgs', 'Admins']

@pulumi.input_type
class AdminsArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[str],
                 admin_id: Optional[pulumi.Input[str]] = None,
                 authentication_method: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['AdminsNetworkArgs']]]] = None,
                 org_access: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AdminsTagArgs']]]] = None):
        """
        The set of arguments for constructing a Admins resource.
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[str] admin_id: adminId path parameter. Admin ID
        :param pulumi.Input[str] authentication_method: Admin's authentication method
        :param pulumi.Input[str] email: Admin's email address
        :param pulumi.Input[str] name: Admin's username
        :param pulumi.Input[Sequence[pulumi.Input['AdminsNetworkArgs']]] networks: Admin network access information
        :param pulumi.Input[str] org_access: Admin's level of access to the organization
        :param pulumi.Input[Sequence[pulumi.Input['AdminsTagArgs']]] tags: Admin tag information
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if admin_id is not None:
            pulumi.set(__self__, "admin_id", admin_id)
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if org_access is not None:
            pulumi.set(__self__, "org_access", org_access)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="adminId")
    def admin_id(self) -> Optional[pulumi.Input[str]]:
        """
        adminId path parameter. Admin ID
        """
        return pulumi.get(self, "admin_id")

    @admin_id.setter
    def admin_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_id", value)

    @property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[pulumi.Input[str]]:
        """
        Admin's authentication method
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_method", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Admin's email address
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Admin's username
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AdminsNetworkArgs']]]]:
        """
        Admin network access information
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AdminsNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter(name="orgAccess")
    def org_access(self) -> Optional[pulumi.Input[str]]:
        """
        Admin's level of access to the organization
        """
        return pulumi.get(self, "org_access")

    @org_access.setter
    def org_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_access", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AdminsTagArgs']]]]:
        """
        Admin tag information
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AdminsTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AdminsState:
    def __init__(__self__, *,
                 account_status: Optional[pulumi.Input[str]] = None,
                 admin_id: Optional[pulumi.Input[str]] = None,
                 authentication_method: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 has_api_key: Optional[pulumi.Input[bool]] = None,
                 last_active: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['AdminsNetworkArgs']]]] = None,
                 org_access: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AdminsTagArgs']]]] = None,
                 two_factor_auth_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Admins resources.
        :param pulumi.Input[str] account_status: Status of the admin's account
        :param pulumi.Input[str] admin_id: adminId path parameter. Admin ID
        :param pulumi.Input[str] authentication_method: Admin's authentication method
        :param pulumi.Input[str] email: Admin's email address
        :param pulumi.Input[bool] has_api_key: Indicates whether the admin has an API key
        :param pulumi.Input[str] last_active: Time when the admin was last active
        :param pulumi.Input[str] name: Admin's username
        :param pulumi.Input[Sequence[pulumi.Input['AdminsNetworkArgs']]] networks: Admin network access information
        :param pulumi.Input[str] org_access: Admin's level of access to the organization
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[Sequence[pulumi.Input['AdminsTagArgs']]] tags: Admin tag information
        :param pulumi.Input[bool] two_factor_auth_enabled: Indicates whether two-factor authentication is enabled
        """
        if account_status is not None:
            pulumi.set(__self__, "account_status", account_status)
        if admin_id is not None:
            pulumi.set(__self__, "admin_id", admin_id)
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if has_api_key is not None:
            pulumi.set(__self__, "has_api_key", has_api_key)
        if last_active is not None:
            pulumi.set(__self__, "last_active", last_active)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if org_access is not None:
            pulumi.set(__self__, "org_access", org_access)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if two_factor_auth_enabled is not None:
            pulumi.set(__self__, "two_factor_auth_enabled", two_factor_auth_enabled)

    @property
    @pulumi.getter(name="accountStatus")
    def account_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the admin's account
        """
        return pulumi.get(self, "account_status")

    @account_status.setter
    def account_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_status", value)

    @property
    @pulumi.getter(name="adminId")
    def admin_id(self) -> Optional[pulumi.Input[str]]:
        """
        adminId path parameter. Admin ID
        """
        return pulumi.get(self, "admin_id")

    @admin_id.setter
    def admin_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_id", value)

    @property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[pulumi.Input[str]]:
        """
        Admin's authentication method
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_method", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Admin's email address
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="hasApiKey")
    def has_api_key(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the admin has an API key
        """
        return pulumi.get(self, "has_api_key")

    @has_api_key.setter
    def has_api_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_api_key", value)

    @property
    @pulumi.getter(name="lastActive")
    def last_active(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the admin was last active
        """
        return pulumi.get(self, "last_active")

    @last_active.setter
    def last_active(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_active", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Admin's username
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AdminsNetworkArgs']]]]:
        """
        Admin network access information
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AdminsNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter(name="orgAccess")
    def org_access(self) -> Optional[pulumi.Input[str]]:
        """
        Admin's level of access to the organization
        """
        return pulumi.get(self, "org_access")

    @org_access.setter
    def org_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_access", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AdminsTagArgs']]]]:
        """
        Admin tag information
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AdminsTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="twoFactorAuthEnabled")
    def two_factor_auth_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether two-factor authentication is enabled
        """
        return pulumi.get(self, "two_factor_auth_enabled")

    @two_factor_auth_enabled.setter
    def two_factor_auth_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "two_factor_auth_enabled", value)


class Admins(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_id: Optional[pulumi.Input[str]] = None,
                 authentication_method: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AdminsNetworkArgs', 'AdminsNetworkArgsDict']]]]] = None,
                 org_access: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AdminsTagArgs', 'AdminsTagArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.Admins("example",
            authentication_method="Email",
            email="miles@meraki.com",
            name="Miles Meraki",
            networks=[{
                "access": "full",
                "id": "N_24329156",
            }],
            org_access="none",
            organization_id="string",
            tags=[{
                "access": "read-only",
                "tag": "west",
            }])
        pulumi.export("merakiOrganizationsAdminsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/admins:Admins example "organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_id: adminId path parameter. Admin ID
        :param pulumi.Input[str] authentication_method: Admin's authentication method
        :param pulumi.Input[str] email: Admin's email address
        :param pulumi.Input[str] name: Admin's username
        :param pulumi.Input[Sequence[pulumi.Input[Union['AdminsNetworkArgs', 'AdminsNetworkArgsDict']]]] networks: Admin network access information
        :param pulumi.Input[str] org_access: Admin's level of access to the organization
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['AdminsTagArgs', 'AdminsTagArgsDict']]]] tags: Admin tag information
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AdminsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.Admins("example",
            authentication_method="Email",
            email="miles@meraki.com",
            name="Miles Meraki",
            networks=[{
                "access": "full",
                "id": "N_24329156",
            }],
            org_access="none",
            organization_id="string",
            tags=[{
                "access": "read-only",
                "tag": "west",
            }])
        pulumi.export("merakiOrganizationsAdminsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/admins:Admins example "organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param AdminsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AdminsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_id: Optional[pulumi.Input[str]] = None,
                 authentication_method: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AdminsNetworkArgs', 'AdminsNetworkArgsDict']]]]] = None,
                 org_access: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AdminsTagArgs', 'AdminsTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AdminsArgs.__new__(AdminsArgs)

            __props__.__dict__["admin_id"] = admin_id
            __props__.__dict__["authentication_method"] = authentication_method
            __props__.__dict__["email"] = email
            __props__.__dict__["name"] = name
            __props__.__dict__["networks"] = networks
            __props__.__dict__["org_access"] = org_access
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["account_status"] = None
            __props__.__dict__["has_api_key"] = None
            __props__.__dict__["last_active"] = None
            __props__.__dict__["two_factor_auth_enabled"] = None
        super(Admins, __self__).__init__(
            'meraki:organizations/admins:Admins',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_status: Optional[pulumi.Input[str]] = None,
            admin_id: Optional[pulumi.Input[str]] = None,
            authentication_method: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            has_api_key: Optional[pulumi.Input[bool]] = None,
            last_active: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AdminsNetworkArgs', 'AdminsNetworkArgsDict']]]]] = None,
            org_access: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AdminsTagArgs', 'AdminsTagArgsDict']]]]] = None,
            two_factor_auth_enabled: Optional[pulumi.Input[bool]] = None) -> 'Admins':
        """
        Get an existing Admins resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_status: Status of the admin's account
        :param pulumi.Input[str] admin_id: adminId path parameter. Admin ID
        :param pulumi.Input[str] authentication_method: Admin's authentication method
        :param pulumi.Input[str] email: Admin's email address
        :param pulumi.Input[bool] has_api_key: Indicates whether the admin has an API key
        :param pulumi.Input[str] last_active: Time when the admin was last active
        :param pulumi.Input[str] name: Admin's username
        :param pulumi.Input[Sequence[pulumi.Input[Union['AdminsNetworkArgs', 'AdminsNetworkArgsDict']]]] networks: Admin network access information
        :param pulumi.Input[str] org_access: Admin's level of access to the organization
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['AdminsTagArgs', 'AdminsTagArgsDict']]]] tags: Admin tag information
        :param pulumi.Input[bool] two_factor_auth_enabled: Indicates whether two-factor authentication is enabled
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AdminsState.__new__(_AdminsState)

        __props__.__dict__["account_status"] = account_status
        __props__.__dict__["admin_id"] = admin_id
        __props__.__dict__["authentication_method"] = authentication_method
        __props__.__dict__["email"] = email
        __props__.__dict__["has_api_key"] = has_api_key
        __props__.__dict__["last_active"] = last_active
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["org_access"] = org_access
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["two_factor_auth_enabled"] = two_factor_auth_enabled
        return Admins(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountStatus")
    def account_status(self) -> pulumi.Output[str]:
        """
        Status of the admin's account
        """
        return pulumi.get(self, "account_status")

    @property
    @pulumi.getter(name="adminId")
    def admin_id(self) -> pulumi.Output[Optional[str]]:
        """
        adminId path parameter. Admin ID
        """
        return pulumi.get(self, "admin_id")

    @property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> pulumi.Output[str]:
        """
        Admin's authentication method
        """
        return pulumi.get(self, "authentication_method")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        Admin's email address
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="hasApiKey")
    def has_api_key(self) -> pulumi.Output[bool]:
        """
        Indicates whether the admin has an API key
        """
        return pulumi.get(self, "has_api_key")

    @property
    @pulumi.getter(name="lastActive")
    def last_active(self) -> pulumi.Output[str]:
        """
        Time when the admin was last active
        """
        return pulumi.get(self, "last_active")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Admin's username
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence['outputs.AdminsNetwork']]:
        """
        Admin network access information
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter(name="orgAccess")
    def org_access(self) -> pulumi.Output[str]:
        """
        Admin's level of access to the organization
        """
        return pulumi.get(self, "org_access")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.AdminsTag']]:
        """
        Admin tag information
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="twoFactorAuthEnabled")
    def two_factor_auth_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates whether two-factor authentication is enabled
        """
        return pulumi.get(self, "two_factor_auth_enabled")

