# Generated by ariadne-codegen
# Source: resources/ariadne_client_configs/collection_data.graphql

from typing import Any, Dict, List, Optional, Union

from .base_client import BaseClient
from .base_model import UNSET, UnsetType
from .collection_mints import CollectionMints
from .enums import CollectionMintsSortBy, OrderSortBy
from .input_types import CollectionMintsFilters
from .mint import Mint
from .mint_list import MintList
from .mints import Mints
from .refetch_mint_metadata import RefetchMintMetadata
from .refresh_rarities import RefreshRarities


def gql(q: str) -> str:
    return q


class CollectionDataClient(BaseClient):
    def mint_list(
        self,
        slug: str,
        limit: Union[Optional[int], UnsetType] = UNSET,
        after: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> MintList:
        """
        Get the list of mints for a given collection (slug).
        """
        query = gql(
            """
            query MintList($slug: String!, $limit: Int, $after: String) {
              mintList(slug: $slug, limit: $limit, after: $after)
            }
            """
        )
        variables: Dict[str, object] = {"slug": slug, "limit": limit, "after": after}
        response = self.execute(
            query=query, operation_name="MintList", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return MintList.model_validate(data)

    def mint(
        self,
        mint: str,
        sort_by: Union[Optional[OrderSortBy], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> Mint:
        """
        Fetches a mint’s slug as well as:
         * TensorSwap/HadeSwap orders tswapOrders /hswapOrders(both bids and/or the pool
           that is sell it)
          * The pool with a non-empty nftsForSale array is the pool you can buy the NFT from
          * All other pools are pools that you can SELL NOW (for the sellNowPrice)
         * Tensor single bids tensorBids : any active bids specifically for this NFT
         * its active listing activeListings (if it’s listed on a traditional marketplace)
        """
        query = gql(
            """
            query Mint($mint: String!, $sortBy: OrderSortBy, $limit: Int) {
              mint(mint: $mint) {
                slug
                tswapOrders(sortBy: $sortBy, limit: $limit) {
                  address
                  ownerAddress
                  buyNowPrice
                  sellNowPrice
                  sellNowPriceNetFees
                  feeInfos {
                    bps
                    kind
                  }
                  nftsForSale {
                    onchainId
                  }
                }
                tensorBids(sortBy: $sortBy, limit: $limit) {
                  bidder
                  expiry
                  price
                }
                hswapOrders {
                  address
                  assetReceiver
                  baseSpotPrice
                  boxes {
                    mint {
                      onchainId
                    }
                  }
                  buyOrdersQuantity
                  createdAt
                  curveType
                  delta
                  feeBps
                  fundsSolOrTokenBalance
                  lastTransactedAt
                  mathCounter
                  pairType
                }
                activeListings {
                  mint {
                    onchainId
                  }
                  tx {
                    sellerId
                    grossAmount
                    grossAmountUnit
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"mint": mint, "sortBy": sort_by, "limit": limit}
        response = self.execute(
            query=query, operation_name="Mint", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Mint.model_validate(data)

    def mints(self, token_mints: List[str], **kwargs: Any) -> Mints:
        """
        Get the collection slug for several mint addresses.
        """
        query = gql(
            """
            query Mints($tokenMints: [String!]!) {
              mints(tokenMints: $tokenMints) {
                slug
              }
            }
            """
        )
        variables: Dict[str, object] = {"tokenMints": token_mints}
        response = self.execute(
            query=query, operation_name="Mints", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Mints.model_validate(data)

    def collection_mints(
        self,
        slug: str,
        sort_by: CollectionMintsSortBy,
        filters: Union[Optional[CollectionMintsFilters], UnsetType] = UNSET,
        cursor: Union[Optional[str], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> CollectionMints:
        """
        Get up to 10K mints for a collection and their Tensor rarities.
        """
        query = gql(
            """
            query CollectionMints($slug: String!, $sortBy: CollectionMintsSortBy!, $filters: CollectionMintsFilters, $cursor: String, $limit: Int) {
              collectionMintsV2(
                slug: $slug
                sortBy: $sortBy
                filters: $filters
                cursor: $cursor
                limit: $limit
              ) {
                mints {
                  mint {
                    onchainId
                    rarityRankHR
                    rarityRankTT
                  }
                }
                page {
                  endCursor
                  hasMore
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "slug": slug,
            "sortBy": sort_by,
            "filters": filters,
            "cursor": cursor,
            "limit": limit,
        }
        response = self.execute(
            query=query, operation_name="CollectionMints", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CollectionMints.model_validate(data)

    def refetch_mint_metadata(self, mint: str, **kwargs: Any) -> RefetchMintMetadata:
        """
        Refetches the NFT’s metadata (eg traits, image).

        To reduce the amount of spam, there is 1 hour cooldown for rarities. See Refresh Rarities for
        triggering a full rarities refresh.
        """
        query = gql(
            """
            mutation RefetchMintMetadata($mint: String!) {
              refetchMintMetadata(mint: $mint) {
                onchainId
                metadataFetchedAt
              }
            }
            """
        )
        variables: Dict[str, object] = {"mint": mint}
        response = self.execute(
            query=query,
            operation_name="RefetchMintMetadata",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return RefetchMintMetadata.model_validate(data)

    def refresh_rarities(self, slug: str, **kwargs: Any) -> RefreshRarities:
        """
        Refreshes a collection’s rarity scores on Tensor.

        To reduce the amount of spam, there is 1 hour cooldown for rarities.
        """
        query = gql(
            """
            mutation RefreshRarities($slug: String!) {
              refreshRarities(slug: $slug)
            }
            """
        )
        variables: Dict[str, object] = {"slug": slug}
        response = self.execute(
            query=query, operation_name="RefreshRarities", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return RefreshRarities.model_validate(data)
