# Generated by ariadne-codegen
# Source: resources/ariadne_client_configs/market_data.graphql

from typing import Any, Dict, List, Optional, Union

from .active_listings_v_2 import ActiveListingsV2
from .async_base_client import AsyncBaseClient
from .base_model import UNSET, UnsetType
from .collections_stats import CollectionsStats
from .enums import ActiveListingsSortBy
from .hade_swap_active_orders import HadeSwapActiveOrders
from .input_types import ActiveListingsCursorInputV2, ActiveListingsFilters
from .single_collection_stats import SingleCollectionStats
from .tcomp_bids import TcompBids
from .tensor_swap_active_orders import TensorSwapActiveOrders


def gql(q: str) -> str:
    return q


class MarketDataClientAsync(AsyncBaseClient):
    async def collections_stats(
        self,
        slugs: Union[Optional[List[str]], UnsetType] = UNSET,
        slugs_me: Union[Optional[List[str]], UnsetType] = UNSET,
        slugs_display: Union[Optional[List[str]], UnsetType] = UNSET,
        ids: Union[Optional[List[str]], UnsetType] = UNSET,
        sort_by: Union[Optional[str], UnsetType] = UNSET,
        page: Union[Optional[int], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> CollectionsStats:
        """
        Fetch collections and their stats across all marketplaces (**paginated**: max limit 50 = per query).

        This is also where you get a collection’s internal `slug`, which is used to identify a collection for
        other queries.

        To filter for collections with available NFTs (or bids) on TensorSwap, simply check that either
        statsTSwap.buyNowPrice and statsTSwap.sellNowPrice are non-null!

        Please limit # of requests to this endpoint to 3/min (per batch of collections). Note that stats update
        on average every 30-60 seconds anyways (not realtime!)

        Also while slug will never change (only deleted), we may occasionally remap mints to a different
        slug/collection as we improve our collection indexing process.
        """
        query = gql(
            """
            query CollectionsStats($slugs: [String!], $slugsMe: [String!], $slugsDisplay: [String!], $ids: [String!], $sortBy: String, $page: Int, $limit: Int) {
              allCollections(
                slugs: $slugs
                slugsMe: $slugsMe
                slugsDisplay: $slugsDisplay
                ids: $ids
                sortBy: $sortBy
                page: $page
                limit: $limit
              ) {
                total
                collections {
                  id
                  slug
                  slugMe
                  slugDisplay
                  statsV2 {
                    currency
                    buyNowPrice
                    buyNowPriceNetFees
                    sellNowPrice
                    sellNowPriceNetFees
                    numListed
                    numMints
                    floor1h
                    floor24h
                    floor7d
                    sales1h
                    sales24h
                    sales7d
                    salesAll
                    volume1h
                    volume24h
                    volume7d
                    volumeAll
                  }
                  firstListDate
                  name
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "slugs": slugs,
            "slugsMe": slugs_me,
            "slugsDisplay": slugs_display,
            "ids": ids,
            "sortBy": sort_by,
            "page": page,
            "limit": limit,
        }
        response = await self.execute(
            query=query,
            operation_name="CollectionsStats",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CollectionsStats.model_validate(data)

    async def single_collection_stats(
        self, slug: str, **kwargs: Any
    ) -> SingleCollectionStats:
        """
        Fetch a single’s collection stats by MCC mint, first verified creator, Tensor slug, or
        or the url slugDisplay.

        Note that slug can actually be any of the following (in priority order of lookup):
         1. URL slugDisplay
         2. Tensor internal slug (use this for all queries)
         3. Tensor internal collection id
         4. MCC mint
         5. First verified creator address
        """
        query = gql(
            """
            query SingleCollectionStats($slug: String!) {
              instrumentTV2(slug: $slug) {
                id
                slug
                slugMe
                slugDisplay
                statsV2 {
                  currency
                  buyNowPrice
                  buyNowPriceNetFees
                  sellNowPrice
                  sellNowPriceNetFees
                  numListed
                  numMints
                  floor1h
                  floor24h
                  floor7d
                  sales1h
                  sales24h
                  sales7d
                  salesAll
                  volume1h
                  volume24h
                  volume7d
                  volumeAll
                }
                firstListDate
                name
              }
            }
            """
        )
        variables: Dict[str, object] = {"slug": slug}
        response = await self.execute(
            query=query,
            operation_name="SingleCollectionStats",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return SingleCollectionStats.model_validate(data)

    async def tensor_swap_active_orders(
        self, slug: str, **kwargs: Any
    ) -> TensorSwapActiveOrders:
        """
        Fetch all TensorSwap active orders for a collection (by slug).
        Pools that can you can sell into will have a non-null sellNowPrice.
        Pools that can you can buy from will have a non-null buyNowPrice.
        """
        query = gql(
            """
            query TensorSwapActiveOrders($slug: String!) {
              tswapOrders(slug: $slug) {
                address
                createdUnix
                curveType
                delta
                mmCompoundFees
                mmFeeBps
                nftsForSale {
                  onchainId
                }
                nftsHeld
                ownerAddress
                poolType
                solBalance
                startingPrice
                buyNowPrice
                sellNowPrice
                statsAccumulatedMmProfit
                statsTakerBuyCount
                statsTakerSellCount
                takerBuyCount
                takerSellCount
                updatedAt
              }
            }
            """
        )
        variables: Dict[str, object] = {"slug": slug}
        response = await self.execute(
            query=query,
            operation_name="TensorSwapActiveOrders",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return TensorSwapActiveOrders.model_validate(data)

    async def hade_swap_active_orders(
        self, slug: str, **kwargs: Any
    ) -> HadeSwapActiveOrders:
        """
        Fetch all HadeSwap active orders for a collection (by slug).
        """
        query = gql(
            """
            query HadeSwapActiveOrders($slug: String!) {
              hswapOrders(slug: $slug) {
                address
                assetReceiver
                baseSpotPrice
                boxes {
                  mint {
                    onchainId
                  }
                }
                buyOrdersQuantity
                createdAt
                curveType
                delta
                feeBps
                fundsSolOrTokenBalance
                lastTransactedAt
                mathCounter
                pairType
              }
            }
            """
        )
        variables: Dict[str, object] = {"slug": slug}
        response = await self.execute(
            query=query,
            operation_name="HadeSwapActiveOrders",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return HadeSwapActiveOrders.model_validate(data)

    async def active_listings_v_2(
        self,
        slug: str,
        sort_by: ActiveListingsSortBy,
        filters: Union[Optional[ActiveListingsFilters], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        cursor: Union[Optional[ActiveListingsCursorInputV2], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ActiveListingsV2:
        """
        Fetch all TensorSwap active (standard marketplace) listings for a collection (by slug).

        This is paginated with cursor and limit.
        """
        query = gql(
            """
            query ActiveListingsV2($slug: String!, $sortBy: ActiveListingsSortBy!, $filters: ActiveListingsFilters, $limit: Int, $cursor: ActiveListingsCursorInputV2) {
              activeListingsV2(
                slug: $slug
                sortBy: $sortBy
                filters: $filters
                limit: $limit
                cursor: $cursor
              ) {
                page {
                  endCursor {
                    str
                  }
                  hasMore
                }
                txs {
                  mint {
                    onchainId
                  }
                  tx {
                    sellerId
                    grossAmount
                    grossAmountUnit
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "slug": slug,
            "sortBy": sort_by,
            "filters": filters,
            "limit": limit,
            "cursor": cursor,
        }
        response = await self.execute(
            query=query,
            operation_name="ActiveListingsV2",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ActiveListingsV2.model_validate(data)

    async def tcomp_bids(self, slug: str, **kwargs: Any) -> TcompBids:
        """
        If field + fieldId is present, then it is a name bid (ie field = NAME).

        For bids with margin, you will need to check the balance of the account onchain.

        quantity - filledQuantity is the remaining # of NFTs that can be sold.
        """
        query = gql(
            """
            query TcompBids($slug: String!) {
              tcompBids(slug: $slug) {
                address
                amount
                createdAt
                field
                fieldId
                filledQuantity
                margin
                marginNr
                ownerAddress
                quantity
                solBalance
                target
                targetId
              }
            }
            """
        )
        variables: Dict[str, object] = {"slug": slug}
        response = await self.execute(
            query=query, operation_name="TcompBids", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TcompBids.model_validate(data)
