# Generated by ariadne-codegen
# Source: resources/ariadne_client_configs/collection_data.graphql

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import CurveType, PoolType


class Mint(BaseModel):
    mint: Optional["MintMint"]


class MintMint(BaseModel):
    slug: str
    tswap_orders: List["MintMintTswapOrders"] = Field(alias="tswapOrders")
    tensor_bids: Optional[List["MintMintTensorBids"]] = Field(alias="tensorBids")
    hswap_orders: List["MintMintHswapOrders"] = Field(alias="hswapOrders")
    active_listings: List["MintMintActiveListings"] = Field(alias="activeListings")


class MintMintTswapOrders(BaseModel):
    address: str
    owner_address: str = Field(alias="ownerAddress")
    buy_now_price: Optional[Any] = Field(alias="buyNowPrice")
    sell_now_price: Optional[Any] = Field(alias="sellNowPrice")
    sell_now_price_net_fees: Optional[Any] = Field(alias="sellNowPriceNetFees")
    fee_infos: Optional[List["MintMintTswapOrdersFeeInfos"]] = Field(alias="feeInfos")
    nfts_for_sale: List["MintMintTswapOrdersNftsForSale"] = Field(alias="nftsForSale")


class MintMintTswapOrdersFeeInfos(BaseModel):
    bps: int
    kind: str


class MintMintTswapOrdersNftsForSale(BaseModel):
    onchain_id: str = Field(alias="onchainId")


class MintMintTensorBids(BaseModel):
    bidder: Optional[str]
    expiry: Optional[Any]
    price: Any


class MintMintHswapOrders(BaseModel):
    address: str
    asset_receiver: str = Field(alias="assetReceiver")
    base_spot_price: Any = Field(alias="baseSpotPrice")
    boxes: List["MintMintHswapOrdersBoxes"]
    buy_orders_quantity: int = Field(alias="buyOrdersQuantity")
    created_at: Any = Field(alias="createdAt")
    curve_type: CurveType = Field(alias="curveType")
    delta: Any
    fee_bps: int = Field(alias="feeBps")
    funds_sol_or_token_balance: Any = Field(alias="fundsSolOrTokenBalance")
    last_transacted_at: Any = Field(alias="lastTransactedAt")
    math_counter: int = Field(alias="mathCounter")
    pair_type: PoolType = Field(alias="pairType")


class MintMintHswapOrdersBoxes(BaseModel):
    mint: "MintMintHswapOrdersBoxesMint"


class MintMintHswapOrdersBoxesMint(BaseModel):
    onchain_id: str = Field(alias="onchainId")


class MintMintActiveListings(BaseModel):
    mint: "MintMintActiveListingsMint"
    tx: "MintMintActiveListingsTx"


class MintMintActiveListingsMint(BaseModel):
    onchain_id: str = Field(alias="onchainId")


class MintMintActiveListingsTx(BaseModel):
    seller_id: Optional[str] = Field(alias="sellerId")
    gross_amount: Optional[Any] = Field(alias="grossAmount")
    gross_amount_unit: Optional[str] = Field(alias="grossAmountUnit")
