# Generated by ariadne-codegen
# Source: resources/ariadne_client_configs/subscriptions.graphql

from typing import Any, AsyncIterator, Dict

from .async_base_client import AsyncBaseClient
from .new_transaction_tv_2 import NewTransactionTV2
from .tswap_order_update_all import TswapOrderUpdateAll


def gql(q: str) -> str:
    return q


class SubscriptionsClientAsync(AsyncBaseClient):
    async def tswap_order_update_all(
        self, **kwargs: Any
    ) -> AsyncIterator[TswapOrderUpdateAll]:
        query = gql(
            """
            subscription TswapOrderUpdateAll {
              tswapOrderUpdateAll {
                address
                pool {
                  address
                  createdUnix
                  curveType
                  delta
                  mmCompoundFees
                  mmFeeBps
                  nftsForSale {
                    onchainId
                  }
                  nftsHeld
                  ownerAddress
                  poolType
                  solBalance
                  startingPrice
                  buyNowPrice
                  sellNowPrice
                  statsAccumulatedMmProfit
                  statsTakerBuyCount
                  statsTakerSellCount
                  takerBuyCount
                  takerSellCount
                  updatedAt
                }
                slug
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        async for data in self.execute_ws(
            query=query,
            operation_name="TswapOrderUpdateAll",
            variables=variables,
            **kwargs
        ):
            yield TswapOrderUpdateAll.model_validate(data)

    async def new_transaction_tv_2(
        self, slug: str, **kwargs: Any
    ) -> AsyncIterator[NewTransactionTV2]:
        query = gql(
            """
            subscription NewTransactionTV2($slug: String!) {
              newTransactionTV2(slug: $slug) {
                tx {
                  grossAmount
                  mintOnchainId
                  txAt
                  txId
                  txType
                  buyerId
                  sellerId
                  source
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"slug": slug}
        async for data in self.execute_ws(
            query=query,
            operation_name="NewTransactionTV2",
            variables=variables,
            **kwargs
        ):
            yield NewTransactionTV2.model_validate(data)
