# Generated by ariadne-codegen
# Source: resources/ariadne_client_configs/transactions.graphql

from typing import Any, Dict, List, Optional, Union

from .async_base_client import AsyncBaseClient
from .base_model import UNSET, UnsetType
from .enums import DepositWithdrawAction, TCompTarget
from .hswap_buy_nft_tx import HswapBuyNftTx
from .hswap_sell_nft_tx import HswapSellNftTx
from .input_types import AttributeInput, PoolConfig
from .take_bid_tx import TakeBidTx
from .tcomp_bid_tx import TcompBidTx
from .tcomp_bid_tx_for_collection import TcompBidTxForCollection
from .tcomp_buy_tx import TcompBuyTx
from .tcomp_cancel_coll_bid_tx import TcompCancelCollBidTx
from .tcomp_delist_tx import TcompDelistTx
from .tcomp_edit_bid_tx import TcompEditBidTx
from .tcomp_edit_tx import TcompEditTx
from .tcomp_list_tx import TcompListTx
from .tcomp_take_bid_tx import TcompTakeBidTx
from .tcomp_trait_bid_tx import TcompTraitBidTx
from .tswap_buy_nft_tx import TswapBuyNftTx
from .tswap_buy_single_listing_tx import TswapBuySingleListingTx
from .tswap_close_pool_tx import TswapClosePoolTx
from .tswap_delist_nft_tx import TswapDelistNftTx
from .tswap_deposit_withdraw_margin_account_tx import (
    TswapDepositWithdrawMarginAccountTx,
)
from .tswap_deposit_withdraw_nft_tx import TswapDepositWithdrawNftTx
from .tswap_deposit_withdraw_sol_tx import TswapDepositWithdrawSolTx
from .tswap_edit_pool_tx import TswapEditPoolTx
from .tswap_edit_single_listing_tx import TswapEditSingleListingTx
from .tswap_exchange_nft_tx import TswapExchangeNftTx
from .tswap_init_pool_tx import TswapInitPoolTx
from .tswap_list_nft_tx import TswapListNftTx
from .tswap_sell_nft_tx import TswapSellNftTx


def gql(q: str) -> str:
    return q


class TransactionsClientAsync(AsyncBaseClient):
    async def tcomp_buy_tx(
        self, buyer: str, max_price: Any, mint: str, owner: str, **kwargs: Any
    ) -> TcompBuyTx:
        """
        Buy NFT from Listing
        """
        query = gql(
            """
            query TcompBuyTx($buyer: String!, $maxPrice: Decimal!, $mint: String!, $owner: String!) {
              tcompBuyTx(buyer: $buyer, maxPrice: $maxPrice, mint: $mint, owner: $owner) {
                txs {
                  tx
                  txV0
                  lastValidBlockHeight
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "buyer": buyer,
            "maxPrice": max_price,
            "mint": mint,
            "owner": owner,
        }
        response = await self.execute(
            query=query, operation_name="TcompBuyTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TcompBuyTx.model_validate(data)

    async def tcomp_list_tx(
        self, mint: str, owner: str, price: Any, **kwargs: Any
    ) -> TcompListTx:
        """
        List single NFT
        """
        query = gql(
            """
            query TcompListTx($mint: String!, $owner: String!, $price: Decimal!) {
              tcompListTx(mint: $mint, owner: $owner, price: $price) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"mint": mint, "owner": owner, "price": price}
        response = await self.execute(
            query=query, operation_name="TcompListTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TcompListTx.model_validate(data)

    async def tcomp_take_bid_tx(
        self, min_price: Any, mint: str, seller: str, **kwargs: Any
    ) -> TcompTakeBidTx:
        """
        Sell NFT into Bid
        """
        query = gql(
            """
            query TcompTakeBidTx($minPrice: Decimal!, $mint: String!, $seller: String!) {
              tcompTakeBidTx(minPrice: $minPrice, mint: $mint, seller: $seller) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "minPrice": min_price,
            "mint": mint,
            "seller": seller,
        }
        response = await self.execute(
            query=query, operation_name="TcompTakeBidTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TcompTakeBidTx.model_validate(data)

    async def tcomp_delist_tx(
        self, mint: str, owner: str, **kwargs: Any
    ) -> TcompDelistTx:
        """
        Delist single NFT
        """
        query = gql(
            """
            query TcompDelistTx($mint: String!, $owner: String!) {
              tcompDelistTx(mint: $mint, owner: $owner) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"mint": mint, "owner": owner}
        response = await self.execute(
            query=query, operation_name="TcompDelistTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TcompDelistTx.model_validate(data)

    async def tcomp_edit_tx(
        self, mint: str, owner: str, price: Any, **kwargs: Any
    ) -> TcompEditTx:
        """
        Edit single NFT
        """
        query = gql(
            """
            query TcompEditTx($mint: String!, $owner: String!, $price: Decimal!) {
              tcompEditTx(mint: $mint, owner: $owner, price: $price) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"mint": mint, "owner": owner, "price": price}
        response = await self.execute(
            query=query, operation_name="TcompEditTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TcompEditTx.model_validate(data)

    async def tcomp_bid_tx(
        self,
        quantity: float,
        price: Any,
        owner: str,
        target_id: Union[Optional[str], UnsetType] = UNSET,
        target: Union[Optional[TCompTarget], UnsetType] = UNSET,
        rent_payer: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> TcompBidTx:
        """
        Place Single Bid
        """
        query = gql(
            """
            query TcompBidTx($quantity: Float!, $price: Decimal!, $owner: String!, $targetId: String, $target: TCompTarget, $rentPayer: String) {
              tcompBidTx(
                quantity: $quantity
                price: $price
                owner: $owner
                targetId: $targetId
                target: $target
                rentPayer: $rentPayer
              ) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "quantity": quantity,
            "price": price,
            "owner": owner,
            "targetId": target_id,
            "target": target,
            "rentPayer": rent_payer,
        }
        response = await self.execute(
            query=query, operation_name="TcompBidTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TcompBidTx.model_validate(data)

    async def tcomp_trait_bid_tx(
        self,
        owner: str,
        price: Any,
        quantity: float,
        slug: Union[Optional[str], UnsetType] = UNSET,
        attributes: Union[Optional[List[AttributeInput]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> TcompTraitBidTx:
        """
        Place Trait Bid

        TComp is used to place trait bids for both compressed and non-compressed collections. This is also
        the ONLY endpoint used for trait biddding. If you see a trait bid on Tensor, even on a non-compressed
        collection, it’s actually placed via TComp.
        """
        query = gql(
            """
            query TcompTraitBidTx($owner: String!, $price: Decimal!, $quantity: Float!, $slug: String, $attributes: [AttributeInput!]) {
              tcompBidTx(
                owner: $owner
                price: $price
                quantity: $quantity
                slug: $slug
                attributes: $attributes
              ) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "owner": owner,
            "price": price,
            "quantity": quantity,
            "slug": slug,
            "attributes": attributes,
        }
        response = await self.execute(
            query=query, operation_name="TcompTraitBidTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TcompTraitBidTx.model_validate(data)

    async def tcomp_bid_tx_for_collection(
        self,
        owner: str,
        price: Any,
        quantity: float,
        slug: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> TcompBidTxForCollection:
        """
        Place Collection Bid
        """
        query = gql(
            """
            query TcompBidTxForCollection($owner: String!, $price: Decimal!, $quantity: Float!, $slug: String) {
              tcompBidTx(owner: $owner, price: $price, quantity: $quantity, slug: $slug) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "owner": owner,
            "price": price,
            "quantity": quantity,
            "slug": slug,
        }
        response = await self.execute(
            query=query,
            operation_name="TcompBidTxForCollection",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return TcompBidTxForCollection.model_validate(data)

    async def tcomp_edit_bid_tx(
        self,
        bid_state_address: str,
        price: Union[Optional[Any], UnsetType] = UNSET,
        quantity: Union[Optional[float], UnsetType] = UNSET,
        **kwargs: Any
    ) -> TcompEditBidTx:
        """
        Edit Bid
        """
        query = gql(
            """
            query TcompEditBidTx($bidStateAddress: String!, $price: Decimal, $quantity: Float) {
              tcompEditBidTx(
                bidStateAddress: $bidStateAddress
                price: $price
                quantity: $quantity
              ) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "bidStateAddress": bid_state_address,
            "price": price,
            "quantity": quantity,
        }
        response = await self.execute(
            query=query, operation_name="TcompEditBidTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TcompEditBidTx.model_validate(data)

    async def tcomp_cancel_coll_bid_tx(
        self, bid_state_address: str, **kwargs: Any
    ) -> TcompCancelCollBidTx:
        """
        Cancel Collection Bid
        """
        query = gql(
            """
            query TcompCancelCollBidTx($bidStateAddress: String!) {
              tcompCancelCollBidTx(bidStateAddress: $bidStateAddress) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"bidStateAddress": bid_state_address}
        response = await self.execute(
            query=query,
            operation_name="TcompCancelCollBidTx",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return TcompCancelCollBidTx.model_validate(data)

    async def hswap_buy_nft_tx(
        self, buyer: str, max_price_lamports: Any, mint: str, pair: str, **kwargs: Any
    ) -> HswapBuyNftTx:
        """
        Buy an NFT from a HadeSwap order (pair, see address in HadeSwap Active Orders).

        Specify maxPriceLamports as the maximum price you’re willing to pay (you can specify a higher
        price than the current price to account for slippage).

        Usually this is set to the current buy price of the target order/pool.
        """
        query = gql(
            """
            query HswapBuyNftTx($buyer: String!, $maxPriceLamports: Decimal!, $mint: String!, $pair: String!) {
              hswapBuyNftTx(
                buyer: $buyer
                maxPriceLamports: $maxPriceLamports
                mint: $mint
                pair: $pair
              ) {
                txs {
                  lastValidBlockHeight
                  tx
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "buyer": buyer,
            "maxPriceLamports": max_price_lamports,
            "mint": mint,
            "pair": pair,
        }
        response = await self.execute(
            query=query, operation_name="HswapBuyNftTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return HswapBuyNftTx.model_validate(data)

    async def hswap_sell_nft_tx(
        self,
        math_counter: float,
        min_price_lamports: Any,
        mint: str,
        pair: str,
        seller: str,
        **kwargs: Any
    ) -> HswapSellNftTx:
        """
        Sell an NFT to a HadeSwap order (pair).

        Specify minPriceLamports as the minimum price you’re willing to receive.

        Usually this is set to the current sell price of the target order/pool.
        """
        query = gql(
            """
            query HswapSellNftTx($mathCounter: Float!, $minPriceLamports: Decimal!, $mint: String!, $pair: String!, $seller: String!) {
              hswapSellNftTx(
                mathCounter: $mathCounter
                minPriceLamports: $minPriceLamports
                mint: $mint
                pair: $pair
                seller: $seller
              ) {
                txs {
                  lastValidBlockHeight
                  tx
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "mathCounter": math_counter,
            "minPriceLamports": min_price_lamports,
            "mint": mint,
            "pair": pair,
            "seller": seller,
        }
        response = await self.execute(
            query=query, operation_name="HswapSellNftTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return HswapSellNftTx.model_validate(data)

    async def tswap_buy_nft_tx(
        self, buyer: str, max_price_lamports: Any, mint: str, pool: str, **kwargs: Any
    ) -> TswapBuyNftTx:
        """
        Buy (now) NFT from Order

        Buy an NFT from a TensorSwap order (pool see address in TensorSwap Active Orders).

        Specify maxPriceLamports as the maximum price you’re willing to pay (you can specify a higher
        price than the current price to account for slippage).

        Usually this is set to buyNowPrice of the target order/pool.
        """
        query = gql(
            """
            query TswapBuyNftTx($buyer: String!, $maxPriceLamports: Decimal!, $mint: String!, $pool: String!) {
              tswapBuyNftTx(
                buyer: $buyer
                maxPriceLamports: $maxPriceLamports
                mint: $mint
                pool: $pool
              ) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "buyer": buyer,
            "maxPriceLamports": max_price_lamports,
            "mint": mint,
            "pool": pool,
        }
        response = await self.execute(
            query=query, operation_name="TswapBuyNftTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TswapBuyNftTx.model_validate(data)

    async def tswap_sell_nft_tx(
        self,
        min_price_lamports: Any,
        mint: str,
        pool: str,
        seller: str,
        seller_token_account: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> TswapSellNftTx:
        """
        Sell (now) NFT to Order

        Sell an NFT to a TensorSwap order (pool).

        Specify minPriceLamports as the minimum price you’re willing to receive, after accounting for
        the MM fee but before Tensor fee & royalties (you can specify a lower price than the current
        price to account for slippage).

        Usually this is set to sellNowPrice of the target order/pool.
        """
        query = gql(
            """
            query TswapSellNftTx($minPriceLamports: Decimal!, $mint: String!, $pool: String!, $seller: String!, $sellerTokenAccount: String) {
              tswapSellNftTx(
                minPriceLamports: $minPriceLamports
                mint: $mint
                pool: $pool
                seller: $seller
                sellerTokenAccount: $sellerTokenAccount
              ) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "minPriceLamports": min_price_lamports,
            "mint": mint,
            "pool": pool,
            "seller": seller,
            "sellerTokenAccount": seller_token_account,
        }
        response = await self.execute(
            query=query, operation_name="TswapSellNftTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TswapSellNftTx.model_validate(data)

    async def tswap_init_pool_tx(
        self, config: PoolConfig, owner: str, slug: str, **kwargs: Any
    ) -> TswapInitPoolTx:
        """
        Creating an order allows you do the following (determined by the poolType):
         * NFT : list NFT(s) for sale
         * Token : collection-wide bids to buy NFT(s)
         * Trade: market-making order (buy/sell NFT(s) at the same time)
        """
        query = gql(
            """
            query TswapInitPoolTx($config: PoolConfig!, $owner: String!, $slug: String!) {
              tswapInitPoolTx(config: $config, owner: $owner, slug: $slug) {
                pool
                txs {
                  lastValidBlockHeight
                  tx
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"config": config, "owner": owner, "slug": slug}
        response = await self.execute(
            query=query, operation_name="TswapInitPoolTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TswapInitPoolTx.model_validate(data)

    async def tswap_deposit_withdraw_nft_tx(
        self, action: DepositWithdrawAction, mint: str, pool: str, **kwargs: Any
    ) -> TswapDepositWithdrawNftTx:
        """
        Deposit (or withdraw) NFTs into (or out of) an order/pool to sell.
        """
        query = gql(
            """
            query TswapDepositWithdrawNftTx($action: DepositWithdrawAction!, $mint: String!, $pool: String!) {
              tswapDepositWithdrawNftTx(action: $action, mint: $mint, pool: $pool) {
                txs {
                  lastValidBlockHeight
                  tx
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"action": action, "mint": mint, "pool": pool}
        response = await self.execute(
            query=query,
            operation_name="TswapDepositWithdrawNftTx",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return TswapDepositWithdrawNftTx.model_validate(data)

    async def tswap_deposit_withdraw_sol_tx(
        self, action: DepositWithdrawAction, lamports: Any, pool: str, **kwargs: Any
    ) -> TswapDepositWithdrawSolTx:
        """
        Deposit (or withdraw) SOL into (or out of) an order/pool to buy NFTs.
        """
        query = gql(
            """
            query TswapDepositWithdrawSolTx($action: DepositWithdrawAction!, $lamports: Decimal!, $pool: String!) {
              tswapDepositWithdrawSolTx(action: $action, lamports: $lamports, pool: $pool) {
                txs {
                  lastValidBlockHeight
                  tx
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "action": action,
            "lamports": lamports,
            "pool": pool,
        }
        response = await self.execute(
            query=query,
            operation_name="TswapDepositWithdrawSolTx",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return TswapDepositWithdrawSolTx.model_validate(data)

    async def tswap_deposit_withdraw_margin_account_tx(
        self,
        margin_nr: float,
        lamports: Any,
        owner: str,
        action: DepositWithdrawAction,
        **kwargs: Any
    ) -> TswapDepositWithdrawMarginAccountTx:
        """
        Deposit/Withdraw from Shared Escrow
        """
        query = gql(
            """
            query TswapDepositWithdrawMarginAccountTx($marginNr: Float!, $lamports: Decimal!, $owner: String!, $action: DepositWithdrawAction!) {
              tswapDepositWithdrawMarginAccountTx(
                marginNr: $marginNr
                lamports: $lamports
                owner: $owner
                action: $action
              ) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "marginNr": margin_nr,
            "lamports": lamports,
            "owner": owner,
            "action": action,
        }
        response = await self.execute(
            query=query,
            operation_name="TswapDepositWithdrawMarginAccountTx",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return TswapDepositWithdrawMarginAccountTx.model_validate(data)

    async def tswap_close_pool_tx(self, pool: str, **kwargs: Any) -> TswapClosePoolTx:
        """
        This will close an order/pool (and withdraws any remaining SOL/rent to the owner).

        This transaction will fail if there are NFTs still in the order/pool (nftsHeld in the Orders response).
        You must withdraw all NFTs before you can close the order.
        """
        query = gql(
            """
            query TswapClosePoolTx($pool: String!) {
              tswapClosePoolTx(pool: $pool) {
                txs {
                  lastValidBlockHeight
                  tx
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"pool": pool}
        response = await self.execute(
            query=query,
            operation_name="TswapClosePoolTx",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return TswapClosePoolTx.model_validate(data)

    async def tswap_edit_pool_tx(
        self, new_config: PoolConfig, pool: str, **kwargs: Any
    ) -> TswapEditPoolTx:
        """
        Edit parameters of an order/pool.
        """
        query = gql(
            """
            query TswapEditPoolTx($newConfig: PoolConfig!, $pool: String!) {
              tswapEditPoolTx(newConfig: $newConfig, pool: $pool) {
                pool
                txs {
                  lastValidBlockHeight
                  tx
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"newConfig": new_config, "pool": pool}
        response = await self.execute(
            query=query, operation_name="TswapEditPoolTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TswapEditPoolTx.model_validate(data)

    async def tswap_list_nft_tx(
        self, mint: str, owner: str, price: Any, **kwargs: Any
    ) -> TswapListNftTx:
        """
        Lists an NFT at a given price (standard marketplace listing).
        """
        query = gql(
            """
            query TswapListNftTx($mint: String!, $owner: String!, $price: Decimal!) {
              tswapListNftTx(mint: $mint, owner: $owner, price: $price) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"mint": mint, "owner": owner, "price": price}
        response = await self.execute(
            query=query, operation_name="TswapListNftTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TswapListNftTx.model_validate(data)

    async def tswap_delist_nft_tx(
        self, mint: str, owner: str, **kwargs: Any
    ) -> TswapDelistNftTx:
        """
        Delists/cancels a single marketplace listing.
        """
        query = gql(
            """
            query TswapDelistNftTx($mint: String!, $owner: String!) {
              tswapDelistNftTx(mint: $mint, owner: $owner) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"mint": mint, "owner": owner}
        response = await self.execute(
            query=query,
            operation_name="TswapDelistNftTx",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return TswapDelistNftTx.model_validate(data)

    async def tswap_edit_single_listing_tx(
        self, mint: str, owner: str, price: Any, **kwargs: Any
    ) -> TswapEditSingleListingTx:
        """
        Edit a single marketplace listing price.
        """
        query = gql(
            """
            query TswapEditSingleListingTx($mint: String!, $owner: String!, $price: Decimal!) {
              tswapEditSingleListingTx(mint: $mint, owner: $owner, price: $price) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"mint": mint, "owner": owner, "price": price}
        response = await self.execute(
            query=query,
            operation_name="TswapEditSingleListingTx",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return TswapEditSingleListingTx.model_validate(data)

    async def tswap_buy_single_listing_tx(
        self, buyer: str, max_price: Any, mint: str, owner: str, **kwargs: Any
    ) -> TswapBuySingleListingTx:
        """
        Buy NFT from Listing

        Buy an NFT that is listed on TensorSwap via a standard marketplace listing.

        For most cases, just pass in maxPrice = grossAmount, owner = sellerId from
        “TensorSwap Active Listings” query.
        """
        query = gql(
            """
            query TswapBuySingleListingTx($buyer: String!, $maxPrice: Decimal!, $mint: String!, $owner: String!) {
              tswapBuySingleListingTx(
                buyer: $buyer
                maxPrice: $maxPrice
                mint: $mint
                owner: $owner
              ) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "buyer": buyer,
            "maxPrice": max_price,
            "mint": mint,
            "owner": owner,
        }
        response = await self.execute(
            query=query,
            operation_name="TswapBuySingleListingTx",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return TswapBuySingleListingTx.model_validate(data)

    async def tswap_exchange_nft_tx(
        self,
        max_price_lamports: Any,
        min_price_lamports: Any,
        mint_to_buy: str,
        mint_to_sell: str,
        pool: str,
        taker: str,
        **kwargs: Any
    ) -> TswapExchangeNftTx:
        """
        Swap NFT from Order

        Swap an NFT from the same collection with a TRADE pool only (pool see address in
        TensorSwap Active Orders).
         * Swap an NFT from the same collection with a TRADE pool only (pool see address in
           TensorSwap Active Orders).
         * minPriceLamports - buyNowPrice * (1 - mmFee)
          * eg if meFeeBps = 1000 (10%) then mmFee = 0.1
         * pool - address of the TRADE (must be TRADE) order
         * mintToBuy - NFT in pool that is in nftsForSale
         * mintToSell - NFT to trade-in (must be from same collection)
         * taker - wallet who owns mintToSell

        The fee for the swap is equal to  (2 * takerFee + mmFee) * buyNowPrice.
        """
        query = gql(
            """
            query TswapExchangeNftTx($maxPriceLamports: Decimal!, $minPriceLamports: Decimal!, $mintToBuy: String!, $mintToSell: String!, $pool: String!, $taker: String!) {
              tswapExchangeNftTx(
                maxPriceLamports: $maxPriceLamports
                minPriceLamports: $minPriceLamports
                mintToBuy: $mintToBuy
                mintToSell: $mintToSell
                pool: $pool
                taker: $taker
              ) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "maxPriceLamports": max_price_lamports,
            "minPriceLamports": min_price_lamports,
            "mintToBuy": mint_to_buy,
            "mintToSell": mint_to_sell,
            "pool": pool,
            "taker": taker,
        }
        response = await self.execute(
            query=query,
            operation_name="TswapExchangeNftTx",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return TswapExchangeNftTx.model_validate(data)

    async def take_bid_tx(
        self, bidder: str, mint: str, price: Any, seller: str, **kwargs: Any
    ) -> TakeBidTx:
        """
        Sells the NFT into the open single NFT bid (see tensorBids from Mint endpoint).
        """
        query = gql(
            """
            query TakeBidTx($bidder: String!, $mint: String!, $price: Decimal!, $seller: String!) {
              takeBidTx(bidder: $bidder, mint: $mint, price: $price, seller: $seller) {
                txs {
                  lastValidBlockHeight
                  tx
                  txV0
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "bidder": bidder,
            "mint": mint,
            "price": price,
            "seller": seller,
        }
        response = await self.execute(
            query=query, operation_name="TakeBidTx", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TakeBidTx.model_validate(data)
