/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  var define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
"ed583be1cf": function _(e,s,o,t,n){t();const i=e("tslib").__importStar(e("67e88827d9"));o.AwesomePanelExtensions=i;e("@bokehjs/base").register_models(i)},
"67e88827d9": function _(e,t,a,o,b){o(),b("FastAnchor",e("61ceb3906d").FastAnchor),b("FastButton",e("cffb3837b7").FastButton),b("FastCheckboxGroup",e("b5be3a3047").FastCheckboxGroup),b("FastSwitchGroup",e("ec1eb7e949").FastSwitchGroup),b("FastTextAreaInput",e("86ebbe8a0e").FastTextAreaInput),b("FastTextInput",e("d7e6a9ee16").FastTextInput),b("PerspectiveViewer",e("59f7dfa54f").PerspectiveViewer),b("PivotTable",e("eb1a40b8a7").PivotTable),b("TabulatorModel",e("e2e34597ee").TabulatorModel),b("WebComponent",e("5c604c9068").WebComponent)},
"61ceb3906d": function _(e,t,r,i,n){i();const s=e("tslib"),o=e("@bokehjs/models/layouts/html_box"),h=s.__importStar(e("@bokehjs/core/properties"));class l extends o.HTMLBoxView{setAttr(e,t){const r=this.anchor_el;null===t?r.setAttribute(e,!1):r.setAttribute(e,t)}connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,(()=>{null===this.model.name?this.anchor_el.innerHTML="":this.anchor_el.innerHTML=this.model.name})),this.connect(this.model.properties.appearance.change,(()=>{this.setAttr("appearance",this.model.appearance)})),this.connect(this.model.properties.href.change,(()=>{this.setAttr("href",this.model.href)})),this.connect(this.model.properties.hreflang.change,(()=>{this.setAttr("hreflang",this.model.hreflang)})),this.connect(this.model.properties.ping.change,(()=>{this.setAttr("ping",this.model.ping)})),this.connect(this.model.properties.href.change,(()=>{this.setAttr("referrerpolicy",this.model.referrerpolicy)})),this.connect(this.model.properties.download.change,(()=>{this.setAttr("download",this.model.download)})),this.connect(this.model.properties.referrer.change,(()=>{this.setAttr("referrer",this.model.referrer)})),this.connect(this.model.properties.rel.change,(()=>{this.setAttr("rel",this.model.rel)})),this.connect(this.model.properties.target.change,(()=>{this.setAttr("mimetype",this.model.mimetype)}))}render(){super.render();const e=document.createElement("fast-anchor");this.anchor_el=e,this.anchor_el.style.width="100%",this.el.appendChild(this.anchor_el),null!==this.model.name&&(this.anchor_el.innerHTML=this.model.name),null!==this.model.appearance&&(e.appearance=this.model.appearance),null!==this.model.href&&(e.href=this.model.href),null!==this.model.hreflang&&(e.hreflang=this.model.hreflang),null!==this.model.ping&&(e.ping=this.model.ping),null!==this.model.referrerpolicy&&(e.referrerpolicy=this.model.referrerpolicy),null!==this.model.download&&(e.download=this.model.download),null!==this.model.referrer&&(e.ref=this.model.referrer),null!==this.model.rel&&(e.rel=this.model.rel),null!==this.model.target&&(e.target=this.model.target),null!==this.model.mimetype&&(e.mimetype=this.model.mimetype)}}r.FastAnchorView=l,l.__name__="FastAnchorView";class a extends o.HTMLBox{constructor(e){super(e)}static init_FastAnchor(){this.prototype.default_view=l,this.define({appearance:[h.String],download:[h.String],href:[h.String],hreflang:[h.String],ping:[h.String],referrerpolicy:[h.String],referrer:[h.String],rel:[h.String],target:[h.String],mimetype:[h.String]})}}r.FastAnchor=a,a.__name__="FastAnchor",a.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_anchor",a.init_FastAnchor()},
"cffb3837b7": function _(t,e,s,o,n){o();const a=t("tslib"),i=t("@bokehjs/models/widgets/button"),u=a.__importStar(t("@bokehjs/core/properties"));class _ extends i.ButtonView{_render_button(...t){const e=document.createElement("fast-button");return e.innerText=this.model.label,e.disabled=this.model.disabled,e.appearance=this.model.appearance,e.autofocus=this.model.autofocus,e.style.width="100%",e.style.height="100%",e}}s.FastButtonView=_,_.__name__="FastButtonView";class l extends i.Button{constructor(t){super(t)}static init_FastButton(){this.prototype.default_view=_,this.define({appearance:[u.String],autofocus:[u.Boolean]})}}s.FastButton=l,l.__name__="FastButton",l.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_button",l.init_FastButton()},
"b5be3a3047": function _(e,s,t,o,i){o();const n=e("tslib"),a=e("@bokehjs/models/widgets/checkbox_group"),c=e("@bokehjs/styles/mixins"),l=e("@bokehjs/styles/widgets/inputs"),h=e("@bokehjs/core/dom"),r=e("@bokehjs/core/util/array"),d=n.__importStar(e("@bokehjs/core/properties"));class _ extends a.CheckboxGroupView{render(){const e=h.div({class:[l.bk_input_group,this.model.inline?c.bk_inline:null]});this.el.innerHTML="",this.el.appendChild(e);const{active:s,labels:t}=this.model;this._inputs=[];for(let o=0;o<t.length;o++){let i=document.createElement("fast-checkbox");this.model.readonly&&i.setAttribute("readonly",!0),i.innerHTML=t[o];const n=i;n.value=`${o}`,n.addEventListener("change",(()=>this.change_active(o))),this._inputs.push(n),this.model.disabled&&(n.disabled=!0),r.includes(s,o)&&(n.checked=!0),e.appendChild(n)}}}t.FastCheckboxGroupView=_,_.__name__="FastCheckboxGroupView";class p extends a.CheckboxGroup{constructor(e){super(e)}static init_FastCheckboxGroup(){this.prototype.default_view=_,this.define({readonly:[d.Boolean]})}}t.FastCheckboxGroup=p,p.__name__="FastCheckboxGroup",p.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_checkbox_group",p.init_FastCheckboxGroup()},
"ec1eb7e949": function _(e,t,s,i,n){i();const o=e("tslib"),c=e("@bokehjs/models/widgets/checkbox_group"),a=e("@bokehjs/styles/mixins"),h=e("@bokehjs/styles/widgets/inputs"),d=e("@bokehjs/core/dom"),l=e("@bokehjs/core/util/array"),r=o.__importStar(e("@bokehjs/core/properties"));class u extends c.CheckboxGroupView{render(){const e=d.div({class:[h.bk_input_group,this.model.inline?a.bk_inline:null]});this.el.innerHTML="",this.el.appendChild(e);const{active:t,labels:s}=this.model;this._inputs=[];for(let i=0;i<s.length;i++){let n=document.createElement("fast-switch");this.model.readonly&&n.setAttribute("readonly",!0),n.innerHTML=s[i],n.innerHTML=s[i];const o=n;o.value=`${i}`,o.addEventListener("change",(()=>this.change_active(i))),this._inputs.push(o),this.model.disabled&&(o.disabled=!0),l.includes(t,i)&&(o.checked=!0);const c=document.createElement("span");c.setAttribute("slot","checked-message"),c.innerHTML=this.model.checked_message,o.appendChild(c);const a=document.createElement("span");a.setAttribute("slot","unchecked-message"),a.innerHTML=this.model.unchecked_message,o.appendChild(a),e.appendChild(o)}}}s.FastSwitchGroupView=u,u.__name__="FastSwitchGroupView";class _ extends c.CheckboxGroup{constructor(e){super(e)}static init_FastSwitchGroup(){this.prototype.default_view=u,this.define({readonly:[r.Boolean],checked_message:[r.String],unchecked_message:[r.String]})}}s.FastSwitchGroup=_,_.__name__="FastSwitchGroup",_.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_switch_group",_.init_FastSwitchGroup()},
"86ebbe8a0e": function _(e,t,i,s,n){s();const l=e("tslib"),o=e("@bokehjs/models/widgets/textarea_input"),a=e("@bokehjs/models/widgets/input_widget"),h=l.__importStar(e("@bokehjs/core/properties"));class r extends a.InputWidgetView{get input_el_any(){return this.input_el}connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,(()=>{var e;return this.input_el.name=null!==(e=this.model.name)&&void 0!==e?e:""})),this.connect(this.model.properties.value.change,(()=>{this.input_el.value=this.model.value})),this.connect(this.model.properties.disabled.change,(()=>this.input_el.disabled=this.model.disabled)),this.connect(this.model.properties.placeholder.change,(()=>this.input_el.placeholder=this.model.placeholder)),this.connect(this.model.properties.rows.change,(()=>this.input_el.rows=this.model.rows)),this.connect(this.model.properties.cols.change,(()=>this.input_el.cols=this.model.cols)),this.connect(this.model.properties.max_length.change,(()=>this.input_el_any.setAttribute("maxlength",this.model.max_length))),this.connect(this.model.properties.appearance.change,(()=>this.input_el_any.appearance=this.model.appearance)),this.connect(this.model.properties.autofocus.change,(()=>this.input_el_any.autofocus=this.model.autofocus)),this.connect(this.model.properties.resize.change,(()=>this.input_el_any.resize=this.model.resize)),this.connect(this.model.properties.spellcheck.change,(()=>this.input_el_any.spellcheck=this.model.spellcheck)),this.connect(this.model.properties.min_length.change,(()=>this.input_el_any.setAttribute("minlength",this.model.min_length))),this.connect(this.model.properties.required.change,(()=>this.input_el_any.required=this.model.required)),this.connect(this.model.properties.readonly.change,(()=>{!0===this.model.readonly?this.input_el_any.setAttribute("readonly",""):this.input_el_any.removeAttribute("readonly")}))}render(){super.render();const e=document.createElement("fast-text-area");this.input_el=e,this.input_el.className="bk-fast-input",this.input_el.addEventListener("change",(()=>this.change_input())),this.group_el.appendChild(this.input_el),e.name=this.model.name,e.value=this.model.value,e.disabled=this.model.disabled,e.placeholder=this.model.placeholder,e.cols=this.model.cols,e.rows=this.model.rows,null!=this.model.max_length&&e.setAttribute("maxlength",this.model.max_length),e.appearance=this.model.appearance,e.autofocus=this.model.autofocus,e.resize=this.model.resize,e.spellcheck=this.model.spellcheck,null!=this.model.min_length&&e.setAttribute("minlength",this.model.min_length),e.required=this.model.required,!0===this.model.readonly&&e.setAttribute("readonly","")}change_input(){this.model.value=this.input_el.value,super.change_input()}}i.FastTextAreaInputView=r,r.__name__="FastTextAreaInputView";class p extends o.TextAreaInput{constructor(e){super(e)}static init_FastTextAreaInput(){this.prototype.default_view=r,this.define({appearance:[h.String],autofocus:[h.Boolean],resize:[h.String],spellcheck:[h.Boolean],min_length:[h.Number],required:[h.Boolean],readonly:[h.Boolean]})}}i.FastTextAreaInput=p,p.__name__="FastTextAreaInput",p.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_textarea_input",p.init_FastTextAreaInput()},
"d7e6a9ee16": function _(e,t,i,n,s){n();const l=e("tslib"),o=e("@bokehjs/models/widgets/text_input"),a=e("@bokehjs/models/widgets/input_widget"),h=l.__importStar(e("@bokehjs/core/properties"));class p extends a.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,(()=>{var e;return this.input_el.name=null!==(e=this.model.name)&&void 0!==e?e:""})),this.connect(this.model.properties.value.change,(()=>{this.input_el.value=this.model.value,console.log("value")})),this.connect(this.model.properties.value_input.change,(()=>this.input_el.value=this.model.value_input)),this.connect(this.model.properties.disabled.change,(()=>this.input_el.disabled=this.model.disabled)),this.connect(this.model.properties.placeholder.change,(()=>this.input_el.placeholder=this.model.placeholder)),this.connect(this.model.properties.appearance.change,(()=>this.input_el_any.appearance=this.model.appearance)),this.connect(this.model.properties.autofocus.change,(()=>this.input_el_any.autofocus=this.model.autofocus)),this.connect(this.model.properties.type_of_text.change,(()=>this.input_el_any.type=this.model.type_of_text)),this.connect(this.model.properties.max_length.change,(()=>this.input_el_any.setAttribute("maxlength",this.model.max_length))),this.connect(this.model.properties.min_length.change,(()=>this.input_el_any.setAttribute("minlength",this.model.min_length))),this.connect(this.model.properties.pattern.change,(()=>this.input_el_any.pattern=this.model.pattern)),this.connect(this.model.properties.spellcheck.change,(()=>this.input_el_any.spellcheck=this.model.spellcheck)),this.connect(this.model.properties.required.change,(()=>this.input_el_any.required=this.model.required)),this.connect(this.model.properties.readonly.change,(()=>this.input_el_any.setAttribute("readonly",this.model.readonly)))}get input_el_any(){return this.input_el}render(){super.render();const e=document.createElement("fast-text-field");this.input_el=e,this.input_el.className="bk-fast-input",this.input_el.addEventListener("change",(()=>this.change_input())),this.input_el.addEventListener("input",(()=>this.change_input_oninput())),this.group_el.appendChild(this.input_el),e.name=this.model.name,e.value=this.model.value,e.appearance=this.model.appearance,e.autofocus=this.model.autofocus,e.placeholder=this.model.placeholder,e.disabled=this.model.disabled,e.type=this.model.type_of_text,e.setAttribute("maxlength",this.model.max_length),e.setAttribute("minlength",this.model.min_length),e.pattern=this.model.pattern,e.spellcheck=this.model.spellcheck,e.required=this.model.required,e.disabled=this.model.disabled,e.setAttribute("readonly",this.model.readonly)}change_input(){this.model.value=this.input_el.value,super.change_input()}change_input_oninput(){this.model.value_input=this.input_el.value,super.change_input()}}i.FastTextInputView=p,p.__name__="FastTextInputView";class r extends o.TextInput{constructor(e){super(e)}static init_FastTextInput(){this.prototype.default_view=p,this.define({appearance:[h.String],autofocus:[h.Boolean],type_of_text:[h.String],max_length:[h.Number],min_length:[h.Number],pattern:[h.String],size:[h.Any],spellcheck:[h.Boolean],required:[h.Boolean],readonly:[h.Boolean,!1]})}}i.FastTextInput=r,r.__name__="FastTextInput",r.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_text_input",r.init_FastTextInput()},
"59f7dfa54f": function _(e,t,s,i,o){i();const r=e("tslib"),p=e("@bokehjs/models/layouts/html_box"),u=e("@bokehjs/core/dom"),n=r.__importStar(e("@bokehjs/core/properties")),a=e("88538263fa"),l=["perspective-viewer-material","perspective-viewer-material-dark","perspective-viewer-material-dense","perspective-viewer-material-dense-dark","perspective-viewer-vaporwave"];function c(e){return!l.includes(e)}function d(e){return"perspective-viewer-"+e}class m extends p.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.source.properties.data.change,this.setData),this.connect(this.model.source_stream.properties.data.change,this.addData),this.connect(this.model.source_patch.properties.data.change,this.updateOrAddData),this.connect(this.model.properties.columns.change,this.updateColumns),this.connect(this.model.properties.parsed_computed_columns.change,this.updateParsedComputedColumns),this.connect(this.model.properties.computed_columns.change,this.updateComputedColumns),this.connect(this.model.properties.column_pivots.change,this.updateColumnPivots),this.connect(this.model.properties.row_pivots.change,this.updateRowPivots),this.connect(this.model.properties.aggregates.change,this.updateAggregates),this.connect(this.model.properties.filters.change,this.updateFilters),this.connect(this.model.properties.plugin.change,this.updatePlugin),this.connect(this.model.properties.theme.change,this.updateTheme)}render(){super.render();const e=u.div({class:"pnx-perspective-viewer"});e.innerHTML=this.getInnerHTML(),this.perspective_element=e.children[0],a.set_size(e,this.model),this.el.appendChild(e),this.setData();let t=this;this.perspective_element.addEventListener("perspective-config-update",(function(){t.model.columns=this.columns,t.model.column_pivots=JSON.parse(this.getAttribute("column-pivots")),t.model.parsed_computed_columns=JSON.parse(this.getAttribute("parsed-computed-columns")),t.model.computed_columns=JSON.parse(this.getAttribute("computed-columns")),t.model.row_pivots=JSON.parse(this.getAttribute("row-pivots")),t.model.aggregates=JSON.parse(this.getAttribute("aggregates")),t.model.sort=JSON.parse(this.getAttribute("sort")),t.model.filters=JSON.parse(this.getAttribute("filters")),"debug"!==this.getAttribute("plugin")&&(t.model.plugin=this.getAttribute("plugin"))}))}getInnerHTML(){let e="<perspective-viewer style='height:100%;width:100%;'";return e+=a.toAttribute("class",d(this.model.theme)),e+=a.toAttribute("columns",this.model.columns),e+=a.toAttribute("column-pivots",this.model.column_pivots),e+=a.toAttribute("computed-columns",this.model.computed_columns),e+=a.toAttribute("row-pivots",this.model.row_pivots),e+=a.toAttribute("aggregates",this.model.aggregates),e+=a.toAttribute("sort",this.model.sort),e+=a.toAttribute("filters",this.model.filters),e+=a.toAttribute("plugin",this.model.plugin),e+="></perspective-viewer>",e}setData(){console.log("setData"),console.log(this.model.source.data);let e=a.transform_cds_to_records(this.model.source);this.perspective_element.load(e)}addData(){console.log("addData"),this.setData()}updateOrAddData(){console.log("updateOrAddData"),this.setData()}updateAttribute(e,t,s){if(null==t||t===[])return;const i=this.perspective_element.getAttribute(e);s&&(t=JSON.stringify(t)),i!==t&&this.perspective_element.setAttribute(e,t)}updateColumns(){this.updateAttribute("columns",this.model.columns,!0)}updateParsedComputedColumns(){this.updateAttribute("parsed-computed-columns",this.model.parsed_computed_columns,!0)}updateComputedColumns(){this.updateAttribute("computed-columns",this.model.computed_columns,!0)}updateColumnPivots(){this.updateAttribute("column-pivots",this.model.column_pivots,!0)}updateRowPivots(){this.updateAttribute("row-pivots",this.model.row_pivots,!0)}updateAggregates(){this.updateAttribute("aggregates",this.model.row_pivots,!0)}updateSort(){this.updateAttribute("sort",this.model.sort,!0)}updateFilters(){this.updateAttribute("sort",this.model.filters,!0)}updatePlugin(){this.updateAttribute("plugin",this.model.plugin,!1)}updateTheme(){let e=this.perspective_element.getAttribute("class"),t=this.toNewClassAttribute(e,this.model.theme);this.perspective_element.setAttribute("class",t)}toNewClassAttribute(e,t){let s=[];return null!=e&&(s=e.split(" ").filter(c)),s.push(d(t)),s.join(" ")}}s.PerspectiveViewerView=m,m.__name__="PerspectiveViewerView";class h extends p.HTMLBox{constructor(e){super(e)}static init_PerspectiveViewer(){this.prototype.default_view=m,this.define({source:[n.Any],source_stream:[n.Any],source_patch:[n.Any],columns:[n.Array],parsed_computed_columns:[n.Array,[]],computed_columns:[n.Array],column_pivots:[n.Array],row_pivots:[n.Array],aggregates:[n.Any],sort:[n.Array],filters:[n.Array],plugin:[n.String],theme:[n.String]})}}s.PerspectiveViewer=h,h.__name__="PerspectiveViewer",h.__module__="awesome_panel_extensions.bokeh_extensions.perspective_viewer",h.init_PerspectiveViewer()},
"88538263fa": function _(e,t,i,l,n){l(),i.set_size=function(e,t){let i=null!=t.width?"fixed":"fit",l=null!=t.height?"fixed":"fit";const{sizing_mode:n}=t;if(null!=n)if("fixed"==n)i=l="fixed";else if("stretch_both"==n)i=l="max";else if("stretch_width"==n)i="max";else if("stretch_height"==n)l="max";else switch(n){case"scale_width":i="max",l="min";break;case"scale_height":i="min",l="max";break;case"scale_both":i="max",l="max";break;default:throw new Error("unreachable")}"fixed"==i&&t.width?e.style.width=t.width+"px":"max"==i&&(e.style.width="100%"),"fixed"==l&&t.height?e.style.height=t.height+"px":"max"==l&&(e.style.height="100%")},i.transform_cds_to_records=function(e){const t=[],i=e.columns(),l=e.get_length();if(0===i.length||null===l)return[];for(let n=0;n<l;n++){const l={};for(const t of i){let i=e.get_array(t);const s=null==i[0].shape?null:i[0].shape;null!=s&&s.length>1&&"number"==typeof s[0]?l[t]=i.slice(n*s[1],n*s[1]+s[1]):l[t]=i[n]}t.push(l)}return t},i.toAttribute=function(e,t){return null===t?"":("string"!=typeof t&&(t=JSON.stringify(t))," "+e+"='"+t+"'")}},
"eb1a40b8a7": function _(e,t,s,o,i){o();const n=e("tslib"),a=e("@bokehjs/models/layouts/html_box"),l=e("@bokehjs/core/dom"),_=n.__importStar(e("@bokehjs/core/properties")),c=e("88538263fa");class r extends a.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.source.properties.data.change,this.setData)}render(){super.render(),this.container=l.div({class:"pnx-pivot-table"}),c.set_size(this.container,this.model),this.el.appendChild(this.container),this.setData()}setData(){console.log("setData"),console.log(this.model.source.data);let e=c.transform_cds_to_records(this.model.source);this.pivot_table_element=$(this.container),console.log(e),this.pivot_table_element.pivotUI(e,{})}}s.PivotTableView=r,r.__name__="PivotTableView";class h extends a.HTMLBox{constructor(e){super(e)}static init_PivotTable(){this.prototype.default_view=r,this.define({source:[_.Any],source_stream:[_.Any],source_patch:[_.Any]})}}s.PivotTable=h,h.__name__="PivotTable",h.__module__="awesome_panel_extensions.bokeh_extensions.pivot_table",h.init_PivotTable()},
"e2e34597ee": function _(e,t,o,l,a){l();const s=e("tslib"),i=e("@bokehjs/models/layouts/html_box"),n=e("@bokehjs/core/dom"),c=s.__importStar(e("@bokehjs/core/properties"));function r(e,t){let o=null!=t.width?"fixed":"fit",l=null!=t.height?"fixed":"fit";const{sizing_mode:a}=t;if(null!=a)if("fixed"==a)o=l="fixed";else if("stretch_both"==a)o=l="max";else if("stretch_width"==a)o="max";else if("stretch_height"==a)l="max";else switch(a){case"scale_width":o="max",l="min";break;case"scale_height":o="min",l="max";break;case"scale_both":o="max",l="max";break;default:throw new Error("unreachable")}"fixed"==o&&t.width?e.style.width=t.width+"px":"max"==o&&(e.style.width="100%"),"fixed"==l&&t.height?e.style.height=t.height+"px":"max"==l&&(e.style.height="100%")}function d(e){const t=[],o=e.columns(),l=e.get_length();if(0===o.length||null===l)return[];for(let a=0;a<l;a++){const l={};for(const t of o){let o=e.get_array(t);const s=null==o[0].shape?null:o[0].shape;null!=s&&s.length>1&&"number"==typeof s[0]?l[t]=o.slice(a*s[1],a*s[1]+s[1]):l[t]=o[a]}t.push(l)}return t}o.set_size=r;class u extends i.HTMLBoxView{constructor(){super(...arguments),this._tabulator_cell_updating=!1}connect_signals(){super.connect_signals(),this.connect(this.model.properties.configuration.change,(()=>{this.render()})),this.connect(this.model.source.properties.data.change,(()=>{this.setData()})),this.connect(this.model.source.streaming,(()=>this.addData())),this.connect(this.model.source.patching,(()=>this.updateOrAddData())),this.connect(this.model.source.selected.properties.indices.change,(()=>this.updateSelection()))}render(){super.render(),console.log("render");const e=n.div({class:"pnx-tabulator"});r(e,this.model);let t=this.getConfiguration();"undefined"==typeof Tabulator&&console.log("Tabulator not loaded. See https://github.com/holoviz/panel/issues/15299"),console.log(Tabulator),this.tabulator=new Tabulator(e,t),this.el.appendChild(e)}getConfiguration(){let e=this;let t={rowSelectionChanged:function(t,o){console.log("rowSelectionChanged");let l=t.map((e=>e.index));e.model.source.selected.indices=l},cellEdited:function(t){console.log("cellEdited");const o=t._cell.column.field,l=t._cell.row.data.index,a=t._cell.value;e._tabulator_cell_updating=!0,e.model.source.patch({[o]:[[l,a]]}),e.model._cell_change={c:o,i:l,v:a},e._tabulator_cell_updating=!1},index:"index"},o=Object.assign(Object.assign({},this.model.configuration),t),l=this.model.source;return null===l||0===Object.keys(l.data).length?o:(console.log("adding data to configuration"),l=d(l),Object.assign(Object.assign({},o),{data:l}))}after_layout(){console.log("after_layout"),super.after_layout(),this.tabulator.redraw(!0)}setData(){console.log("setData");let e=d(this.model.source);this.tabulator.setData(e)}addData(){console.log("addData");let e=d(this.model.source);this.tabulator.setData(e)}updateOrAddData(){if(!0===this._tabulator_cell_updating)return;console.log("updateData");let e=d(this.model.source);this.tabulator.setData(e)}updateSelection(){if(console.log("updateSelection"),null==this.tabulator)return;let e=this.model.source.selected.indices,t=this.tabulator.getSelectedRows();for(let o of t)e.includes(o.getData().index)||o.toggleSelect();for(let t of e)this.tabulator.selectRow(t)}}o.TabulatorModelView=u,u.__name__="TabulatorModelView";class h extends i.HTMLBox{constructor(e){super(e)}static init_TabulatorModel(){this.prototype.default_view=u,this.define({configuration:[c.Any],source:[c.Any],_cell_change:[c.Any]})}}o.TabulatorModel=h,h.__name__="TabulatorModel",h.__module__="awesome_panel_extensions.bokeh_extensions.tabulator_model",h.init_TabulatorModel()},
"5c604c9068": function _(e,t,n,o,s){o();const i=e("tslib"),r=e("@bokehjs/core/dom"),a=i.__importStar(e("@bokehjs/core/properties")),l=e("@bokehjs/models/layouts/html_box"),h=e("@bokehjs/styles/widgets/inputs");function p(e){return(new DOMParser).parseFromString(e,"text/html").documentElement.textContent}class m extends l.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,(()=>this.handleNameChange())),this.connect(this.model.properties.innerHTML.change,(()=>this.render())),this.connect(this.model.properties.attributesLastChange.change,(()=>this.handleAttributesLastChangeChange())),this.connect(this.model.properties.propertiesLastChange.change,(()=>this.handlePropertiesLastChangeChange())),this.connect(this.model.properties.columnDataSource.change,(()=>this.handleColumnDataSourceChange()))}handleNameChange(){this.label_el&&(this.label_el.textContent=this.model.name)}render(){super.render(),this.el.innerHTML!==this.model.innerHTML&&this.createOrUpdateWebComponentElement()}after_layout(){"after_layout"in this.webComponentElement&&this.webComponentElement.after_layout()}createOrUpdateWebComponentElement(){this.webComponentElement&&(this.webComponentElement.onchange=null);const e=this.model.name;"inputgroup"===this.model.componentType&&e?(this.group_el=r.div({class:h.bk_input_group},this.label_el),this.group_el.innerHTML=p(this.model.innerHTML),this.webComponentElement=this.group_el.firstElementChild,this.label_el=r.label({style:{display:0==e.length?"none":""}},e),this.group_el.insertBefore(this.label_el,this.webComponentElement),this.el.appendChild(this.group_el)):(this.el.innerHTML=p(this.model.innerHTML),this.webComponentElement=this.el.firstElementChild),this.activate_scripts(this.webComponentElement.parentNode),this.initPropertyValues(),this.handlePropertiesLastChangeChange(),this.handleColumnDataSourceChange(),this.webComponentElement.onchange=e=>this.handlePropertiesChange(e),this.addEventListeners(),this.addAttributesMutationObserver()}addAttributesMutationObserver(){if(!this.model.attributesToWatch)return;let e={childList:!1,attributes:!0,characterData:!1,subtree:!1,attributeFilter:Object.keys(this.model.attributesToWatch),attributeOldValue:!1,characterDataOldValue:!1};new MutationObserver((e=>{let t=new Object;for(let e in this.model.attributesToWatch){const n=this.webComponentElement.getAttribute(e);t[e]=n}this.model.attributesLastChange!==t&&(this.model.attributesLastChange=t)})).observe(this.webComponentElement,e)}addEventListeners(){this.eventsCount={};for(let e in this.model.eventsToWatch)this.eventsCount[e]=0,this.webComponentElement.addEventListener(e,(e=>this.eventHandler(e)),!1)}transform_cds_to_records(e){const t=[],n=e.columns(),o=e.get_length();if(0===n.length||null===o)return[];for(let s=0;s<o;s++){const o={};for(const t of n){let n=e.get_array(t);const i=null==n[0].shape?null:n[0].shape;null!=i&&i.length>1&&"number"==typeof i[0]?o[t]=n.slice(s*i[1],s*i[1]+i[1]):o[t]=n[s]}t.push(o)}return t}isFunction(e){if(e){const t={}.toString.call(e);return"[object Function]"===t||"[object AsyncFunction]"===t}return!1}handleColumnDataSourceChange(){if(this.model.columnDataSource){let e;e="records"===this.model.columnDataSourceOrient?this.transform_cds_to_records(this.model.columnDataSource):this.model.columnDataSource.data;const t=this.model.columnDataSourceLoadFunction.toString(),n=this.webComponentElement[t];this.isFunction(n)?this.webComponentElement[t](e):this.webComponentElement[t]=e}}activate_scripts(e){Array.from(e.querySelectorAll("script")).forEach((e=>{const t=document.createElement("script");Array.from(e.attributes).forEach((e=>t.setAttribute(e.name,e.value))),t.appendChild(document.createTextNode(e.innerHTML)),e.parentNode&&e.parentNode.replaceChild(t,e)}))}get_nested_property(e,t){let n=(t=(t=t.replace(/\[(\w+)\]/g,".$1")).replace(/^\./,"")).split(".");for(let t=0,o=n.length;t<o;++t){let o=n[t];if(!(o in e))return"";e=e[o]}return e}set_nested_property(e,t,n){const o=t.split(".");if(1===o.length)e[t]=n;else{const t=o.length;for(let n=0;n<t-1;n++){const t=o[n];e[t]||(e[t]={}),e=e[t]}e[o[t-1]]=n}}eventHandler(e){let t=e.type;this.eventsCount[t]+=1;let n={};n[t]=this.eventsCount[t],this.model.eventsCountLastChange=n,this.checkIfPropertiesChanged()}checkIfPropertiesChanged(){const e={};for(const t in this.model.propertiesToWatch){const n=this.propertyValues[t],o=this.get_nested_property(this.webComponentElement,t);n!=o&&(e[t]=o,this.propertyValues[t]=o)}Object.keys(e).length&&(this.model.propertiesLastChange=e)}handlePropertiesChange(e){const t=new Object;for(const n in this.model.propertiesToWatch)e.detail&&n in e.detail?(t[n]=e.detail[n],this.propertyValues[n]=e.detail[n]):e.target&&n in e.target&&(t[n]=e.target[n],this.propertyValues[n]=e.target[n]);Object.keys(t).length&&(this.model.propertiesLastChange=t)}initPropertyValues(){if(this.propertyValues=new Object,this.webComponentElement)for(let e in this.model.propertiesToWatch){let t=this.propertyValues[e],n=this.get_nested_property(this.webComponentElement,e);n!==t&&(this.propertyValues[e]=n)}}handleAttributesLastChangeChange(){if(!this.webComponentElement)return;let e=this.model.attributesLastChange;for(let t in this.model.attributesLastChange)if(t in this.model.attributesToWatch){let n=this.webComponentElement.getAttribute(t),o=e[t];n!==o&&(null===o?this.webComponentElement.removeAttribute(t):this.webComponentElement.setAttribute(t,o))}}handlePropertiesLastChangeChange(){if(!this.webComponentElement)return;let e=this.model.propertiesLastChange;for(let t in this.model.propertiesLastChange)if(t in this.model.propertiesToWatch){let n=e[t];this.set_nested_property(this.webComponentElement,t,n)}}}n.WebComponentView=m,m.__name__="WebComponentView";class c extends l.HTMLBox{constructor(e){super(e)}static init_WebComponent(){this.prototype.default_view=m,this.define({componentType:[a.String,"htmlbox"],innerHTML:[a.String,""],attributesToWatch:[a.Any],attributesLastChange:[a.Any],propertiesToWatch:[a.Any],propertiesLastChange:[a.Any],eventsToWatch:[a.Any],eventsCountLastChange:[a.Any],columnDataSource:[a.Any],columnDataSourceOrient:[a.Any],columnDataSourceLoadFunction:[a.Any]})}}n.WebComponent=c,c.__name__="WebComponent",c.__module__="awesome_panel_extensions.bokeh_extensions.web_component",c.init_WebComponent()},
}, "ed583be1cf", {"index":"ed583be1cf","bokeh_extensions/index":"67e88827d9","bokeh_extensions/fast/fast_anchor":"61ceb3906d","bokeh_extensions/fast/fast_button":"cffb3837b7","bokeh_extensions/fast/fast_checkbox_group":"b5be3a3047","bokeh_extensions/fast/fast_switch_group":"ec1eb7e949","bokeh_extensions/fast/fast_textarea_input":"86ebbe8a0e","bokeh_extensions/fast/fast_text_input":"d7e6a9ee16","bokeh_extensions/perspective_viewer":"59f7dfa54f","bokeh_extensions/shared":"88538263fa","bokeh_extensions/pivot_table":"eb1a40b8a7","bokeh_extensions/tabulator_model":"e2e34597ee","bokeh_extensions/web_component":"5c604c9068"}, {});});
