"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGateway = exports.ApiGatewayDomain = void 0;
/**
 * Defines an API Gateway domain name as the alias target.
 *
 * Use the `ApiGateway` class if you wish to map the alias to an REST API with a
 * domain name defined through the `RestApiProps.domainName` prop.
 */
class ApiGatewayDomain {
    /**
     *
     */
    constructor(domainName) {
        this.domainName = domainName;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     */
    bind(_record) {
        return {
            dnsName: this.domainName.domainNameAliasDomainName,
            hostedZoneId: this.domainName.domainNameAliasHostedZoneId,
        };
    }
}
exports.ApiGatewayDomain = ApiGatewayDomain;
/**
 * Defines an API Gateway REST API as the alias target. Requires that the domain name will be defined through `RestApiProps.domainName`.
 *
 * You can direct the alias to any `apigateway.DomainName` resource through the
 * `ApiGatewayDomain` class.
 */
class ApiGateway extends ApiGatewayDomain {
    /**
     *
     */
    constructor(api) {
        if (!api.domainName) {
            throw new Error('API does not define a default domain name');
        }
        super(api.domainName);
    }
}
exports.ApiGateway = ApiGateway;
//# sourceMappingURL=data:application/json;base64,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