"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayv2Domain = void 0;
/**
 * Defines an API Gateway V2 domain name as the alias target.
 */
class ApiGatewayv2Domain {
    /**
     *
     */
    constructor(domainName) {
        this.domainName = domainName;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     */
    bind(_record) {
        return {
            dnsName: this.domainName.regionalDomainName,
            hostedZoneId: this.domainName.regionalHostedZoneId,
        };
    }
}
exports.ApiGatewayv2Domain = ApiGatewayv2Domain;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLWdhdGV3YXl2Mi1kb21haW4tbmFtZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFwaS1nYXRld2F5djItZG9tYWluLW5hbWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBTUEsTUFBYSxrQkFBa0I7Ozs7SUFDN0IsWUFBNkIsVUFBOEI7UUFBOUIsZUFBVSxHQUFWLFVBQVUsQ0FBb0I7SUFBSSxDQUFDOzs7O0lBRXpELElBQUksQ0FBQyxPQUEyQjtRQUNyQyxPQUFPO1lBQ0wsT0FBTyxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsa0JBQWtCO1lBQzNDLFlBQVksRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLG9CQUFvQjtTQUNuRCxDQUFDO0lBQ0osQ0FBQztDQUNGO0FBVEQsZ0RBU0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBhcGlndjIgZnJvbSAnQGF3cy1jZGsvYXdzLWFwaWdhdGV3YXl2Mic7XG5pbXBvcnQgKiBhcyByb3V0ZTUzIGZyb20gJ0Bhd3MtY2RrL2F3cy1yb3V0ZTUzJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQXBpR2F0ZXdheXYyRG9tYWluIGltcGxlbWVudHMgcm91dGU1My5JQWxpYXNSZWNvcmRUYXJnZXQge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGRvbWFpbk5hbWU6IGFwaWd2Mi5JRG9tYWluTmFtZSkgeyB9XG5cbiAgcHVibGljIGJpbmQoX3JlY29yZDogcm91dGU1My5JUmVjb3JkU2V0KTogcm91dGU1My5BbGlhc1JlY29yZFRhcmdldENvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGRuc05hbWU6IHRoaXMuZG9tYWluTmFtZS5yZWdpb25hbERvbWFpbk5hbWUsXG4gICAgICBob3N0ZWRab25lSWQ6IHRoaXMuZG9tYWluTmFtZS5yZWdpb25hbEhvc3RlZFpvbmVJZCxcbiAgICB9O1xuICB9XG59XG4iXX0=