"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BucketWebsiteTarget = void 0;
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
/**
 * Use a S3 as an alias record target.
 */
class BucketWebsiteTarget {
    /**
     *
     */
    constructor(bucket) {
        this.bucket = bucket;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     */
    bind(_record) {
        const { region } = core_1.Stack.of(this.bucket.stack);
        if (core_1.Token.isUnresolved(region)) {
            throw new Error([
                'Cannot use an S3 record alias in region-agnostic stacks.',
                'You must specify a specific region when you define the stack',
                '(see https://docs.aws.amazon.com/cdk/latest/guide/environments.html)',
            ].join(' '));
        }
        const { s3StaticWebsiteHostedZoneId: hostedZoneId, s3StaticWebsiteEndpoint: dnsName } = region_info_1.RegionInfo.get(region);
        if (!hostedZoneId || !dnsName) {
            throw new Error(`Bucket website target is not supported for the "${region}" region`);
        }
        return { hostedZoneId, dnsName };
    }
}
exports.BucketWebsiteTarget = BucketWebsiteTarget;
//# sourceMappingURL=data:application/json;base64,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