"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontTarget = void 0;
const core_1 = require("@aws-cdk/core");
/**
 * Use a CloudFront Distribution as an alias record target.
 */
class CloudFrontTarget {
    /**
     *
     */
    constructor(distribution) {
        this.distribution = distribution;
    }
    /**
     * Get the hosted zone id for the current scope.
     *
     * @param scope - scope in which this resource is defined.
     */
    static getHostedZoneId(scope) {
        var _a;
        const mappingName = 'AWSCloudFrontPartitionHostedZoneIdMap';
        const scopeStack = core_1.Stack.of(scope);
        let mapping = (_a = scopeStack.node.tryFindChild(mappingName)) !== null && _a !== void 0 ? _a : new core_1.CfnMapping(scopeStack, mappingName, {
            mapping: {
                ['aws']: {
                    zoneId: 'Z2FDTNDATAQYW2',
                },
                ['aws-cn']: {
                    zoneId: 'Z3RFFRIM2A3IF5',
                },
            },
        });
        return mapping.findInMap(core_1.Aws.PARTITION, 'zoneId');
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     */
    bind(_record) {
        return {
            hostedZoneId: CloudFrontTarget.getHostedZoneId(this.distribution),
            dnsName: this.distribution.domainName,
        };
    }
}
exports.CloudFrontTarget = CloudFrontTarget;
/**
 * The hosted zone Id if using an alias record in Route53.
 *
 * This value never changes.
 */
CloudFrontTarget.CLOUDFRONT_ZONE_ID = 'Z2FDTNDATAQYW2';
//# sourceMappingURL=data:application/json;base64,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