"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolDomainTarget = void 0;
const cloudfront_target_1 = require("./cloudfront-target");
/**
 * Use a user pool domain as an alias record target.
 */
class UserPoolDomainTarget {
    /**
     *
     */
    constructor(domain) {
        this.domain = domain;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     */
    bind(_record) {
        return {
            dnsName: this.domain.cloudFrontDomainName,
            hostedZoneId: cloudfront_target_1.CloudFrontTarget.getHostedZoneId(this.domain),
        };
    }
}
exports.UserPoolDomainTarget = UserPoolDomainTarget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlcnBvb2wtZG9tYWluLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidXNlcnBvb2wtZG9tYWluLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLDJEQUF1RDs7OztBQUt2RCxNQUFhLG9CQUFvQjs7OztJQUMvQixZQUE2QixNQUFzQjtRQUF0QixXQUFNLEdBQU4sTUFBTSxDQUFnQjtJQUNuRCxDQUFDOzs7O0lBRU0sSUFBSSxDQUFDLE9BQW1CO1FBQzdCLE9BQU87WUFDTCxPQUFPLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxvQkFBb0I7WUFDekMsWUFBWSxFQUFFLG9DQUFnQixDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDO1NBQzVELENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFWRCxvREFVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFVzZXJQb29sRG9tYWluIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWNvZ25pdG8nO1xuaW1wb3J0IHsgQWxpYXNSZWNvcmRUYXJnZXRDb25maWcsIElBbGlhc1JlY29yZFRhcmdldCwgSVJlY29yZFNldCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1yb3V0ZTUzJztcbmltcG9ydCB7IENsb3VkRnJvbnRUYXJnZXQgfSBmcm9tICcuL2Nsb3VkZnJvbnQtdGFyZ2V0JztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBVc2VyUG9vbERvbWFpblRhcmdldCBpbXBsZW1lbnRzIElBbGlhc1JlY29yZFRhcmdldCB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgZG9tYWluOiBVc2VyUG9vbERvbWFpbikge1xuICB9XG5cbiAgcHVibGljIGJpbmQoX3JlY29yZDogSVJlY29yZFNldCk6IEFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgZG5zTmFtZTogdGhpcy5kb21haW4uY2xvdWRGcm9udERvbWFpbk5hbWUsXG4gICAgICBob3N0ZWRab25lSWQ6IENsb3VkRnJvbnRUYXJnZXQuZ2V0SG9zdGVkWm9uZUlkKHRoaXMuZG9tYWluKSxcbiAgICB9O1xuICB9XG59XG4iXX0=