"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClassicLoadBalancerTarget = void 0;
/**
 * Use a classic ELB as an alias record target.
 */
class ClassicLoadBalancerTarget {
    /**
     *
     */
    constructor(loadBalancer) {
        this.loadBalancer = loadBalancer;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     */
    bind(_record) {
        return {
            hostedZoneId: this.loadBalancer.loadBalancerCanonicalHostedZoneNameId,
            dnsName: `dualstack.${this.loadBalancer.loadBalancerDnsName}`,
        };
    }
}
exports.ClassicLoadBalancerTarget = ClassicLoadBalancerTarget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xhc3NpYy1sb2FkLWJhbGFuY2VyLXRhcmdldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNsYXNzaWMtbG9hZC1iYWxhbmNlci10YXJnZXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBTUEsTUFBYSx5QkFBeUI7Ozs7SUFDcEMsWUFBNkIsWUFBOEI7UUFBOUIsaUJBQVksR0FBWixZQUFZLENBQWtCO0lBQzNELENBQUM7Ozs7SUFFTSxJQUFJLENBQUMsT0FBMkI7UUFDckMsT0FBTztZQUNMLFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWSxDQUFDLHFDQUFxQztZQUNyRSxPQUFPLEVBQUUsYUFBYSxJQUFJLENBQUMsWUFBWSxDQUFDLG1CQUFtQixFQUFFO1NBQzlELENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFWRCw4REFVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVsYiBmcm9tICdAYXdzLWNkay9hd3MtZWxhc3RpY2xvYWRiYWxhbmNpbmcnO1xuaW1wb3J0ICogYXMgcm91dGU1MyBmcm9tICdAYXdzLWNkay9hd3Mtcm91dGU1Myc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIENsYXNzaWNMb2FkQmFsYW5jZXJUYXJnZXQgaW1wbGVtZW50cyByb3V0ZTUzLklBbGlhc1JlY29yZFRhcmdldCB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgbG9hZEJhbGFuY2VyOiBlbGIuTG9hZEJhbGFuY2VyKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfcmVjb3JkOiByb3V0ZTUzLklSZWNvcmRTZXQpOiByb3V0ZTUzLkFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgaG9zdGVkWm9uZUlkOiB0aGlzLmxvYWRCYWxhbmNlci5sb2FkQmFsYW5jZXJDYW5vbmljYWxIb3N0ZWRab25lTmFtZUlkLFxuICAgICAgZG5zTmFtZTogYGR1YWxzdGFjay4ke3RoaXMubG9hZEJhbGFuY2VyLmxvYWRCYWxhbmNlckRuc05hbWV9YCxcbiAgICB9O1xuICB9XG59XG4iXX0=