import * as ec2 from '@aws-cdk/aws-ec2';
import * as route53 from '@aws-cdk/aws-route53';
/**
 * Set an InterfaceVpcEndpoint as a target for an ARecord.
 */
export declare class InterfaceVpcEndpointTarget implements route53.IAliasRecordTarget {
    private readonly vpcEndpoint;
    private readonly cfnVpcEndpoint;
    /**
     *
     */
    constructor(vpcEndpoint: ec2.IInterfaceVpcEndpoint);
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     */
    bind(_record: route53.IRecordSet): route53.AliasRecordTargetConfig;
}
