import { UserPoolDomain } from '@aws-cdk/aws-cognito';
import { AliasRecordTargetConfig, IAliasRecordTarget, IRecordSet } from '@aws-cdk/aws-route53';
/**
 * Use a user pool domain as an alias record target.
 */
export declare class UserPoolDomainTarget implements IAliasRecordTarget {
    private readonly domain;
    /**
     *
     */
    constructor(domain: UserPoolDomain);
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     */
    bind(_record: IRecordSet): AliasRecordTargetConfig;
}
