# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['domainlab',
 'domainlab.algos',
 'domainlab.algos.msels',
 'domainlab.algos.observers',
 'domainlab.algos.trainers',
 'domainlab.algos.trainers.compos',
 'domainlab.compos',
 'domainlab.compos.nn_zoo',
 'domainlab.compos.pcr',
 'domainlab.compos.vae',
 'domainlab.compos.vae.compos',
 'domainlab.dsets',
 'domainlab.exp',
 'domainlab.exp_protocol',
 'domainlab.models',
 'domainlab.tasks',
 'domainlab.utils',
 'domainlab.zdata.script',
 'domainlab.zdata.ztest_files']

package_data = \
{'': ['*'],
 'domainlab': ['zdata/mixed_codec/caltech/auto/*',
               'zdata/mixed_codec/caltech/vogel/*',
               'zdata/mixed_codec/sun/sofa/*',
               'zdata/mixed_codec/sun/vehicle/*',
               'zdata/pacs_mini_10/*',
               'zdata/pacs_mini_10/art_painting/dog/*',
               'zdata/pacs_mini_10/art_painting/elephant/*',
               'zdata/pacs_mini_10/art_painting/giraffe/*',
               'zdata/pacs_mini_10/art_painting/guitar/*',
               'zdata/pacs_mini_10/art_painting/horse/*',
               'zdata/pacs_mini_10/art_painting/person/*',
               'zdata/pacs_mini_10/cartoon/dog/*',
               'zdata/pacs_mini_10/cartoon/elephant/*',
               'zdata/pacs_mini_10/cartoon/giraffe/*',
               'zdata/pacs_mini_10/cartoon/horse/*',
               'zdata/pacs_mini_10/cartoon/house/*',
               'zdata/pacs_mini_10/cartoon/person/*',
               'zdata/pacs_mini_10/photo/dog/*',
               'zdata/pacs_mini_10/photo/elephant/*',
               'zdata/pacs_mini_10/photo/guitar/*',
               'zdata/pacs_mini_10/photo/horse/*',
               'zdata/pacs_mini_10/photo/house/*',
               'zdata/pacs_mini_10/photo/person/*',
               'zdata/pacs_mini_10/sketch/dog/*',
               'zdata/pacs_mini_10/sketch/elephant/*',
               'zdata/pacs_mini_10/sketch/giraffe/*',
               'zdata/pacs_mini_10/sketch/guitar/*',
               'zdata/pacs_mini_10/sketch/horse/*',
               'zdata/pacs_mini_10/sketch/house/*',
               'zdata/pacs_split/*',
               'zdata/patches_permutation4jigsaw/*',
               'zdata/vlcs_mini/caltech/auto/*',
               'zdata/vlcs_mini/caltech/hund/*',
               'zdata/vlcs_mini/caltech/mensch/*',
               'zdata/vlcs_mini/caltech/stuhl/*',
               'zdata/vlcs_mini/caltech/vogel/*',
               'zdata/vlcs_mini/labelme/bird/*',
               'zdata/vlcs_mini/labelme/drive/*',
               'zdata/vlcs_mini/labelme/husky/*',
               'zdata/vlcs_mini/labelme/sit/*',
               'zdata/vlcs_mini/sun/dog/*',
               'zdata/vlcs_mini/sun/flying/*',
               'zdata/vlcs_mini/sun/sapiens/*',
               'zdata/vlcs_mini/sun/sofa/*',
               'zdata/vlcs_mini/sun/vehicle/*']}

install_requires = \
['gdown>=4.7.1,<5.0.0',
 'matplotlib>=3.6.1,<4.0.0',
 'numpy>=1.23.4,<2.0.0',
 'pandas>=1.5.1,<2.0.0',
 'pillow>=9.3.0,<10.0.0',
 'pyyaml>=6.0,<7.0',
 'rich>=13.3.1,<14.0.0',
 'scikit-learn>=1.2.1,<2.0.0',
 'seaborn==0.12.2',
 'torch>=1.12.0,<2.0.0',
 'torchmetrics>=0.10.0,<0.11.0',
 'torchvision>=0.13.0,<0.14.0']

setup_kwargs = {
    'name': 'domainlab',
    'version': '0.2.0',
    'description': 'Library of Domain Generalization',
    'long_description': 'None',
    'author': 'Xudong Sun',
    'author_email': 'smilesun.east@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
