
__all__ = ('MA_RESULT_STR', 'MiniaudioError')


MA_RESULT_STR = dict([
    (0, 'MA_SUCCESS'),
    (-1, 'MA_ERROR'),
    (-2, 'MA_INVALID_ARGS'),
    (-3, 'MA_INVALID_OPERATION'),
    (-4, 'MA_OUT_OF_MEMORY'),
    (-5, 'MA_OUT_OF_RANGE'),
    (-6, 'MA_ACCESS_DENIED'),
    (-7, 'MA_DOES_NOT_EXIST'),
    (-8, 'MA_ALREADY_EXISTS'),
    (-9, 'MA_TOO_MANY_OPEN_FILES'),
    (-10, 'MA_INVALID_FILE'),
    (-11, 'MA_TOO_BIG'),
    (-12, 'MA_PATH_TOO_LONG'),
    (-13, 'MA_NAME_TOO_LONG'),
    (-14, 'MA_NOT_DIRECTORY'),
    (-15, 'MA_IS_DIRECTORY'),
    (-16, 'MA_DIRECTORY_NOT_EMPTY'),
    (-17, 'MA_END_OF_FILE'),
    (-18, 'MA_NO_SPACE'),
    (-19, 'MA_BUSY'),
    (-20, 'MA_IO_ERROR'),
    (-21, 'MA_INTERRUPT'),
    (-22, 'MA_UNAVAILABLE'),
    (-23, 'MA_ALREADY_IN_USE'),
    (-24, 'MA_BAD_ADDRESS'),
    (-25, 'MA_BAD_SEEK'),
    (-26, 'MA_BAD_PIPE'),
    (-27, 'MA_DEADLOCK'),
    (-28, 'MA_TOO_MANY_LINKS'),
    (-29, 'MA_NOT_IMPLEMENTED'),
    (-30, 'MA_NO_MESSAGE'),
    (-31, 'MA_BAD_MESSAGE'),
    (-32, 'MA_NO_DATA_AVAILABLE'),
    (-33, 'MA_INVALID_DATA'),
    (-34, 'MA_TIMEOUT'),
    (-35, 'MA_NO_NETWORK'),
    (-36, 'MA_NOT_UNIQUE'),
    (-37, 'MA_NOT_SOCKET'),
    (-38, 'MA_NO_ADDRESS'),
    (-39, 'MA_BAD_PROTOCOL'),
    (-40, 'MA_PROTOCOL_UNAVAILABLE'),
    (-41, 'MA_PROTOCOL_NOT_SUPPORTED'),
    (-42, 'MA_PROTOCOL_FAMILY_NOT_SUPPORTED'),
    (-43, 'MA_ADDRESS_FAMILY_NOT_SUPPORTED'),
    (-44, 'MA_SOCKET_NOT_SUPPORTED'),
    (-45, 'MA_CONNECTION_RESET'),
    (-46, 'MA_ALREADY_CONNECTED'),
    (-47, 'MA_NOT_CONNECTED'),
    (-48, 'MA_CONNECTION_REFUSED'),
    (-49, 'MA_NO_HOST'),
    (-50, 'MA_IN_PROGRESS'),
    (-51, 'MA_CANCELLED'),
    (-52, 'MA_MEMORY_ALREADY_MAPPED'),
    (-53, 'MA_AT_END'),
    (-100, 'MA_FORMAT_NOT_SUPPORTED'),
    (-101, 'MA_DEVICE_TYPE_NOT_SUPPORTED'),
    (-102, 'MA_SHARE_MODE_NOT_SUPPORTED'),
    (-103, 'MA_NO_BACKEND'),
    (-104, 'MA_NO_DEVICE'),
    (-105, 'MA_API_NOT_FOUND'),
    (-106, 'MA_INVALID_DEVICE_CONFIG'),
    (-107, 'MA_LOOP'),
    (-200, 'MA_DEVICE_NOT_INITIALIZED'),
    (-201, 'MA_DEVICE_ALREADY_INITIALIZED'),
    (-202, 'MA_DEVICE_NOT_STARTED'),
    (-203, 'MA_DEVICE_NOT_STOPPED'),
    (-300, 'MA_FAILED_TO_INIT_BACKEND'),
    (-301, 'MA_FAILED_TO_OPEN_BACKEND_DEVICE'),
    (-302, 'MA_FAILED_TO_START_BACKEND_DEVICE'),
    (-303, 'MA_FAILED_TO_STOP_BACKEND_DEVICE')
])


class MiniaudioError(Exception):
    def __init__(self, *args: object) -> None:
        if args:
            self.message = args[0]
        
        else:
            self.message = None
    
    def __str__(self) -> str:
        return self.message if self.message else 'UNKNOWN MA_ERROR'