"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToSagemakerEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
/**
 * @summary The LambdaToSagemakerEndpoint class.
 */
class LambdaToSagemakerEndpoint extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToSagemakerEndpoint class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a scope-unique id.
     * @param {LambdaToSagemakerEndpointProps} props - user provided props for the construct.
     * @since 1.87.1
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckVpcProps(props);
        defaults.CheckLambdaProps(props);
        defaults.CheckSagemakerProps(props);
        if (props.deployVpc || props.existingVpc) {
            // create the VPC
            this.vpc = defaults.buildVpc(scope, {
                defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
                existingVpc: props.existingVpc,
                userVpcProps: props.vpcProps,
                constructVpcProps: {
                    enableDnsHostnames: true,
                    enableDnsSupport: true,
                },
            });
            // Add S3 VPC Gateway Endpoint, required by SageMaker to access Models artifacts via AWS private network
            defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.S3);
            // Add SAGEMAKER_RUNTIME VPC Interface Endpoint, required by the lambda function to invoke the SageMaker endpoint
            defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.SAGEMAKER_RUNTIME);
        }
        // Build SageMaker Endpoint (inclduing SageMaker's Endpoint Configuration and Model)
        const buildSagemakerEndpointResponse = defaults.BuildSagemakerEndpoint(this, id, {
            ...props,
            vpc: this.vpc,
        });
        this.sagemakerEndpoint = buildSagemakerEndpointResponse.endpoint;
        this.sagemakerEndpointConfig = buildSagemakerEndpointResponse.endpointConfig;
        this.sagemakerModel = buildSagemakerEndpointResponse.model;
        // Setup the Lambda function
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            vpc: this.vpc,
        });
        // Configure environment variables
        const sagemakerEnvironmentVariableName = props.sagemakerEnvironmentVariableName || 'SAGEMAKER_ENDPOINT_NAME';
        this.lambdaFunction.addEnvironment(sagemakerEnvironmentVariableName, this.sagemakerEndpoint.attrEndpointName);
        // Add permission to invoke the SageMaker endpoint
        this.lambdaFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['sagemaker:InvokeEndpoint'],
            resources: [this.sagemakerEndpoint.ref],
        }));
    }
}
exports.LambdaToSagemakerEndpoint = LambdaToSagemakerEndpoint;
_a = JSII_RTTI_SYMBOL_1;
LambdaToSagemakerEndpoint[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-sagemakerendpoint.LambdaToSagemakerEndpoint", version: "2.85.6" };
//# sourceMappingURL=data:application/json;base64,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