"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const defaults = require("@aws-solutions-constructs/core");
const lambda = require("aws-cdk-lib/aws-lambda");
const test_helper_1 = require("./test-helper");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, (0, core_1.generateIntegStackName)(__filename));
stack.templateOptions.description = 'Integration Test for aws-lambda-sagemakerendpoint';
// deploy lambda function
const fn = defaults.deployLambdaFunction(stack, {
    runtime: lambda.Runtime.PYTHON_3_8,
    code: lambda.Code.fromAsset(`${__dirname}/lambda`),
    handler: 'index.handler',
    timeout: aws_cdk_lib_1.Duration.minutes(5),
    memorySize: 128,
});
const getSagemakerModelResponse = (0, test_helper_1.getSagemakerModel)(stack);
const constructProps = {
    modelProps: {
        primaryContainer: {
            image: getSagemakerModelResponse.mapping.findInMap(aws_cdk_lib_1.Stack.of(stack).region, "containerArn"),
            modelDataUrl: getSagemakerModelResponse.asset.s3ObjectUrl
        },
    },
    existingLambdaObj: fn,
};
//   Fix names and construct IDs
const lambdaToSagemakerConstruct = new lib_1.LambdaToSagemakerEndpoint(stack, 'test-lambda-sagemaker', constructProps);
lambdaToSagemakerConstruct.node.addDependency(getSagemakerModelResponse.asset);
// Synth
new integ_tests_alpha_1.IntegTest(stack, 'Integ', { testCases: [
        stack
    ] });
//# sourceMappingURL=data:application/json;base64,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