"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const defaults = require("@aws-solutions-constructs/core");
const lambda = require("aws-cdk-lib/aws-lambda");
const test_helper_1 = require("./test-helper");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, (0, core_1.generateIntegStackName)(__filename));
stack.templateOptions.description = 'Integration Test for aws-lambda-sagemakerendpoint';
const getSagemakerModelResponse = (0, test_helper_1.getSagemakerModel)(stack);
const deploySagemakerEndpointResponse = defaults.deploySagemakerEndpoint(stack, 'test', {
    modelProps: {
        primaryContainer: {
            image: getSagemakerModelResponse.mapping.findInMap(aws_cdk_lib_1.Stack.of(stack).region, "containerArn"),
            modelDataUrl: getSagemakerModelResponse.asset.s3ObjectUrl
        },
    },
});
deploySagemakerEndpointResponse.endpoint.node.addDependency(getSagemakerModelResponse.asset);
deploySagemakerEndpointResponse.endpointConfig?.node.addDependency(getSagemakerModelResponse.asset);
deploySagemakerEndpointResponse.model?.node.addDependency(getSagemakerModelResponse.asset);
const constructProps = {
    existingSagemakerEndpointObj: deploySagemakerEndpointResponse.endpoint,
    lambdaFunctionProps: {
        runtime: lambda.Runtime.PYTHON_3_8,
        code: lambda.Code.fromAsset(`${__dirname}/lambda`),
        handler: 'index.handler',
        timeout: aws_cdk_lib_1.Duration.minutes(5),
        memorySize: 128,
    },
};
const lambdaToSagemakerConstruct = new lib_1.LambdaToSagemakerEndpoint(stack, 'test-lambda-sagemaker', constructProps);
lambdaToSagemakerConstruct.node.addDependency(getSagemakerModelResponse.asset);
// Synth
new integ_tests_alpha_1.IntegTest(stack, 'Integ', { testCases: [
        stack
    ] });
//# sourceMappingURL=data:application/json;base64,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