"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSagemakerModel = getSagemakerModel;
const s3a = require("aws-cdk-lib/aws-s3-assets");
const aws_cdk_lib_1 = require("aws-cdk-lib");
// linear learner ECR images can be found here:
// https://github.com/awsdocs/amazon-sagemaker-developer-guide/blob/master/doc_source/sagemaker-algo-docker-registry-paths.md
function getSagemakerModel(stack) {
    const containerMap = new aws_cdk_lib_1.CfnMapping(stack, 'mappings', {
        mapping: {
            "us-east-1": {
                containerArn: "382416733822.dkr.ecr.us-east-1.amazonaws.com/linear-learner:latest",
            },
            "us-east-2": {
                containerArn: "404615174143.dkr.ecr.us-east-2.amazonaws.com/linear-learner:latest",
            },
            "us-west-1": {
                containerArn: "632365934929.dkr.ecr.us-west-1.amazonaws.com/linear-learner:latest",
            },
            "us-west-2": {
                containerArn: "174872318107.dkr.ecr.us-west-2.amazonaws.com/linear-learner:latest",
            },
            "af-south-1": {
                containerArn: "455444449433.dkr.ecr.af-south-1.amazonaws.com/linear-learner:latest",
            },
            "ap-east-1": {
                containerArn: "286214385809.dkr.ecr.ap-east-1.amazonaws.com/linear-learner:latest",
            },
            "ap-south-1": {
                containerArn: "991648021394.dkr.ecr.ap-south-1.amazonaws.com/linear-learner:latest",
            },
            "ap-northeast-2": {
                containerArn: "835164637446.dkr.ecr.ap-northeast-2.amazonaws.com/linear-learner:latest",
            },
            "ap-southeast-1": {
                containerArn: "475088953585.dkr.ecr.ap-southeast-1.amazonaws.com/linear-learner:latest",
            },
            "ap-southeast-2": {
                containerArn: "712309505854.dkr.ecr.ap-southeast-2.amazonaws.com/linear-learner:latest",
            },
            "ap-northeast-1": {
                containerArn: "351501993468.dkr.ecr.ap-northeast-1.amazonaws.com/linear-learner:latest",
            },
            "ca-central-1": {
                containerArn: "469771592824.dkr.ecr.ca-central-1.amazonaws.com/linear-learner:latest",
            },
            "eu-central-1": {
                containerArn: "664544806723.dkr.ecr.eu-central-1.amazonaws.com/linear-learner:latest",
            },
            "eu-west-1": {
                containerArn: "438346466558.dkr.ecr.eu-west-1.amazonaws.com/linear-learner:latest",
            },
            "eu-west-2": {
                containerArn: "644912444149.dkr.ecr.eu-west-2.amazonaws.com/linear-learner:latest",
            },
            "eu-west-3": {
                containerArn: "749696950732.dkr.ecr.eu-west-3.amazonaws.com/linear-learner:latest",
            },
            "eu-north-1": {
                containerArn: "669576153137.dkr.ecr.eu-north-1.amazonaws.com/linear-learner:latest",
            },
            "eu-south-1": {
                containerArn: "257386234256.dkr.ecr.eu-south-1.amazonaws.com/linear-learner:latest",
            },
            "me-south-1": {
                containerArn: "249704162688.dkr.ecr.me-south-1.amazonaws.com/linear-learner:latest",
            },
            "sa-east-1": {
                containerArn: "855470959533.dkr.ecr.sa-east-1.amazonaws.com/linear-learner:latest",
            },
            "us-gov-west-1": {
                containerArn: "226302683700.dkr.ecr.us-gov-west-1.amazonaws.com/linear-learner:latest",
            },
        }
    });
    const modelAsset = new s3a.Asset(stack, 'SampleAsset', {
        path: 'model/model.tar.gz',
    });
    return { mapping: containerMap, asset: modelAsset };
}
//# sourceMappingURL=data:application/json;base64,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