#pragma once

#include <TH/TH.h>
#include <THNN/THNN.h>
#undef THNN_
#include <THS/THS.h>

#include "ATen/Tensor.h"
#include "ATen/TensorImpl.h"
#include "ATen/Context.h"
#include "ATen/TensorMethods.h"

namespace at {

struct CPUByteTensor final : public TensorImpl {
public:
  explicit CPUByteTensor(Context* context);
  CPUByteTensor(Context* context, THByteTensor * tensor);
  virtual ~CPUByteTensor();
  virtual const char * toString() const override;
  virtual IntList sizes() const override;
  virtual IntList strides() const override;
  virtual int64_t dim() const override;
  virtual Scalar localScalar() override;
  virtual void assign_(Scalar s) override;
  virtual void * unsafeGetTH(bool retain) override;
  static const char * typeString();

//TODO(zach): sort of friend permissions later so this
// can be protected
public:
  THByteTensor * tensor;
  Context* context;
  friend struct CPUByteType;
};

} // namespace at
