#pragma once
#include "ATen/Type.h"
#include "ATen/Context.h"
#include "ATen/TensorMethods.h"
#include "ATen/CheckGenerator.h"

#ifdef _MSC_VER
#ifdef Type
#undef Type
#endif
#endif

namespace at {

struct CPUDoubleType final : public Type {
  explicit CPUDoubleType(Context* context);
  virtual ScalarType scalarType() const override;
  virtual Backend backend() const override;
  virtual bool isCuda() const override;
  virtual bool isSparse() const override;
  virtual bool isDistributed() const override;
  virtual std::unique_ptr<Storage> storage() const override;
  virtual std::unique_ptr<Storage> storage(size_t size) const override;
  virtual std::unique_ptr<Storage> storageFromBlob(void * data, int64_t size, const std::function<void(void*)> & deleter) const override;
  virtual std::unique_ptr<Generator> generator() const override;
  virtual const char * toString() const override;
  virtual std::size_t elementSizeInBytes() const override;
  virtual TypeID ID() const override;
  static const char * typeString();
  Tensor unsafeTensorFromTH(void * th_pointer, bool retain) const override;

  // example
  // virtual Tensor * add(Tensor & a, Tensor & b) override;

  virtual void s_copy(const Tensor & src, Tensor & dst) const override;
  virtual int64_t m_storage_offset(const Tensor & self) const override;
  virtual Tensor & m_resize_(Tensor & self, IntList size) const override;
  virtual Tensor & zeros_out(Tensor & result, IntList size) const override;
  virtual Tensor zeros(IntList size) const override;
  virtual Tensor & zeros_like_out(Tensor & result, const Tensor & input) const override;
  virtual Tensor zeros_like(const Tensor & input) const override;
  virtual Tensor & ones_out(Tensor & result, IntList size) const override;
  virtual Tensor ones(IntList size) const override;
  virtual Tensor & ones_like_out(Tensor & result, const Tensor & input) const override;
  virtual Tensor ones_like(const Tensor & input) const override;
  virtual int64_t numel(const Tensor & self) const override;
  virtual Tensor & m_set_(Tensor & self, Storage & storage) const override;
  virtual Tensor & m_set_(Tensor & self, Storage & sourceStorage, int64_t storage_offset, IntList size, IntList stride) const override;
  virtual Tensor & m_set_(Tensor & self, const Tensor & source) const override;
  virtual Tensor & m_set_(Tensor & self) const override;
  virtual Tensor & m_fill_(Tensor & self, Scalar value) const override;
  virtual bool m_is_contiguous(const Tensor & self) const override;
  virtual bool m_is_set_to(const Tensor & self, const Tensor & tensor) const override;
  virtual Tensor & s_m_masked_fill_(Tensor & self, const Tensor & mask, Scalar value) const override;
  virtual Tensor & s_m_masked_scatter_(Tensor & self, const Tensor & mask, const Tensor & source) const override;
  virtual Tensor & s_masked_select_out(Tensor & result, const Tensor & self, const Tensor & mask) const override;
  virtual Tensor s_masked_select(const Tensor & self, const Tensor & mask) const override;
  virtual Tensor transpose(const Tensor & self, int64_t dim0, int64_t dim1) const override;
  virtual Tensor & m_transpose_(Tensor & self, int64_t dim0, int64_t dim1) const override;
  virtual Tensor t(const Tensor & self) const override;
  virtual Tensor & m_t_(Tensor & self) const override;
  virtual Tensor & squeeze_out(Tensor & result, const Tensor & self, int64_t dim) const override;
  virtual Tensor squeeze(const Tensor & self, int64_t dim) const override;
  virtual Tensor & squeeze_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor squeeze(const Tensor & self) const override;
  virtual Tensor & m_squeeze_(Tensor & self, int64_t dim) const override;
  virtual Tensor & m_squeeze_(Tensor & self) const override;
  virtual Tensor & unsqueeze_out(Tensor & result, const Tensor & self, int64_t dim) const override;
  virtual Tensor unsqueeze(const Tensor & self, int64_t dim) const override;
  virtual Tensor & m_unsqueeze_(Tensor & self, int64_t dim) const override;
  virtual Tensor & nonzero_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor nonzero(const Tensor & self) const override;
  virtual Tensor m_contiguous(const Tensor & self) const override;
  virtual Tensor m_clone(const Tensor & self) const override;
  virtual Tensor m_view(const Tensor & self, IntList size) const override;
  virtual Tensor m_expand(const Tensor & self, IntList size) const override;
  virtual Tensor & m_resize_as_(Tensor & self, const Tensor & the_template) const override;
  virtual Tensor & index_select_out(Tensor & result, const Tensor & self, int64_t dim, const Tensor & index) const override;
  virtual Tensor index_select(const Tensor & self, int64_t dim, const Tensor & index) const override;
  virtual Tensor & m_index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const override;
  virtual Tensor & take_out(Tensor & result, const Tensor & self, const Tensor & index) const override;
  virtual Tensor take(const Tensor & self, const Tensor & index) const override;
  virtual Tensor & m_put_(Tensor & self, const Tensor & index, const Tensor & source, bool accumulate) const override;
  virtual Tensor & m_index_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const override;
  virtual Tensor & m_index_fill_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const override;
  virtual Tensor m_narrow(const Tensor & self, int64_t dimension, int64_t start, int64_t length) const override;
  virtual Tensor m_unfold(const Tensor & self, int64_t dimension, int64_t size, int64_t step) const override;
  virtual Tensor & range_out(Tensor & result, Scalar start, Scalar end, Scalar step) const override;
  virtual Tensor range(Scalar start, Scalar end, Scalar step) const override;
  virtual Tensor & arange_out(Tensor & result, Scalar start, Scalar end, Scalar step) const override;
  virtual Tensor arange(Scalar start, Scalar end, Scalar step) const override;
  virtual Tensor & arange_out(Tensor & result, Scalar end) const override;
  virtual Tensor arange(Scalar end) const override;
  virtual Tensor & m_scatter_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const override;
  virtual Tensor & m_scatter_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const override;
  virtual Tensor & m_scatter_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const override;
  virtual Tensor & gather_out(Tensor & result, const Tensor & self, int64_t dim, const Tensor & index) const override;
  virtual Tensor gather(const Tensor & self, int64_t dim, const Tensor & index) const override;
  virtual void* m_data_ptr(const Tensor & self) const override;
  virtual bool equal(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __and___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __and__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___and___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___and__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __iand__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___iand__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & __or___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __or__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___or___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___or__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __ior__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___ior__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & __xor___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __xor__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___xor___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___xor__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __ixor__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___ixor__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & __lshift___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __lshift__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___lshift___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___lshift__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __ilshift__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___ilshift__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & __rshift___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __rshift__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___rshift___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___rshift__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __irshift__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___irshift__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & lt_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor lt(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_lt_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_lt(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_lt_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_lt_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & gt_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor gt(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_gt_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_gt(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_gt_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_gt_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & le_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor le(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_le_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_le(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_le_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_le_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & ge_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor ge(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_ge_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_ge(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_ge_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_ge_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & eq_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor eq(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_eq_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_eq(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_eq_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_eq_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & ne_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor ne(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_ne_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_ne(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_ne_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_ne_(Tensor & self, const Tensor & other) const override;
  virtual std::tuple<Tensor &,Tensor &> min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor,Tensor> min(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor & s_min_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_min(const Tensor & self, const Tensor & other) const override;
  virtual Scalar min(const Tensor & self) const override;
  virtual std::tuple<Tensor &,Tensor &> max_out(Tensor & max, Tensor & max_indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor,Tensor> max(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor & s_max_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_max(const Tensor & self, const Tensor & other) const override;
  virtual Scalar max(const Tensor & self) const override;
  virtual std::tuple<Tensor &,Tensor &> kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor,Tensor> kthvalue(const Tensor & self, int64_t k, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor &,Tensor &> mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor,Tensor> mode(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor &,Tensor &> median_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor,Tensor> median(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Scalar median(const Tensor & self) const override;
  virtual std::tuple<Tensor &,Tensor &> sort_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool descending) const override;
  virtual std::tuple<Tensor,Tensor> sort(const Tensor & self, int64_t dim, bool descending) const override;
  virtual std::tuple<Tensor &,Tensor &> topk_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const override;
  virtual std::tuple<Tensor,Tensor> topk(const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const override;
  virtual Tensor & abs_out(Tensor & destination, const Tensor & self) const override;
  virtual Tensor abs(const Tensor & self) const override;
  virtual Tensor & m_abs_(Tensor & self) const override;
  virtual Tensor & m_sigmoid_(Tensor & self) const override;
  virtual Tensor & sigmoid_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor sigmoid(const Tensor & self) const override;
  virtual Tensor & m_log_(Tensor & self) const override;
  virtual Tensor & log_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor log(const Tensor & self) const override;
  virtual Tensor & m_log1p_(Tensor & self) const override;
  virtual Tensor & log1p_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor log1p(const Tensor & self) const override;
  virtual Tensor & lgamma_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor lgamma(const Tensor & self) const override;
  virtual Tensor & m_lgamma_(Tensor & self) const override;
  virtual Tensor & m_exp_(Tensor & self) const override;
  virtual Tensor & exp_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor exp(const Tensor & self) const override;
  virtual Tensor & m_cos_(Tensor & self) const override;
  virtual Tensor & cos_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor cos(const Tensor & self) const override;
  virtual Tensor & m_acos_(Tensor & self) const override;
  virtual Tensor & acos_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor acos(const Tensor & self) const override;
  virtual Tensor & m_cosh_(Tensor & self) const override;
  virtual Tensor & cosh_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor cosh(const Tensor & self) const override;
  virtual Tensor & m_sin_(Tensor & self) const override;
  virtual Tensor & sin_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor sin(const Tensor & self) const override;
  virtual Tensor & m_asin_(Tensor & self) const override;
  virtual Tensor & asin_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor asin(const Tensor & self) const override;
  virtual Tensor & m_sinh_(Tensor & self) const override;
  virtual Tensor & sinh_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor sinh(const Tensor & self) const override;
  virtual Tensor & m_tan_(Tensor & self) const override;
  virtual Tensor & tan_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor tan(const Tensor & self) const override;
  virtual Tensor & m_atan_(Tensor & self) const override;
  virtual Tensor & atan_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor atan(const Tensor & self) const override;
  virtual Tensor & m_tanh_(Tensor & self) const override;
  virtual Tensor & tanh_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor tanh(const Tensor & self) const override;
  virtual Tensor & m_erf_(Tensor & self) const override;
  virtual Tensor & erf_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor erf(const Tensor & self) const override;
  virtual Tensor & m_erfinv_(Tensor & self) const override;
  virtual Tensor & erfinv_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor erfinv(const Tensor & self) const override;
  virtual Tensor & m_sqrt_(Tensor & self) const override;
  virtual Tensor & sqrt_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor sqrt(const Tensor & self) const override;
  virtual Tensor & m_rsqrt_(Tensor & self) const override;
  virtual Tensor & rsqrt_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor rsqrt(const Tensor & self) const override;
  virtual Tensor & m_ceil_(Tensor & self) const override;
  virtual Tensor & ceil_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor ceil(const Tensor & self) const override;
  virtual Tensor & m_floor_(Tensor & self) const override;
  virtual Tensor & floor_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor floor(const Tensor & self) const override;
  virtual Tensor & m_round_(Tensor & self) const override;
  virtual Tensor & round_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor round(const Tensor & self) const override;
  virtual Tensor & m_trunc_(Tensor & self) const override;
  virtual Tensor & trunc_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor trunc(const Tensor & self) const override;
  virtual Tensor & m_frac_(Tensor & self) const override;
  virtual Tensor & frac_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor frac(const Tensor & self) const override;
  virtual Tensor & mean_out(Tensor & destination, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor mean(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Scalar mean(const Tensor & self) const override;
  virtual Tensor & var_out(Tensor & destination, const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  virtual Tensor var(const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  virtual Scalar var(const Tensor & self, bool unbiased) const override;
  virtual Tensor & std_out(Tensor & destination, const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  virtual Tensor std(const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  virtual Scalar std(const Tensor & self, bool unbiased) const override;
  virtual Tensor & norm_out(Tensor & destination, const Tensor & self, Scalar p, int64_t dim, bool keepdim) const override;
  virtual Tensor norm(const Tensor & self, Scalar p, int64_t dim, bool keepdim) const override;
  virtual Scalar norm(const Tensor & self, Scalar p) const override;
  virtual Tensor & renorm_out(Tensor & destination, const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  virtual Tensor renorm(const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  virtual Tensor & m_renorm_(Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  virtual Scalar s_dist(const Tensor & self, const Tensor & other, Scalar p) const override;
  virtual Tensor & reciprocal_out(Tensor & destination, const Tensor & self) const override;
  virtual Tensor reciprocal(const Tensor & self) const override;
  virtual Tensor & m_reciprocal_(Tensor & self) const override;
  virtual Tensor & neg_out(Tensor & destination, const Tensor & self) const override;
  virtual Tensor neg(const Tensor & self) const override;
  virtual Tensor & m_neg_(Tensor & self) const override;
  virtual Tensor & s_atan2_out(Tensor & destination, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_atan2(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & s_m_atan2_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & pow_out(Tensor & destination, const Tensor & self, Scalar exponent) const override;
  virtual Tensor pow(const Tensor & self, Scalar exponent) const override;
  virtual Tensor & s_pow_out(Tensor & destination, const Tensor & self, const Tensor & exponent) const override;
  virtual Tensor s_pow(const Tensor & self, const Tensor & exponent) const override;
  virtual Tensor & m_pow_(Tensor & self, Scalar exponent) const override;
  virtual Tensor & s_m_pow_(Tensor & self, const Tensor & exponent) const override;
  virtual Tensor & s_lerp_out(Tensor & destination, const Tensor & self, const Tensor & end, Scalar weight) const override;
  virtual Tensor s_lerp(const Tensor & self, const Tensor & end, Scalar weight) const override;
  virtual Tensor & s_m_lerp_(Tensor & self, const Tensor & end, Scalar weight) const override;
  virtual Tensor & linspace_out(Tensor & result, Scalar start, Scalar end, int64_t steps) const override;
  virtual Tensor linspace(Scalar start, Scalar end, int64_t steps) const override;
  virtual Tensor & logspace_out(Tensor & result, Scalar start, Scalar end, int64_t steps) const override;
  virtual Tensor logspace(Scalar start, Scalar end, int64_t steps) const override;
  virtual Tensor & histc_out(Tensor & destination, const Tensor & self, int64_t bins, Scalar min, Scalar max) const override;
  virtual Tensor histc(const Tensor & self, int64_t bins, Scalar min, Scalar max) const override;
  virtual Tensor & m_zero_(Tensor & self) const override;
  virtual Tensor & sum_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor sum(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Scalar sum(const Tensor & self) const override;
  virtual Tensor & prod_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor prod(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Scalar prod(const Tensor & self) const override;
  virtual Tensor & cumsum_out(Tensor & result, const Tensor & self, int64_t dim) const override;
  virtual Tensor cumsum(const Tensor & self, int64_t dim) const override;
  virtual Tensor & cumprod_out(Tensor & result, const Tensor & self, int64_t dim) const override;
  virtual Tensor cumprod(const Tensor & self, int64_t dim) const override;
  virtual Tensor & sign_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor sign(const Tensor & self) const override;
  virtual Tensor & m_sign_(Tensor & self) const override;
  virtual Scalar trace(const Tensor & self) const override;
  virtual Tensor & add_out(Tensor & result, const Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor add(const Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor & s_add_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor s_add(const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & add_out(Tensor & result, const Tensor & self, SparseTensor other, Scalar alpha) const override;
  virtual Tensor add(const Tensor & self, SparseTensor other, Scalar alpha) const override;
  virtual Tensor & m_add_(Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor & s_m_add_(Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & m_add_(Tensor & self, SparseTensor other, Scalar alpha) const override;
  virtual Tensor & sub_out(Tensor & result, const Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor sub(const Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor & s_sub_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor s_sub(const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & m_sub_(Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor & s_m_sub_(Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & mul_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor mul(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_mul_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_mul(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_mul_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_mul_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & div_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor div(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_div_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_div(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_div_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_div_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & fmod_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor fmod(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_fmod_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_fmod(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_fmod_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_fmod_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & remainder_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor remainder(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_remainder_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_remainder(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_remainder_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_remainder_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & clamp_out(Tensor & destination, const Tensor & self, Scalar min, Scalar max) const override;
  virtual Tensor clamp(const Tensor & self, Scalar min, Scalar max) const override;
  virtual Tensor & clamp_out(Tensor & result, const Tensor & self, Scalar min) const override;
  virtual Tensor clamp(const Tensor & self, Scalar min) const override;
  virtual Tensor & m_clamp_(Tensor & self, Scalar min, Scalar max) const override;
  virtual Tensor & m_clamp_(Tensor & self, Scalar min) const override;
  virtual Scalar dot(const Tensor & self, const Tensor & tensor) const override;
  virtual Tensor & tril_out(Tensor & destination, const Tensor & self, int64_t diagonal) const override;
  virtual Tensor tril(const Tensor & self, int64_t diagonal) const override;
  virtual Tensor & m_tril_(Tensor & self, int64_t diagonal) const override;
  virtual Tensor & triu_out(Tensor & destination, const Tensor & self, int64_t diagonal) const override;
  virtual Tensor triu(const Tensor & self, int64_t diagonal) const override;
  virtual Tensor & m_triu_(Tensor & self, int64_t diagonal) const override;
  virtual Tensor & cross_out(Tensor & destination, const Tensor & self, const Tensor & other, int64_t dim) const override;
  virtual Tensor cross(const Tensor & self, const Tensor & other, int64_t dim) const override;
  virtual Tensor & eye_out(Tensor & result, int64_t n, int64_t m) const override;
  virtual Tensor eye(int64_t n, int64_t m) const override;
  virtual Tensor & diag_out(Tensor & result, const Tensor & self, int64_t diagonal) const override;
  virtual Tensor diag(const Tensor & self, int64_t diagonal) const override;
  virtual Tensor & s_addmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  virtual Tensor s_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & m_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & s_addmv_out(Tensor & result, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  virtual Tensor s_addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  virtual Tensor & m_addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  virtual Tensor & s_addr_out(Tensor & result, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  virtual Tensor s_addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & m_addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & ger_out(Tensor & result, const Tensor & self, const Tensor & vec2) const override;
  virtual Tensor ger(const Tensor & self, const Tensor & vec2) const override;
  virtual Tensor & mv_out(Tensor & result, const Tensor & self, const Tensor & vec) const override;
  virtual Tensor mv(const Tensor & self, const Tensor & vec) const override;
  virtual Tensor & mm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const override;
  virtual Tensor mm(const Tensor & self, const Tensor & mat2) const override;
  virtual Tensor & bmm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const override;
  virtual Tensor bmm(const Tensor & self, const Tensor & mat2) const override;
  virtual Tensor & s_addbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor s_addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & m_addbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & s_baddbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor s_baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & m_baddbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & s_addcmul_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor s_addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor & s_m_addcmul_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor & s_addcdiv_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor s_addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor & s_m_addcdiv_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual std::tuple<Tensor &,Tensor &> gesv_out(Tensor & solution, Tensor & lu, const Tensor & self, const Tensor & A) const override;
  virtual std::tuple<Tensor,Tensor> gesv(const Tensor & self, const Tensor & A) const override;
  virtual std::tuple<Tensor &,Tensor &> gels_out(Tensor & res1, Tensor & res2, const Tensor & self, const Tensor & A) const override;
  virtual std::tuple<Tensor,Tensor> gels(const Tensor & self, const Tensor & A) const override;
  virtual std::tuple<Tensor &,Tensor &> trtrs_out(Tensor & res1, Tensor & res2, const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular) const override;
  virtual std::tuple<Tensor,Tensor> trtrs(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular) const override;
  virtual std::tuple<Tensor &,Tensor &> symeig_out(Tensor & res1, Tensor & res2, const Tensor & self, bool eigenvectors, bool upper) const override;
  virtual std::tuple<Tensor,Tensor> symeig(const Tensor & self, bool eigenvectors, bool upper) const override;
  virtual std::tuple<Tensor &,Tensor &> eig_out(Tensor & res1, Tensor & res2, const Tensor & self, bool eigenvectors) const override;
  virtual std::tuple<Tensor,Tensor> eig(const Tensor & self, bool eigenvectors) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> svd_out(Tensor & res1, Tensor & res2, Tensor & res3, const Tensor & self, bool some) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> svd(const Tensor & self, bool some) const override;
  virtual Tensor & inverse_out(Tensor & output, const Tensor & self) const override;
  virtual Tensor inverse(const Tensor & self) const override;
  virtual Tensor & potrf_out(Tensor & output, const Tensor & self, bool upper) const override;
  virtual Tensor potrf(const Tensor & self, bool upper) const override;
  virtual Tensor & potrs_out(Tensor & result, const Tensor & self, const Tensor & input2, bool upper) const override;
  virtual Tensor potrs(const Tensor & self, const Tensor & input2, bool upper) const override;
  virtual Tensor & potri_out(Tensor & output, const Tensor & self, bool upper) const override;
  virtual Tensor potri(const Tensor & self, bool upper) const override;
  virtual std::tuple<Tensor &,Tensor &> pstrf_out(Tensor & res1, Tensor & res2, const Tensor & self, bool upper, Scalar tol) const override;
  virtual std::tuple<Tensor,Tensor> pstrf(const Tensor & self, bool upper, Scalar tol) const override;
  virtual std::tuple<Tensor &,Tensor &> qr_out(Tensor & res1, Tensor & res2, const Tensor & self) const override;
  virtual std::tuple<Tensor,Tensor> qr(const Tensor & self) const override;
  virtual std::tuple<Tensor &,Tensor &> geqrf_out(Tensor & res1, Tensor & res2, const Tensor & self) const override;
  virtual std::tuple<Tensor,Tensor> geqrf(const Tensor & self) const override;
  virtual Tensor & orgqr_out(Tensor & result, const Tensor & self, const Tensor & input2) const override;
  virtual Tensor orgqr(const Tensor & self, const Tensor & input2) const override;
  virtual Tensor & ormqr_out(Tensor & result, const Tensor & self, const Tensor & input2, const Tensor & input3, bool left, bool transpose) const override;
  virtual Tensor ormqr(const Tensor & self, const Tensor & input2, const Tensor & input3, bool left, bool transpose) const override;
  virtual std::tuple<Tensor &,Tensor &> btrifact_out(Tensor & result, Tensor & pivots, const Tensor & self, const Tensor & info, bool pivot) const override;
  virtual std::tuple<Tensor,Tensor> btrifact(const Tensor & self, const Tensor & info, bool pivot) const override;
  virtual Tensor & btrisolve_out(Tensor & result, const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const override;
  virtual Tensor btrisolve(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const override;
  virtual Tensor & randperm_out(Tensor & result, int64_t n, Generator * generator) const override;
  virtual Tensor randperm(int64_t n, Generator * generator) const override;
  virtual Tensor & m_random_(Tensor & self, int64_t from, int64_t to, Generator * generator) const override;
  virtual Tensor & m_random_(Tensor & self, int64_t to, Generator * generator) const override;
  virtual Tensor & m_random_(Tensor & self, Generator * generator) const override;
  virtual Tensor & multinomial_out(Tensor & result, const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) const override;
  virtual Tensor multinomial(const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) const override;
  virtual Tensor & m_uniform_(Tensor & self, double from, double to, Generator * generator) const override;
  virtual Tensor & normal_out(Tensor & output, const Tensor & means, double std, Generator * generator) const override;
  virtual Tensor normal(const Tensor & means, double std, Generator * generator) const override;
  virtual Tensor & normal_out(Tensor & output, double mean, const Tensor & std, Generator * generator) const override;
  virtual Tensor normal(double mean, const Tensor & std, Generator * generator) const override;
  virtual Tensor & normal_out(Tensor & output, const Tensor & means, const Tensor & std, Generator * generator) const override;
  virtual Tensor normal(const Tensor & means, const Tensor & std, Generator * generator) const override;
  virtual Tensor & m_normal_(Tensor & self, double mean, double std, Generator * generator) const override;
  virtual Tensor & m_cauchy_(Tensor & self, double median, double sigma, Generator * generator) const override;
  virtual Tensor & m_log_normal_(Tensor & self, double mean, double std, Generator * generator) const override;
  virtual Tensor & m_exponential_(Tensor & self, double lambd, Generator * generator) const override;
  virtual Tensor & rand_out(Tensor & result, IntList size, Generator * generator) const override;
  virtual Tensor rand(IntList size, Generator * generator) const override;
  virtual Tensor & randn_out(Tensor & result, IntList size, Generator * generator) const override;
  virtual Tensor randn(IntList size, Generator * generator) const override;
  virtual Tensor & m_geometric_(Tensor & self, double p, Generator * generator) const override;
  virtual int64_t m_size(const Tensor & self, int64_t dim) const override;
  virtual int64_t m_stride(const Tensor & self, int64_t dim) const override;
  virtual Tensor tensor(Storage & storage, int64_t storageOffset, IntList size, IntList stride) const override;
  virtual Tensor tensor(IntList size) const override;
  virtual Tensor tensor(IntList size, IntList stride) const override;
  virtual Tensor tensor() const override;
  virtual Tensor alias(const Tensor & tensor) const override;
  virtual Tensor & select_out(Tensor & result, const Tensor & self, int64_t dim, int64_t sliceIndex) const override;
  virtual Tensor select(const Tensor & self, int64_t dim, int64_t sliceIndex) const override;
  virtual Tensor & _unnarrow_out(Tensor & result, const Tensor & self, int64_t dimension, int64_t offset, int64_t dimSize) const override;
  virtual Tensor _unnarrow(const Tensor & self, int64_t dimension, int64_t offset, int64_t dimSize) const override;
  virtual Tensor & m_assign_(Tensor & self, const Tensor & src) const override;
  virtual Tensor & as_strided_out(Tensor & result, const Tensor & self, IntList size, IntList stride) const override;
  virtual Tensor as_strided(const Tensor & self, IntList size, IntList stride) const override;
  virtual Tensor & as_strided_(Tensor & self, IntList size, IntList stride, int64_t storage_offset) const override;
  virtual Tensor & cat_out(Tensor & self, TensorList tensors, int64_t dim) const override;
  virtual Tensor cat(TensorList tensors, int64_t dim) const override;
  virtual Tensor & m_reshape_(Tensor & self, IntList size, IntList stride) const override;
  virtual Tensor & binary_cross_entropy_out(Tensor & output, const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average) const override;
  virtual Tensor binary_cross_entropy(const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average) const override;
  virtual Tensor & binary_cross_entropy_forward_out(Tensor & output, const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average) const override;
  virtual Tensor binary_cross_entropy_forward(const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average) const override;
  virtual Tensor & binary_cross_entropy_backward_out(Tensor & grad_input, const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average) const override;
  virtual Tensor binary_cross_entropy_backward(const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average) const override;
  virtual Tensor & kl_div_out(Tensor & output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor kl_div(const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor & kl_div_forward_out(Tensor & output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor kl_div_forward(const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor & kl_div_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor kl_div_backward(const Tensor & grad_output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor & l1_loss_out(Tensor & output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor l1_loss(const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor & l1_loss_forward_out(Tensor & output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor l1_loss_forward(const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor & l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor l1_loss_backward(const Tensor & grad_output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor & mse_loss_out(Tensor & output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor mse_loss(const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor & mse_loss_forward_out(Tensor & output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor mse_loss_forward(const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor & mse_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor mse_loss_backward(const Tensor & grad_output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor & multi_margin_loss_out(Tensor & output, const Tensor & input, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, bool size_average) const override;
  virtual Tensor multi_margin_loss(const Tensor & input, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, bool size_average) const override;
  virtual Tensor & multi_margin_loss_forward_out(Tensor & output, const Tensor & input, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, bool size_average) const override;
  virtual Tensor multi_margin_loss_forward(const Tensor & input, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, bool size_average) const override;
  virtual Tensor & multi_margin_loss_backward_out(Tensor & grad_input, const Tensor & input, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, bool size_average) const override;
  virtual Tensor multi_margin_loss_backward(const Tensor & input, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, bool size_average) const override;
  virtual Tensor & multilabel_margin_loss_out(Tensor & output, const Tensor & input, const Tensor & target, bool size_average) const override;
  virtual Tensor multilabel_margin_loss(const Tensor & input, const Tensor & target, bool size_average) const override;
  virtual Tensor & multilabel_margin_loss_forward_out(Tensor & output, const Tensor & input, const Tensor & target, bool size_average, const Tensor & is_target) const override;
  virtual Tensor multilabel_margin_loss_forward(const Tensor & input, const Tensor & target, bool size_average, const Tensor & is_target) const override;
  virtual Tensor & multilabel_margin_loss_backward_out(Tensor & grad_input, const Tensor & input, const Tensor & target, bool size_average, const Tensor & is_target) const override;
  virtual Tensor multilabel_margin_loss_backward(const Tensor & input, const Tensor & target, bool size_average, const Tensor & is_target) const override;
  virtual Tensor & nll_loss_out(Tensor & output, const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average, int64_t ignore_index, bool reduce) const override;
  virtual Tensor nll_loss(const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average, int64_t ignore_index, bool reduce) const override;
  virtual Tensor & nll_loss_forward_out(Tensor & output, const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average, int64_t ignore_index, bool reduce, const Tensor & total_weight) const override;
  virtual Tensor nll_loss_forward(const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average, int64_t ignore_index, bool reduce, const Tensor & total_weight) const override;
  virtual Tensor & nll_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average, int64_t ignore_index, bool reduce, const Tensor & total_weight) const override;
  virtual Tensor nll_loss_backward(const Tensor & grad_output, const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average, int64_t ignore_index, bool reduce, const Tensor & total_weight) const override;
  virtual Tensor & nll_loss2d_out(Tensor & output, const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average, int64_t ignore_index, bool reduce) const override;
  virtual Tensor nll_loss2d(const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average, int64_t ignore_index, bool reduce) const override;
  virtual Tensor & nll_loss2d_forward_out(Tensor & output, const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average, int64_t ignore_index, bool reduce, const Tensor & total_weight) const override;
  virtual Tensor nll_loss2d_forward(const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average, int64_t ignore_index, bool reduce, const Tensor & total_weight) const override;
  virtual Tensor & nll_loss2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average, int64_t ignore_index, bool reduce, const Tensor & total_weight) const override;
  virtual Tensor nll_loss2d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & target, const Tensor & weight, bool size_average, int64_t ignore_index, bool reduce, const Tensor & total_weight) const override;
  virtual Tensor & smooth_l1_loss_out(Tensor & output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor smooth_l1_loss(const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor & smooth_l1_loss_forward_out(Tensor & output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor smooth_l1_loss_forward(const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor & smooth_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor smooth_l1_loss_backward(const Tensor & grad_output, const Tensor & input, const Tensor & target, bool size_average, bool reduce) const override;
  virtual Tensor & soft_margin_loss_out(Tensor & output, const Tensor & input, const Tensor & target, bool size_average) const override;
  virtual Tensor soft_margin_loss(const Tensor & input, const Tensor & target, bool size_average) const override;
  virtual Tensor & soft_margin_loss_forward_out(Tensor & output, const Tensor & input, const Tensor & target, bool size_average) const override;
  virtual Tensor soft_margin_loss_forward(const Tensor & input, const Tensor & target, bool size_average) const override;
  virtual Tensor & soft_margin_loss_backward_out(Tensor & grad_input, const Tensor & input, const Tensor & target, bool size_average) const override;
  virtual Tensor soft_margin_loss_backward(const Tensor & input, const Tensor & target, bool size_average) const override;
  virtual Tensor & elu_out(Tensor & output, const Tensor & input, Scalar alpha, bool inplace) const override;
  virtual Tensor elu(const Tensor & input, Scalar alpha, bool inplace) const override;
  virtual Tensor & elu_forward_out(Tensor & output, const Tensor & input, Scalar alpha, bool inplace) const override;
  virtual Tensor elu_forward(const Tensor & input, Scalar alpha, bool inplace) const override;
  virtual Tensor & elu_backward_out(Tensor & grad_input, const Tensor & grad_output, Scalar alpha, const Tensor & output) const override;
  virtual Tensor elu_backward(const Tensor & grad_output, Scalar alpha, const Tensor & output) const override;
  virtual Tensor & glu_out(Tensor & output, const Tensor & input, int64_t dim) const override;
  virtual Tensor glu(const Tensor & input, int64_t dim) const override;
  virtual Tensor & glu_forward_out(Tensor & output, const Tensor & input, int64_t dim) const override;
  virtual Tensor glu_forward(const Tensor & input, int64_t dim) const override;
  virtual Tensor & glu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, int64_t dim) const override;
  virtual Tensor glu_backward(const Tensor & grad_output, const Tensor & input, int64_t dim) const override;
  virtual Tensor & hardshrink_out(Tensor & output, const Tensor & input, Scalar lambd) const override;
  virtual Tensor hardshrink(const Tensor & input, Scalar lambd) const override;
  virtual Tensor & hardshrink_forward_out(Tensor & output, const Tensor & input, Scalar lambd) const override;
  virtual Tensor hardshrink_forward(const Tensor & input, Scalar lambd) const override;
  virtual Tensor & hardshrink_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, Scalar lambd) const override;
  virtual Tensor hardshrink_backward(const Tensor & grad_output, const Tensor & input, Scalar lambd) const override;
  virtual Tensor & hardtanh_out(Tensor & output, const Tensor & input, Scalar min_val, Scalar max_val, bool inplace) const override;
  virtual Tensor hardtanh(const Tensor & input, Scalar min_val, Scalar max_val, bool inplace) const override;
  virtual Tensor & hardtanh_forward_out(Tensor & output, const Tensor & input, Scalar min_val, Scalar max_val, bool inplace) const override;
  virtual Tensor hardtanh_forward(const Tensor & input, Scalar min_val, Scalar max_val, bool inplace) const override;
  virtual Tensor & hardtanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, Scalar min_val, Scalar max_val) const override;
  virtual Tensor hardtanh_backward(const Tensor & grad_output, const Tensor & input, Scalar min_val, Scalar max_val) const override;
  virtual Tensor & leaky_relu_out(Tensor & output, const Tensor & input, Scalar negative_slope, bool inplace) const override;
  virtual Tensor leaky_relu(const Tensor & input, Scalar negative_slope, bool inplace) const override;
  virtual Tensor & leaky_relu_forward_out(Tensor & output, const Tensor & input, Scalar negative_slope, bool inplace) const override;
  virtual Tensor leaky_relu_forward(const Tensor & input, Scalar negative_slope, bool inplace) const override;
  virtual Tensor & leaky_relu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, Scalar negative_slope) const override;
  virtual Tensor leaky_relu_backward(const Tensor & grad_output, const Tensor & input, Scalar negative_slope) const override;
  virtual Tensor & log_sigmoid_out(Tensor & output, const Tensor & input) const override;
  virtual Tensor log_sigmoid(const Tensor & input) const override;
  virtual Tensor & log_sigmoid_forward_out(Tensor & output, const Tensor & input, const Tensor & buffer) const override;
  virtual Tensor log_sigmoid_forward(const Tensor & input, const Tensor & buffer) const override;
  virtual Tensor & log_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, const Tensor & buffer) const override;
  virtual Tensor log_sigmoid_backward(const Tensor & grad_output, const Tensor & input, const Tensor & buffer) const override;
  virtual Tensor & log_softmax_out(Tensor & output, const Tensor & input, int64_t dim) const override;
  virtual Tensor log_softmax(const Tensor & input, int64_t dim) const override;
  virtual Tensor & log_softmax_forward_out(Tensor & output, const Tensor & input, int64_t dim) const override;
  virtual Tensor log_softmax_forward(const Tensor & input, int64_t dim) const override;
  virtual Tensor & log_softmax_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, int64_t dim, const Tensor & output) const override;
  virtual Tensor log_softmax_backward(const Tensor & grad_output, const Tensor & input, int64_t dim, const Tensor & output) const override;
  virtual Tensor & prelu_out(Tensor & output, const Tensor & input, const Tensor & weight) const override;
  virtual Tensor prelu(const Tensor & input, const Tensor & weight) const override;
  virtual Tensor & prelu_forward_out(Tensor & output, const Tensor & input, const Tensor & weight) const override;
  virtual Tensor prelu_forward(const Tensor & input, const Tensor & weight) const override;
  virtual std::tuple<Tensor &,Tensor &> prelu_backward_out(Tensor & grad_input, Tensor & grad_weight, const Tensor & grad_output, const Tensor & input, const Tensor & weight) const override;
  virtual std::tuple<Tensor,Tensor> prelu_backward(const Tensor & grad_output, const Tensor & input, const Tensor & weight, std::array<bool, 2> output_mask) const override;
  virtual Tensor & rrelu_out(Tensor & output, const Tensor & input, Scalar lower, Scalar upper, bool training, bool inplace, Generator * generator) const override;
  virtual Tensor rrelu(const Tensor & input, Scalar lower, Scalar upper, bool training, bool inplace, Generator * generator) const override;
  virtual Tensor & rrelu_forward_out(Tensor & output, const Tensor & input, Scalar lower, Scalar upper, bool training, bool inplace, Generator * generator, const Tensor & noise) const override;
  virtual Tensor rrelu_forward(const Tensor & input, Scalar lower, Scalar upper, bool training, bool inplace, Generator * generator, const Tensor & noise) const override;
  virtual Tensor & rrelu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, Scalar lower, Scalar upper, bool training, const Tensor & noise) const override;
  virtual Tensor rrelu_backward(const Tensor & grad_output, const Tensor & input, Scalar lower, Scalar upper, bool training, const Tensor & noise) const override;
  virtual Tensor & softmax_out(Tensor & output, const Tensor & input, int64_t dim) const override;
  virtual Tensor softmax(const Tensor & input, int64_t dim) const override;
  virtual Tensor & softmax_forward_out(Tensor & output, const Tensor & input, int64_t dim) const override;
  virtual Tensor softmax_forward(const Tensor & input, int64_t dim) const override;
  virtual Tensor & softmax_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, int64_t dim, const Tensor & output) const override;
  virtual Tensor softmax_backward(const Tensor & grad_output, const Tensor & input, int64_t dim, const Tensor & output) const override;
  virtual Tensor & softplus_out(Tensor & output, const Tensor & input, Scalar beta, Scalar threshold) const override;
  virtual Tensor softplus(const Tensor & input, Scalar beta, Scalar threshold) const override;
  virtual Tensor & softplus_forward_out(Tensor & output, const Tensor & input, Scalar beta, Scalar threshold) const override;
  virtual Tensor softplus_forward(const Tensor & input, Scalar beta, Scalar threshold) const override;
  virtual Tensor & softplus_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, Scalar beta, Scalar threshold, const Tensor & output) const override;
  virtual Tensor softplus_backward(const Tensor & grad_output, const Tensor & input, Scalar beta, Scalar threshold, const Tensor & output) const override;
  virtual Tensor & softshrink_out(Tensor & output, const Tensor & input, Scalar lambd) const override;
  virtual Tensor softshrink(const Tensor & input, Scalar lambd) const override;
  virtual Tensor & softshrink_forward_out(Tensor & output, const Tensor & input, Scalar lambd) const override;
  virtual Tensor softshrink_forward(const Tensor & input, Scalar lambd) const override;
  virtual Tensor & softshrink_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, Scalar lambd) const override;
  virtual Tensor softshrink_backward(const Tensor & grad_output, const Tensor & input, Scalar lambd) const override;
  virtual Tensor & threshold_out(Tensor & output, const Tensor & input, Scalar threshold, Scalar value, bool inplace) const override;
  virtual Tensor threshold(const Tensor & input, Scalar threshold, Scalar value, bool inplace) const override;
  virtual Tensor & threshold_forward_out(Tensor & output, const Tensor & input, Scalar threshold, Scalar value, bool inplace) const override;
  virtual Tensor threshold_forward(const Tensor & input, Scalar threshold, Scalar value, bool inplace) const override;
  virtual Tensor & threshold_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, Scalar threshold, Scalar value) const override;
  virtual Tensor threshold_backward(const Tensor & grad_output, const Tensor & input, Scalar threshold, Scalar value) const override;
  virtual std::tuple<Tensor &,Tensor &> adaptive_max_pool2d_out(Tensor & output, Tensor & indices, const Tensor & input, IntList output_size) const override;
  virtual std::tuple<Tensor,Tensor> adaptive_max_pool2d(const Tensor & input, IntList output_size) const override;
  virtual std::tuple<Tensor &,Tensor &> adaptive_max_pool2d_forward_out(Tensor & output, Tensor & indices, const Tensor & input, IntList output_size) const override;
  virtual std::tuple<Tensor,Tensor> adaptive_max_pool2d_forward(const Tensor & input, IntList output_size) const override;
  virtual Tensor & adaptive_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, const Tensor & indices) const override;
  virtual Tensor adaptive_max_pool2d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & indices) const override;
  virtual Tensor & avg_pool2d_out(Tensor & output, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor avg_pool2d(const Tensor & input, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor & avg_pool2d_forward_out(Tensor & output, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor avg_pool2d_forward(const Tensor & input, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor & avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor avg_pool2d_backward(const Tensor & grad_output, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor & avg_pool3d_out(Tensor & output, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor avg_pool3d(const Tensor & input, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor & avg_pool3d_forward_out(Tensor & output, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor avg_pool3d_forward(const Tensor & input, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor & avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor avg_pool3d_backward(const Tensor & grad_output, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual std::tuple<Tensor &,Tensor &> max_pool2d_out(Tensor & output, Tensor & indices, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  virtual std::tuple<Tensor,Tensor> max_pool2d(const Tensor & input, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  virtual std::tuple<Tensor &,Tensor &> max_pool2d_forward_out(Tensor & output, Tensor & indices, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  virtual std::tuple<Tensor,Tensor> max_pool2d_forward(const Tensor & input, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  virtual Tensor & max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const override;
  virtual Tensor max_pool2d_backward(const Tensor & grad_output, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const override;
  virtual std::tuple<Tensor &,Tensor &> max_pool3d_out(Tensor & output, Tensor & indices, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  virtual std::tuple<Tensor,Tensor> max_pool3d(const Tensor & input, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  virtual std::tuple<Tensor &,Tensor &> max_pool3d_forward_out(Tensor & output, Tensor & indices, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  virtual std::tuple<Tensor,Tensor> max_pool3d_forward(const Tensor & input, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  virtual Tensor & max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const override;
  virtual Tensor max_pool3d_backward(const Tensor & grad_output, const Tensor & input, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const override;
  virtual Tensor & max_unpool2d_out(Tensor & output, const Tensor & input, const Tensor & indices, IntList output_size) const override;
  virtual Tensor max_unpool2d(const Tensor & input, const Tensor & indices, IntList output_size) const override;
  virtual Tensor & max_unpool2d_forward_out(Tensor & output, const Tensor & input, const Tensor & indices, IntList output_size) const override;
  virtual Tensor max_unpool2d_forward(const Tensor & input, const Tensor & indices, IntList output_size) const override;
  virtual Tensor & max_unpool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, const Tensor & indices, IntList output_size) const override;
  virtual Tensor max_unpool2d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & indices, IntList output_size) const override;
  virtual Tensor & max_unpool3d_out(Tensor & output, const Tensor & input, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const override;
  virtual Tensor max_unpool3d(const Tensor & input, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const override;
  virtual Tensor & max_unpool3d_forward_out(Tensor & output, const Tensor & input, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const override;
  virtual Tensor max_unpool3d_forward(const Tensor & input, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const override;
  virtual Tensor & max_unpool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & input, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const override;
  virtual Tensor max_unpool3d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const override;
  virtual Tensor & _sigmoid_out(Tensor & output, const Tensor & input) const override;
  virtual Tensor _sigmoid(const Tensor & input) const override;
  virtual Tensor & _sigmoid_forward_out(Tensor & output, const Tensor & input) const override;
  virtual Tensor _sigmoid_forward(const Tensor & input) const override;
  virtual Tensor & _sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const override;
  virtual Tensor _sigmoid_backward(const Tensor & grad_output, const Tensor & output) const override;
  virtual Tensor & _tanh_out(Tensor & output, const Tensor & input) const override;
  virtual Tensor _tanh(const Tensor & input) const override;
  virtual Tensor & _tanh_forward_out(Tensor & output, const Tensor & input) const override;
  virtual Tensor _tanh_forward(const Tensor & input) const override;
  virtual Tensor & _tanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const override;
  virtual Tensor _tanh_backward(const Tensor & grad_output, const Tensor & output) const override;
  virtual Tensor & batch_norm_out(Tensor & output, const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps) const override;
  virtual Tensor batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps) const override;
  virtual Tensor & batch_norm_forward_out(Tensor & output, const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, const Tensor & save_mean, const Tensor & save_std) const override;
  virtual Tensor batch_norm_forward(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, const Tensor & save_mean, const Tensor & save_std) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> batch_norm_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & input, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, bool training, double eps, const Tensor & save_mean, const Tensor & save_std) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> batch_norm_backward(const Tensor & grad_output, const Tensor & input, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, bool training, double eps, const Tensor & save_mean, const Tensor & save_std, std::array<bool, 3> output_mask) const override;
  virtual Tensor & conv_transpose2d_out(Tensor & output, const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const override;
  virtual Tensor conv_transpose2d(const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const override;
  virtual Tensor & conv_transpose2d_forward_out(Tensor & output, const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  virtual Tensor conv_transpose2d_forward(const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> conv_transpose2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> conv_transpose2d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & columns, const Tensor & ones, std::array<bool, 3> output_mask) const override;
  virtual Tensor & conv_transpose3d_out(Tensor & output, const Tensor & input, const Tensor & weight, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const override;
  virtual Tensor conv_transpose3d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const override;
  virtual Tensor & conv_transpose3d_forward_out(Tensor & output, const Tensor & input, const Tensor & weight, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & finput, const Tensor & fgrad_input) const override;
  virtual Tensor conv_transpose3d_forward(const Tensor & input, const Tensor & weight, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & finput, const Tensor & fgrad_input) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> conv_transpose3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & finput, const Tensor & fgrad_input) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> conv_transpose3d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & finput, const Tensor & fgrad_input, std::array<bool, 3> output_mask) const override;
  virtual Tensor & conv2d_out(Tensor & output, const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding) const override;
  virtual Tensor conv2d(const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding) const override;
  virtual Tensor & conv2d_forward_out(Tensor & output, const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input) const override;
  virtual Tensor conv2d_forward(const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> conv2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> conv2d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool, 3> output_mask) const override;
  virtual Tensor & conv3d_out(Tensor & output, const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding) const override;
  virtual Tensor conv3d(const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding) const override;
  virtual Tensor & conv3d_forward_out(Tensor & output, const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, const Tensor & finput) const override;
  virtual Tensor conv3d_forward(const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, const Tensor & finput) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> conv3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> conv3d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool, 3> output_mask) const override;
  virtual Tensor & conv_dilated2d_out(Tensor & output, const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const override;
  virtual Tensor conv_dilated2d(const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const override;
  virtual Tensor & conv_dilated2d_forward_out(Tensor & output, const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  virtual Tensor conv_dilated2d_forward(const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> conv_dilated2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> conv_dilated2d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones, std::array<bool, 3> output_mask) const override;
  virtual Tensor & conv_dilated3d_out(Tensor & output, const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const override;
  virtual Tensor conv_dilated3d(const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const override;
  virtual Tensor & conv_dilated3d_forward_out(Tensor & output, const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  virtual Tensor conv_dilated3d_forward(const Tensor & input, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> conv_dilated3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> conv_dilated3d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones, std::array<bool, 3> output_mask) const override;
};

} // namespace at
