from PIL import Image
import random, time, sys
def text_image(text,print_status=True):
    """This function/method will take text ( not unicode ) and encoded it into
an image file. The result/return will be a PIL.Image object,
with the first RGB value of each pixel
(the red value) be equivelent to the character code it represents.
The green and blue values are set to random."""
    if print_status:
        print("about to compute %sKB of data from input string." % (sys.getsizeof(text) / 1000))
        print("creating empty image...")
    start_time = time.time()
    d = len(text) / 640
    re = len(text) % 640
    lines = int(d) + re
    if len(text) < 480:
        iml = len(text)
        img = Image.new("RGB",(1,len(text)),(255,255,255))
        lines = 1
    else:
        iml = 480
        img = Image.new("RGB",(lines,480),(255,255,255))
    larr = []
    xc = 0
    if print_status:
        print("encoding character codes into RGB value array...")
    for i in range(1,lines + 1):
        part = text[xc:480 * i]
        larr.append(list(part))
        xc = 480 * i
    for i in range(0,len(larr)):
        for j in range(0,len(larr[i])):
            larr[i][j] = ord(larr[i][j])
    if print_status:
        print("writing values to image...")
    for x in range(0,len(larr)):
        for y in range(0,len(larr[x])):
            xpos = x 
            ypos = y
            charnum = larr[x][y]
            try:
                img.putpixel( (xpos,ypos), (charnum,int(random.random()* 200),int(random.random()* 200)))
            except IndexError:
                print("hit IndexError at:")
                print(xpos,ypos,charnum)
    if print_status:
        print("time elapsed: %s seconds" % (time.time() - start_time))
    return img
def decode_image(img,print_status=True):
    """Input <img> should be a PIL.Image object,populated with RGB pixels.
The image should be generated by my text_image function/method"""
    if print_status:
        print("about to process %s KB of data from PIL Image" % (sys.getsizeof(img.tobytes()) / 1000))
        print("decoding RGB values...")
    start_time = time.time()
    text = []
    for x in range(0,img.width):
        for y in range(0,img.height):
            chpx = chr(img.getpixel((x,y))[0])
            text.append(chpx)
    if print_status:
        print("done. time elapsed: %s seconds" % (time.time() - start_time))
    return "".join(text)
def tests():
    """check if everything works as it should"""
    input_text = "hello world."
    img = text_image(input_text)
    text = decode_image(img)
    print("----------------------")
    if text == input_text:
        print("all clear! Test were successful")
    else:
        raise Exception("An the input string for text_image and output string for decode_image were not the same.")
if __name__ == '__main__':
    tests()
    
