from divinegift.cipher import decrypt_str, get_cipher, encrypt_str

cipher_key = b'rKKvXPL7OefUAfscsduYOWdtHHC1V0Mo0n5VgLR19tE='

console_template = b'gAAAAABca9BXJiXgb263by4ivXAqoU7R-Zmg_TnqzBagO3lZJoat5yeEy9sXsNzLhDHKo2tXU7nRfibzpJVcwx8EE9Oyiyooa4sSocm7MwKkAsH_3_1fovoETMHhEEciG3ELVoWXPXIBdT4onEz6hZHjDSZM7pLRfbzRzR9IvpAJnVP7eyQj5oHUzx_LRY4ReljOxjqMKH4_17gFFE9SSHNjyHPW7MbVm15Wcg72WlZBmhUOG1cU123yvO84WU1HNQ9zNKuH380p7q1mRkYcNzSVa4bOoEYaX4rHYkez0q2BmcbE-E-SQC4GxVQwFPaYslFsHc4l7hIejt2pylTfeVRtT9-8j-BeOgxa9mwgLaWgnE-hfuX9se9zgLIU1DCX98XL0VCMD1EAhCsCzwKOR0ch_SOLwTXeWGja1nf0I1xwY8_feqancugDP5KmJLyIUtS0AwsMIp-qJVAvFi3ferf05homZm3G_7PfjIH1OvW3dLqSrGMmmkPV3VxU-0UGNrYsZeyhWxhYRf3f5P6d2AQKxY6JdYPi-k6tfW3KNTkk3A-AXOU6cdohJc2Uu3Pdw86f_SXq2AdAUblN7K71UCGvQEzrUTQDrA4IISMw4UAjzbaSTZDUlhcJ-iSDQzp2F030X0TlWjUSQaka6X9sfrKs4_jqDR_uJATaHbjX4MoKrgC-QhIyM3aK9R_pJ81G4NeS1K8PPepbM2UeYM-MCn-16wuxscSc5HXEfrGBU3bOovPKSnrVZYQ7luIRpP3nUZ2l1JmRuGYHqiKxSiZaqh07bGS0l5YU_t6qsxd2QVF0Ev16JuHmqrffTfqzEUmy8PKXqi71sf01_0DB_ksjYTsy2e3nzmAHIdKmVM2jpMy7p3dkNMR-PqO7LlW_56wU7F0Ft5NhcVyn1wJz8qvEBSDrnFvMaba4OWATPRYYLD5vwncv80j_-kMgC6ptVJPtjLs6POTakUHyHdo_b_2dzlDwiQx8mbtO6p3xUb0xd6ZvYp9uNQWMUosI8K1m8mI83ulRGdV5NgcM4G-QWzjkT000Gt8JaUDKTDXe1VqQAGU1UBQVHPC9yUOFnh1CxOpcRJnDvdpfX3YDmdDVy2gjUBaqE_Az2xByPFzX59oOSuNnckUr9lYf1V2GpaO13McL6Sc57EpH10laXwdHORwcTaDRv_Nfy1Xq_u_YwstGNLzmVZx1gMmM8RcgXwpnEZztxLgR0akoVp4hfUerTSjhpm0xMmF_Ip8Wxu-yzNz1QHrLmUpA-t0pTquFBSCQCW9hAgbfxVrIeZlNbnR6mmthFTFDCRxQgDr4UFCkZUijFWDRGemnCUiLSOwJcPHNBB2NhNh3lx2RSiQid-FtfzVJXFdEhFIAtT-mBGpyQVrz0sk3CwafhhvacOmdJnvLK7Fxepbp9To0D14l4wrYNf5X0lvk-1OqJSznCl2Yzc5wKXkbJYZbpfx0X3KQGYw2e7U0k-yo65Jk-D6ckAuiKVfZlseapP-ZGl-GTSSX8yuNK36DA2FR1rFQdraaqhCB29drNH8-aXKKauLeJpGlpeHEAnGmS-uv7mc5mlXf-KxIU9HA7ypNzjz5Htif8nmXEePbatTu25Ku0frpiL38lU0DyJffqEKEc-Fa0f56ROLnbYM5umVhkH4yoVDnhUrJtP9NgZUNwmOIt4QR1FkY96LtWch2uGe0Zrhk_Gk-h50aO3rdbiQFiFI2LL67l2lyySHCH6gAz9QLFzJGN8g6xeTl9AvqqTZLf5kEJiyAlcL9edX0FbLfml3t0ALX7C4ehQQTa8ZWyNXRPDhhDAq899EfLROBoClK-2IAVlDSVasnUEl3_9EQVWCGOXXN9Ub2LU9hvsfCOXxIfng69EhSGi1ysrCzJ2buQ_UCiuImLnO_ShMGQn7FFgHOVsLvDgpqs8eJtDfZD5ykxVDGt2Uv8kCzJ0Nje9WSj_7WJ_Y2czFWuuBqXK8h30999TyDWuzhorG2Al64YyCw56iole_Nw6s5Q0B4cy-HacY39gl0aU0pR9JJ8_2UKSV7iXMT-5ghGxy1NkEfu3OvNP8N'
gui_template = b'gAAAAABcam3jCOeXKlovNWFJUdVNzFpbJxkf934F4ehEf8EDPRCSdhSDNMB6lIKuwQ8Xnq4vfQGsGtRyZA6X64NLmXhObUEES1tuXpU_U2wdd51YP5TIPOzQO3mCw_18Vwd_yO2VFe2w2kNCslaGw-NR7IPnRjFuckcCIOxsFPYf9vY5SyfCbuYJl2CHcbsdzAjE4U6D0O1Uk2JI4ZRSgBn5ratyKeC4v3tCBGjmY-NM4Suj8d8BB7uaTuRzcUhJco35zfCYVLqqyeJZjEFAuKW5iPll3EJDK__iXzZMQR_Tc530cCsSTVDIwX2dZ59x8BrhDaugEfb0Q-7B7NJE5U4BItCjSZ2AqEUPCsgB2S1SGmcDlSds_3zSYWwIydTqfLgt47QkC4qrzSHIcKVNKkNI3ClySDoOYIJKLRqm-_c-9eV5qVlpRIc_-_ezee3_WlK5HlJ5o1iRaO5NAEtbsXYfJhvrVPwXG9K03d7v_qaVoRzS19N9WFZcmYxZMBhmTep1APiOa7ggyAZimwfFF7SX6yZVTWXl6pj8c1xqBvm0XTgk7Um2Wqs6sPM8unYW0TntKEZYHPj6xOuJHPodAeoyQsXp7RnkbzZFcsSsdN_er60vQOQ4KpPm8PM9BxkC2tunApBMSC-jDfXOScMLEiWuJmgXN8iO1JyoxqaGZdLUtIVCVm9qUCargUi9A_Wp5aVfZRKKmyGNXpMVaiTRE97a0yAUcrRTWfRHj6bk6udztP1ndQaBXurj21seZryEmX5vd-swwsqcvHUsWP3L1pfMGRyTkv_ImpZUnLLnoMjiLjl76Gv9tYSsjpFdse5boi7WL9fajXw-b-zM3AfccDsxY1sftrjS4MSu6JqjhE7mgIvhMXpUAj15QnGGBozjstAoJ3jNyj_9GM6NBzIfHqUumC__gA7ZToH9TpLK_QuCV9knZBdf-73q3NkdX2DaSx0drM-obNOYx8s5jHg8Z1uplZFVWf_tOMo0BiuPiXuV7fFImSXSUczLiuM15LFmItN7a-42NeQh377kaq8X-93NVJrZz94xBbfZy6OCVLZ7XuyQyHSGllJ4O4_hafoNdec7CMQ6EVjWtZ82SIJKhMogusu5bitx52MHWXk4kyZ3DYZCwAsrLUOkUqgZL6adHhSlmJpEXFgPTqQrcTh77oeG8kE89MmYTDsNowI-ymb1DAAE8FQ-Gu7w75kNtqCyGNcWNX6XcHofy8lc0q1D-HrMf2xXN2JZx8wsyeO4kuIGA0A62gpYebQGWZsBEL-ngei5XbLjMYuh1njI-Ffg2YAIGIp8A--0rIyvs-G8WYluA1X6JPfQ3M8o56JHSUkgKwrRbFTt64Yq6PxuWvJxKunbqV6QbHDD62MXOtWzhekWrlPWrMjm_3onGycWnDxuN7HfvnEFSfz7LMKks4HOdqdaSaSLSyCTavBO-aruXeQCjPhtTfAlw56pPCOJZ6FXAk0L74r4L9MWYGCX2DCh8Uuz63kHtI3-HlCojL4Qr1IUPQdPGLwQJduYiSuyYXqJhpq1eeDHqRi1fP6htIPN1T1zA78lO3jmC_IrOa-kXQhIV1SGf0xO9JMA4_dwIPLOF2d1OXeT9Whl1Mr54HUAFN4nnDBgEriUFN2roqeZfY1RNFnb_p0tnnTIhLaxCDSFC3LUNzYEsyzMs41yKMpHYJRGpWxcNqx-T28PBzHYnrYMDSFtvkc441ux5mjU9BEcbLxXQqb2Hh2syp4Su9IS2xRo8vaBPspZflh_wVQxIqsyDG4zXqM0T_5gYWlKSgMwxMtR-sHSEoK9RPkThrpRz45b8z9Ivx8z_d9Ind99aY58PFR957wugvQktAaV9Kflgx4bu_yCjVNVjYezritfXIEqfvmwtU9i0aQ-nLMPED5BiLtlnP8aAPNN6tJC9UFjjgEuCONzajdxD47vuow9L_RcPUsDGXF8YkERUt78a-xlh3aYdA6Z4EIj-d9WZxeSoqPBXfUqL2NnF-9RCnd9u9Py9dcyIk9XLZAbFl_m_OmHF8kzH09DVocVqbtS72N31HjpMHEr0e8GD-ybrD0CBayil1WIaw9H3dArd5qgcmG5dD5Dc8BU02Sb2VS6vny4OU3UMC8C-Bd-hS_L33UztGn13i8G6VYvV-cmXo0vMskv9xI9GKDFqcbwOKZdFcRiiPlYUfkfkQLT7LyH06cOXD9f0mrhsoeSlgflV0AodOwDLPOlK_XAn33cT_J18eE6tiXncIZxi4dq-9o2QF1TeSo3EMSuHm6ENtybjWT_G_V_SHEc4EVLfX_ncsSmAf1-T6ETPpqEk2F0h9UPutZN--GRN_EKgAdcmFnmC3BwahFWQKR4eKW--zNTUATDHb00POZk1myaXVnridFcLDbJNKzC7LKN55JlZEN9e2n4WSyZYCtnOXQ7UK4S_bze292jxziS04tcDY7ji2bNnzp-GBhwSKou362Z2KXhkVQ-1T8FxO2fX_NDw5aPrFQ0rZrr3talowUnfV6n0sNISPN1RKpXgGJYrNOOym7jxAq9r6oeEd10JB7UvRR7aGVZcPXSdKa6XNsFsAdnVxwzzkyiMgjSCZWgeM5AFlMbSetNY8JtFKBXE-XLe6zTPClkjz2gRBHity-MT74kk9utp0Qfm3dEf-9pXxHY2N5DfKdJTdSZhImxsJ46lDEViUNzkfiq0C9NkI92r6Nw5ARAVzs0V12VM2IXW_NO_xHXqBSu4pVXWA6pK3uAYoQNsFr5QWxmXu930KHuU71gCpMvOVV50jOFIdyEGBD0JegspumYuQOKPFVr1lihCJBUrMvCHPW9iuv9fIRbf0bkrNlmYNWUKzK5clpZ7WlB9tLwkgnjxKqciMdSn3GeReJqexbkmEIR_JqKrdG6YWRItQMY5eIPwFW_nmSQL3KZiDTct6REwtXzSdOtUr28kblOWafhO_-RFmTM_h6CigmvUrHICZioM9oofb1nyEdQc4doF5Yx1Kf1fIJcwqG0n27GkfQ3giPtoU6Bop2XBIgRVG7ozkhKoZ1SrgqpQakn8GCPXWdaDsSf_am8ezhEKmCRLFej7EsxYfb-ui4q0tzGRZg8Ggb4sCG2AvFzaCguD0McsBvmZGIuY-ac81ippFQBmfr0qh2t-l7OplikSRtfzNDSGO2AYdYq5G-ySGb-BQEQLihqwO72EsJwcIDn3DzMeA6VGXv1Lh97p7F309R4FC4By1YALM7K5lsYt-0-QzwVIxoIW9p7wmY8ZtvZb3a3CO6GtzJJIgpIUfX678impQkfbWxynKpXwO-6goxjF-yFUQ4OD3wrfWcaD9m-uDtzGgHWR-IKWsZXy0-a4nzUIYGAzaT080GWQfKHaRQJhDGASUXZbh_PZhqu36xQtd9seGu7Tom57WOH9hrOXxsK3jOWYJKnx5C3Y88uoAfowXppnY9GH5hYECvQuFzZGxXZWlWEjCA07thJkDHQlOs6k6pN5axVHziE-y5KY_3xASTaOA3RtEi6K-cHZZ5tl5s6kvhrrzF_x977AUNay9NC45suAWHLTfkdlKKw3bric-HaWpdbx3Xz4to2WGKzhhqnNHsFKuKvfBIljYU2LMxVLhMVBSKuvmMV0f6y-JIYzDkk6h7Cp6aJapPKQ2P5bEwjO7Aw7GRf45GxkADp-4FmXE_WGs8W0PpZBGpUwWHE6B6o-CdmfnErC3fOC1PUAmXZ4HmcZo8VPGx6bSOWUOqXECrNL1dacwUbnBkJ41LBIg=='
config_template = b'gAAAAABcam4IXxB5tsuLAWqnXGH4PQT0tEg8aU_gusJvhR5xEh56Aim_jjtcXmTz2EBJSM8_RPp_nAJvxEf4baDMtzTsBY95VLY-a6MMTRGSUlVOE4nsD5cgp95iXC6MNRYEGNFxYswTI_O8JZyYfF1bEaVz8ISlLlwFCCSHWqnC3MURYWISTXQ8-GXJAR5FDzPHP0A3nvPcP3b3kY8EPPZIW639cUdHNmQv6tr9zPKE3du5Wfe1tV3aEKIgtSVhwfHmI55ZrQ-cQ7Yrkxh740Y3T17CjYWSARSr9R3iA-YK1L1bKq6MgD8bgIP1Lg6tl9BZ1yyjZk3OZtSJmsbuzup_7RxjYY3fY1wKBDydM3GOL3MrE8nwZ3dehRiZzdQNFaJb0S-eK8qPw25NItQYXA4RPLrBJepU6PyuRCQNx5MReKODp1vWs_Wze7l8LhARMnfrBeYFA5vbfLqCXrdYqcDmOuRNV8uIhuLB5jREBsL9lToTuAuCjia1j9UejZejm4v3YNoztffu'
email_config_template = b'gAAAAABcam4qHlH4MHm2hjQV_XOgRFBTluMpHfiFmdXqGHBEUejBqBzB76elHTgZ2X1NT9ZCQMbk9w9XAJ7ZQEMA6SiX1Px-NMezp7F4HMI31Bia2-sPV5WtlCNJBsUaM8e0q4jMLqklBRy1-_nAkUxE4DVYjWVUvOTPcU1szIWWxFVFzjrS1Wpb8KZXR_vsYXDylTxrv5uwlMscCc_RrFANL3K8L-swbfVramykFcvnYhQHbgsqN_n7_MtQ8mfBpwTz6iNoCIC9'


def create_file(filename, text):
    cipher = get_cipher(cipher_key)
    with open(filename, 'w') as f:
        f.write(decrypt_str(text, cipher))


def create_console(filename='main.py'):
    if not filename.endswith('.py'):
        filename += '.py'
    create_file(filename, console_template)


def create_gui(filename='main_gui.py'):
    if not filename.endswith('.py'):
        filename += '.py'
    create_file(filename, gui_template)


def create_config(filename='settings.conf'):
    create_file(filename, config_template)


def add_email_config(filename='settings.conf'):
    try:
        with open(filename, 'r') as f:
            text = f.read()
        text += ',\n'
    except:
        text = ''
    cipher = get_cipher(cipher_key)
    text += decrypt_str(email_config_template, cipher)
    config_with_email_template = encrypt_str(text, cipher, get_str=False)
    create_file(filename, config_with_email_template)
