# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCpeDeviceShapesResult',
    'AwaitableGetCpeDeviceShapesResult',
    'get_cpe_device_shapes',
    'get_cpe_device_shapes_output',
]

@pulumi.output_type
class GetCpeDeviceShapesResult:
    """
    A collection of values returned by getCpeDeviceShapes.
    """
    def __init__(__self__, cpe_device_shapes=None, filters=None, id=None):
        if cpe_device_shapes and not isinstance(cpe_device_shapes, list):
            raise TypeError("Expected argument 'cpe_device_shapes' to be a list")
        pulumi.set(__self__, "cpe_device_shapes", cpe_device_shapes)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="cpeDeviceShapes")
    def cpe_device_shapes(self) -> Sequence['outputs.GetCpeDeviceShapesCpeDeviceShapeResult']:
        """
        The list of cpe_device_shapes.
        """
        return pulumi.get(self, "cpe_device_shapes")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCpeDeviceShapesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetCpeDeviceShapesResult(GetCpeDeviceShapesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCpeDeviceShapesResult(
            cpe_device_shapes=self.cpe_device_shapes,
            filters=self.filters,
            id=self.id)


def get_cpe_device_shapes(filters: Optional[Sequence[Union['GetCpeDeviceShapesFilterArgs', 'GetCpeDeviceShapesFilterArgsDict']]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCpeDeviceShapesResult:
    """
    This data source provides the list of Cpe Device Shapes in Oracle Cloud Infrastructure Core service.

    Lists the CPE device types that the Networking service provides CPE configuration
    content for (example: Cisco ASA). The content helps a network engineer configure
    the actual CPE device represented by a [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object.

    If you want to generate CPE configuration content for one of the returned CPE device types,
    ensure that the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object's `cpeDeviceShapeId` attribute is set
    to the CPE device type's [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) (returned by this operation).

    For information about generating CPE configuration content, see these operations:

      * [GetCpeDeviceConfigContent](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/GetCpeDeviceConfigContent)
      * [GetIpsecCpeDeviceConfigContent](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnection/GetIpsecCpeDeviceConfigContent)
      * [GetTunnelCpeDeviceConfigContent](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/TunnelCpeDeviceConfig/GetTunnelCpeDeviceConfigContent)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cpe_device_shapes = oci.Core.get_cpe_device_shapes()
    ```
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getCpeDeviceShapes:getCpeDeviceShapes', __args__, opts=opts, typ=GetCpeDeviceShapesResult).value

    return AwaitableGetCpeDeviceShapesResult(
        cpe_device_shapes=pulumi.get(__ret__, 'cpe_device_shapes'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_cpe_device_shapes_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCpeDeviceShapesFilterArgs', 'GetCpeDeviceShapesFilterArgsDict']]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCpeDeviceShapesResult]:
    """
    This data source provides the list of Cpe Device Shapes in Oracle Cloud Infrastructure Core service.

    Lists the CPE device types that the Networking service provides CPE configuration
    content for (example: Cisco ASA). The content helps a network engineer configure
    the actual CPE device represented by a [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object.

    If you want to generate CPE configuration content for one of the returned CPE device types,
    ensure that the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object's `cpeDeviceShapeId` attribute is set
    to the CPE device type's [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) (returned by this operation).

    For information about generating CPE configuration content, see these operations:

      * [GetCpeDeviceConfigContent](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/GetCpeDeviceConfigContent)
      * [GetIpsecCpeDeviceConfigContent](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnection/GetIpsecCpeDeviceConfigContent)
      * [GetTunnelCpeDeviceConfigContent](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/TunnelCpeDeviceConfig/GetTunnelCpeDeviceConfigContent)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cpe_device_shapes = oci.Core.get_cpe_device_shapes()
    ```
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getCpeDeviceShapes:getCpeDeviceShapes', __args__, opts=opts, typ=GetCpeDeviceShapesResult)
    return __ret__.apply(lambda __response__: GetCpeDeviceShapesResult(
        cpe_device_shapes=pulumi.get(__response__, 'cpe_device_shapes'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
