# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbSystemArgs', 'DbSystem']

@pulumi.input_type
class DbSystemArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 db_home: pulumi.Input['DbSystemDbHomeArgs'],
                 hostname: pulumi.Input[str],
                 shape: pulumi.Input[str],
                 ssh_public_keys: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnet_id: pulumi.Input[str],
                 backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_subnet_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 data_collection_options: Optional[pulumi.Input['DbSystemDataCollectionOptionsArgs']] = None,
                 data_storage_percentage: Optional[pulumi.Input[int]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 database_edition: Optional[pulumi.Input[str]] = None,
                 db_system_options: Optional[pulumi.Input['DbSystemDbSystemOptionsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disk_redundancy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kms_key_version_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 maintenance_window_details: Optional[pulumi.Input['DbSystemMaintenanceWindowDetailsArgs']] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 private_ip_v6: Optional[pulumi.Input[str]] = None,
                 reco_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_db_system_id: Optional[pulumi.Input[str]] = None,
                 sparse_diskgroup: Optional[pulumi.Input[bool]] = None,
                 storage_volume_performance_mode: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DbSystem resource.
        :param pulumi.Input[str] availability_domain: The availability domain where the DB system is located.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment the DB system  belongs in.
        :param pulumi.Input['DbSystemDbHomeArgs'] db_home: (Updatable) Details for creating a Database Home if you are creating a database by restoring from a database backup.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[str] hostname: The hostname for the DB system. The hostname must begin with an alphabetic character, and can contain alphanumeric characters and hyphens (-). The maximum length of the hostname is 16 characters for bare metal and virtual machine DB systems, and 12 characters for Exadata DB systems.
               
               The maximum length of the combined hostname and domain is 63 characters.
               
               **Note:** The hostname must be unique within the subnet. If it is not unique, the DB system will fail to provision.
        :param pulumi.Input[str] shape: (Updatable) The shape of the DB system. The shape determines resources allocated to the DB system.
               * For virtual machine shapes, the number of CPU cores and memory
               * For bare metal and Exadata shapes, the number of CPU cores, memory, and storage
               
               To get a list of shapes, use the [ListDbSystemShapes](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbSystemShapeSummary/ListDbSystemShapes) operation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_public_keys: (Updatable) The public key portion of the key pair to use for SSH access to the DB system. Multiple public keys can be provided. The length of the combined keys cannot exceed 40,000 characters.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the DB system is associated with.
               
               **Subnet Restrictions:**
               * For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
               * For Exadata and virtual machine 2-node RAC DB systems, do not use a subnet that overlaps with 192.168.128.0/20.
               
               These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and the backup subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_network_nsg_ids: (Updatable) A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        :param pulumi.Input[str] backup_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet the DB system is associated with. Applicable only to Exadata DB systems.
               
               **Subnet Restrictions:** See the subnet restrictions information for **subnetId**.
        :param pulumi.Input[str] cluster_name: The cluster name for Exadata and 2-node RAC virtual machine DB systems. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        :param pulumi.Input[int] cpu_core_count: (Updatable) The number of CPU cores to enable for a bare metal or Exadata DB system or AMD VMDB Systems. The valid values depend on the specified shape:
               * BM.DenseIO1.36 - Specify a multiple of 2, from 2 to 36.
               * BM.DenseIO2.52 - Specify a multiple of 2, from 2 to 52.
               * Exadata.Base.48 - Specify a multiple of 2, from 0 to 48.
               * Exadata.Quarter1.84 - Specify a multiple of 2, from 22 to 84.
               * Exadata.Half1.168 - Specify a multiple of 4, from 44 to 168.
               * Exadata.Full1.336 - Specify a multiple of 8, from 88 to 336.
               * Exadata.Quarter2.92 - Specify a multiple of 2, from 0 to 92.
               * Exadata.Half2.184 - Specify a multiple of 4, from 0 to 184.
               * Exadata.Full2.368 - Specify a multiple of 8, from 0 to 368.
               * VM.Standard.E4.Flex - Specify any thing from 1 to 64.
               
               This parameter is not used for INTEL virtual machine DB systems because virtual machine DB systems have a set number of cores for each shape. For information about the number of cores for a virtual machine DB system shape, see [Virtual Machine DB Systems](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/overview.htm#virtualmachine)
        :param pulumi.Input['DbSystemDataCollectionOptionsArgs'] data_collection_options: (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[int] data_storage_percentage: The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Specify 80 or 40. The default is 80 percent assigned to DATA storage. Not applicable for virtual machine DB systems. Required for BMDBs.
        :param pulumi.Input[int] data_storage_size_in_gb: (Updatable) Size (in GB) of the initial data volume that will be created and attached to a virtual machine DB system. You can scale up storage after provisioning, as needed. Note that the total storage size attached will be more than the amount you specify to allow for REDO/RECO space and software volume. Required for VMDBs.
        :param pulumi.Input[str] database_edition: The Oracle Database Edition that applies to all the databases on the DB system. Exadata DB systems and 2-node RAC DB systems require ENTERPRISE_EDITION_EXTREME_PERFORMANCE.
        :param pulumi.Input['DbSystemDbSystemOptionsArgs'] db_system_options: The DB system options.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] disk_redundancy: The type of redundancy configured for the DB system. Normal is 2-way redundancy, recommended for test and development systems. High is 3-way redundancy, recommended for production systems.
        :param pulumi.Input[str] display_name: The user-friendly name for the DB system. The name does not have to be unique.
        :param pulumi.Input[str] domain: A domain name used for the DB system. If the Oracle-provided Internet and VCN Resolver is enabled for the specified subnet, the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fault_domains: A Fault Domain is a grouping of hardware and infrastructure within an availability domain. Fault Domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or maintenance that affects one Fault Domain does not affect DB systems in other Fault Domains.
               
               If you do not specify the Fault Domain, the system selects one for you. To change the Fault Domain for a DB system, terminate it and launch a new DB system in the preferred Fault Domain.
               
               If the node count is greater than 1, you can specify which Fault Domains these nodes will be distributed into. The system assigns your nodes automatically to the Fault Domains you specify so that no Fault Domain contains more than one node.
               
               To get a list of Fault Domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/latest/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to all the databases on the DB system. The default is LICENSE_INCLUDED.
        :param pulumi.Input['DbSystemMaintenanceWindowDetailsArgs'] maintenance_window_details: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] node_count: The number of nodes to launch for a 2-node RAC virtual machine DB system. Specify either 1 or 2.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[str] private_ip: A private IP address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. Supported for VM BM shape.
        :param pulumi.Input[str] private_ip_v6: A private IPv6 address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value and the subnet is dual stack, Oracle automatically assigns a private IPv6 address from the subnet.
        :param pulumi.Input[int] reco_storage_size_in_gb: The RECO/REDO storage size, in gigabytes, that is currently allocated to the DB system. Applies only for virtual machine DB systems.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] security_attributes: (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param pulumi.Input[str] source: The source of the database: Use `NONE` for creating a new database. Use `DB_BACKUP` for creating a new database by restoring from a backup. Use `DATABASE` for creating a new database from an existing database, including archive redo log data. The default is `NONE`.
        :param pulumi.Input[str] source_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[bool] sparse_diskgroup: If true, Sparse Diskgroup is configured for Exadata dbsystem. If False, Sparse diskgroup is not configured. Only applied for Exadata shape.
        :param pulumi.Input[str] storage_volume_performance_mode: The block storage volume performance level. Valid values are `BALANCED` and `HIGH_PERFORMANCE`. See [Block Volume Performance](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm) for more information.
        :param pulumi.Input[str] time_zone: The time zone to use for the DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "db_home", db_home)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if backup_network_nsg_ids is not None:
            pulumi.set(__self__, "backup_network_nsg_ids", backup_network_nsg_ids)
        if backup_subnet_id is not None:
            pulumi.set(__self__, "backup_subnet_id", backup_subnet_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if data_collection_options is not None:
            pulumi.set(__self__, "data_collection_options", data_collection_options)
        if data_storage_percentage is not None:
            pulumi.set(__self__, "data_storage_percentage", data_storage_percentage)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if database_edition is not None:
            pulumi.set(__self__, "database_edition", database_edition)
        if db_system_options is not None:
            pulumi.set(__self__, "db_system_options", db_system_options)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if disk_redundancy is not None:
            pulumi.set(__self__, "disk_redundancy", disk_redundancy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if fault_domains is not None:
            pulumi.set(__self__, "fault_domains", fault_domains)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if maintenance_window_details is not None:
            pulumi.set(__self__, "maintenance_window_details", maintenance_window_details)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_ip_v6 is not None:
            pulumi.set(__self__, "private_ip_v6", private_ip_v6)
        if reco_storage_size_in_gb is not None:
            pulumi.set(__self__, "reco_storage_size_in_gb", reco_storage_size_in_gb)
        if security_attributes is not None:
            pulumi.set(__self__, "security_attributes", security_attributes)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_db_system_id is not None:
            pulumi.set(__self__, "source_db_system_id", source_db_system_id)
        if sparse_diskgroup is not None:
            pulumi.set(__self__, "sparse_diskgroup", sparse_diskgroup)
        if storage_volume_performance_mode is not None:
            pulumi.set(__self__, "storage_volume_performance_mode", storage_volume_performance_mode)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[str]:
        """
        The availability domain where the DB system is located.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment the DB system  belongs in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dbHome")
    def db_home(self) -> pulumi.Input['DbSystemDbHomeArgs']:
        """
        (Updatable) Details for creating a Database Home if you are creating a database by restoring from a database backup.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "db_home")

    @db_home.setter
    def db_home(self, value: pulumi.Input['DbSystemDbHomeArgs']):
        pulumi.set(self, "db_home", value)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        The hostname for the DB system. The hostname must begin with an alphabetic character, and can contain alphanumeric characters and hyphens (-). The maximum length of the hostname is 16 characters for bare metal and virtual machine DB systems, and 12 characters for Exadata DB systems.

        The maximum length of the combined hostname and domain is 63 characters.

        **Note:** The hostname must be unique within the subnet. If it is not unique, the DB system will fail to provision.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Input[str]:
        """
        (Updatable) The shape of the DB system. The shape determines resources allocated to the DB system.
        * For virtual machine shapes, the number of CPU cores and memory
        * For bare metal and Exadata shapes, the number of CPU cores, memory, and storage

        To get a list of shapes, use the [ListDbSystemShapes](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbSystemShapeSummary/ListDbSystemShapes) operation.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: pulumi.Input[str]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) The public key portion of the key pair to use for SSH access to the DB system. Multiple public keys can be provided. The length of the combined keys cannot exceed 40,000 characters.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the DB system is associated with.

        **Subnet Restrictions:**
        * For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
        * For Exadata and virtual machine 2-node RAC DB systems, do not use a subnet that overlaps with 192.168.128.0/20.

        These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and the backup subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="backupNetworkNsgIds")
    def backup_network_nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        """
        return pulumi.get(self, "backup_network_nsg_ids")

    @backup_network_nsg_ids.setter
    def backup_network_nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "backup_network_nsg_ids", value)

    @property
    @pulumi.getter(name="backupSubnetId")
    def backup_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet the DB system is associated with. Applicable only to Exadata DB systems.

        **Subnet Restrictions:** See the subnet restrictions information for **subnetId**.
        """
        return pulumi.get(self, "backup_subnet_id")

    @backup_subnet_id.setter
    def backup_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_subnet_id", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster name for Exadata and 2-node RAC virtual machine DB systems. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of CPU cores to enable for a bare metal or Exadata DB system or AMD VMDB Systems. The valid values depend on the specified shape:
        * BM.DenseIO1.36 - Specify a multiple of 2, from 2 to 36.
        * BM.DenseIO2.52 - Specify a multiple of 2, from 2 to 52.
        * Exadata.Base.48 - Specify a multiple of 2, from 0 to 48.
        * Exadata.Quarter1.84 - Specify a multiple of 2, from 22 to 84.
        * Exadata.Half1.168 - Specify a multiple of 4, from 44 to 168.
        * Exadata.Full1.336 - Specify a multiple of 8, from 88 to 336.
        * Exadata.Quarter2.92 - Specify a multiple of 2, from 0 to 92.
        * Exadata.Half2.184 - Specify a multiple of 4, from 0 to 184.
        * Exadata.Full2.368 - Specify a multiple of 8, from 0 to 368.
        * VM.Standard.E4.Flex - Specify any thing from 1 to 64.

        This parameter is not used for INTEL virtual machine DB systems because virtual machine DB systems have a set number of cores for each shape. For information about the number of cores for a virtual machine DB system shape, see [Virtual Machine DB Systems](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/overview.htm#virtualmachine)
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Optional[pulumi.Input['DbSystemDataCollectionOptionsArgs']]:
        """
        (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @data_collection_options.setter
    def data_collection_options(self, value: Optional[pulumi.Input['DbSystemDataCollectionOptionsArgs']]):
        pulumi.set(self, "data_collection_options", value)

    @property
    @pulumi.getter(name="dataStoragePercentage")
    def data_storage_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Specify 80 or 40. The default is 80 percent assigned to DATA storage. Not applicable for virtual machine DB systems. Required for BMDBs.
        """
        return pulumi.get(self, "data_storage_percentage")

    @data_storage_percentage.setter
    def data_storage_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_storage_percentage", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Size (in GB) of the initial data volume that will be created and attached to a virtual machine DB system. You can scale up storage after provisioning, as needed. Note that the total storage size attached will be more than the amount you specify to allow for REDO/RECO space and software volume. Required for VMDBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Database Edition that applies to all the databases on the DB system. Exadata DB systems and 2-node RAC DB systems require ENTERPRISE_EDITION_EXTREME_PERFORMANCE.
        """
        return pulumi.get(self, "database_edition")

    @database_edition.setter
    def database_edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_edition", value)

    @property
    @pulumi.getter(name="dbSystemOptions")
    def db_system_options(self) -> Optional[pulumi.Input['DbSystemDbSystemOptionsArgs']]:
        """
        The DB system options.
        """
        return pulumi.get(self, "db_system_options")

    @db_system_options.setter
    def db_system_options(self, value: Optional[pulumi.Input['DbSystemDbSystemOptionsArgs']]):
        pulumi.set(self, "db_system_options", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="diskRedundancy")
    def disk_redundancy(self) -> Optional[pulumi.Input[str]]:
        """
        The type of redundancy configured for the DB system. Normal is 2-way redundancy, recommended for test and development systems. High is 3-way redundancy, recommended for production systems.
        """
        return pulumi.get(self, "disk_redundancy")

    @disk_redundancy.setter
    def disk_redundancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_redundancy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        A domain name used for the DB system. If the Oracle-provided Internet and VCN Resolver is enabled for the specified subnet, the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A Fault Domain is a grouping of hardware and infrastructure within an availability domain. Fault Domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or maintenance that affects one Fault Domain does not affect DB systems in other Fault Domains.

        If you do not specify the Fault Domain, the system selects one for you. To change the Fault Domain for a DB system, terminate it and launch a new DB system in the preferred Fault Domain.

        If the node count is greater than 1, you can specify which Fault Domains these nodes will be distributed into. The system assigns your nodes automatically to the Fault Domains you specify so that no Fault Domain contains more than one node.

        To get a list of Fault Domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/latest/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.

        Example: `FAULT-DOMAIN-1`
        """
        return pulumi.get(self, "fault_domains")

    @fault_domains.setter
    def fault_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fault_domains", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        """
        return pulumi.get(self, "kms_key_version_id")

    @kms_key_version_id.setter
    def kms_key_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_version_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle license model that applies to all the databases on the DB system. The default is LICENSE_INCLUDED.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="maintenanceWindowDetails")
    def maintenance_window_details(self) -> Optional[pulumi.Input['DbSystemMaintenanceWindowDetailsArgs']]:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window_details")

    @maintenance_window_details.setter
    def maintenance_window_details(self, value: Optional[pulumi.Input['DbSystemMaintenanceWindowDetailsArgs']]):
        pulumi.set(self, "maintenance_window_details", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes to launch for a 2-node RAC virtual machine DB system. Specify either 1 or 2.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        A private IP address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. Supported for VM BM shape.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="privateIpV6")
    def private_ip_v6(self) -> Optional[pulumi.Input[str]]:
        """
        A private IPv6 address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value and the subnet is dual stack, Oracle automatically assigns a private IPv6 address from the subnet.
        """
        return pulumi.get(self, "private_ip_v6")

    @private_ip_v6.setter
    def private_ip_v6(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_v6", value)

    @property
    @pulumi.getter(name="recoStorageSizeInGb")
    def reco_storage_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The RECO/REDO storage size, in gigabytes, that is currently allocated to the DB system. Applies only for virtual machine DB systems.
        """
        return pulumi.get(self, "reco_storage_size_in_gb")

    @reco_storage_size_in_gb.setter
    def reco_storage_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reco_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @security_attributes.setter
    def security_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "security_attributes", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source of the database: Use `NONE` for creating a new database. Use `DB_BACKUP` for creating a new database by restoring from a backup. Use `DATABASE` for creating a new database from an existing database, including archive redo log data. The default is `NONE`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceDbSystemId")
    def source_db_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "source_db_system_id")

    @source_db_system_id.setter
    def source_db_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_db_system_id", value)

    @property
    @pulumi.getter(name="sparseDiskgroup")
    def sparse_diskgroup(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, Sparse Diskgroup is configured for Exadata dbsystem. If False, Sparse diskgroup is not configured. Only applied for Exadata shape.
        """
        return pulumi.get(self, "sparse_diskgroup")

    @sparse_diskgroup.setter
    def sparse_diskgroup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sparse_diskgroup", value)

    @property
    @pulumi.getter(name="storageVolumePerformanceMode")
    def storage_volume_performance_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The block storage volume performance level. Valid values are `BALANCED` and `HIGH_PERFORMANCE`. See [Block Volume Performance](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm) for more information.
        """
        return pulumi.get(self, "storage_volume_performance_mode")

    @storage_volume_performance_mode.setter
    def storage_volume_performance_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_volume_performance_mode", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone to use for the DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _DbSystemState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_subnet_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 data_collection_options: Optional[pulumi.Input['DbSystemDataCollectionOptionsArgs']] = None,
                 data_storage_percentage: Optional[pulumi.Input[int]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 database_edition: Optional[pulumi.Input[str]] = None,
                 db_home: Optional[pulumi.Input['DbSystemDbHomeArgs']] = None,
                 db_system_options: Optional[pulumi.Input['DbSystemDbSystemOptionsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disk_redundancy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 iorm_config_caches: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemIormConfigCachArgs']]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kms_key_version_id: Optional[pulumi.Input[str]] = None,
                 last_maintenance_run_id: Optional[pulumi.Input[str]] = None,
                 last_patch_history_entry_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 listener_port: Optional[pulumi.Input[int]] = None,
                 maintenance_window_details: Optional[pulumi.Input['DbSystemMaintenanceWindowDetailsArgs']] = None,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemMaintenanceWindowArgs']]]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 next_maintenance_run_id: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_version: Optional[pulumi.Input[str]] = None,
                 point_in_time_data_disk_clone_timestamp: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 private_ip_v6: Optional[pulumi.Input[str]] = None,
                 reco_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 scan_dns_name: Optional[pulumi.Input[str]] = None,
                 scan_dns_record_id: Optional[pulumi.Input[str]] = None,
                 scan_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scan_ipv6ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_db_system_id: Optional[pulumi.Input[str]] = None,
                 sparse_diskgroup: Optional[pulumi.Input[bool]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage_volume_performance_mode: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vipv6ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DbSystem resources.
        :param pulumi.Input[str] availability_domain: The availability domain where the DB system is located.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_network_nsg_ids: (Updatable) A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        :param pulumi.Input[str] backup_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet the DB system is associated with. Applicable only to Exadata DB systems.
               
               **Subnet Restrictions:** See the subnet restrictions information for **subnetId**.
        :param pulumi.Input[str] cluster_name: The cluster name for Exadata and 2-node RAC virtual machine DB systems. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment the DB system  belongs in.
        :param pulumi.Input[int] cpu_core_count: (Updatable) The number of CPU cores to enable for a bare metal or Exadata DB system or AMD VMDB Systems. The valid values depend on the specified shape:
               * BM.DenseIO1.36 - Specify a multiple of 2, from 2 to 36.
               * BM.DenseIO2.52 - Specify a multiple of 2, from 2 to 52.
               * Exadata.Base.48 - Specify a multiple of 2, from 0 to 48.
               * Exadata.Quarter1.84 - Specify a multiple of 2, from 22 to 84.
               * Exadata.Half1.168 - Specify a multiple of 4, from 44 to 168.
               * Exadata.Full1.336 - Specify a multiple of 8, from 88 to 336.
               * Exadata.Quarter2.92 - Specify a multiple of 2, from 0 to 92.
               * Exadata.Half2.184 - Specify a multiple of 4, from 0 to 184.
               * Exadata.Full2.368 - Specify a multiple of 8, from 0 to 368.
               * VM.Standard.E4.Flex - Specify any thing from 1 to 64.
               
               This parameter is not used for INTEL virtual machine DB systems because virtual machine DB systems have a set number of cores for each shape. For information about the number of cores for a virtual machine DB system shape, see [Virtual Machine DB Systems](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/overview.htm#virtualmachine)
        :param pulumi.Input['DbSystemDataCollectionOptionsArgs'] data_collection_options: (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[int] data_storage_percentage: The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Specify 80 or 40. The default is 80 percent assigned to DATA storage. Not applicable for virtual machine DB systems. Required for BMDBs.
        :param pulumi.Input[int] data_storage_size_in_gb: (Updatable) Size (in GB) of the initial data volume that will be created and attached to a virtual machine DB system. You can scale up storage after provisioning, as needed. Note that the total storage size attached will be more than the amount you specify to allow for REDO/RECO space and software volume. Required for VMDBs.
        :param pulumi.Input[str] database_edition: The Oracle Database Edition that applies to all the databases on the DB system. Exadata DB systems and 2-node RAC DB systems require ENTERPRISE_EDITION_EXTREME_PERFORMANCE.
        :param pulumi.Input['DbSystemDbHomeArgs'] db_home: (Updatable) Details for creating a Database Home if you are creating a database by restoring from a database backup.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input['DbSystemDbSystemOptionsArgs'] db_system_options: The DB system options.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] disk_redundancy: The type of redundancy configured for the DB system. Normal is 2-way redundancy, recommended for test and development systems. High is 3-way redundancy, recommended for production systems.
        :param pulumi.Input[str] display_name: The user-friendly name for the DB system. The name does not have to be unique.
        :param pulumi.Input[str] domain: A domain name used for the DB system. If the Oracle-provided Internet and VCN Resolver is enabled for the specified subnet, the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fault_domains: A Fault Domain is a grouping of hardware and infrastructure within an availability domain. Fault Domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or maintenance that affects one Fault Domain does not affect DB systems in other Fault Domains.
               
               If you do not specify the Fault Domain, the system selects one for you. To change the Fault Domain for a DB system, terminate it and launch a new DB system in the preferred Fault Domain.
               
               If the node count is greater than 1, you can specify which Fault Domains these nodes will be distributed into. The system assigns your nodes automatically to the Fault Domains you specify so that no Fault Domain contains more than one node.
               
               To get a list of Fault Domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/latest/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hostname: The hostname for the DB system. The hostname must begin with an alphabetic character, and can contain alphanumeric characters and hyphens (-). The maximum length of the hostname is 16 characters for bare metal and virtual machine DB systems, and 12 characters for Exadata DB systems.
               
               The maximum length of the combined hostname and domain is 63 characters.
               
               **Note:** The hostname must be unique within the subnet. If it is not unique, the DB system will fail to provision.
        :param pulumi.Input[Sequence[pulumi.Input['DbSystemIormConfigCachArgs']]] iorm_config_caches: The IORM settings of the Exadata DB system.
        :param pulumi.Input[str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        :param pulumi.Input[str] last_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        :param pulumi.Input[str] last_patch_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to all the databases on the DB system. The default is LICENSE_INCLUDED.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[int] listener_port: The port number configured for the listener on the DB system.
        :param pulumi.Input['DbSystemMaintenanceWindowDetailsArgs'] maintenance_window_details: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[Sequence[pulumi.Input['DbSystemMaintenanceWindowArgs']]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] memory_size_in_gbs: Memory allocated to the DB system, in gigabytes.
        :param pulumi.Input[str] next_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        :param pulumi.Input[int] node_count: The number of nodes to launch for a 2-node RAC virtual machine DB system. Specify either 1 or 2.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[str] os_version: The most recent OS Patch Version applied on the DB system.
        :param pulumi.Input[str] point_in_time_data_disk_clone_timestamp: The point in time for a cloned database system when the data disks were cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[str] private_ip: A private IP address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. Supported for VM BM shape.
        :param pulumi.Input[str] private_ip_v6: A private IPv6 address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value and the subnet is dual stack, Oracle automatically assigns a private IPv6 address from the subnet.
        :param pulumi.Input[int] reco_storage_size_in_gb: The RECO/REDO storage size, in gigabytes, that is currently allocated to the DB system. Applies only for virtual machine DB systems.
        :param pulumi.Input[str] scan_dns_name: The FQDN of the DNS record for the SCAN IP addresses that are associated with the DB system.
        :param pulumi.Input[str] scan_dns_record_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DNS record for the SCAN IP addresses that are associated with the DB system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scan_ip_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IPv4 addresses associated with the DB system. SCAN IPv4 addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scan_ipv6ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IPv6 addresses associated with the DB system. SCAN IPv6 addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] security_attributes: (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param pulumi.Input[str] shape: (Updatable) The shape of the DB system. The shape determines resources allocated to the DB system.
               * For virtual machine shapes, the number of CPU cores and memory
               * For bare metal and Exadata shapes, the number of CPU cores, memory, and storage
               
               To get a list of shapes, use the [ListDbSystemShapes](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbSystemShapeSummary/ListDbSystemShapes) operation.
        :param pulumi.Input[str] source: The source of the database: Use `NONE` for creating a new database. Use `DB_BACKUP` for creating a new database by restoring from a backup. Use `DATABASE` for creating a new database from an existing database, including archive redo log data. The default is `NONE`.
        :param pulumi.Input[str] source_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[bool] sparse_diskgroup: If true, Sparse Diskgroup is configured for Exadata dbsystem. If False, Sparse diskgroup is not configured. Only applied for Exadata shape.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_public_keys: (Updatable) The public key portion of the key pair to use for SSH access to the DB system. Multiple public keys can be provided. The length of the combined keys cannot exceed 40,000 characters.
        :param pulumi.Input[str] state: The current state of the DB system.
        :param pulumi.Input[str] storage_volume_performance_mode: The block storage volume performance level. Valid values are `BALANCED` and `HIGH_PERFORMANCE`. See [Block Volume Performance](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm) for more information.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the DB system is associated with.
               
               **Subnet Restrictions:**
               * For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
               * For Exadata and virtual machine 2-node RAC DB systems, do not use a subnet that overlaps with 192.168.128.0/20.
               
               These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and the backup subnet.
        :param pulumi.Input[str] time_created: The date and time the DB system was created.
        :param pulumi.Input[str] time_zone: The time zone to use for the DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] version: The Oracle Database version of the DB system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vip_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IPv4 (VIP) addresses associated with the DB system. The Cluster Ready Services (CRS) creates and maintains one VIPv4 address for each node in the DB system to enable failover. If one node fails, the VIPv4 is reassigned to another active node in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vipv6ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IPv6 (VIP) addresses associated with the DB system. The Cluster Ready Services (CRS) creates and maintains one VIP IpV6 address for each node in the DB system to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
        :param pulumi.Input[str] zone_id: The OCID of the zone the DB system is associated with.
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_network_nsg_ids is not None:
            pulumi.set(__self__, "backup_network_nsg_ids", backup_network_nsg_ids)
        if backup_subnet_id is not None:
            pulumi.set(__self__, "backup_subnet_id", backup_subnet_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if data_collection_options is not None:
            pulumi.set(__self__, "data_collection_options", data_collection_options)
        if data_storage_percentage is not None:
            pulumi.set(__self__, "data_storage_percentage", data_storage_percentage)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if database_edition is not None:
            pulumi.set(__self__, "database_edition", database_edition)
        if db_home is not None:
            pulumi.set(__self__, "db_home", db_home)
        if db_system_options is not None:
            pulumi.set(__self__, "db_system_options", db_system_options)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if disk_redundancy is not None:
            pulumi.set(__self__, "disk_redundancy", disk_redundancy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if fault_domains is not None:
            pulumi.set(__self__, "fault_domains", fault_domains)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if iorm_config_caches is not None:
            pulumi.set(__self__, "iorm_config_caches", iorm_config_caches)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if last_maintenance_run_id is not None:
            pulumi.set(__self__, "last_maintenance_run_id", last_maintenance_run_id)
        if last_patch_history_entry_id is not None:
            pulumi.set(__self__, "last_patch_history_entry_id", last_patch_history_entry_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if listener_port is not None:
            pulumi.set(__self__, "listener_port", listener_port)
        if maintenance_window_details is not None:
            pulumi.set(__self__, "maintenance_window_details", maintenance_window_details)
        if maintenance_windows is not None:
            pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if next_maintenance_run_id is not None:
            pulumi.set(__self__, "next_maintenance_run_id", next_maintenance_run_id)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if point_in_time_data_disk_clone_timestamp is not None:
            pulumi.set(__self__, "point_in_time_data_disk_clone_timestamp", point_in_time_data_disk_clone_timestamp)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_ip_v6 is not None:
            pulumi.set(__self__, "private_ip_v6", private_ip_v6)
        if reco_storage_size_in_gb is not None:
            pulumi.set(__self__, "reco_storage_size_in_gb", reco_storage_size_in_gb)
        if scan_dns_name is not None:
            pulumi.set(__self__, "scan_dns_name", scan_dns_name)
        if scan_dns_record_id is not None:
            pulumi.set(__self__, "scan_dns_record_id", scan_dns_record_id)
        if scan_ip_ids is not None:
            pulumi.set(__self__, "scan_ip_ids", scan_ip_ids)
        if scan_ipv6ids is not None:
            pulumi.set(__self__, "scan_ipv6ids", scan_ipv6ids)
        if security_attributes is not None:
            pulumi.set(__self__, "security_attributes", security_attributes)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_db_system_id is not None:
            pulumi.set(__self__, "source_db_system_id", source_db_system_id)
        if sparse_diskgroup is not None:
            pulumi.set(__self__, "sparse_diskgroup", sparse_diskgroup)
        if ssh_public_keys is not None:
            pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_volume_performance_mode is not None:
            pulumi.set(__self__, "storage_volume_performance_mode", storage_volume_performance_mode)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vip_ids is not None:
            pulumi.set(__self__, "vip_ids", vip_ids)
        if vipv6ids is not None:
            pulumi.set(__self__, "vipv6ids", vipv6ids)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain where the DB system is located.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="backupNetworkNsgIds")
    def backup_network_nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        """
        return pulumi.get(self, "backup_network_nsg_ids")

    @backup_network_nsg_ids.setter
    def backup_network_nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "backup_network_nsg_ids", value)

    @property
    @pulumi.getter(name="backupSubnetId")
    def backup_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet the DB system is associated with. Applicable only to Exadata DB systems.

        **Subnet Restrictions:** See the subnet restrictions information for **subnetId**.
        """
        return pulumi.get(self, "backup_subnet_id")

    @backup_subnet_id.setter
    def backup_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_subnet_id", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster name for Exadata and 2-node RAC virtual machine DB systems. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment the DB system  belongs in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of CPU cores to enable for a bare metal or Exadata DB system or AMD VMDB Systems. The valid values depend on the specified shape:
        * BM.DenseIO1.36 - Specify a multiple of 2, from 2 to 36.
        * BM.DenseIO2.52 - Specify a multiple of 2, from 2 to 52.
        * Exadata.Base.48 - Specify a multiple of 2, from 0 to 48.
        * Exadata.Quarter1.84 - Specify a multiple of 2, from 22 to 84.
        * Exadata.Half1.168 - Specify a multiple of 4, from 44 to 168.
        * Exadata.Full1.336 - Specify a multiple of 8, from 88 to 336.
        * Exadata.Quarter2.92 - Specify a multiple of 2, from 0 to 92.
        * Exadata.Half2.184 - Specify a multiple of 4, from 0 to 184.
        * Exadata.Full2.368 - Specify a multiple of 8, from 0 to 368.
        * VM.Standard.E4.Flex - Specify any thing from 1 to 64.

        This parameter is not used for INTEL virtual machine DB systems because virtual machine DB systems have a set number of cores for each shape. For information about the number of cores for a virtual machine DB system shape, see [Virtual Machine DB Systems](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/overview.htm#virtualmachine)
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Optional[pulumi.Input['DbSystemDataCollectionOptionsArgs']]:
        """
        (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @data_collection_options.setter
    def data_collection_options(self, value: Optional[pulumi.Input['DbSystemDataCollectionOptionsArgs']]):
        pulumi.set(self, "data_collection_options", value)

    @property
    @pulumi.getter(name="dataStoragePercentage")
    def data_storage_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Specify 80 or 40. The default is 80 percent assigned to DATA storage. Not applicable for virtual machine DB systems. Required for BMDBs.
        """
        return pulumi.get(self, "data_storage_percentage")

    @data_storage_percentage.setter
    def data_storage_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_storage_percentage", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Size (in GB) of the initial data volume that will be created and attached to a virtual machine DB system. You can scale up storage after provisioning, as needed. Note that the total storage size attached will be more than the amount you specify to allow for REDO/RECO space and software volume. Required for VMDBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Database Edition that applies to all the databases on the DB system. Exadata DB systems and 2-node RAC DB systems require ENTERPRISE_EDITION_EXTREME_PERFORMANCE.
        """
        return pulumi.get(self, "database_edition")

    @database_edition.setter
    def database_edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_edition", value)

    @property
    @pulumi.getter(name="dbHome")
    def db_home(self) -> Optional[pulumi.Input['DbSystemDbHomeArgs']]:
        """
        (Updatable) Details for creating a Database Home if you are creating a database by restoring from a database backup.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "db_home")

    @db_home.setter
    def db_home(self, value: Optional[pulumi.Input['DbSystemDbHomeArgs']]):
        pulumi.set(self, "db_home", value)

    @property
    @pulumi.getter(name="dbSystemOptions")
    def db_system_options(self) -> Optional[pulumi.Input['DbSystemDbSystemOptionsArgs']]:
        """
        The DB system options.
        """
        return pulumi.get(self, "db_system_options")

    @db_system_options.setter
    def db_system_options(self, value: Optional[pulumi.Input['DbSystemDbSystemOptionsArgs']]):
        pulumi.set(self, "db_system_options", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="diskRedundancy")
    def disk_redundancy(self) -> Optional[pulumi.Input[str]]:
        """
        The type of redundancy configured for the DB system. Normal is 2-way redundancy, recommended for test and development systems. High is 3-way redundancy, recommended for production systems.
        """
        return pulumi.get(self, "disk_redundancy")

    @disk_redundancy.setter
    def disk_redundancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_redundancy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        A domain name used for the DB system. If the Oracle-provided Internet and VCN Resolver is enabled for the specified subnet, the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A Fault Domain is a grouping of hardware and infrastructure within an availability domain. Fault Domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or maintenance that affects one Fault Domain does not affect DB systems in other Fault Domains.

        If you do not specify the Fault Domain, the system selects one for you. To change the Fault Domain for a DB system, terminate it and launch a new DB system in the preferred Fault Domain.

        If the node count is greater than 1, you can specify which Fault Domains these nodes will be distributed into. The system assigns your nodes automatically to the Fault Domains you specify so that no Fault Domain contains more than one node.

        To get a list of Fault Domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/latest/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.

        Example: `FAULT-DOMAIN-1`
        """
        return pulumi.get(self, "fault_domains")

    @fault_domains.setter
    def fault_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fault_domains", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname for the DB system. The hostname must begin with an alphabetic character, and can contain alphanumeric characters and hyphens (-). The maximum length of the hostname is 16 characters for bare metal and virtual machine DB systems, and 12 characters for Exadata DB systems.

        The maximum length of the combined hostname and domain is 63 characters.

        **Note:** The hostname must be unique within the subnet. If it is not unique, the DB system will fail to provision.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="iormConfigCaches")
    def iorm_config_caches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemIormConfigCachArgs']]]]:
        """
        The IORM settings of the Exadata DB system.
        """
        return pulumi.get(self, "iorm_config_caches")

    @iorm_config_caches.setter
    def iorm_config_caches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemIormConfigCachArgs']]]]):
        pulumi.set(self, "iorm_config_caches", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        """
        return pulumi.get(self, "kms_key_version_id")

    @kms_key_version_id.setter
    def kms_key_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_version_id", value)

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @last_maintenance_run_id.setter
    def last_maintenance_run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_maintenance_run_id", value)

    @property
    @pulumi.getter(name="lastPatchHistoryEntryId")
    def last_patch_history_entry_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        """
        return pulumi.get(self, "last_patch_history_entry_id")

    @last_patch_history_entry_id.setter
    def last_patch_history_entry_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_patch_history_entry_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle license model that applies to all the databases on the DB system. The default is LICENSE_INCLUDED.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number configured for the listener on the DB system.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "listener_port", value)

    @property
    @pulumi.getter(name="maintenanceWindowDetails")
    def maintenance_window_details(self) -> Optional[pulumi.Input['DbSystemMaintenanceWindowDetailsArgs']]:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window_details")

    @maintenance_window_details.setter
    def maintenance_window_details(self, value: Optional[pulumi.Input['DbSystemMaintenanceWindowDetailsArgs']]):
        pulumi.set(self, "maintenance_window_details", value)

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemMaintenanceWindowArgs']]]]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @maintenance_windows.setter
    def maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemMaintenanceWindowArgs']]]]):
        pulumi.set(self, "maintenance_windows", value)

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        Memory allocated to the DB system, in gigabytes.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @next_maintenance_run_id.setter
    def next_maintenance_run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_maintenance_run_id", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes to launch for a 2-node RAC virtual machine DB system. Specify either 1 or 2.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        """
        The most recent OS Patch Version applied on the DB system.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)

    @property
    @pulumi.getter(name="pointInTimeDataDiskCloneTimestamp")
    def point_in_time_data_disk_clone_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        The point in time for a cloned database system when the data disks were cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "point_in_time_data_disk_clone_timestamp")

    @point_in_time_data_disk_clone_timestamp.setter
    def point_in_time_data_disk_clone_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "point_in_time_data_disk_clone_timestamp", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        A private IP address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. Supported for VM BM shape.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="privateIpV6")
    def private_ip_v6(self) -> Optional[pulumi.Input[str]]:
        """
        A private IPv6 address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value and the subnet is dual stack, Oracle automatically assigns a private IPv6 address from the subnet.
        """
        return pulumi.get(self, "private_ip_v6")

    @private_ip_v6.setter
    def private_ip_v6(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_v6", value)

    @property
    @pulumi.getter(name="recoStorageSizeInGb")
    def reco_storage_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The RECO/REDO storage size, in gigabytes, that is currently allocated to the DB system. Applies only for virtual machine DB systems.
        """
        return pulumi.get(self, "reco_storage_size_in_gb")

    @reco_storage_size_in_gb.setter
    def reco_storage_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reco_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="scanDnsName")
    def scan_dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The FQDN of the DNS record for the SCAN IP addresses that are associated with the DB system.
        """
        return pulumi.get(self, "scan_dns_name")

    @scan_dns_name.setter
    def scan_dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scan_dns_name", value)

    @property
    @pulumi.getter(name="scanDnsRecordId")
    def scan_dns_record_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DNS record for the SCAN IP addresses that are associated with the DB system.
        """
        return pulumi.get(self, "scan_dns_record_id")

    @scan_dns_record_id.setter
    def scan_dns_record_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scan_dns_record_id", value)

    @property
    @pulumi.getter(name="scanIpIds")
    def scan_ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IPv4 addresses associated with the DB system. SCAN IPv4 addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        """
        return pulumi.get(self, "scan_ip_ids")

    @scan_ip_ids.setter
    def scan_ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scan_ip_ids", value)

    @property
    @pulumi.getter(name="scanIpv6ids")
    def scan_ipv6ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IPv6 addresses associated with the DB system. SCAN IPv6 addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        """
        return pulumi.get(self, "scan_ipv6ids")

    @scan_ipv6ids.setter
    def scan_ipv6ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scan_ipv6ids", value)

    @property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @security_attributes.setter
    def security_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "security_attributes", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The shape of the DB system. The shape determines resources allocated to the DB system.
        * For virtual machine shapes, the number of CPU cores and memory
        * For bare metal and Exadata shapes, the number of CPU cores, memory, and storage

        To get a list of shapes, use the [ListDbSystemShapes](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbSystemShapeSummary/ListDbSystemShapes) operation.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source of the database: Use `NONE` for creating a new database. Use `DB_BACKUP` for creating a new database by restoring from a backup. Use `DATABASE` for creating a new database from an existing database, including archive redo log data. The default is `NONE`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceDbSystemId")
    def source_db_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "source_db_system_id")

    @source_db_system_id.setter
    def source_db_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_db_system_id", value)

    @property
    @pulumi.getter(name="sparseDiskgroup")
    def sparse_diskgroup(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, Sparse Diskgroup is configured for Exadata dbsystem. If False, Sparse diskgroup is not configured. Only applied for Exadata shape.
        """
        return pulumi.get(self, "sparse_diskgroup")

    @sparse_diskgroup.setter
    def sparse_diskgroup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sparse_diskgroup", value)

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The public key portion of the key pair to use for SSH access to the DB system. Multiple public keys can be provided. The length of the combined keys cannot exceed 40,000 characters.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the DB system.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageVolumePerformanceMode")
    def storage_volume_performance_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The block storage volume performance level. Valid values are `BALANCED` and `HIGH_PERFORMANCE`. See [Block Volume Performance](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm) for more information.
        """
        return pulumi.get(self, "storage_volume_performance_mode")

    @storage_volume_performance_mode.setter
    def storage_volume_performance_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_volume_performance_mode", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the DB system is associated with.

        **Subnet Restrictions:**
        * For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
        * For Exadata and virtual machine 2-node RAC DB systems, do not use a subnet that overlaps with 192.168.128.0/20.

        These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and the backup subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the DB system was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone to use for the DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Database version of the DB system.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vipIds")
    def vip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IPv4 (VIP) addresses associated with the DB system. The Cluster Ready Services (CRS) creates and maintains one VIPv4 address for each node in the DB system to enable failover. If one node fails, the VIPv4 is reassigned to another active node in the cluster.
        """
        return pulumi.get(self, "vip_ids")

    @vip_ids.setter
    def vip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vip_ids", value)

    @property
    @pulumi.getter
    def vipv6ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IPv6 (VIP) addresses associated with the DB system. The Cluster Ready Services (CRS) creates and maintains one VIP IpV6 address for each node in the DB system to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
        """
        return pulumi.get(self, "vipv6ids")

    @vipv6ids.setter
    def vipv6ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vipv6ids", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the zone the DB system is associated with.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class DbSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_subnet_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 data_collection_options: Optional[pulumi.Input[Union['DbSystemDataCollectionOptionsArgs', 'DbSystemDataCollectionOptionsArgsDict']]] = None,
                 data_storage_percentage: Optional[pulumi.Input[int]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 database_edition: Optional[pulumi.Input[str]] = None,
                 db_home: Optional[pulumi.Input[Union['DbSystemDbHomeArgs', 'DbSystemDbHomeArgsDict']]] = None,
                 db_system_options: Optional[pulumi.Input[Union['DbSystemDbSystemOptionsArgs', 'DbSystemDbSystemOptionsArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disk_redundancy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kms_key_version_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 maintenance_window_details: Optional[pulumi.Input[Union['DbSystemMaintenanceWindowDetailsArgs', 'DbSystemMaintenanceWindowDetailsArgsDict']]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 private_ip_v6: Optional[pulumi.Input[str]] = None,
                 reco_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_db_system_id: Optional[pulumi.Input[str]] = None,
                 sparse_diskgroup: Optional[pulumi.Input[bool]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_volume_performance_mode: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Db System resource in Oracle Cloud Infrastructure Database service.

        Creates a new DB system in the specified compartment and availability domain. The Oracle
        Database edition that you specify applies to all the databases on that DB system. The selected edition cannot be changed.

        An initial database is created on the DB system based on the request parameters you provide and some default
        options. For detailed information about default options, see [Bare metal and virtual machine DB system default options.](https://docs.cloud.oracle.com/iaas/Content/Database/Tasks/creatingDBsystem.htm#Default)

        **Note:** Deprecated for Exadata Cloud Service systems. Use the [new resource model APIs](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaflexsystem.htm#exaflexsystem_topic-resource_model) instead.

        For Exadata Cloud Service instances, support for this API will end on May 15th, 2021. See [Switching an Exadata DB System to the New Resource Model and APIs](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaflexsystem_topic-resource_model_conversion.htm) for details on converting existing Exadata DB systems to the new resource model.

        Use the [CreateCloudExadataInfrastructure](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudExadataInfrastructure/CreateCloudExadataInfrastructure/) and [CreateCloudVmCluster](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudVmCluster/CreateCloudVmCluster/) APIs to provision a new Exadata Cloud Service instance.

        **Important:** When `auto_backup_enabled` is not present in the configuration or set to true, the `auto_backup_window` and `auto_full_backup_window` will be ignored

        ## Import

        DbSystems can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/dbSystem:DbSystem test_db_system "id"
        ```

        Import is only supported for source=NONE

        `db_home.0.database.0.admin_password` is not returned by the service for security reasons. To avoid a force new of the db_home on the next apply, add the following to the resource:

            lifecycle {
            
                ignore_changes = ["db_home.0.database.0.admin_password"]
            
            }

        You may also need to add `hostname` to the ignore_changes list if you see a diff on a subsequent apply

        If the oci_database_db_system being imported is missing a primary db_home, an empty placeholder for `db_home` will be set in the Terraform state.

        To keep configurations consistent with the imported state, add an empty placeholder for `db_home` to your configuration like this:

        # Add this placeholder into your oci_database_db_system configuration to indicate that the primary db home is empty.

          db_home {

            database {
            
              admin_password = ""
            
            }

          }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: The availability domain where the DB system is located.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_network_nsg_ids: (Updatable) A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        :param pulumi.Input[str] backup_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet the DB system is associated with. Applicable only to Exadata DB systems.
               
               **Subnet Restrictions:** See the subnet restrictions information for **subnetId**.
        :param pulumi.Input[str] cluster_name: The cluster name for Exadata and 2-node RAC virtual machine DB systems. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment the DB system  belongs in.
        :param pulumi.Input[int] cpu_core_count: (Updatable) The number of CPU cores to enable for a bare metal or Exadata DB system or AMD VMDB Systems. The valid values depend on the specified shape:
               * BM.DenseIO1.36 - Specify a multiple of 2, from 2 to 36.
               * BM.DenseIO2.52 - Specify a multiple of 2, from 2 to 52.
               * Exadata.Base.48 - Specify a multiple of 2, from 0 to 48.
               * Exadata.Quarter1.84 - Specify a multiple of 2, from 22 to 84.
               * Exadata.Half1.168 - Specify a multiple of 4, from 44 to 168.
               * Exadata.Full1.336 - Specify a multiple of 8, from 88 to 336.
               * Exadata.Quarter2.92 - Specify a multiple of 2, from 0 to 92.
               * Exadata.Half2.184 - Specify a multiple of 4, from 0 to 184.
               * Exadata.Full2.368 - Specify a multiple of 8, from 0 to 368.
               * VM.Standard.E4.Flex - Specify any thing from 1 to 64.
               
               This parameter is not used for INTEL virtual machine DB systems because virtual machine DB systems have a set number of cores for each shape. For information about the number of cores for a virtual machine DB system shape, see [Virtual Machine DB Systems](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/overview.htm#virtualmachine)
        :param pulumi.Input[Union['DbSystemDataCollectionOptionsArgs', 'DbSystemDataCollectionOptionsArgsDict']] data_collection_options: (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[int] data_storage_percentage: The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Specify 80 or 40. The default is 80 percent assigned to DATA storage. Not applicable for virtual machine DB systems. Required for BMDBs.
        :param pulumi.Input[int] data_storage_size_in_gb: (Updatable) Size (in GB) of the initial data volume that will be created and attached to a virtual machine DB system. You can scale up storage after provisioning, as needed. Note that the total storage size attached will be more than the amount you specify to allow for REDO/RECO space and software volume. Required for VMDBs.
        :param pulumi.Input[str] database_edition: The Oracle Database Edition that applies to all the databases on the DB system. Exadata DB systems and 2-node RAC DB systems require ENTERPRISE_EDITION_EXTREME_PERFORMANCE.
        :param pulumi.Input[Union['DbSystemDbHomeArgs', 'DbSystemDbHomeArgsDict']] db_home: (Updatable) Details for creating a Database Home if you are creating a database by restoring from a database backup.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[Union['DbSystemDbSystemOptionsArgs', 'DbSystemDbSystemOptionsArgsDict']] db_system_options: The DB system options.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] disk_redundancy: The type of redundancy configured for the DB system. Normal is 2-way redundancy, recommended for test and development systems. High is 3-way redundancy, recommended for production systems.
        :param pulumi.Input[str] display_name: The user-friendly name for the DB system. The name does not have to be unique.
        :param pulumi.Input[str] domain: A domain name used for the DB system. If the Oracle-provided Internet and VCN Resolver is enabled for the specified subnet, the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fault_domains: A Fault Domain is a grouping of hardware and infrastructure within an availability domain. Fault Domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or maintenance that affects one Fault Domain does not affect DB systems in other Fault Domains.
               
               If you do not specify the Fault Domain, the system selects one for you. To change the Fault Domain for a DB system, terminate it and launch a new DB system in the preferred Fault Domain.
               
               If the node count is greater than 1, you can specify which Fault Domains these nodes will be distributed into. The system assigns your nodes automatically to the Fault Domains you specify so that no Fault Domain contains more than one node.
               
               To get a list of Fault Domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/latest/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hostname: The hostname for the DB system. The hostname must begin with an alphabetic character, and can contain alphanumeric characters and hyphens (-). The maximum length of the hostname is 16 characters for bare metal and virtual machine DB systems, and 12 characters for Exadata DB systems.
               
               The maximum length of the combined hostname and domain is 63 characters.
               
               **Note:** The hostname must be unique within the subnet. If it is not unique, the DB system will fail to provision.
        :param pulumi.Input[str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to all the databases on the DB system. The default is LICENSE_INCLUDED.
        :param pulumi.Input[Union['DbSystemMaintenanceWindowDetailsArgs', 'DbSystemMaintenanceWindowDetailsArgsDict']] maintenance_window_details: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] node_count: The number of nodes to launch for a 2-node RAC virtual machine DB system. Specify either 1 or 2.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[str] private_ip: A private IP address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. Supported for VM BM shape.
        :param pulumi.Input[str] private_ip_v6: A private IPv6 address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value and the subnet is dual stack, Oracle automatically assigns a private IPv6 address from the subnet.
        :param pulumi.Input[int] reco_storage_size_in_gb: The RECO/REDO storage size, in gigabytes, that is currently allocated to the DB system. Applies only for virtual machine DB systems.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] security_attributes: (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param pulumi.Input[str] shape: (Updatable) The shape of the DB system. The shape determines resources allocated to the DB system.
               * For virtual machine shapes, the number of CPU cores and memory
               * For bare metal and Exadata shapes, the number of CPU cores, memory, and storage
               
               To get a list of shapes, use the [ListDbSystemShapes](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbSystemShapeSummary/ListDbSystemShapes) operation.
        :param pulumi.Input[str] source: The source of the database: Use `NONE` for creating a new database. Use `DB_BACKUP` for creating a new database by restoring from a backup. Use `DATABASE` for creating a new database from an existing database, including archive redo log data. The default is `NONE`.
        :param pulumi.Input[str] source_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[bool] sparse_diskgroup: If true, Sparse Diskgroup is configured for Exadata dbsystem. If False, Sparse diskgroup is not configured. Only applied for Exadata shape.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_public_keys: (Updatable) The public key portion of the key pair to use for SSH access to the DB system. Multiple public keys can be provided. The length of the combined keys cannot exceed 40,000 characters.
        :param pulumi.Input[str] storage_volume_performance_mode: The block storage volume performance level. Valid values are `BALANCED` and `HIGH_PERFORMANCE`. See [Block Volume Performance](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm) for more information.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the DB system is associated with.
               
               **Subnet Restrictions:**
               * For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
               * For Exadata and virtual machine 2-node RAC DB systems, do not use a subnet that overlaps with 192.168.128.0/20.
               
               These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and the backup subnet.
        :param pulumi.Input[str] time_zone: The time zone to use for the DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Db System resource in Oracle Cloud Infrastructure Database service.

        Creates a new DB system in the specified compartment and availability domain. The Oracle
        Database edition that you specify applies to all the databases on that DB system. The selected edition cannot be changed.

        An initial database is created on the DB system based on the request parameters you provide and some default
        options. For detailed information about default options, see [Bare metal and virtual machine DB system default options.](https://docs.cloud.oracle.com/iaas/Content/Database/Tasks/creatingDBsystem.htm#Default)

        **Note:** Deprecated for Exadata Cloud Service systems. Use the [new resource model APIs](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaflexsystem.htm#exaflexsystem_topic-resource_model) instead.

        For Exadata Cloud Service instances, support for this API will end on May 15th, 2021. See [Switching an Exadata DB System to the New Resource Model and APIs](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaflexsystem_topic-resource_model_conversion.htm) for details on converting existing Exadata DB systems to the new resource model.

        Use the [CreateCloudExadataInfrastructure](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudExadataInfrastructure/CreateCloudExadataInfrastructure/) and [CreateCloudVmCluster](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudVmCluster/CreateCloudVmCluster/) APIs to provision a new Exadata Cloud Service instance.

        **Important:** When `auto_backup_enabled` is not present in the configuration or set to true, the `auto_backup_window` and `auto_full_backup_window` will be ignored

        ## Import

        DbSystems can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/dbSystem:DbSystem test_db_system "id"
        ```

        Import is only supported for source=NONE

        `db_home.0.database.0.admin_password` is not returned by the service for security reasons. To avoid a force new of the db_home on the next apply, add the following to the resource:

            lifecycle {
            
                ignore_changes = ["db_home.0.database.0.admin_password"]
            
            }

        You may also need to add `hostname` to the ignore_changes list if you see a diff on a subsequent apply

        If the oci_database_db_system being imported is missing a primary db_home, an empty placeholder for `db_home` will be set in the Terraform state.

        To keep configurations consistent with the imported state, add an empty placeholder for `db_home` to your configuration like this:

        # Add this placeholder into your oci_database_db_system configuration to indicate that the primary db home is empty.

          db_home {

            database {
            
              admin_password = ""
            
            }

          }

        :param str resource_name: The name of the resource.
        :param DbSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_subnet_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 data_collection_options: Optional[pulumi.Input[Union['DbSystemDataCollectionOptionsArgs', 'DbSystemDataCollectionOptionsArgsDict']]] = None,
                 data_storage_percentage: Optional[pulumi.Input[int]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 database_edition: Optional[pulumi.Input[str]] = None,
                 db_home: Optional[pulumi.Input[Union['DbSystemDbHomeArgs', 'DbSystemDbHomeArgsDict']]] = None,
                 db_system_options: Optional[pulumi.Input[Union['DbSystemDbSystemOptionsArgs', 'DbSystemDbSystemOptionsArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disk_redundancy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kms_key_version_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 maintenance_window_details: Optional[pulumi.Input[Union['DbSystemMaintenanceWindowDetailsArgs', 'DbSystemMaintenanceWindowDetailsArgsDict']]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 private_ip_v6: Optional[pulumi.Input[str]] = None,
                 reco_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_db_system_id: Optional[pulumi.Input[str]] = None,
                 sparse_diskgroup: Optional[pulumi.Input[bool]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_volume_performance_mode: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbSystemArgs.__new__(DbSystemArgs)

            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            __props__.__dict__["backup_network_nsg_ids"] = backup_network_nsg_ids
            __props__.__dict__["backup_subnet_id"] = backup_subnet_id
            __props__.__dict__["cluster_name"] = cluster_name
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["cpu_core_count"] = cpu_core_count
            __props__.__dict__["data_collection_options"] = data_collection_options
            __props__.__dict__["data_storage_percentage"] = data_storage_percentage
            __props__.__dict__["data_storage_size_in_gb"] = data_storage_size_in_gb
            __props__.__dict__["database_edition"] = database_edition
            if db_home is None and not opts.urn:
                raise TypeError("Missing required property 'db_home'")
            __props__.__dict__["db_home"] = db_home
            __props__.__dict__["db_system_options"] = db_system_options
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["disk_redundancy"] = disk_redundancy
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["domain"] = domain
            __props__.__dict__["fault_domains"] = fault_domains
            __props__.__dict__["freeform_tags"] = freeform_tags
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["kms_key_version_id"] = kms_key_version_id
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["maintenance_window_details"] = maintenance_window_details
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["nsg_ids"] = nsg_ids
            __props__.__dict__["private_ip"] = private_ip
            __props__.__dict__["private_ip_v6"] = private_ip_v6
            __props__.__dict__["reco_storage_size_in_gb"] = reco_storage_size_in_gb
            __props__.__dict__["security_attributes"] = security_attributes
            if shape is None and not opts.urn:
                raise TypeError("Missing required property 'shape'")
            __props__.__dict__["shape"] = shape
            __props__.__dict__["source"] = source
            __props__.__dict__["source_db_system_id"] = source_db_system_id
            __props__.__dict__["sparse_diskgroup"] = sparse_diskgroup
            if ssh_public_keys is None and not opts.urn:
                raise TypeError("Missing required property 'ssh_public_keys'")
            __props__.__dict__["ssh_public_keys"] = ssh_public_keys
            __props__.__dict__["storage_volume_performance_mode"] = storage_volume_performance_mode
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["iorm_config_caches"] = None
            __props__.__dict__["last_maintenance_run_id"] = None
            __props__.__dict__["last_patch_history_entry_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["listener_port"] = None
            __props__.__dict__["maintenance_windows"] = None
            __props__.__dict__["memory_size_in_gbs"] = None
            __props__.__dict__["next_maintenance_run_id"] = None
            __props__.__dict__["os_version"] = None
            __props__.__dict__["point_in_time_data_disk_clone_timestamp"] = None
            __props__.__dict__["scan_dns_name"] = None
            __props__.__dict__["scan_dns_record_id"] = None
            __props__.__dict__["scan_ip_ids"] = None
            __props__.__dict__["scan_ipv6ids"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["version"] = None
            __props__.__dict__["vip_ids"] = None
            __props__.__dict__["vipv6ids"] = None
            __props__.__dict__["zone_id"] = None
        super(DbSystem, __self__).__init__(
            'oci:Database/dbSystem:DbSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            backup_subnet_id: Optional[pulumi.Input[str]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            cpu_core_count: Optional[pulumi.Input[int]] = None,
            data_collection_options: Optional[pulumi.Input[Union['DbSystemDataCollectionOptionsArgs', 'DbSystemDataCollectionOptionsArgsDict']]] = None,
            data_storage_percentage: Optional[pulumi.Input[int]] = None,
            data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
            database_edition: Optional[pulumi.Input[str]] = None,
            db_home: Optional[pulumi.Input[Union['DbSystemDbHomeArgs', 'DbSystemDbHomeArgsDict']]] = None,
            db_system_options: Optional[pulumi.Input[Union['DbSystemDbSystemOptionsArgs', 'DbSystemDbSystemOptionsArgsDict']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            disk_redundancy: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            iorm_config_caches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbSystemIormConfigCachArgs', 'DbSystemIormConfigCachArgsDict']]]]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            kms_key_version_id: Optional[pulumi.Input[str]] = None,
            last_maintenance_run_id: Optional[pulumi.Input[str]] = None,
            last_patch_history_entry_id: Optional[pulumi.Input[str]] = None,
            license_model: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            listener_port: Optional[pulumi.Input[int]] = None,
            maintenance_window_details: Optional[pulumi.Input[Union['DbSystemMaintenanceWindowDetailsArgs', 'DbSystemMaintenanceWindowDetailsArgsDict']]] = None,
            maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbSystemMaintenanceWindowArgs', 'DbSystemMaintenanceWindowArgsDict']]]]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
            next_maintenance_run_id: Optional[pulumi.Input[str]] = None,
            node_count: Optional[pulumi.Input[int]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            os_version: Optional[pulumi.Input[str]] = None,
            point_in_time_data_disk_clone_timestamp: Optional[pulumi.Input[str]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            private_ip_v6: Optional[pulumi.Input[str]] = None,
            reco_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
            scan_dns_name: Optional[pulumi.Input[str]] = None,
            scan_dns_record_id: Optional[pulumi.Input[str]] = None,
            scan_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            scan_ipv6ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None,
            source_db_system_id: Optional[pulumi.Input[str]] = None,
            sparse_diskgroup: Optional[pulumi.Input[bool]] = None,
            ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage_volume_performance_mode: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None,
            vip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vipv6ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'DbSystem':
        """
        Get an existing DbSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: The availability domain where the DB system is located.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_network_nsg_ids: (Updatable) A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        :param pulumi.Input[str] backup_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet the DB system is associated with. Applicable only to Exadata DB systems.
               
               **Subnet Restrictions:** See the subnet restrictions information for **subnetId**.
        :param pulumi.Input[str] cluster_name: The cluster name for Exadata and 2-node RAC virtual machine DB systems. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment the DB system  belongs in.
        :param pulumi.Input[int] cpu_core_count: (Updatable) The number of CPU cores to enable for a bare metal or Exadata DB system or AMD VMDB Systems. The valid values depend on the specified shape:
               * BM.DenseIO1.36 - Specify a multiple of 2, from 2 to 36.
               * BM.DenseIO2.52 - Specify a multiple of 2, from 2 to 52.
               * Exadata.Base.48 - Specify a multiple of 2, from 0 to 48.
               * Exadata.Quarter1.84 - Specify a multiple of 2, from 22 to 84.
               * Exadata.Half1.168 - Specify a multiple of 4, from 44 to 168.
               * Exadata.Full1.336 - Specify a multiple of 8, from 88 to 336.
               * Exadata.Quarter2.92 - Specify a multiple of 2, from 0 to 92.
               * Exadata.Half2.184 - Specify a multiple of 4, from 0 to 184.
               * Exadata.Full2.368 - Specify a multiple of 8, from 0 to 368.
               * VM.Standard.E4.Flex - Specify any thing from 1 to 64.
               
               This parameter is not used for INTEL virtual machine DB systems because virtual machine DB systems have a set number of cores for each shape. For information about the number of cores for a virtual machine DB system shape, see [Virtual Machine DB Systems](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/overview.htm#virtualmachine)
        :param pulumi.Input[Union['DbSystemDataCollectionOptionsArgs', 'DbSystemDataCollectionOptionsArgsDict']] data_collection_options: (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[int] data_storage_percentage: The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Specify 80 or 40. The default is 80 percent assigned to DATA storage. Not applicable for virtual machine DB systems. Required for BMDBs.
        :param pulumi.Input[int] data_storage_size_in_gb: (Updatable) Size (in GB) of the initial data volume that will be created and attached to a virtual machine DB system. You can scale up storage after provisioning, as needed. Note that the total storage size attached will be more than the amount you specify to allow for REDO/RECO space and software volume. Required for VMDBs.
        :param pulumi.Input[str] database_edition: The Oracle Database Edition that applies to all the databases on the DB system. Exadata DB systems and 2-node RAC DB systems require ENTERPRISE_EDITION_EXTREME_PERFORMANCE.
        :param pulumi.Input[Union['DbSystemDbHomeArgs', 'DbSystemDbHomeArgsDict']] db_home: (Updatable) Details for creating a Database Home if you are creating a database by restoring from a database backup.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[Union['DbSystemDbSystemOptionsArgs', 'DbSystemDbSystemOptionsArgsDict']] db_system_options: The DB system options.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] disk_redundancy: The type of redundancy configured for the DB system. Normal is 2-way redundancy, recommended for test and development systems. High is 3-way redundancy, recommended for production systems.
        :param pulumi.Input[str] display_name: The user-friendly name for the DB system. The name does not have to be unique.
        :param pulumi.Input[str] domain: A domain name used for the DB system. If the Oracle-provided Internet and VCN Resolver is enabled for the specified subnet, the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fault_domains: A Fault Domain is a grouping of hardware and infrastructure within an availability domain. Fault Domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or maintenance that affects one Fault Domain does not affect DB systems in other Fault Domains.
               
               If you do not specify the Fault Domain, the system selects one for you. To change the Fault Domain for a DB system, terminate it and launch a new DB system in the preferred Fault Domain.
               
               If the node count is greater than 1, you can specify which Fault Domains these nodes will be distributed into. The system assigns your nodes automatically to the Fault Domains you specify so that no Fault Domain contains more than one node.
               
               To get a list of Fault Domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/latest/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hostname: The hostname for the DB system. The hostname must begin with an alphabetic character, and can contain alphanumeric characters and hyphens (-). The maximum length of the hostname is 16 characters for bare metal and virtual machine DB systems, and 12 characters for Exadata DB systems.
               
               The maximum length of the combined hostname and domain is 63 characters.
               
               **Note:** The hostname must be unique within the subnet. If it is not unique, the DB system will fail to provision.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbSystemIormConfigCachArgs', 'DbSystemIormConfigCachArgsDict']]]] iorm_config_caches: The IORM settings of the Exadata DB system.
        :param pulumi.Input[str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        :param pulumi.Input[str] last_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        :param pulumi.Input[str] last_patch_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to all the databases on the DB system. The default is LICENSE_INCLUDED.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[int] listener_port: The port number configured for the listener on the DB system.
        :param pulumi.Input[Union['DbSystemMaintenanceWindowDetailsArgs', 'DbSystemMaintenanceWindowDetailsArgsDict']] maintenance_window_details: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbSystemMaintenanceWindowArgs', 'DbSystemMaintenanceWindowArgsDict']]]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] memory_size_in_gbs: Memory allocated to the DB system, in gigabytes.
        :param pulumi.Input[str] next_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        :param pulumi.Input[int] node_count: The number of nodes to launch for a 2-node RAC virtual machine DB system. Specify either 1 or 2.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[str] os_version: The most recent OS Patch Version applied on the DB system.
        :param pulumi.Input[str] point_in_time_data_disk_clone_timestamp: The point in time for a cloned database system when the data disks were cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[str] private_ip: A private IP address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. Supported for VM BM shape.
        :param pulumi.Input[str] private_ip_v6: A private IPv6 address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value and the subnet is dual stack, Oracle automatically assigns a private IPv6 address from the subnet.
        :param pulumi.Input[int] reco_storage_size_in_gb: The RECO/REDO storage size, in gigabytes, that is currently allocated to the DB system. Applies only for virtual machine DB systems.
        :param pulumi.Input[str] scan_dns_name: The FQDN of the DNS record for the SCAN IP addresses that are associated with the DB system.
        :param pulumi.Input[str] scan_dns_record_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DNS record for the SCAN IP addresses that are associated with the DB system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scan_ip_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IPv4 addresses associated with the DB system. SCAN IPv4 addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scan_ipv6ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IPv6 addresses associated with the DB system. SCAN IPv6 addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] security_attributes: (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param pulumi.Input[str] shape: (Updatable) The shape of the DB system. The shape determines resources allocated to the DB system.
               * For virtual machine shapes, the number of CPU cores and memory
               * For bare metal and Exadata shapes, the number of CPU cores, memory, and storage
               
               To get a list of shapes, use the [ListDbSystemShapes](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbSystemShapeSummary/ListDbSystemShapes) operation.
        :param pulumi.Input[str] source: The source of the database: Use `NONE` for creating a new database. Use `DB_BACKUP` for creating a new database by restoring from a backup. Use `DATABASE` for creating a new database from an existing database, including archive redo log data. The default is `NONE`.
        :param pulumi.Input[str] source_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[bool] sparse_diskgroup: If true, Sparse Diskgroup is configured for Exadata dbsystem. If False, Sparse diskgroup is not configured. Only applied for Exadata shape.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_public_keys: (Updatable) The public key portion of the key pair to use for SSH access to the DB system. Multiple public keys can be provided. The length of the combined keys cannot exceed 40,000 characters.
        :param pulumi.Input[str] state: The current state of the DB system.
        :param pulumi.Input[str] storage_volume_performance_mode: The block storage volume performance level. Valid values are `BALANCED` and `HIGH_PERFORMANCE`. See [Block Volume Performance](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm) for more information.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the DB system is associated with.
               
               **Subnet Restrictions:**
               * For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
               * For Exadata and virtual machine 2-node RAC DB systems, do not use a subnet that overlaps with 192.168.128.0/20.
               
               These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and the backup subnet.
        :param pulumi.Input[str] time_created: The date and time the DB system was created.
        :param pulumi.Input[str] time_zone: The time zone to use for the DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] version: The Oracle Database version of the DB system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vip_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IPv4 (VIP) addresses associated with the DB system. The Cluster Ready Services (CRS) creates and maintains one VIPv4 address for each node in the DB system to enable failover. If one node fails, the VIPv4 is reassigned to another active node in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vipv6ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IPv6 (VIP) addresses associated with the DB system. The Cluster Ready Services (CRS) creates and maintains one VIP IpV6 address for each node in the DB system to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
        :param pulumi.Input[str] zone_id: The OCID of the zone the DB system is associated with.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbSystemState.__new__(_DbSystemState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["backup_network_nsg_ids"] = backup_network_nsg_ids
        __props__.__dict__["backup_subnet_id"] = backup_subnet_id
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["cpu_core_count"] = cpu_core_count
        __props__.__dict__["data_collection_options"] = data_collection_options
        __props__.__dict__["data_storage_percentage"] = data_storage_percentage
        __props__.__dict__["data_storage_size_in_gb"] = data_storage_size_in_gb
        __props__.__dict__["database_edition"] = database_edition
        __props__.__dict__["db_home"] = db_home
        __props__.__dict__["db_system_options"] = db_system_options
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["disk_redundancy"] = disk_redundancy
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain"] = domain
        __props__.__dict__["fault_domains"] = fault_domains
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["iorm_config_caches"] = iorm_config_caches
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["kms_key_version_id"] = kms_key_version_id
        __props__.__dict__["last_maintenance_run_id"] = last_maintenance_run_id
        __props__.__dict__["last_patch_history_entry_id"] = last_patch_history_entry_id
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["listener_port"] = listener_port
        __props__.__dict__["maintenance_window_details"] = maintenance_window_details
        __props__.__dict__["maintenance_windows"] = maintenance_windows
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["next_maintenance_run_id"] = next_maintenance_run_id
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["os_version"] = os_version
        __props__.__dict__["point_in_time_data_disk_clone_timestamp"] = point_in_time_data_disk_clone_timestamp
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["private_ip_v6"] = private_ip_v6
        __props__.__dict__["reco_storage_size_in_gb"] = reco_storage_size_in_gb
        __props__.__dict__["scan_dns_name"] = scan_dns_name
        __props__.__dict__["scan_dns_record_id"] = scan_dns_record_id
        __props__.__dict__["scan_ip_ids"] = scan_ip_ids
        __props__.__dict__["scan_ipv6ids"] = scan_ipv6ids
        __props__.__dict__["security_attributes"] = security_attributes
        __props__.__dict__["shape"] = shape
        __props__.__dict__["source"] = source
        __props__.__dict__["source_db_system_id"] = source_db_system_id
        __props__.__dict__["sparse_diskgroup"] = sparse_diskgroup
        __props__.__dict__["ssh_public_keys"] = ssh_public_keys
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_volume_performance_mode"] = storage_volume_performance_mode
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["version"] = version
        __props__.__dict__["vip_ids"] = vip_ids
        __props__.__dict__["vipv6ids"] = vipv6ids
        __props__.__dict__["zone_id"] = zone_id
        return DbSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The availability domain where the DB system is located.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="backupNetworkNsgIds")
    def backup_network_nsg_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        """
        return pulumi.get(self, "backup_network_nsg_ids")

    @property
    @pulumi.getter(name="backupSubnetId")
    def backup_subnet_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet the DB system is associated with. Applicable only to Exadata DB systems.

        **Subnet Restrictions:** See the subnet restrictions information for **subnetId**.
        """
        return pulumi.get(self, "backup_subnet_id")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        The cluster name for Exadata and 2-node RAC virtual machine DB systems. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment the DB system  belongs in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of CPU cores to enable for a bare metal or Exadata DB system or AMD VMDB Systems. The valid values depend on the specified shape:
        * BM.DenseIO1.36 - Specify a multiple of 2, from 2 to 36.
        * BM.DenseIO2.52 - Specify a multiple of 2, from 2 to 52.
        * Exadata.Base.48 - Specify a multiple of 2, from 0 to 48.
        * Exadata.Quarter1.84 - Specify a multiple of 2, from 22 to 84.
        * Exadata.Half1.168 - Specify a multiple of 4, from 44 to 168.
        * Exadata.Full1.336 - Specify a multiple of 8, from 88 to 336.
        * Exadata.Quarter2.92 - Specify a multiple of 2, from 0 to 92.
        * Exadata.Half2.184 - Specify a multiple of 4, from 0 to 184.
        * Exadata.Full2.368 - Specify a multiple of 8, from 0 to 368.
        * VM.Standard.E4.Flex - Specify any thing from 1 to 64.

        This parameter is not used for INTEL virtual machine DB systems because virtual machine DB systems have a set number of cores for each shape. For information about the number of cores for a virtual machine DB system shape, see [Virtual Machine DB Systems](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/overview.htm#virtualmachine)
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> pulumi.Output['outputs.DbSystemDataCollectionOptions']:
        """
        (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @property
    @pulumi.getter(name="dataStoragePercentage")
    def data_storage_percentage(self) -> pulumi.Output[int]:
        """
        The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Specify 80 or 40. The default is 80 percent assigned to DATA storage. Not applicable for virtual machine DB systems. Required for BMDBs.
        """
        return pulumi.get(self, "data_storage_percentage")

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> pulumi.Output[int]:
        """
        (Updatable) Size (in GB) of the initial data volume that will be created and attached to a virtual machine DB system. You can scale up storage after provisioning, as needed. Note that the total storage size attached will be more than the amount you specify to allow for REDO/RECO space and software volume. Required for VMDBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> pulumi.Output[str]:
        """
        The Oracle Database Edition that applies to all the databases on the DB system. Exadata DB systems and 2-node RAC DB systems require ENTERPRISE_EDITION_EXTREME_PERFORMANCE.
        """
        return pulumi.get(self, "database_edition")

    @property
    @pulumi.getter(name="dbHome")
    def db_home(self) -> pulumi.Output['outputs.DbSystemDbHome']:
        """
        (Updatable) Details for creating a Database Home if you are creating a database by restoring from a database backup.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "db_home")

    @property
    @pulumi.getter(name="dbSystemOptions")
    def db_system_options(self) -> pulumi.Output['outputs.DbSystemDbSystemOptions']:
        """
        The DB system options.
        """
        return pulumi.get(self, "db_system_options")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="diskRedundancy")
    def disk_redundancy(self) -> pulumi.Output[str]:
        """
        The type of redundancy configured for the DB system. Normal is 2-way redundancy, recommended for test and development systems. High is 3-way redundancy, recommended for production systems.
        """
        return pulumi.get(self, "disk_redundancy")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        A domain name used for the DB system. If the Oracle-provided Internet and VCN Resolver is enabled for the specified subnet, the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> pulumi.Output[Sequence[str]]:
        """
        A Fault Domain is a grouping of hardware and infrastructure within an availability domain. Fault Domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or maintenance that affects one Fault Domain does not affect DB systems in other Fault Domains.

        If you do not specify the Fault Domain, the system selects one for you. To change the Fault Domain for a DB system, terminate it and launch a new DB system in the preferred Fault Domain.

        If the node count is greater than 1, you can specify which Fault Domains these nodes will be distributed into. The system assigns your nodes automatically to the Fault Domains you specify so that no Fault Domain contains more than one node.

        To get a list of Fault Domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/latest/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.

        Example: `FAULT-DOMAIN-1`
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        The hostname for the DB system. The hostname must begin with an alphabetic character, and can contain alphanumeric characters and hyphens (-). The maximum length of the hostname is 16 characters for bare metal and virtual machine DB systems, and 12 characters for Exadata DB systems.

        The maximum length of the combined hostname and domain is 63 characters.

        **Note:** The hostname must be unique within the subnet. If it is not unique, the DB system will fail to provision.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="iormConfigCaches")
    def iorm_config_caches(self) -> pulumi.Output[Sequence['outputs.DbSystemIormConfigCach']]:
        """
        The IORM settings of the Exadata DB system.
        """
        return pulumi.get(self, "iorm_config_caches")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> pulumi.Output[Optional[str]]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        """
        return pulumi.get(self, "kms_key_version_id")

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @property
    @pulumi.getter(name="lastPatchHistoryEntryId")
    def last_patch_history_entry_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        """
        return pulumi.get(self, "last_patch_history_entry_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[str]:
        """
        (Updatable) The Oracle license model that applies to all the databases on the DB system. The default is LICENSE_INCLUDED.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Output[int]:
        """
        The port number configured for the listener on the DB system.
        """
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="maintenanceWindowDetails")
    def maintenance_window_details(self) -> pulumi.Output[Optional['outputs.DbSystemMaintenanceWindowDetails']]:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window_details")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> pulumi.Output[Sequence['outputs.DbSystemMaintenanceWindow']]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[int]:
        """
        Memory allocated to the DB system, in gigabytes.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[int]:
        """
        The number of nodes to launch for a 2-node RAC virtual machine DB system. Specify either 1 or 2.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> pulumi.Output[str]:
        """
        The most recent OS Patch Version applied on the DB system.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="pointInTimeDataDiskCloneTimestamp")
    def point_in_time_data_disk_clone_timestamp(self) -> pulumi.Output[str]:
        """
        The point in time for a cloned database system when the data disks were cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "point_in_time_data_disk_clone_timestamp")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        A private IP address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. Supported for VM BM shape.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="privateIpV6")
    def private_ip_v6(self) -> pulumi.Output[str]:
        """
        A private IPv6 address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value and the subnet is dual stack, Oracle automatically assigns a private IPv6 address from the subnet.
        """
        return pulumi.get(self, "private_ip_v6")

    @property
    @pulumi.getter(name="recoStorageSizeInGb")
    def reco_storage_size_in_gb(self) -> pulumi.Output[int]:
        """
        The RECO/REDO storage size, in gigabytes, that is currently allocated to the DB system. Applies only for virtual machine DB systems.
        """
        return pulumi.get(self, "reco_storage_size_in_gb")

    @property
    @pulumi.getter(name="scanDnsName")
    def scan_dns_name(self) -> pulumi.Output[str]:
        """
        The FQDN of the DNS record for the SCAN IP addresses that are associated with the DB system.
        """
        return pulumi.get(self, "scan_dns_name")

    @property
    @pulumi.getter(name="scanDnsRecordId")
    def scan_dns_record_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DNS record for the SCAN IP addresses that are associated with the DB system.
        """
        return pulumi.get(self, "scan_dns_record_id")

    @property
    @pulumi.getter(name="scanIpIds")
    def scan_ip_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IPv4 addresses associated with the DB system. SCAN IPv4 addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        """
        return pulumi.get(self, "scan_ip_ids")

    @property
    @pulumi.getter(name="scanIpv6ids")
    def scan_ipv6ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IPv6 addresses associated with the DB system. SCAN IPv6 addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        """
        return pulumi.get(self, "scan_ipv6ids")

    @property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        """
        (Updatable) The shape of the DB system. The shape determines resources allocated to the DB system.
        * For virtual machine shapes, the number of CPU cores and memory
        * For bare metal and Exadata shapes, the number of CPU cores, memory, and storage

        To get a list of shapes, use the [ListDbSystemShapes](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbSystemShapeSummary/ListDbSystemShapes) operation.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        The source of the database: Use `NONE` for creating a new database. Use `DB_BACKUP` for creating a new database by restoring from a backup. Use `DATABASE` for creating a new database from an existing database, including archive redo log data. The default is `NONE`.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceDbSystemId")
    def source_db_system_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "source_db_system_id")

    @property
    @pulumi.getter(name="sparseDiskgroup")
    def sparse_diskgroup(self) -> pulumi.Output[bool]:
        """
        If true, Sparse Diskgroup is configured for Exadata dbsystem. If False, Sparse diskgroup is not configured. Only applied for Exadata shape.
        """
        return pulumi.get(self, "sparse_diskgroup")

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The public key portion of the key pair to use for SSH access to the DB system. Multiple public keys can be provided. The length of the combined keys cannot exceed 40,000 characters.
        """
        return pulumi.get(self, "ssh_public_keys")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the DB system.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageVolumePerformanceMode")
    def storage_volume_performance_mode(self) -> pulumi.Output[str]:
        """
        The block storage volume performance level. Valid values are `BALANCED` and `HIGH_PERFORMANCE`. See [Block Volume Performance](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm) for more information.
        """
        return pulumi.get(self, "storage_volume_performance_mode")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the DB system is associated with.

        **Subnet Restrictions:**
        * For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
        * For Exadata and virtual machine 2-node RAC DB systems, do not use a subnet that overlaps with 192.168.128.0/20.

        These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and the backup subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the DB system was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        The time zone to use for the DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The Oracle Database version of the DB system.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vipIds")
    def vip_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IPv4 (VIP) addresses associated with the DB system. The Cluster Ready Services (CRS) creates and maintains one VIPv4 address for each node in the DB system to enable failover. If one node fails, the VIPv4 is reassigned to another active node in the cluster.
        """
        return pulumi.get(self, "vip_ids")

    @property
    @pulumi.getter
    def vipv6ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IPv6 (VIP) addresses associated with the DB system. The Cluster Ready Services (CRS) creates and maintains one VIP IpV6 address for each node in the DB system to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
        """
        return pulumi.get(self, "vipv6ids")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The OCID of the zone the DB system is associated with.
        """
        return pulumi.get(self, "zone_id")

