# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatasetsResult',
    'AwaitableGetDatasetsResult',
    'get_datasets',
    'get_datasets_output',
]

@pulumi.output_type
class GetDatasetsResult:
    """
    A collection of values returned by getDatasets.
    """
    def __init__(__self__, annotation_format=None, compartment_id=None, dataset_collections=None, display_name=None, filters=None, id=None, state=None):
        if annotation_format and not isinstance(annotation_format, str):
            raise TypeError("Expected argument 'annotation_format' to be a str")
        pulumi.set(__self__, "annotation_format", annotation_format)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if dataset_collections and not isinstance(dataset_collections, list):
            raise TypeError("Expected argument 'dataset_collections' to be a list")
        pulumi.set(__self__, "dataset_collections", dataset_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="annotationFormat")
    def annotation_format(self) -> Optional[str]:
        """
        The annotation format name required for labeling records.
        """
        return pulumi.get(self, "annotation_format")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment of the resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="datasetCollections")
    def dataset_collections(self) -> Sequence['outputs.GetDatasetsDatasetCollectionResult']:
        """
        The list of dataset_collection.
        """
        return pulumi.get(self, "dataset_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatasetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The OCID of the Dataset.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of a dataset. CREATING - The dataset is being created.  It will transition to ACTIVE when it is ready for labeling. ACTIVE   - The dataset is ready for labeling. UPDATING - The dataset is being updated.  It and its related resources may be unavailable for other updates until it returns to ACTIVE. NEEDS_ATTENTION - A dataset updation operation has failed due to validation or other errors and needs attention. DELETING - The dataset and its related resources are being deleted. DELETED  - The dataset has been deleted and is no longer available. FAILED   - The dataset has failed due to validation or other errors.
        """
        return pulumi.get(self, "state")


class AwaitableGetDatasetsResult(GetDatasetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatasetsResult(
            annotation_format=self.annotation_format,
            compartment_id=self.compartment_id,
            dataset_collections=self.dataset_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_datasets(annotation_format: Optional[str] = None,
                 compartment_id: Optional[str] = None,
                 display_name: Optional[str] = None,
                 filters: Optional[Sequence[Union['GetDatasetsFilterArgs', 'GetDatasetsFilterArgsDict']]] = None,
                 id: Optional[str] = None,
                 state: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatasetsResult:
    """
    This data source provides the list of Datasets in Oracle Cloud Infrastructure Data Labeling Service service.

    Returns a list of Datasets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_datasets = oci.DataLabellingService.get_datasets(compartment_id=compartment_id,
        annotation_format=dataset_annotation_format,
        display_name=dataset_display_name,
        id=dataset_id,
        state=dataset_state)
    ```


    :param str annotation_format: A filter to return only resources that match the entire annotation format given.
    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: Unique Dataset OCID
    :param str state: A filter to return only resources whose lifecycleState matches this query param.
    """
    __args__ = dict()
    __args__['annotationFormat'] = annotation_format
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataLabellingService/getDatasets:getDatasets', __args__, opts=opts, typ=GetDatasetsResult).value

    return AwaitableGetDatasetsResult(
        annotation_format=pulumi.get(__ret__, 'annotation_format'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        dataset_collections=pulumi.get(__ret__, 'dataset_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_datasets_output(annotation_format: Optional[pulumi.Input[Optional[str]]] = None,
                        compartment_id: Optional[pulumi.Input[str]] = None,
                        display_name: Optional[pulumi.Input[Optional[str]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDatasetsFilterArgs', 'GetDatasetsFilterArgsDict']]]]] = None,
                        id: Optional[pulumi.Input[Optional[str]]] = None,
                        state: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatasetsResult]:
    """
    This data source provides the list of Datasets in Oracle Cloud Infrastructure Data Labeling Service service.

    Returns a list of Datasets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_datasets = oci.DataLabellingService.get_datasets(compartment_id=compartment_id,
        annotation_format=dataset_annotation_format,
        display_name=dataset_display_name,
        id=dataset_id,
        state=dataset_state)
    ```


    :param str annotation_format: A filter to return only resources that match the entire annotation format given.
    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: Unique Dataset OCID
    :param str state: A filter to return only resources whose lifecycleState matches this query param.
    """
    __args__ = dict()
    __args__['annotationFormat'] = annotation_format
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataLabellingService/getDatasets:getDatasets', __args__, opts=opts, typ=GetDatasetsResult)
    return __ret__.apply(lambda __response__: GetDatasetsResult(
        annotation_format=pulumi.get(__response__, 'annotation_format'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        dataset_collections=pulumi.get(__response__, 'dataset_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
