# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetScheduleResult',
    'AwaitableGetScheduleResult',
    'get_schedule',
    'get_schedule_output',
]

@pulumi.output_type
class GetScheduleResult:
    """
    A collection of values returned by getSchedule.
    """
    def __init__(__self__, actions=None, compartment_id=None, created_by=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, last_schedule_run_details=None, lifecycle_details=None, log_details=None, project_id=None, schedule_id=None, state=None, system_tags=None, time_created=None, time_last_schedule_run=None, time_next_scheduled_run=None, time_updated=None, triggers=None):
        if actions and not isinstance(actions, list):
            raise TypeError("Expected argument 'actions' to be a list")
        pulumi.set(__self__, "actions", actions)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_schedule_run_details and not isinstance(last_schedule_run_details, str):
            raise TypeError("Expected argument 'last_schedule_run_details' to be a str")
        pulumi.set(__self__, "last_schedule_run_details", last_schedule_run_details)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if log_details and not isinstance(log_details, list):
            raise TypeError("Expected argument 'log_details' to be a list")
        pulumi.set(__self__, "log_details", log_details)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if schedule_id and not isinstance(schedule_id, str):
            raise TypeError("Expected argument 'schedule_id' to be a str")
        pulumi.set(__self__, "schedule_id", schedule_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_schedule_run and not isinstance(time_last_schedule_run, str):
            raise TypeError("Expected argument 'time_last_schedule_run' to be a str")
        pulumi.set(__self__, "time_last_schedule_run", time_last_schedule_run)
        if time_next_scheduled_run and not isinstance(time_next_scheduled_run, str):
            raise TypeError("Expected argument 'time_next_scheduled_run' to be a str")
        pulumi.set(__self__, "time_next_scheduled_run", time_next_scheduled_run)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if triggers and not isinstance(triggers, list):
            raise TypeError("Expected argument 'triggers' to be a list")
        pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetScheduleActionResult']:
        """
        The schedule action
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the schedule.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the schedule.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A short description of the schedule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly display name for the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the schedule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastScheduleRunDetails")
    def last_schedule_run_details(self) -> str:
        """
        Details about the action performed by the last schedule execution. Example: `Invoked ML Application trigger.`
        """
        return pulumi.get(self, "last_schedule_run_details")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="logDetails")
    def log_details(self) -> Sequence['outputs.GetScheduleLogDetailResult']:
        """
        Custom logging details for schedule execution.
        """
        return pulumi.get(self, "log_details")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project associated with the schedule.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> str:
        return pulumi.get(self, "schedule_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the schedule.           Example: `ACTIVE`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the schedule was created. Format is defined by RFC3339.           Example: `2022-08-05T01:02:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastScheduleRun")
    def time_last_schedule_run(self) -> str:
        """
        The last schedule execution time. Format is defined by RFC3339. Example: `2022-08-05T01:02:29.600Z`
        """
        return pulumi.get(self, "time_last_schedule_run")

    @property
    @pulumi.getter(name="timeNextScheduledRun")
    def time_next_scheduled_run(self) -> str:
        """
        The next scheduled execution time for the schedule. Format is defined by RFC3339. Example: `2022-08-05T01:02:29.600Z`
        """
        return pulumi.get(self, "time_next_scheduled_run")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the schedule was updated. Format is defined by RFC3339.           Example: `2022-09-05T01:02:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def triggers(self) -> Sequence['outputs.GetScheduleTriggerResult']:
        """
        The trigger of the schedule can be UNIX cron or iCal expression or simple interval
        """
        return pulumi.get(self, "triggers")


class AwaitableGetScheduleResult(GetScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduleResult(
            actions=self.actions,
            compartment_id=self.compartment_id,
            created_by=self.created_by,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            last_schedule_run_details=self.last_schedule_run_details,
            lifecycle_details=self.lifecycle_details,
            log_details=self.log_details,
            project_id=self.project_id,
            schedule_id=self.schedule_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_last_schedule_run=self.time_last_schedule_run,
            time_next_scheduled_run=self.time_next_scheduled_run,
            time_updated=self.time_updated,
            triggers=self.triggers)


def get_schedule(schedule_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduleResult:
    """
    This data source provides details about a specific Schedule resource in Oracle Cloud Infrastructure Data Science service.

    Gets a Schedule by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_schedule = oci.DataScience.get_schedule(schedule_id=test_schedule_oci_datascience_schedule["id"])
    ```


    :param str schedule_id: unique Schedule identifier
    """
    __args__ = dict()
    __args__['scheduleId'] = schedule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getSchedule:getSchedule', __args__, opts=opts, typ=GetScheduleResult).value

    return AwaitableGetScheduleResult(
        actions=pulumi.get(__ret__, 'actions'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_by=pulumi.get(__ret__, 'created_by'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        last_schedule_run_details=pulumi.get(__ret__, 'last_schedule_run_details'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        log_details=pulumi.get(__ret__, 'log_details'),
        project_id=pulumi.get(__ret__, 'project_id'),
        schedule_id=pulumi.get(__ret__, 'schedule_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_schedule_run=pulumi.get(__ret__, 'time_last_schedule_run'),
        time_next_scheduled_run=pulumi.get(__ret__, 'time_next_scheduled_run'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        triggers=pulumi.get(__ret__, 'triggers'))
def get_schedule_output(schedule_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScheduleResult]:
    """
    This data source provides details about a specific Schedule resource in Oracle Cloud Infrastructure Data Science service.

    Gets a Schedule by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_schedule = oci.DataScience.get_schedule(schedule_id=test_schedule_oci_datascience_schedule["id"])
    ```


    :param str schedule_id: unique Schedule identifier
    """
    __args__ = dict()
    __args__['scheduleId'] = schedule_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataScience/getSchedule:getSchedule', __args__, opts=opts, typ=GetScheduleResult)
    return __ret__.apply(lambda __response__: GetScheduleResult(
        actions=pulumi.get(__response__, 'actions'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        created_by=pulumi.get(__response__, 'created_by'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        last_schedule_run_details=pulumi.get(__response__, 'last_schedule_run_details'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        log_details=pulumi.get(__response__, 'log_details'),
        project_id=pulumi.get(__response__, 'project_id'),
        schedule_id=pulumi.get(__response__, 'schedule_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_last_schedule_run=pulumi.get(__response__, 'time_last_schedule_run'),
        time_next_scheduled_run=pulumi.get(__response__, 'time_next_scheduled_run'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        triggers=pulumi.get(__response__, 'triggers')))
