# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ModelDefinedMetadataArtifactArgs', 'ModelDefinedMetadataArtifact']

@pulumi.input_type
class ModelDefinedMetadataArtifactArgs:
    def __init__(__self__, *,
                 content_length: pulumi.Input[str],
                 metadatum_key_name: pulumi.Input[str],
                 model_defined_metadatum_artifact: pulumi.Input[str],
                 model_id: pulumi.Input[str],
                 content_disposition: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ModelDefinedMetadataArtifact resource.
        :param pulumi.Input[str] content_length: (Updatable) The content length of the body.
        :param pulumi.Input[str] metadatum_key_name: The name of the model metadatum in the metadata.
        :param pulumi.Input[str] model_defined_metadatum_artifact: (Updatable) The model defined metadata artifact to upload.
        :param pulumi.Input[str] model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] content_disposition: (Updatable) This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. If this optional field is not populated in the request, then the OCID of the model is used for the file name when downloading. Example: `{"Content-Disposition": "attachment" "filename"="model.tar.gz" "Content-Length": "2347" "Content-Type": "application/gzip"}`
        """
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "metadatum_key_name", metadatum_key_name)
        pulumi.set(__self__, "model_defined_metadatum_artifact", model_defined_metadatum_artifact)
        pulumi.set(__self__, "model_id", model_id)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> pulumi.Input[str]:
        """
        (Updatable) The content length of the body.
        """
        return pulumi.get(self, "content_length")

    @content_length.setter
    def content_length(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_length", value)

    @property
    @pulumi.getter(name="metadatumKeyName")
    def metadatum_key_name(self) -> pulumi.Input[str]:
        """
        The name of the model metadatum in the metadata.
        """
        return pulumi.get(self, "metadatum_key_name")

    @metadatum_key_name.setter
    def metadatum_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metadatum_key_name", value)

    @property
    @pulumi.getter(name="modelDefinedMetadatumArtifact")
    def model_defined_metadatum_artifact(self) -> pulumi.Input[str]:
        """
        (Updatable) The model defined metadata artifact to upload.
        """
        return pulumi.get(self, "model_defined_metadatum_artifact")

    @model_defined_metadatum_artifact.setter
    def model_defined_metadatum_artifact(self, value: pulumi.Input[str]):
        pulumi.set(self, "model_defined_metadatum_artifact", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. If this optional field is not populated in the request, then the OCID of the model is used for the file name when downloading. Example: `{"Content-Disposition": "attachment" "filename"="model.tar.gz" "Content-Length": "2347" "Content-Type": "application/gzip"}`
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_disposition", value)


@pulumi.input_type
class _ModelDefinedMetadataArtifactState:
    def __init__(__self__, *,
                 content_disposition: Optional[pulumi.Input[str]] = None,
                 content_length: Optional[pulumi.Input[str]] = None,
                 metadatum_key_name: Optional[pulumi.Input[str]] = None,
                 model_defined_metadatum_artifact: Optional[pulumi.Input[str]] = None,
                 model_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ModelDefinedMetadataArtifact resources.
        :param pulumi.Input[str] content_disposition: (Updatable) This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. If this optional field is not populated in the request, then the OCID of the model is used for the file name when downloading. Example: `{"Content-Disposition": "attachment" "filename"="model.tar.gz" "Content-Length": "2347" "Content-Type": "application/gzip"}`
        :param pulumi.Input[str] content_length: (Updatable) The content length of the body.
        :param pulumi.Input[str] metadatum_key_name: The name of the model metadatum in the metadata.
        :param pulumi.Input[str] model_defined_metadatum_artifact: (Updatable) The model defined metadata artifact to upload.
        :param pulumi.Input[str] model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_length is not None:
            pulumi.set(__self__, "content_length", content_length)
        if metadatum_key_name is not None:
            pulumi.set(__self__, "metadatum_key_name", metadatum_key_name)
        if model_defined_metadatum_artifact is not None:
            pulumi.set(__self__, "model_defined_metadatum_artifact", model_defined_metadatum_artifact)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. If this optional field is not populated in the request, then the OCID of the model is used for the file name when downloading. Example: `{"Content-Disposition": "attachment" "filename"="model.tar.gz" "Content-Length": "2347" "Content-Type": "application/gzip"}`
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_disposition", value)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The content length of the body.
        """
        return pulumi.get(self, "content_length")

    @content_length.setter
    def content_length(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_length", value)

    @property
    @pulumi.getter(name="metadatumKeyName")
    def metadatum_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the model metadatum in the metadata.
        """
        return pulumi.get(self, "metadatum_key_name")

    @metadatum_key_name.setter
    def metadatum_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadatum_key_name", value)

    @property
    @pulumi.getter(name="modelDefinedMetadatumArtifact")
    def model_defined_metadatum_artifact(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The model defined metadata artifact to upload.
        """
        return pulumi.get(self, "model_defined_metadatum_artifact")

    @model_defined_metadatum_artifact.setter
    def model_defined_metadatum_artifact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_defined_metadatum_artifact", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_id", value)


class ModelDefinedMetadataArtifact(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_disposition: Optional[pulumi.Input[str]] = None,
                 content_length: Optional[pulumi.Input[str]] = None,
                 metadatum_key_name: Optional[pulumi.Input[str]] = None,
                 model_defined_metadatum_artifact: Optional[pulumi.Input[str]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Model Defined Metadata Artifact resource in Oracle Cloud Infrastructure Data Science service.

        Creates model defined metadata artifact for specified model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model_defined_metadata_artifact = oci.data_science.ModelDefinedMetadataArtifact("test_model_defined_metadata_artifact",
            model_defined_metadatum_artifact=model_defined_metadata_artifact_model_defined_metadatum_artifact,
            content_length=model_defined_metadata_artifact_content_length,
            metadatum_key_name=test_key["name"],
            model_id=test_model["id"],
            content_disposition=model_defined_metadata_artifact_content_disposition)
        ```

        ## Import

        ModelDefinedMetadataArtifacts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/modelDefinedMetadataArtifact:ModelDefinedMetadataArtifact test_model_defined_metadata_artifact "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content_disposition: (Updatable) This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. If this optional field is not populated in the request, then the OCID of the model is used for the file name when downloading. Example: `{"Content-Disposition": "attachment" "filename"="model.tar.gz" "Content-Length": "2347" "Content-Type": "application/gzip"}`
        :param pulumi.Input[str] content_length: (Updatable) The content length of the body.
        :param pulumi.Input[str] metadatum_key_name: The name of the model metadatum in the metadata.
        :param pulumi.Input[str] model_defined_metadatum_artifact: (Updatable) The model defined metadata artifact to upload.
        :param pulumi.Input[str] model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelDefinedMetadataArtifactArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Model Defined Metadata Artifact resource in Oracle Cloud Infrastructure Data Science service.

        Creates model defined metadata artifact for specified model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model_defined_metadata_artifact = oci.data_science.ModelDefinedMetadataArtifact("test_model_defined_metadata_artifact",
            model_defined_metadatum_artifact=model_defined_metadata_artifact_model_defined_metadatum_artifact,
            content_length=model_defined_metadata_artifact_content_length,
            metadatum_key_name=test_key["name"],
            model_id=test_model["id"],
            content_disposition=model_defined_metadata_artifact_content_disposition)
        ```

        ## Import

        ModelDefinedMetadataArtifacts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/modelDefinedMetadataArtifact:ModelDefinedMetadataArtifact test_model_defined_metadata_artifact "id"
        ```

        :param str resource_name: The name of the resource.
        :param ModelDefinedMetadataArtifactArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelDefinedMetadataArtifactArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_disposition: Optional[pulumi.Input[str]] = None,
                 content_length: Optional[pulumi.Input[str]] = None,
                 metadatum_key_name: Optional[pulumi.Input[str]] = None,
                 model_defined_metadatum_artifact: Optional[pulumi.Input[str]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelDefinedMetadataArtifactArgs.__new__(ModelDefinedMetadataArtifactArgs)

            __props__.__dict__["content_disposition"] = content_disposition
            if content_length is None and not opts.urn:
                raise TypeError("Missing required property 'content_length'")
            __props__.__dict__["content_length"] = content_length
            if metadatum_key_name is None and not opts.urn:
                raise TypeError("Missing required property 'metadatum_key_name'")
            __props__.__dict__["metadatum_key_name"] = metadatum_key_name
            if model_defined_metadatum_artifact is None and not opts.urn:
                raise TypeError("Missing required property 'model_defined_metadatum_artifact'")
            __props__.__dict__["model_defined_metadatum_artifact"] = model_defined_metadatum_artifact
            if model_id is None and not opts.urn:
                raise TypeError("Missing required property 'model_id'")
            __props__.__dict__["model_id"] = model_id
        super(ModelDefinedMetadataArtifact, __self__).__init__(
            'oci:DataScience/modelDefinedMetadataArtifact:ModelDefinedMetadataArtifact',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content_disposition: Optional[pulumi.Input[str]] = None,
            content_length: Optional[pulumi.Input[str]] = None,
            metadatum_key_name: Optional[pulumi.Input[str]] = None,
            model_defined_metadatum_artifact: Optional[pulumi.Input[str]] = None,
            model_id: Optional[pulumi.Input[str]] = None) -> 'ModelDefinedMetadataArtifact':
        """
        Get an existing ModelDefinedMetadataArtifact resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content_disposition: (Updatable) This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. If this optional field is not populated in the request, then the OCID of the model is used for the file name when downloading. Example: `{"Content-Disposition": "attachment" "filename"="model.tar.gz" "Content-Length": "2347" "Content-Type": "application/gzip"}`
        :param pulumi.Input[str] content_length: (Updatable) The content length of the body.
        :param pulumi.Input[str] metadatum_key_name: The name of the model metadatum in the metadata.
        :param pulumi.Input[str] model_defined_metadatum_artifact: (Updatable) The model defined metadata artifact to upload.
        :param pulumi.Input[str] model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelDefinedMetadataArtifactState.__new__(_ModelDefinedMetadataArtifactState)

        __props__.__dict__["content_disposition"] = content_disposition
        __props__.__dict__["content_length"] = content_length
        __props__.__dict__["metadatum_key_name"] = metadatum_key_name
        __props__.__dict__["model_defined_metadatum_artifact"] = model_defined_metadatum_artifact
        __props__.__dict__["model_id"] = model_id
        return ModelDefinedMetadataArtifact(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> pulumi.Output[str]:
        """
        (Updatable) This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. If this optional field is not populated in the request, then the OCID of the model is used for the file name when downloading. Example: `{"Content-Disposition": "attachment" "filename"="model.tar.gz" "Content-Length": "2347" "Content-Type": "application/gzip"}`
        """
        return pulumi.get(self, "content_disposition")

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> pulumi.Output[str]:
        """
        (Updatable) The content length of the body.
        """
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="metadatumKeyName")
    def metadatum_key_name(self) -> pulumi.Output[str]:
        """
        The name of the model metadatum in the metadata.
        """
        return pulumi.get(self, "metadatum_key_name")

    @property
    @pulumi.getter(name="modelDefinedMetadatumArtifact")
    def model_defined_metadatum_artifact(self) -> pulumi.Output[str]:
        """
        (Updatable) The model defined metadata artifact to upload.
        """
        return pulumi.get(self, "model_defined_metadatum_artifact")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "model_id")

