# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPbfListingsResult',
    'AwaitableGetPbfListingsResult',
    'get_pbf_listings',
    'get_pbf_listings_output',
]

@pulumi.output_type
class GetPbfListingsResult:
    """
    A collection of values returned by getPbfListings.
    """
    def __init__(__self__, filters=None, id=None, name=None, name_contains=None, name_starts_with=None, pbf_listing_id=None, pbf_listings_collections=None, state=None, triggers=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_contains and not isinstance(name_contains, str):
            raise TypeError("Expected argument 'name_contains' to be a str")
        pulumi.set(__self__, "name_contains", name_contains)
        if name_starts_with and not isinstance(name_starts_with, str):
            raise TypeError("Expected argument 'name_starts_with' to be a str")
        pulumi.set(__self__, "name_starts_with", name_starts_with)
        if pbf_listing_id and not isinstance(pbf_listing_id, str):
            raise TypeError("Expected argument 'pbf_listing_id' to be a str")
        pulumi.set(__self__, "pbf_listing_id", pbf_listing_id)
        if pbf_listings_collections and not isinstance(pbf_listings_collections, list):
            raise TypeError("Expected argument 'pbf_listings_collections' to be a list")
        pulumi.set(__self__, "pbf_listings_collections", pbf_listings_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if triggers and not isinstance(triggers, list):
            raise TypeError("Expected argument 'triggers' to be a list")
        pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPbfListingsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A brief descriptive name for the PBF trigger.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameContains")
    def name_contains(self) -> Optional[str]:
        return pulumi.get(self, "name_contains")

    @property
    @pulumi.getter(name="nameStartsWith")
    def name_starts_with(self) -> Optional[str]:
        return pulumi.get(self, "name_starts_with")

    @property
    @pulumi.getter(name="pbfListingId")
    def pbf_listing_id(self) -> Optional[str]:
        return pulumi.get(self, "pbf_listing_id")

    @property
    @pulumi.getter(name="pbfListingsCollections")
    def pbf_listings_collections(self) -> Sequence['outputs.GetPbfListingsPbfListingsCollectionResult']:
        """
        The list of pbf_listings_collection.
        """
        return pulumi.get(self, "pbf_listings_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the PBF resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def triggers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "triggers")


class AwaitableGetPbfListingsResult(GetPbfListingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPbfListingsResult(
            filters=self.filters,
            id=self.id,
            name=self.name,
            name_contains=self.name_contains,
            name_starts_with=self.name_starts_with,
            pbf_listing_id=self.pbf_listing_id,
            pbf_listings_collections=self.pbf_listings_collections,
            state=self.state,
            triggers=self.triggers)


def get_pbf_listings(filters: Optional[Sequence[Union['GetPbfListingsFilterArgs', 'GetPbfListingsFilterArgsDict']]] = None,
                     name: Optional[str] = None,
                     name_contains: Optional[str] = None,
                     name_starts_with: Optional[str] = None,
                     pbf_listing_id: Optional[str] = None,
                     state: Optional[str] = None,
                     triggers: Optional[Sequence[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPbfListingsResult:
    """
    This data source provides the list of Pbf Listings in Oracle Cloud Infrastructure Functions service.

    Fetches a wrapped list of all Pre-built Function(PBF) Listings. Returns a PbfListingCollection containing
    an array of PbfListingSummary response models.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pbf_listings = oci.Functions.get_pbf_listings(name=pbf_listing_name,
        name_contains=pbf_listing_name_contains,
        name_starts_with=pbf_listing_name_starts_with,
        pbf_listing_id=test_pbf_listing["id"],
        state=pbf_listing_state,
        triggers=pbf_listing_trigger)
    ```


    :param str name: A filter to return only resources that match the entire PBF name given.
    :param str name_contains: A filter to return only resources that contain the supplied filter text in the PBF name given.
    :param str name_starts_with: A filter to return only resources that start with the supplied filter text in the PBF name given.
    :param str pbf_listing_id: unique PbfListing identifier
    :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    :param Sequence[str] triggers: A filter to return only resources that match the service trigger sources of a PBF.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['nameContains'] = name_contains
    __args__['nameStartsWith'] = name_starts_with
    __args__['pbfListingId'] = pbf_listing_id
    __args__['state'] = state
    __args__['triggers'] = triggers
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getPbfListings:getPbfListings', __args__, opts=opts, typ=GetPbfListingsResult).value

    return AwaitableGetPbfListingsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        name_contains=pulumi.get(__ret__, 'name_contains'),
        name_starts_with=pulumi.get(__ret__, 'name_starts_with'),
        pbf_listing_id=pulumi.get(__ret__, 'pbf_listing_id'),
        pbf_listings_collections=pulumi.get(__ret__, 'pbf_listings_collections'),
        state=pulumi.get(__ret__, 'state'),
        triggers=pulumi.get(__ret__, 'triggers'))
def get_pbf_listings_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPbfListingsFilterArgs', 'GetPbfListingsFilterArgsDict']]]]] = None,
                            name: Optional[pulumi.Input[Optional[str]]] = None,
                            name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                            name_starts_with: Optional[pulumi.Input[Optional[str]]] = None,
                            pbf_listing_id: Optional[pulumi.Input[Optional[str]]] = None,
                            state: Optional[pulumi.Input[Optional[str]]] = None,
                            triggers: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPbfListingsResult]:
    """
    This data source provides the list of Pbf Listings in Oracle Cloud Infrastructure Functions service.

    Fetches a wrapped list of all Pre-built Function(PBF) Listings. Returns a PbfListingCollection containing
    an array of PbfListingSummary response models.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pbf_listings = oci.Functions.get_pbf_listings(name=pbf_listing_name,
        name_contains=pbf_listing_name_contains,
        name_starts_with=pbf_listing_name_starts_with,
        pbf_listing_id=test_pbf_listing["id"],
        state=pbf_listing_state,
        triggers=pbf_listing_trigger)
    ```


    :param str name: A filter to return only resources that match the entire PBF name given.
    :param str name_contains: A filter to return only resources that contain the supplied filter text in the PBF name given.
    :param str name_starts_with: A filter to return only resources that start with the supplied filter text in the PBF name given.
    :param str pbf_listing_id: unique PbfListing identifier
    :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    :param Sequence[str] triggers: A filter to return only resources that match the service trigger sources of a PBF.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['nameContains'] = name_contains
    __args__['nameStartsWith'] = name_starts_with
    __args__['pbfListingId'] = pbf_listing_id
    __args__['state'] = state
    __args__['triggers'] = triggers
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Functions/getPbfListings:getPbfListings', __args__, opts=opts, typ=GetPbfListingsResult)
    return __ret__.apply(lambda __response__: GetPbfListingsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        name_contains=pulumi.get(__response__, 'name_contains'),
        name_starts_with=pulumi.get(__response__, 'name_starts_with'),
        pbf_listing_id=pulumi.get(__response__, 'pbf_listing_id'),
        pbf_listings_collections=pulumi.get(__response__, 'pbf_listings_collections'),
        state=pulumi.get(__response__, 'state'),
        triggers=pulumi.get(__response__, 'triggers')))
