# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetScheduledJobResult',
    'AwaitableGetScheduledJobResult',
    'get_scheduled_job',
    'get_scheduled_job_output',
]

@pulumi.output_type
class GetScheduledJobResult:
    """
    A collection of values returned by getScheduledJob.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, is_managed_by_autonomous_linux=None, is_restricted=None, is_subcompartment_included=None, lifecycle_stage_ids=None, locations=None, managed_compartment_ids=None, managed_instance_group_ids=None, managed_instance_ids=None, operations=None, recurring_rule=None, retry_intervals=None, schedule_type=None, scheduled_job_id=None, state=None, system_tags=None, time_created=None, time_last_execution=None, time_next_execution=None, time_updated=None, work_request_id=None, work_request_ids=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_managed_by_autonomous_linux and not isinstance(is_managed_by_autonomous_linux, bool):
            raise TypeError("Expected argument 'is_managed_by_autonomous_linux' to be a bool")
        pulumi.set(__self__, "is_managed_by_autonomous_linux", is_managed_by_autonomous_linux)
        if is_restricted and not isinstance(is_restricted, bool):
            raise TypeError("Expected argument 'is_restricted' to be a bool")
        pulumi.set(__self__, "is_restricted", is_restricted)
        if is_subcompartment_included and not isinstance(is_subcompartment_included, bool):
            raise TypeError("Expected argument 'is_subcompartment_included' to be a bool")
        pulumi.set(__self__, "is_subcompartment_included", is_subcompartment_included)
        if lifecycle_stage_ids and not isinstance(lifecycle_stage_ids, list):
            raise TypeError("Expected argument 'lifecycle_stage_ids' to be a list")
        pulumi.set(__self__, "lifecycle_stage_ids", lifecycle_stage_ids)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if managed_compartment_ids and not isinstance(managed_compartment_ids, list):
            raise TypeError("Expected argument 'managed_compartment_ids' to be a list")
        pulumi.set(__self__, "managed_compartment_ids", managed_compartment_ids)
        if managed_instance_group_ids and not isinstance(managed_instance_group_ids, list):
            raise TypeError("Expected argument 'managed_instance_group_ids' to be a list")
        pulumi.set(__self__, "managed_instance_group_ids", managed_instance_group_ids)
        if managed_instance_ids and not isinstance(managed_instance_ids, list):
            raise TypeError("Expected argument 'managed_instance_ids' to be a list")
        pulumi.set(__self__, "managed_instance_ids", managed_instance_ids)
        if operations and not isinstance(operations, list):
            raise TypeError("Expected argument 'operations' to be a list")
        pulumi.set(__self__, "operations", operations)
        if recurring_rule and not isinstance(recurring_rule, str):
            raise TypeError("Expected argument 'recurring_rule' to be a str")
        pulumi.set(__self__, "recurring_rule", recurring_rule)
        if retry_intervals and not isinstance(retry_intervals, list):
            raise TypeError("Expected argument 'retry_intervals' to be a list")
        pulumi.set(__self__, "retry_intervals", retry_intervals)
        if schedule_type and not isinstance(schedule_type, str):
            raise TypeError("Expected argument 'schedule_type' to be a str")
        pulumi.set(__self__, "schedule_type", schedule_type)
        if scheduled_job_id and not isinstance(scheduled_job_id, str):
            raise TypeError("Expected argument 'scheduled_job_id' to be a str")
        pulumi.set(__self__, "scheduled_job_id", scheduled_job_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_execution and not isinstance(time_last_execution, str):
            raise TypeError("Expected argument 'time_last_execution' to be a str")
        pulumi.set(__self__, "time_last_execution", time_last_execution)
        if time_next_execution and not isinstance(time_next_execution, str):
            raise TypeError("Expected argument 'time_next_execution' to be a str")
        pulumi.set(__self__, "time_next_execution", time_next_execution)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if work_request_id and not isinstance(work_request_id, str):
            raise TypeError("Expected argument 'work_request_id' to be a str")
        pulumi.set(__self__, "work_request_id", work_request_id)
        if work_request_ids and not isinstance(work_request_ids, list):
            raise TypeError("Expected argument 'work_request_ids' to be a list")
        pulumi.set(__self__, "work_request_ids", work_request_ids)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the scheduled job.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        User-specified description for the scheduled job.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        User-friendly name for the scheduled job.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the scheduled job.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> bool:
        """
        Indicates whether this scheduled job is managed by the Autonomous Linux service.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @property
    @pulumi.getter(name="isRestricted")
    def is_restricted(self) -> bool:
        """
        Indicates if the schedule job has restricted update and deletion capabilities. For restricted scheduled jobs,  you can update only the timeNextExecution, recurringRule, and tags.
        """
        return pulumi.get(self, "is_restricted")

    @property
    @pulumi.getter(name="isSubcompartmentIncluded")
    def is_subcompartment_included(self) -> bool:
        """
        Indicates whether to apply the scheduled job to all compartments in the tenancy when managedCompartmentIds specifies the tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) (root compartment).
        """
        return pulumi.get(self, "is_subcompartment_included")

    @property
    @pulumi.getter(name="lifecycleStageIds")
    def lifecycle_stage_ids(self) -> Sequence[str]:
        """
        The lifecycle stage [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore this parameter is mutually exclusive with  managedInstanceIds, managedInstanceGroupIds, and managedCompartmentIds.
        """
        return pulumi.get(self, "lifecycle_stage_ids")

    @property
    @pulumi.getter
    def locations(self) -> Sequence[str]:
        """
        The list of locations this scheduled job should operate on for a job targeting on compartments. (Empty list means apply to all locations). This can only be set when managedCompartmentIds is not empty.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="managedCompartmentIds")
    def managed_compartment_ids(self) -> Sequence[str]:
        """
        The compartment [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on. A scheduled job can only operate on one type of target, therefore this parameter is mutually exclusive with managedInstanceIds, managedInstanceGroupIds, and lifecycleStageIds.
        """
        return pulumi.get(self, "managed_compartment_ids")

    @property
    @pulumi.getter(name="managedInstanceGroupIds")
    def managed_instance_group_ids(self) -> Sequence[str]:
        """
        The managed instance group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on. A scheduled job can only operate on one type of target, therefore this parameter is mutually exclusive with managedInstanceIds, managedCompartmentIds, and lifecycleStageIds.
        """
        return pulumi.get(self, "managed_instance_group_ids")

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> Sequence[str]:
        """
        The managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that this scheduled job operates on.  A scheduled job can only operate on one type of target, therefore this parameter is mutually exclusive with  managedInstanceGroupIds, managedCompartmentIds, and lifecycleStageIds.
        """
        return pulumi.get(self, "managed_instance_ids")

    @property
    @pulumi.getter
    def operations(self) -> Sequence['outputs.GetScheduledJobOperationResult']:
        """
        The list of operations this scheduled job needs to perform. A scheduled job supports only one operation type, unless it is one of the following:
        * UPDATE_PACKAGES
        * UPDATE_ALL
        * UPDATE_SECURITY
        * UPDATE_BUGFIX
        * UPDATE_ENHANCEMENT
        * UPDATE_OTHER
        * UPDATE_KSPLICE_USERSPACE
        * UPDATE_KSPLICE_KERNEL
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter(name="recurringRule")
    def recurring_rule(self) -> str:
        """
        The frequency schedule for a recurring scheduled job.
        """
        return pulumi.get(self, "recurring_rule")

    @property
    @pulumi.getter(name="retryIntervals")
    def retry_intervals(self) -> Sequence[int]:
        """
        The amount of time in minutes to wait until retrying the scheduled job. If set, the service will automatically retry  a failed scheduled job after the interval. For example, you could set the interval to [2,5,10]. If the initial  execution of the job fails, the service waits 2 minutes and then retries. If that fails, the service waits 5 minutes  and then retries. If that fails, the service waits 10 minutes and then retries.
        """
        return pulumi.get(self, "retry_intervals")

    @property
    @pulumi.getter(name="scheduleType")
    def schedule_type(self) -> str:
        """
        The type of scheduling frequency for the job.
        """
        return pulumi.get(self, "schedule_type")

    @property
    @pulumi.getter(name="scheduledJobId")
    def scheduled_job_id(self) -> str:
        return pulumi.get(self, "scheduled_job_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the scheduled job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this scheduled job was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastExecution")
    def time_last_execution(self) -> str:
        """
        The time of the last execution of this scheduled job (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_last_execution")

    @property
    @pulumi.getter(name="timeNextExecution")
    def time_next_execution(self) -> str:
        """
        The time of the next execution of this scheduled job (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_next_execution")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this scheduled job was updated (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the work request that will be rerun.
        """
        return pulumi.get(self, "work_request_id")

    @property
    @pulumi.getter(name="workRequestIds")
    def work_request_ids(self) -> Sequence[str]:
        """
        The list of work request [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this scheduled job.
        """
        return pulumi.get(self, "work_request_ids")


class AwaitableGetScheduledJobResult(GetScheduledJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduledJobResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_managed_by_autonomous_linux=self.is_managed_by_autonomous_linux,
            is_restricted=self.is_restricted,
            is_subcompartment_included=self.is_subcompartment_included,
            lifecycle_stage_ids=self.lifecycle_stage_ids,
            locations=self.locations,
            managed_compartment_ids=self.managed_compartment_ids,
            managed_instance_group_ids=self.managed_instance_group_ids,
            managed_instance_ids=self.managed_instance_ids,
            operations=self.operations,
            recurring_rule=self.recurring_rule,
            retry_intervals=self.retry_intervals,
            schedule_type=self.schedule_type,
            scheduled_job_id=self.scheduled_job_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_last_execution=self.time_last_execution,
            time_next_execution=self.time_next_execution,
            time_updated=self.time_updated,
            work_request_id=self.work_request_id,
            work_request_ids=self.work_request_ids)


def get_scheduled_job(scheduled_job_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduledJobResult:
    """
    This data source provides details about a specific Scheduled Job resource in Oracle Cloud Infrastructure Os Management Hub service.

    Gets information about the specified scheduled job.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_job = oci.OsManagementHub.get_scheduled_job(scheduled_job_id=test_scheduled_job_oci_os_management_hub_scheduled_job["id"])
    ```


    :param str scheduled_job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the scheduled job.
    """
    __args__ = dict()
    __args__['scheduledJobId'] = scheduled_job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getScheduledJob:getScheduledJob', __args__, opts=opts, typ=GetScheduledJobResult).value

    return AwaitableGetScheduledJobResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_managed_by_autonomous_linux=pulumi.get(__ret__, 'is_managed_by_autonomous_linux'),
        is_restricted=pulumi.get(__ret__, 'is_restricted'),
        is_subcompartment_included=pulumi.get(__ret__, 'is_subcompartment_included'),
        lifecycle_stage_ids=pulumi.get(__ret__, 'lifecycle_stage_ids'),
        locations=pulumi.get(__ret__, 'locations'),
        managed_compartment_ids=pulumi.get(__ret__, 'managed_compartment_ids'),
        managed_instance_group_ids=pulumi.get(__ret__, 'managed_instance_group_ids'),
        managed_instance_ids=pulumi.get(__ret__, 'managed_instance_ids'),
        operations=pulumi.get(__ret__, 'operations'),
        recurring_rule=pulumi.get(__ret__, 'recurring_rule'),
        retry_intervals=pulumi.get(__ret__, 'retry_intervals'),
        schedule_type=pulumi.get(__ret__, 'schedule_type'),
        scheduled_job_id=pulumi.get(__ret__, 'scheduled_job_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_execution=pulumi.get(__ret__, 'time_last_execution'),
        time_next_execution=pulumi.get(__ret__, 'time_next_execution'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        work_request_id=pulumi.get(__ret__, 'work_request_id'),
        work_request_ids=pulumi.get(__ret__, 'work_request_ids'))
def get_scheduled_job_output(scheduled_job_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScheduledJobResult]:
    """
    This data source provides details about a specific Scheduled Job resource in Oracle Cloud Infrastructure Os Management Hub service.

    Gets information about the specified scheduled job.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_job = oci.OsManagementHub.get_scheduled_job(scheduled_job_id=test_scheduled_job_oci_os_management_hub_scheduled_job["id"])
    ```


    :param str scheduled_job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the scheduled job.
    """
    __args__ = dict()
    __args__['scheduledJobId'] = scheduled_job_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getScheduledJob:getScheduledJob', __args__, opts=opts, typ=GetScheduledJobResult)
    return __ret__.apply(lambda __response__: GetScheduledJobResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_managed_by_autonomous_linux=pulumi.get(__response__, 'is_managed_by_autonomous_linux'),
        is_restricted=pulumi.get(__response__, 'is_restricted'),
        is_subcompartment_included=pulumi.get(__response__, 'is_subcompartment_included'),
        lifecycle_stage_ids=pulumi.get(__response__, 'lifecycle_stage_ids'),
        locations=pulumi.get(__response__, 'locations'),
        managed_compartment_ids=pulumi.get(__response__, 'managed_compartment_ids'),
        managed_instance_group_ids=pulumi.get(__response__, 'managed_instance_group_ids'),
        managed_instance_ids=pulumi.get(__response__, 'managed_instance_ids'),
        operations=pulumi.get(__response__, 'operations'),
        recurring_rule=pulumi.get(__response__, 'recurring_rule'),
        retry_intervals=pulumi.get(__response__, 'retry_intervals'),
        schedule_type=pulumi.get(__response__, 'schedule_type'),
        scheduled_job_id=pulumi.get(__response__, 'scheduled_job_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_last_execution=pulumi.get(__response__, 'time_last_execution'),
        time_next_execution=pulumi.get(__response__, 'time_next_execution'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        work_request_id=pulumi.get(__response__, 'work_request_id'),
        work_request_ids=pulumi.get(__response__, 'work_request_ids')))
