# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSoftwareSourceManifestResult',
    'AwaitableGetSoftwareSourceManifestResult',
    'get_software_source_manifest',
    'get_software_source_manifest_output',
]

@pulumi.output_type
class GetSoftwareSourceManifestResult:
    """
    A collection of values returned by getSoftwareSourceManifest.
    """
    def __init__(__self__, content=None, id=None, software_source_id=None):
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if software_source_id and not isinstance(software_source_id, str):
            raise TypeError("Expected argument 'software_source_id' to be a str")
        pulumi.set(__self__, "software_source_id", software_source_id)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        Provides the manifest content used to update the package list of the software source.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
        """
        return pulumi.get(self, "software_source_id")


class AwaitableGetSoftwareSourceManifestResult(GetSoftwareSourceManifestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSoftwareSourceManifestResult(
            content=self.content,
            id=self.id,
            software_source_id=self.software_source_id)


def get_software_source_manifest(software_source_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSoftwareSourceManifestResult:
    """
    This data source provides details about a specific Software Source Manifest resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns an archive containing the list of packages in the software source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source_manifest = oci.OsManagementHub.get_software_source_manifest(software_source_id=test_software_source["id"])
    ```


    :param str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
    """
    __args__ = dict()
    __args__['softwareSourceId'] = software_source_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getSoftwareSourceManifest:getSoftwareSourceManifest', __args__, opts=opts, typ=GetSoftwareSourceManifestResult).value

    return AwaitableGetSoftwareSourceManifestResult(
        content=pulumi.get(__ret__, 'content'),
        id=pulumi.get(__ret__, 'id'),
        software_source_id=pulumi.get(__ret__, 'software_source_id'))
def get_software_source_manifest_output(software_source_id: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSoftwareSourceManifestResult]:
    """
    This data source provides details about a specific Software Source Manifest resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns an archive containing the list of packages in the software source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source_manifest = oci.OsManagementHub.get_software_source_manifest(software_source_id=test_software_source["id"])
    ```


    :param str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
    """
    __args__ = dict()
    __args__['softwareSourceId'] = software_source_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getSoftwareSourceManifest:getSoftwareSourceManifest', __args__, opts=opts, typ=GetSoftwareSourceManifestResult)
    return __ret__.apply(lambda __response__: GetSoftwareSourceManifestResult(
        content=pulumi.get(__response__, 'content'),
        id=pulumi.get(__response__, 'id'),
        software_source_id=pulumi.get(__response__, 'software_source_id')))
