# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RedisClusterArgs', 'RedisCluster']

@pulumi.input_type
class RedisClusterArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 node_count: pulumi.Input[int],
                 node_memory_in_gbs: pulumi.Input[float],
                 software_version: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 cluster_mode: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a RedisCluster resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the compartment that contains the cluster.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[int] node_count: (Updatable) The number of nodes per shard in the cluster when clusterMode is SHARDED. This is the total number of nodes when clusterMode is NONSHARDED.
        :param pulumi.Input[float] node_memory_in_gbs: (Updatable) The amount of memory allocated to the cluster's nodes, in gigabytes.
        :param pulumi.Input[str] software_version: (Updatable) The Oracle Cloud Infrastructure Cache engine version that the cluster is running.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster's subnet.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] cluster_mode: Specifies whether the cluster is sharded or non-sharded.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) A list of Network Security Group (NSG) [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this cluster. For more information, see [Using an NSG for Clusters](https://docs.cloud.oracle.com/iaas/Content/ocicache/connecttocluster.htm#connecttocluster__networksecuritygroup).
        :param pulumi.Input[int] shard_count: (Updatable) The number of shards in sharded cluster. Only applicable when clusterMode is SHARDED.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_memory_in_gbs", node_memory_in_gbs)
        pulumi.set(__self__, "software_version", software_version)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if cluster_mode is not None:
            pulumi.set(__self__, "cluster_mode", cluster_mode)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the compartment that contains the cluster.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[int]:
        """
        (Updatable) The number of nodes per shard in the cluster when clusterMode is SHARDED. This is the total number of nodes when clusterMode is NONSHARDED.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeMemoryInGbs")
    def node_memory_in_gbs(self) -> pulumi.Input[float]:
        """
        (Updatable) The amount of memory allocated to the cluster's nodes, in gigabytes.
        """
        return pulumi.get(self, "node_memory_in_gbs")

    @node_memory_in_gbs.setter
    def node_memory_in_gbs(self, value: pulumi.Input[float]):
        pulumi.set(self, "node_memory_in_gbs", value)

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> pulumi.Input[str]:
        """
        (Updatable) The Oracle Cloud Infrastructure Cache engine version that the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "software_version", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster's subnet.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="clusterMode")
    def cluster_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the cluster is sharded or non-sharded.
        """
        return pulumi.get(self, "cluster_mode")

    @cluster_mode.setter
    def cluster_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_mode", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of Network Security Group (NSG) [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this cluster. For more information, see [Using an NSG for Clusters](https://docs.cloud.oracle.com/iaas/Content/ocicache/connecttocluster.htm#connecttocluster__networksecuritygroup).
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of shards in sharded cluster. Only applicable when clusterMode is SHARDED.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shard_count", value)


@pulumi.input_type
class _RedisClusterState:
    def __init__(__self__, *,
                 cluster_mode: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 node_collections: Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterNodeCollectionArgs']]]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_memory_in_gbs: Optional[pulumi.Input[float]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 primary_endpoint_ip_address: Optional[pulumi.Input[str]] = None,
                 primary_fqdn: Optional[pulumi.Input[str]] = None,
                 replicas_endpoint_ip_address: Optional[pulumi.Input[str]] = None,
                 replicas_fqdn: Optional[pulumi.Input[str]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 software_version: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RedisCluster resources.
        :param pulumi.Input[str] cluster_mode: Specifies whether the cluster is sharded or non-sharded.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the compartment that contains the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, the message might provide actionable information for a resource in `FAILED` state.
        :param pulumi.Input[Sequence[pulumi.Input['RedisClusterNodeCollectionArgs']]] node_collections: The collection of  cluster nodes.
        :param pulumi.Input[int] node_count: (Updatable) The number of nodes per shard in the cluster when clusterMode is SHARDED. This is the total number of nodes when clusterMode is NONSHARDED.
        :param pulumi.Input[float] node_memory_in_gbs: (Updatable) The amount of memory allocated to the cluster's nodes, in gigabytes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) A list of Network Security Group (NSG) [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this cluster. For more information, see [Using an NSG for Clusters](https://docs.cloud.oracle.com/iaas/Content/ocicache/connecttocluster.htm#connecttocluster__networksecuritygroup).
        :param pulumi.Input[str] primary_endpoint_ip_address: The private IP address of the API endpoint for the cluster's primary node.
        :param pulumi.Input[str] primary_fqdn: The fully qualified domain name (FQDN) of the API endpoint for the cluster's primary node.
        :param pulumi.Input[str] replicas_endpoint_ip_address: The private IP address of the API endpoint for the cluster's replica nodes.
        :param pulumi.Input[str] replicas_fqdn: The fully qualified domain name (FQDN) of the API endpoint for the cluster's replica nodes.
        :param pulumi.Input[int] shard_count: (Updatable) The number of shards in sharded cluster. Only applicable when clusterMode is SHARDED.
        :param pulumi.Input[str] software_version: (Updatable) The Oracle Cloud Infrastructure Cache engine version that the cluster is running.
        :param pulumi.Input[str] state: The current state of the cluster.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster's subnet.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the cluster was created. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        :param pulumi.Input[str] time_updated: The date and time the cluster was updated. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        if cluster_mode is not None:
            pulumi.set(__self__, "cluster_mode", cluster_mode)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if node_collections is not None:
            pulumi.set(__self__, "node_collections", node_collections)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_memory_in_gbs is not None:
            pulumi.set(__self__, "node_memory_in_gbs", node_memory_in_gbs)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if primary_endpoint_ip_address is not None:
            pulumi.set(__self__, "primary_endpoint_ip_address", primary_endpoint_ip_address)
        if primary_fqdn is not None:
            pulumi.set(__self__, "primary_fqdn", primary_fqdn)
        if replicas_endpoint_ip_address is not None:
            pulumi.set(__self__, "replicas_endpoint_ip_address", replicas_endpoint_ip_address)
        if replicas_fqdn is not None:
            pulumi.set(__self__, "replicas_fqdn", replicas_fqdn)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="clusterMode")
    def cluster_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the cluster is sharded or non-sharded.
        """
        return pulumi.get(self, "cluster_mode")

    @cluster_mode.setter
    def cluster_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_mode", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the compartment that contains the cluster.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, the message might provide actionable information for a resource in `FAILED` state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="nodeCollections")
    def node_collections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterNodeCollectionArgs']]]]:
        """
        The collection of  cluster nodes.
        """
        return pulumi.get(self, "node_collections")

    @node_collections.setter
    def node_collections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterNodeCollectionArgs']]]]):
        pulumi.set(self, "node_collections", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of nodes per shard in the cluster when clusterMode is SHARDED. This is the total number of nodes when clusterMode is NONSHARDED.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeMemoryInGbs")
    def node_memory_in_gbs(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The amount of memory allocated to the cluster's nodes, in gigabytes.
        """
        return pulumi.get(self, "node_memory_in_gbs")

    @node_memory_in_gbs.setter
    def node_memory_in_gbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "node_memory_in_gbs", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of Network Security Group (NSG) [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this cluster. For more information, see [Using an NSG for Clusters](https://docs.cloud.oracle.com/iaas/Content/ocicache/connecttocluster.htm#connecttocluster__networksecuritygroup).
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="primaryEndpointIpAddress")
    def primary_endpoint_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address of the API endpoint for the cluster's primary node.
        """
        return pulumi.get(self, "primary_endpoint_ip_address")

    @primary_endpoint_ip_address.setter
    def primary_endpoint_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_endpoint_ip_address", value)

    @property
    @pulumi.getter(name="primaryFqdn")
    def primary_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified domain name (FQDN) of the API endpoint for the cluster's primary node.
        """
        return pulumi.get(self, "primary_fqdn")

    @primary_fqdn.setter
    def primary_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_fqdn", value)

    @property
    @pulumi.getter(name="replicasEndpointIpAddress")
    def replicas_endpoint_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address of the API endpoint for the cluster's replica nodes.
        """
        return pulumi.get(self, "replicas_endpoint_ip_address")

    @replicas_endpoint_ip_address.setter
    def replicas_endpoint_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replicas_endpoint_ip_address", value)

    @property
    @pulumi.getter(name="replicasFqdn")
    def replicas_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified domain name (FQDN) of the API endpoint for the cluster's replica nodes.
        """
        return pulumi.get(self, "replicas_fqdn")

    @replicas_fqdn.setter
    def replicas_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replicas_fqdn", value)

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of shards in sharded cluster. Only applicable when clusterMode is SHARDED.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shard_count", value)

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle Cloud Infrastructure Cache engine version that the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_version", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster's subnet.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the cluster was created. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the cluster was updated. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class RedisCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_mode: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_memory_in_gbs: Optional[pulumi.Input[float]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 software_version: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Redis Cluster resource in Oracle Cloud Infrastructure Redis service.

        Creates a new Oracle Cloud Infrastructure Cache cluster. A cluster is a memory-based storage solution. For more information, see [OCI Cache](https://docs.cloud.oracle.com/iaas/Content/ocicache/home.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_redis_cluster = oci.redis.RedisCluster("test_redis_cluster",
            compartment_id=compartment_id,
            display_name=redis_cluster_display_name,
            node_count=redis_cluster_node_count,
            node_memory_in_gbs=redis_cluster_node_memory_in_gbs,
            software_version=redis_cluster_software_version,
            subnet_id=test_subnet["id"],
            cluster_mode=redis_cluster_cluster_mode,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            nsg_ids=redis_cluster_nsg_ids,
            shard_count=redis_cluster_shard_count)
        ```

        ## Import

        RedisClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Redis/redisCluster:RedisCluster test_redis_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_mode: Specifies whether the cluster is sharded or non-sharded.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the compartment that contains the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] node_count: (Updatable) The number of nodes per shard in the cluster when clusterMode is SHARDED. This is the total number of nodes when clusterMode is NONSHARDED.
        :param pulumi.Input[float] node_memory_in_gbs: (Updatable) The amount of memory allocated to the cluster's nodes, in gigabytes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) A list of Network Security Group (NSG) [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this cluster. For more information, see [Using an NSG for Clusters](https://docs.cloud.oracle.com/iaas/Content/ocicache/connecttocluster.htm#connecttocluster__networksecuritygroup).
        :param pulumi.Input[int] shard_count: (Updatable) The number of shards in sharded cluster. Only applicable when clusterMode is SHARDED.
        :param pulumi.Input[str] software_version: (Updatable) The Oracle Cloud Infrastructure Cache engine version that the cluster is running.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster's subnet.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RedisClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Redis Cluster resource in Oracle Cloud Infrastructure Redis service.

        Creates a new Oracle Cloud Infrastructure Cache cluster. A cluster is a memory-based storage solution. For more information, see [OCI Cache](https://docs.cloud.oracle.com/iaas/Content/ocicache/home.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_redis_cluster = oci.redis.RedisCluster("test_redis_cluster",
            compartment_id=compartment_id,
            display_name=redis_cluster_display_name,
            node_count=redis_cluster_node_count,
            node_memory_in_gbs=redis_cluster_node_memory_in_gbs,
            software_version=redis_cluster_software_version,
            subnet_id=test_subnet["id"],
            cluster_mode=redis_cluster_cluster_mode,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            nsg_ids=redis_cluster_nsg_ids,
            shard_count=redis_cluster_shard_count)
        ```

        ## Import

        RedisClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Redis/redisCluster:RedisCluster test_redis_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param RedisClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RedisClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_mode: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_memory_in_gbs: Optional[pulumi.Input[float]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 software_version: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RedisClusterArgs.__new__(RedisClusterArgs)

            __props__.__dict__["cluster_mode"] = cluster_mode
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if node_count is None and not opts.urn:
                raise TypeError("Missing required property 'node_count'")
            __props__.__dict__["node_count"] = node_count
            if node_memory_in_gbs is None and not opts.urn:
                raise TypeError("Missing required property 'node_memory_in_gbs'")
            __props__.__dict__["node_memory_in_gbs"] = node_memory_in_gbs
            __props__.__dict__["nsg_ids"] = nsg_ids
            __props__.__dict__["shard_count"] = shard_count
            if software_version is None and not opts.urn:
                raise TypeError("Missing required property 'software_version'")
            __props__.__dict__["software_version"] = software_version
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["node_collections"] = None
            __props__.__dict__["primary_endpoint_ip_address"] = None
            __props__.__dict__["primary_fqdn"] = None
            __props__.__dict__["replicas_endpoint_ip_address"] = None
            __props__.__dict__["replicas_fqdn"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(RedisCluster, __self__).__init__(
            'oci:Redis/redisCluster:RedisCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_mode: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            node_collections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RedisClusterNodeCollectionArgs', 'RedisClusterNodeCollectionArgsDict']]]]] = None,
            node_count: Optional[pulumi.Input[int]] = None,
            node_memory_in_gbs: Optional[pulumi.Input[float]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            primary_endpoint_ip_address: Optional[pulumi.Input[str]] = None,
            primary_fqdn: Optional[pulumi.Input[str]] = None,
            replicas_endpoint_ip_address: Optional[pulumi.Input[str]] = None,
            replicas_fqdn: Optional[pulumi.Input[str]] = None,
            shard_count: Optional[pulumi.Input[int]] = None,
            software_version: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'RedisCluster':
        """
        Get an existing RedisCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_mode: Specifies whether the cluster is sharded or non-sharded.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the compartment that contains the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, the message might provide actionable information for a resource in `FAILED` state.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RedisClusterNodeCollectionArgs', 'RedisClusterNodeCollectionArgsDict']]]] node_collections: The collection of  cluster nodes.
        :param pulumi.Input[int] node_count: (Updatable) The number of nodes per shard in the cluster when clusterMode is SHARDED. This is the total number of nodes when clusterMode is NONSHARDED.
        :param pulumi.Input[float] node_memory_in_gbs: (Updatable) The amount of memory allocated to the cluster's nodes, in gigabytes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) A list of Network Security Group (NSG) [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this cluster. For more information, see [Using an NSG for Clusters](https://docs.cloud.oracle.com/iaas/Content/ocicache/connecttocluster.htm#connecttocluster__networksecuritygroup).
        :param pulumi.Input[str] primary_endpoint_ip_address: The private IP address of the API endpoint for the cluster's primary node.
        :param pulumi.Input[str] primary_fqdn: The fully qualified domain name (FQDN) of the API endpoint for the cluster's primary node.
        :param pulumi.Input[str] replicas_endpoint_ip_address: The private IP address of the API endpoint for the cluster's replica nodes.
        :param pulumi.Input[str] replicas_fqdn: The fully qualified domain name (FQDN) of the API endpoint for the cluster's replica nodes.
        :param pulumi.Input[int] shard_count: (Updatable) The number of shards in sharded cluster. Only applicable when clusterMode is SHARDED.
        :param pulumi.Input[str] software_version: (Updatable) The Oracle Cloud Infrastructure Cache engine version that the cluster is running.
        :param pulumi.Input[str] state: The current state of the cluster.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster's subnet.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the cluster was created. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        :param pulumi.Input[str] time_updated: The date and time the cluster was updated. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RedisClusterState.__new__(_RedisClusterState)

        __props__.__dict__["cluster_mode"] = cluster_mode
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["node_collections"] = node_collections
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["node_memory_in_gbs"] = node_memory_in_gbs
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["primary_endpoint_ip_address"] = primary_endpoint_ip_address
        __props__.__dict__["primary_fqdn"] = primary_fqdn
        __props__.__dict__["replicas_endpoint_ip_address"] = replicas_endpoint_ip_address
        __props__.__dict__["replicas_fqdn"] = replicas_fqdn
        __props__.__dict__["shard_count"] = shard_count
        __props__.__dict__["software_version"] = software_version
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return RedisCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterMode")
    def cluster_mode(self) -> pulumi.Output[str]:
        """
        Specifies whether the cluster is sharded or non-sharded.
        """
        return pulumi.get(self, "cluster_mode")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the compartment that contains the cluster.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, the message might provide actionable information for a resource in `FAILED` state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nodeCollections")
    def node_collections(self) -> pulumi.Output[Sequence['outputs.RedisClusterNodeCollection']]:
        """
        The collection of  cluster nodes.
        """
        return pulumi.get(self, "node_collections")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of nodes per shard in the cluster when clusterMode is SHARDED. This is the total number of nodes when clusterMode is NONSHARDED.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeMemoryInGbs")
    def node_memory_in_gbs(self) -> pulumi.Output[float]:
        """
        (Updatable) The amount of memory allocated to the cluster's nodes, in gigabytes.
        """
        return pulumi.get(self, "node_memory_in_gbs")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) A list of Network Security Group (NSG) [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this cluster. For more information, see [Using an NSG for Clusters](https://docs.cloud.oracle.com/iaas/Content/ocicache/connecttocluster.htm#connecttocluster__networksecuritygroup).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="primaryEndpointIpAddress")
    def primary_endpoint_ip_address(self) -> pulumi.Output[str]:
        """
        The private IP address of the API endpoint for the cluster's primary node.
        """
        return pulumi.get(self, "primary_endpoint_ip_address")

    @property
    @pulumi.getter(name="primaryFqdn")
    def primary_fqdn(self) -> pulumi.Output[str]:
        """
        The fully qualified domain name (FQDN) of the API endpoint for the cluster's primary node.
        """
        return pulumi.get(self, "primary_fqdn")

    @property
    @pulumi.getter(name="replicasEndpointIpAddress")
    def replicas_endpoint_ip_address(self) -> pulumi.Output[str]:
        """
        The private IP address of the API endpoint for the cluster's replica nodes.
        """
        return pulumi.get(self, "replicas_endpoint_ip_address")

    @property
    @pulumi.getter(name="replicasFqdn")
    def replicas_fqdn(self) -> pulumi.Output[str]:
        """
        The fully qualified domain name (FQDN) of the API endpoint for the cluster's replica nodes.
        """
        return pulumi.get(self, "replicas_fqdn")

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of shards in sharded cluster. Only applicable when clusterMode is SHARDED.
        """
        return pulumi.get(self, "shard_count")

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> pulumi.Output[str]:
        """
        (Updatable) The Oracle Cloud Infrastructure Cache engine version that the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster's subnet.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the cluster was created. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the cluster was updated. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

